/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.geoway.landteam.customtask.dao.task.TbtskUserManageAreaDao;
import com.geoway.landteam.customtask.mapper.task.TbtskUserManageAreaMapper;
import com.geoway.landteam.customtask.task.entity.TbtskUserManageArea;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserManageAreaService;
import com.gw.base.gpa.entity.GiEntityQueryable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MTbtskUserManageAreaServiceImpl
implements MTbtskUserManageAreaService {
    @Autowired
    TbtskUserManageAreaMapper tbtskUserManageAreaMapper;
    @Autowired
    RegionService regionService;
    @Autowired
    TbtskUserManageAreaDao tbtskUserManageAreaDao;
    @Resource
    JdbcTemplate jdbcTemplate;

    public int deleteByPrimaryKey(Long id) {
        return this.tbtskUserManageAreaMapper.deleteByPrimaryKey((Object)id);
    }

    public int deleteByTaskIdAndUserId(String taskId, String userId) {
        return this.tbtskUserManageAreaMapper.deleteByTaskIdAndUserId(taskId, userId);
    }

    public int deleteByTaskId(String taskId) {
        return this.tbtskUserManageAreaMapper.deleteByTaskId(taskId);
    }

    public int insert(TbtskUserManageArea record) {
        return this.tbtskUserManageAreaMapper.insert((Object)record);
    }

    public int insertSelective(TbtskUserManageArea record) {
        return this.tbtskUserManageAreaMapper.insertSelective((Object)record);
    }

    public int updateByTaskIdAndUserId(String taskId, String userId, String regions, String version) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for (String s : tempRegionList) {
            List list = this.tbtskUserManageAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            if (list.size() > 0) continue;
            TbtskUserManageArea tbtskUserManageArea = new TbtskUserManageArea();
            tbtskUserManageArea.setLevel(Short.valueOf(this.regionService.getRegionLevel(s, version).shortValue()));
            tbtskUserManageArea.setRegioncode(s);
            tbtskUserManageArea.setTaskId(taskId);
            tbtskUserManageArea.setUserId(userId);
            this.tbtskUserManageAreaMapper.insertSelective((Object)tbtskUserManageArea);
        }
        return tempRegionList.size();
    }

    public int delByTaskIdAndUserId(String taskId, String userId, String regions) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for (String s : tempRegionList) {
            List list = this.tbtskUserManageAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            list.forEach(a -> this.tbtskUserManageAreaMapper.deleteByPrimaryKey((Object)a.getId()));
        }
        return tempRegionList.size();
    }

    public TbtskUserManageArea selectByPrimaryKey(Long id) {
        return (TbtskUserManageArea)this.tbtskUserManageAreaMapper.selectByPrimaryKey((Object)id);
    }

    public int updateByPrimaryKeySelective(TbtskUserManageArea record) {
        return this.tbtskUserManageAreaMapper.updateByPrimaryKeySelective((Object)record);
    }

    public int updateByPrimaryKey(TbtskUserManageArea record) {
        return this.tbtskUserManageAreaMapper.updateByPrimaryKey((Object)record);
    }

    public List<TbtskUserManageArea> listManageAreas(String taskId, String userId, Short level) {
        return this.tbtskUserManageAreaMapper.listManageAreas(taskId, userId, level);
    }

    public List<TbtskUserManageArea> listManageAreas(String taskId, String userId) {
        TbtskUserManageArea search = new TbtskUserManageArea();
        search.setTaskId(taskId);
        search.setUserId(userId);
        return this.tbtskUserManageAreaDao.gwSearch((GiEntityQueryable)search);
    }

    public Map<String, Object> findManageAreasTree(String taskId, String userId) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        HashMap<String, String> sheng = new HashMap<String, String>();
        HashMap<Object, String> shi = new HashMap<Object, String>();
        HashMap<Object, String> xian = new HashMap<Object, String>();
        HashMap shiMap = new HashMap();
        HashMap xianMap = new HashMap();
        HashMap xiangMap = new HashMap();
        res.put("sheng", sheng);
        res.put("shi", shi);
        res.put("xian", xian);
        List<TbtskUserManageArea> ls = this.listManageAreas(taskId, userId);
        if (ls != null && !ls.isEmpty()) {
            HashMap<String, TbtskUserManageArea> province = new HashMap<String, TbtskUserManageArea>();
            HashMap<String, TbtskUserManageArea> city = new HashMap<String, TbtskUserManageArea>();
            HashMap<String, TbtskUserManageArea> county = new HashMap<String, TbtskUserManageArea>();
            HashMap town = new HashMap();
            for (TbtskUserManageArea tbtskUserManageArea : ls) {
                String key2;
                if (tbtskUserManageArea.getLevel() == 1) {
                    key2 = tbtskUserManageArea.getRegioncode().substring(0, 2);
                    province.put(key2, tbtskUserManageArea);
                    continue;
                }
                if (tbtskUserManageArea.getLevel() == 2) {
                    key2 = tbtskUserManageArea.getRegioncode().substring(0, 4);
                    city.put(key2, tbtskUserManageArea);
                    continue;
                }
                if (tbtskUserManageArea.getLevel() != 3) continue;
                key2 = tbtskUserManageArea.getRegioncode().substring(0, 6);
                county.put(key2, tbtskUserManageArea);
            }
            ArrayList realArea = new ArrayList();
            if (!county.isEmpty()) {
                county.keySet().removeIf(key -> {
                    String first = key.substring(0, 2);
                    if (province.containsKey(first)) {
                        return true;
                    }
                    String second = key.substring(0, 4);
                    return city.containsKey(second);
                });
            }
            if (!city.isEmpty()) {
                city.keySet().removeIf(key -> {
                    String first = key.substring(0, 2);
                    return province.containsKey(first);
                });
            }
            sheng.put("130000", "\u6cb3\u5317\u7701");
            if (!province.isEmpty()) {
                String cnSql = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=3 and r.f_xzqdm like '13%'";
                List cnlist = this.jdbcTemplate.queryForList(cnSql);
                for (Map temp : cnlist) {
                    String code = temp.get("f_xzqdm").toString();
                    String name = temp.get("f_xzqmc").toString();
                    HashMap<String, Object> mapT = new HashMap<String, Object>();
                    mapT.put("code", code);
                    mapT.put("name", name);
                    xian.put(code, name);
                    xianMap.put(code, mapT);
                }
                xian.put("130000", "\u5168\u7701");
                String citySql = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=2 and r.f_xzqdm like '13%'";
                List ctlist = this.jdbcTemplate.queryForList(citySql);
                for (Map temp : ctlist) {
                    String code = temp.get("f_xzqdm").toString();
                    String name = temp.get("f_xzqmc").toString();
                    shi.put(code, name);
                    xian.put(code, "\u5168" + name);
                    HashMap<String, Object> mapT = new HashMap<String, Object>();
                    mapT.put("code", code);
                    mapT.put("name", name);
                    shiMap.put(code, mapT);
                }
                shi.put("130000", "\u5168\u7701");
                String townSql = "select xzqdm,xzqmc from tb_region_town r where r.xzqdm like '13%'";
                List townlist = this.jdbcTemplate.queryForList(townSql);
                for (Map temp : townlist) {
                    String code = temp.get("xzqdm").toString();
                    String name = temp.get("xzqmc").toString();
                    HashMap<String, String> mapT = new HashMap<String, String>();
                    mapT.put("code", code);
                    mapT.put("name", name);
                    xiangMap.put(code, mapT);
                }
            } else {
                HashMap<String, Object> mapT;
                String name;
                Object code;
                ArrayList<String> params;
                if (!county.isEmpty()) {
                    params = new ArrayList<String>();
                    ArrayList params2 = new ArrayList();
                    for (String key3 : county.keySet()) {
                        String second = key3.substring(0, 4) + "00";
                        params.add(second);
                        params2.add(((TbtskUserManageArea)county.get(key3)).getRegioncode());
                    }
                    String sqlParam2 = "'" + String.join((CharSequence)"','", params2) + "'";
                    String sql1 = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=3 and r.f_xzqdm in (" + sqlParam2 + ")";
                    List cnlist = this.jdbcTemplate.queryForList(sql1);
                    Iterator townlist = cnlist.iterator();
                    while (townlist.hasNext()) {
                        Map temp = (Map)townlist.next();
                        String code2 = temp.get("f_xzqdm").toString();
                        String name2 = temp.get("f_xzqmc").toString();
                        xian.put(code2, name2);
                        HashMap<String, String> mapT2 = new HashMap<String, String>();
                        mapT2.put("code", code2);
                        mapT2.put("name", name2);
                        xianMap.put(code2, mapT2);
                    }
                    String sqlParam = "'" + String.join((CharSequence)"','", params) + "'";
                    String sql = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=2 and r.f_xzqdm in (" + sqlParam + ")";
                    List ctlist = this.jdbcTemplate.queryForList(sql);
                    for (Map temp : ctlist) {
                        code = temp.get("f_xzqdm").toString();
                        name = temp.get("f_xzqmc").toString();
                        shi.put(code, name);
                        mapT = new HashMap<String, Object>();
                        mapT.put("code", code);
                        mapT.put("name", name);
                        shiMap.put(code, mapT);
                    }
                    String sql2 = "select xzqdm,xzqmc from tb_region_town r where r.pcode in (" + sqlParam2 + ")";
                    List townList = this.jdbcTemplate.queryForList(sql2);
                    for (Map temp : townList) {
                        String code3 = temp.get("xzqdm").toString();
                        String name3 = temp.get("xzqmc").toString();
                        HashMap<String, String> mapT3 = new HashMap<String, String>();
                        mapT3.put("code", code3);
                        mapT3.put("name", name3);
                        xiangMap.put(code3, mapT3);
                    }
                }
                if (!city.isEmpty()) {
                    params = new ArrayList();
                    for (String key4 : city.keySet()) {
                        params.add(((TbtskUserManageArea)city.get(key4)).getRegioncode());
                    }
                    String sqlParam = "'" + String.join((CharSequence)"','", params) + "'";
                    String sql1 = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=2 and r.f_xzqdm in (" + sqlParam + ")";
                    List ctlist = this.jdbcTemplate.queryForList(sql1);
                    for (Map temp : ctlist) {
                        String code4 = temp.get("f_xzqdm").toString();
                        String name4 = temp.get("f_xzqmc").toString();
                        shi.put(code4, name4);
                        xian.put(code4, "\u5168" + name4);
                        HashMap<String, Object> mapT4 = new HashMap<String, Object>();
                        mapT4.put("code", code4);
                        mapT4.put("name", name4);
                        shiMap.put(code4, mapT4);
                    }
                    String sql = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=3 and r.f_pcode in (" + sqlParam + ")";
                    List cnlist = this.jdbcTemplate.queryForList(sql);
                    for (Map temp : cnlist) {
                        String code5 = temp.get("f_xzqdm").toString();
                        String name5 = temp.get("f_xzqmc").toString();
                        xian.put(code5, name5);
                        HashMap<String, String> mapT5 = new HashMap<String, String>();
                        mapT5.put("code", code5);
                        mapT5.put("name", name5);
                        xianMap.put(code5, mapT5);
                    }
                    String sql2 = "select xzqdm,xzqmc from tb_region_town r left join tb_region t on r.pcode=t.f_xzqdm and t.f_level=3  where t.f_pcode in (" + sqlParam + ")";
                    List townList = this.jdbcTemplate.queryForList(sql2);
                    for (Map temp : townList) {
                        code = temp.get("xzqdm").toString();
                        name = temp.get("xzqmc").toString();
                        mapT = new HashMap();
                        mapT.put("code", code);
                        mapT.put("name", name);
                        xiangMap.put(code, mapT);
                    }
                }
            }
        }
        res.put("cityRegion", new ArrayList(shiMap.values()));
        res.put("countyRegion", new ArrayList(xianMap.values()));
        res.put("townRegion", new ArrayList(xiangMap.values()));
        return res;
    }

    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userIds) {
        List list = this.tbtskUserManageAreaMapper.queryByTaskIdAndUserIds(sourceTaskId, userIds);
        if (!list.isEmpty()) {
            for (TbtskUserManageArea bean : list) {
                bean.setId(null);
                bean.setTaskId(targetTaskId);
                List tbtskUserManageAreas = this.tbtskUserManageAreaMapper.queryByTaskIdAndUserIdAndRegioncode(targetTaskId, bean.getUserId(), bean.getRegioncode());
                if (!tbtskUserManageAreas.isEmpty()) continue;
                this.tbtskUserManageAreaMapper.insertSelective((Object)bean);
            }
        }
    }

    public List<TbtskUserManageArea> queryListByTaskId(String taskId) {
        return this.tbtskUserManageAreaMapper.queryListByTaskId(taskId);
    }
}

