/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.geoway.landteam.customtask.mapper.task.TbtskUserReviewAreaMapper;
import com.geoway.landteam.customtask.task.entity.TbtskUserReviewArea;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserReviewAreaService;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTbtskUserReviewAreaServiceImpl
implements MTbtskUserReviewAreaService {
    @Autowired
    private TbtskUserReviewAreaMapper tbtskUserReviewAreaMapper;
    @Autowired
    private RegionService regionService;

    public int deleteByPrimaryKey(Long id) {
        return this.tbtskUserReviewAreaMapper.deleteByPrimaryKey((Object)id);
    }

    public int deleteByTaskIdAndUserId(String taskId, String userId) {
        return this.tbtskUserReviewAreaMapper.deleteByTaskIdAndUserId(taskId, userId);
    }

    public int deleteByTaskId(String taskId) {
        return this.tbtskUserReviewAreaMapper.deleteByTaskId(taskId);
    }

    public int insert(TbtskUserReviewArea record) {
        return this.tbtskUserReviewAreaMapper.insert((Object)record);
    }

    public int insertSelective(TbtskUserReviewArea record) {
        return this.tbtskUserReviewAreaMapper.insertSelective((Object)record);
    }

    public TbtskUserReviewArea selectByPrimaryKey(Long id) {
        return (TbtskUserReviewArea)this.tbtskUserReviewAreaMapper.selectByPrimaryKey((Object)id);
    }

    public int updateByPrimaryKeySelective(TbtskUserReviewArea record) {
        return this.tbtskUserReviewAreaMapper.updateByPrimaryKeySelective((Object)record);
    }

    public int updateByPrimaryKey(TbtskUserReviewArea record) {
        return this.tbtskUserReviewAreaMapper.updateByPrimaryKey((Object)record);
    }

    public int updateByTaskIdAndUserId(String taskId, String userId, String regions, String version) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for (String s : tempRegionList) {
            List list = this.tbtskUserReviewAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            if (list.size() > 0) continue;
            TbtskUserReviewArea tbtskUserReviewArea = new TbtskUserReviewArea();
            tbtskUserReviewArea.setLevel(Short.valueOf(this.regionService.getRegionLevel(s, version).shortValue()));
            tbtskUserReviewArea.setRegionCode(s);
            tbtskUserReviewArea.setTaskId(taskId);
            tbtskUserReviewArea.setUserId(userId);
            this.tbtskUserReviewAreaMapper.insertSelective((Object)tbtskUserReviewArea);
        }
        return tempRegionList.size();
    }

    public int delByTaskIdAndUserId(String taskId, String userId, String regions) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for (String s : tempRegionList) {
            List list = this.tbtskUserReviewAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            list.forEach(a -> this.tbtskUserReviewAreaMapper.deleteByPrimaryKey((Object)a.getId()));
        }
        return tempRegionList.size();
    }

    public List<TbtskUserReviewArea> listReviewAreas(String taskId, String userId, Short level) {
        return this.tbtskUserReviewAreaMapper.listReviewAreas(taskId, userId, level);
    }

    public List<TbtskUserReviewArea> listReviewAreas(String taskId, String userId) {
        return this.tbtskUserReviewAreaMapper.queryByTaskIdAndUserId(taskId, userId);
    }

    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userList) {
        List list = this.tbtskUserReviewAreaMapper.queryByTaskIdAndUserIds(sourceTaskId, userList);
        if (!list.isEmpty()) {
            for (TbtskUserReviewArea bean : list) {
                bean.setId(null);
                bean.setTaskId(targetTaskId);
                List tbtskUserReviewAreas = this.tbtskUserReviewAreaMapper.queryByTaskIdAndUserIdAndRegioncode(targetTaskId, bean.getUserId(), bean.getRegionCode());
                if (!tbtskUserReviewAreas.isEmpty()) continue;
                this.tbtskUserReviewAreaMapper.insertSelective((Object)bean);
            }
        }
    }

    public List<TbtskUserReviewArea> queryListByTaskId(String taskId) {
        return this.tbtskUserReviewAreaMapper.queryListByTaskId(taskId);
    }
}

