/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformData;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;
import com.geoway.landteam.customtask.servface.task.ITaskAssignService;
import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskAssignRecord;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupMemberRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskTransformService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskNoticeService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskTransMediaService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.Gw;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Service;

@Service
public class MtaskTransDailyTaskImpl
implements MTaskTransformService {
    @Autowired
    ITaskAssignService taskAssignService;
    protected String uploadDir;
    @Autowired
    WorkGroupMemberRepository workGroupMemberRepository;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    MTbtskFieldsService tbtskFieldsService;
    @Autowired
    MTaskTransMediaService taskTransMediaService;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    MTaskNoticeService taskNoticeService;
    @Autowired
    LandRegUserService landRegUserService;
    @Autowired
    Organization2UserRepository organization2UserDao;
    private final GiLoger logger = GwLoger.getLoger(MtaskTransDailyTaskImpl.class);

    public boolean checkData(List<TaskTransformData> tbDataList, Map<String, List<String>> errorInfo) {
        return true;
    }

    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, List<TaskTransformData> tbDataList, String xzqdm) {
        BaseObjectResponse baseResponse;
        block22: {
            baseResponse = new BaseObjectResponse();
            try {
                String token = request.getSession().getAttribute("access_token").toString();
                HashMap<String, List<String>> errorInfo = new HashMap<String, List<String>>();
                if (this.checkData(tbDataList, errorInfo)) {
                    if (tbDataList != null && tbDataList.size() > 0) {
                        TskTaskBiz targetTaskBiz = this.tskTaskBizService.findByTaskId(targetTaskCode);
                        TbtskObjectinfo targetObjinfo = null;
                        List<TbtskFields> targetFields = null;
                        String geofield = "f_shape";
                        if (targetTaskBiz != null && StringUtils.isNotBlank((CharSequence)targetTaskBiz.getTableId())) {
                            targetObjinfo = this.tbtskObjectinfoService.getObjectbyID(targetTaskBiz.getTableId());
                        }
                        if (targetObjinfo != null && StringUtils.isNotBlank((CharSequence)targetObjinfo.getfTablename())) {
                            targetFields = this.tbtskFieldsService.getAllFieldsByTables(targetObjinfo.getfTablename());
                        }
                        if (targetFields != null && targetFields.size() > 0) {
                            ArrayList<String> needAssignTbIdList = new ArrayList<String>();
                            for (TaskTransformData tbData : tbDataList) {
                                HashMap<String, Object> valueMap = new HashMap<String, Object>();
                                String uuid = UUID.randomUUID().toString();
                                String tbId = "";
                                tbId = uuid;
                                valueMap.put("f_id", tbId);
                                valueMap.put("f_status", 1);
                                valueMap.put("f_createtime", System.currentTimeMillis());
                                valueMap.put("f_ismycreate", 0);
                                valueMap.put("f_requestid", "");
                                valueMap.put("f_tbmc", tbData.getTbName());
                                valueMap.put(geofield, tbData.getExtent());
                                valueMap.put("f_tbmj", tbData.getTbmj());
                                valueMap.put("f_tbbh", UUID.randomUUID().toString());
                                valueMap.put("f_userid", userId);
                                valueMap.put("f_sign", "");
                                valueMap.put("f_lon", 0);
                                valueMap.put("f_lat", 0);
                                valueMap.put("f_shape1", tbData.getExtent());
                                for (TbtskFields field : targetFields) {
                                    if (field.getfNullable() != 0 || valueMap.containsKey(field.getfFieldname())) continue;
                                    if (StringUtils.isNotBlank((CharSequence)field.getfDefaultvalue())) {
                                        valueMap.put(field.getfFieldname(), field.getfDefaultvalue());
                                        continue;
                                    }
                                    if (field.getfFieldtype().equalsIgnoreCase("int4")) {
                                        valueMap.put(field.getfFieldname(), 0);
                                        continue;
                                    }
                                    if (field.getfFieldtype().equalsIgnoreCase("varchar")) {
                                        valueMap.put(field.getfFieldname(), "");
                                        continue;
                                    }
                                    if (field.getfFieldtype().equalsIgnoreCase("text")) {
                                        valueMap.put(field.getfFieldname(), "");
                                        continue;
                                    }
                                    if (field.getfFieldtype().equalsIgnoreCase("decimal")) {
                                        valueMap.put(field.getfFieldname(), 0);
                                        continue;
                                    }
                                    if (field.getfFieldtype().equalsIgnoreCase("Character")) {
                                        valueMap.put(field.getfFieldname(), "");
                                        continue;
                                    }
                                    if (!field.getfFieldtype().equalsIgnoreCase("geometry")) continue;
                                    valueMap.put(field.getfFieldname(), tbData.getExtent());
                                }
                                JSONArray jsonArray = tbData.getMedias();
                                if (jsonArray != null && jsonArray.size() > 0) {
                                    ArrayList<TaskTransformMedia> mediaList = new ArrayList<TaskTransformMedia>();
                                    for (Object obj : jsonArray) {
                                        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(obj));
                                        if (jsonObject == null) continue;
                                        TaskTransformMedia media = ((TaskTransMediaService)Gw.beans.getBean(TaskTransMediaService.class)).convertTaskTransMediaFromJson(jsonObject);
                                        media.setAttachId(UUID.randomUUID().toString());
                                        mediaList.add(media);
                                    }
                                    this.taskTransMediaService.saveAttach(userId, tbId, tbData.getExtent(), mediaList, token);
                                }
                                this.dataBizService.insertData(targetObjinfo.getfTablename(), valueMap, geofield);
                                try {
                                    HashMap updateMap = new HashMap();
                                    String updateSql = "f_lon = st_x(st_centroid(f_shape)),f_lat = st_y(st_centroid(f_shape))";
                                    this.dataBizService.updateBySql(targetObjinfo.getfTablename(), updateSql, "f_id ='" + tbId + "'");
                                }
                                catch (Exception e) {
                                    this.logger.error((Throwable)e);
                                    throw new RuntimeException(e);
                                }
                                needAssignTbIdList.add(tbId);
                            }
                            this.assignCurrentTaskData(needAssignTbIdList, userId, targetTaskCode);
                        }
                    }
                    baseResponse.setStatus("OK");
                    baseResponse.setMessage("\u8f6c\u6362\u6210\u529f!");
                    break block22;
                }
                StringBuilder sb = new StringBuilder();
                if (!errorInfo.isEmpty()) {
                    for (String key : errorInfo.keySet()) {
                        sb.append(errorInfo.get(key));
                        sb.append(";");
                    }
                }
                baseResponse.setStatus("FAILURE");
                baseResponse.setMessage(sb.toString());
            }
            catch (UncategorizedSQLException ue) {
                ue.printStackTrace();
                this.logger.error((Throwable)ue);
                baseResponse.setStatus("FAILURE");
                baseResponse.setMessage("\u8f6c\u6362\u5931\u8d25\uff0c\u6570\u636e\u7c7b\u578b\u4e0d\u5339\u914d");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error((Throwable)e);
                baseResponse.setStatus("FAILURE");
                baseResponse.setMessage(e.getMessage());
            }
        }
        return baseResponse;
    }

    private void assignCurrentTaskData(List<String> tbIdList, long userId, String taskId) {
        JSONArray tbIds = new JSONArray();
        JSONArray userIds = new JSONArray();
        JSONObject org = new JSONObject();
        JSONArray groups = new JSONArray();
        JSONArray orgs = new JSONArray();
        userIds.add((Object)userId);
        org.put("userids", (Object)userIds);
        List organization2Users = this.organization2UserDao.queryByUserId(Long.valueOf(userId));
        if (organization2Users != null && organization2Users.size() > 0) {
            org.put("orgid", (Object)((Organization2User)organization2Users.get(0)).getOrganizationId());
        }
        orgs.add((Object)org);
        if (tbIdList != null && tbIdList.size() > 0) {
            for (String tbid : tbIdList) {
                TskAssignRecord record = this.tskTaskBizService.getRecordByTaskIdAndExecutorId(tbid, userId);
                if (record != null) continue;
                tbIds.add((Object)tbid);
            }
        }
        this.taskAssignService.assignTask(Long.valueOf(userId), taskId, tbIds, groups, orgs);
    }
}

