/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.pub.entity.TbScheduleRecord;
import com.geoway.landteam.landcloud.model.pub.entity.TbScheduleTarget;
import com.geoway.landteam.landcloud.repository.pub.TbScheduleRecordRepository;
import com.geoway.landteam.landcloud.repository.pub.TbScheduleTargetRepository;
import com.geoway.landteam.landcloud.servface.customtask.task.TbScheduleRecordService;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class TbScheduleRecordServiceImpl
implements TbScheduleRecordService {
    @Autowired
    private TbScheduleRecordRepository tbScheduleRecordRepository;
    @Autowired
    private TbScheduleTargetRepository tbScheduleTargetRepository;
    @Autowired
    private AppMediaRepository appMediaRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    RegionService regionService;

    public List<TbScheduleRecord> getScheduleRecordList(String type, String content, Date startTime, Date endTime) {
        if (StringUtils.isNotBlank((CharSequence)type)) {
            if (Objects.nonNull(startTime) && Objects.nonNull(endTime)) {
                return this.tbScheduleRecordRepository.getScheduleRecordList(type, content, startTime, endTime);
            }
            if (Objects.nonNull(startTime)) {
                return this.tbScheduleRecordRepository.getScheduleRecordList(type, content, startTime);
            }
            return this.tbScheduleRecordRepository.getScheduleRecordList(type, content);
        }
        if (Objects.nonNull(startTime) && Objects.nonNull(endTime)) {
            return this.tbScheduleRecordRepository.getScheduleRecordList(content, startTime, endTime);
        }
        if (Objects.nonNull(startTime)) {
            return this.tbScheduleRecordRepository.getScheduleRecordList(content, startTime);
        }
        return this.tbScheduleRecordRepository.getScheduleRecordList(content);
    }

    public String startScheduleRecord(String type, String deviceType, Long userId, String taskId, String tbId, String tbbh, String tbLocation, String receiver) {
        TbScheduleRecord tbScheduleRecord = new TbScheduleRecord();
        String fId = UUID.randomUUID().toString();
        tbScheduleRecord.setFId(fId);
        tbScheduleRecord.setFType(type);
        if ("1".equals(type)) {
            List appMedia = this.appMediaRepository.queryByGid(tbId);
            if (appMedia == null || CollectionUtils.isEmpty((Collection)appMedia)) {
                tbScheduleRecord.setFLogo("https://obs-cq-public.obs.cn-north-4.myhuaweicloud.com/picture/%E6%8C%87%E6%8C%A5%E8%B0%83%E5%BA%A6-%E8%B0%83%E5%BA%A6%E5%8A%A8%E6%80%81%E9%BB%98%E8%AE%A4%E5%9B%BE%E7%89%87.jpg");
            } else {
                tbScheduleRecord.setFLogo(((AppMedia)appMedia.get(0)).getServerpath());
            }
        } else {
            tbScheduleRecord.setFLogo("https://obs-cq-public.obs.cn-north-4.myhuaweicloud.com/picture/%E6%8C%87%E6%8C%A5%E8%B0%83%E5%BA%A6-%E8%B0%83%E5%BA%A6%E5%8A%A8%E6%80%81%E9%BB%98%E8%AE%A4%E5%9B%BE%E7%89%87.jpg");
        }
        LandUser landUser = this.landUserRepository.queryUserById(userId);
        tbScheduleRecord.setFSender(landUser.getName());
        tbScheduleRecord.setFReceiver(receiver);
        if ("1".equals(deviceType)) {
            tbScheduleRecord.setFReceiverUserId(receiver);
        }
        String name = "";
        if (StringUtils.isNotBlank((CharSequence)tbLocation)) {
            String substring;
            name = this.regionService.getName(tbLocation);
            if (StringUtils.isBlank((CharSequence)name)) {
                substring = tbLocation.substring(0, 9);
                name = this.regionService.getName(substring);
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                substring = tbLocation.substring(0, 6);
                name = this.regionService.getName(substring);
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                name = "\u91cd\u5e86\u5e02";
            }
        } else {
            name = "\u91cd\u5e86\u5e02";
        }
        tbScheduleRecord.setFStartTime(new Timestamp(new Date().getTime()));
        tbScheduleRecord.setFDeviceType(deviceType);
        tbScheduleRecord.setFStatus("1");
        tbScheduleRecord.setFSendUserId(userId.toString());
        this.tbScheduleRecordRepository.save((Object)tbScheduleRecord);
        TbScheduleTarget tbScheduleTarget = new TbScheduleTarget();
        tbScheduleTarget.setFId(UUID.randomUUID().toString());
        tbScheduleTarget.setFType(type);
        tbScheduleTarget.setFLinkid(fId);
        tbScheduleTarget.setFTaskId(taskId);
        tbScheduleTarget.setFTbid(tbId);
        tbScheduleTarget.setFLocation(name);
        tbScheduleTarget.setFTbbh(tbbh);
        tbScheduleTarget.setFCreateTime(new Timestamp(new Date().getTime()));
        this.tbScheduleTargetRepository.save((Object)tbScheduleTarget);
        return tbScheduleRecord.getFId();
    }

    public boolean endScheduleRecord(String scheduleId, String channelId, String state, String receiver) {
        TbScheduleRecord tbScheduleRecord = (TbScheduleRecord)this.tbScheduleRecordRepository.findById((Object)scheduleId).get();
        String deviceType = tbScheduleRecord.getFDeviceType();
        if ("1".equals(deviceType) && StringUtils.isBlank((CharSequence)tbScheduleRecord.getFReceiver())) {
            tbScheduleRecord.setFReceiver(receiver);
        }
        tbScheduleRecord.setFChannelId(channelId);
        tbScheduleRecord.setFState(state);
        tbScheduleRecord.setFEndTime(new Timestamp(new Date().getTime()));
        tbScheduleRecord.setFStatus("2");
        this.tbScheduleRecordRepository.save((Object)tbScheduleRecord);
        return true;
    }

    public Map<String, Object> getNearUserList(String wkt, Integer radius, int page, int rows, String filter, String type) throws ParseException {
        Geometry geo = WKTUtil.wktToGeom((String)wkt);
        double degree = (double)radius.intValue() * 8.9992800575E-6;
        Geometry geometry = geo.buffer(degree);
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -5);
        Date beforeD = beforeTime.getTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String before = sf.format(beforeD);
        String sql = "with tem  as(\nSELECT max(f_updatetime) f_updatetime,f_userid FROM tb_devicetrack where f_updatetime > '" + before + "' group by f_userid\n)\n select u.f_userid userId,u.f_username userName,u.f_rname rname,u.f_phonemobile phone, de.f_lon lon,de.f_lat lat, ty.f_accid as accid, ty.f_token  as token  from tb_devicetrack de  inner join tbsys_user u on de.f_userid = u.f_userid   inner join tem on  tem.f_userid = u.f_userid   inner join tb_yxuser2 ty on u.f_userid = ty.f_id  where de.f_updatetime = tem.f_updatetime  and st_contains(st_geometryfromtext('" + WKTUtil.geomToWkt((Geometry)geometry) + "'),\n st_geometryfromtext('POINT('||de.f_lon||' '||de.f_lat||')' ))";
        String countsql = "with tem  as(\nSELECT max(f_updatetime) f_updatetime,f_userid FROM tb_devicetrack where f_updatetime > '" + before + "' group by f_userid\n)\nselect count(1)  from tb_devicetrack de  inner join tbsys_user u on de.f_userid = u.f_userid   inner join tem on  tem.f_userid = u.f_userid   inner join tb_yxuser2 ty on u.f_userid = ty.f_id  where de.f_updatetime = tem.f_updatetime and st_contains(st_geometryfromtext('" + WKTUtil.geomToWkt((Geometry)geometry) + "'),\nst_geometryfromtext('POINT('||de.f_lon||' '||de.f_lat||')' ))";
        sql = sql + " limit " + rows + " offset " + (page - 1) * rows;
        List userList = this.jdbcTemplate.queryForList(sql);
        Long userCount = (Long)this.jdbcTemplate.queryForObject(countsql, Long.class);
        Iterator iterator = userList.iterator();
        while (iterator.hasNext()) {
            Map map;
            map.put("phone", (map = (Map)iterator.next()).get("phone") != null ? map.get("phone").toString() : null);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userList", userList);
        map.put("userCount", userCount);
        return map;
    }

    public Map<String, Object> getNearDroneList(String wkt, Integer radius, int page, int rows, String filter, String type) throws ParseException {
        Geometry geo = WKTUtil.wktToGeom((String)wkt);
        double degree = (double)radius.intValue() * 8.9992800575E-6;
        Geometry geometry = geo.buffer(degree);
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(12, -5);
        Date beforeD = beforeTime.getTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String before = sf.format(beforeD);
        String sql = "with tem as(\n\tselect t.* from (\n\t\tselect tdd.*, row_number() over (partition by tdd.f_sn order by tdd.f_updatetime desc)  from tb_drone_devicetrack tdd where tdd.f_updatetime > '" + before + "'\n\t) t where t.row_number = 1) select * from tb_drone_live_channel tdlc \ninner join tem on tdlc.f_sn = tem.f_sn \nwhere st_contains(st_geometryfromtext('" + WKTUtil.geomToWkt((Geometry)geometry) + "'),  st_geometryfromtext('POINT('|| tem.f_lon ||' '|| tem.f_lat ||')' ))";
        String countsql = "with tem as(\n\tselect t.* from (\n\t\tselect tdd.*, row_number() over (partition by tdd.f_sn order by tdd.f_updatetime desc)  from tb_drone_devicetrack tdd where tdd.f_updatetime > '" + before + "'\n\t) t where t.row_number = 1) select count(*) from tb_drone_live_channel tdlc \ninner join tem on tdlc.f_sn = tem.f_sn \nwhere st_contains(st_geometryfromtext('" + WKTUtil.geomToWkt((Geometry)geometry) + "'),  st_geometryfromtext('POINT('|| tem.f_lon ||' '|| tem.f_lat ||')' ))";
        sql = sql + " limit " + rows + " offset " + (page - 1) * rows;
        List userList = this.jdbcTemplate.queryForList(sql);
        Long userCount = (Long)this.jdbcTemplate.queryForObject(countsql, Long.class);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userList", userList);
        map.put("userCount", userCount);
        return map;
    }

    public List<TbScheduleTarget> getScheduleTargetList(String type, String taskId, String tbId) {
        List all = this.tbScheduleTargetRepository.getScheduleTargetList(type, taskId, tbId);
        for (TbScheduleTarget tbScheduleTarget : all) {
            TbScheduleRecord tbScheduleRecord = (TbScheduleRecord)this.tbScheduleRecordRepository.findById((Object)tbScheduleTarget.getFLinkid()).get();
            tbScheduleTarget.setFScheduleSender(tbScheduleRecord.getFSender());
            tbScheduleTarget.setFScheduleReceiver(tbScheduleRecord.getFReceiver());
        }
        return all;
    }

    public List<TbScheduleRecord> getScheduleRecordByChannelId(String channelId) {
        return this.tbScheduleRecordRepository.findByChannelId(channelId);
    }
}

