/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.taskTranslate.dto.SpatialIntersectOptionDto;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskRelationAtalsResultDto;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskRelationAtlasDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateAtlasDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateAttach;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateField;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTask;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTemplate;
import com.geoway.landteam.landcloud.common.util.RequestUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.http.HttpUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTaskTranslateAtlasService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateAttachService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateFieldService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTaskService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTemplateService;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class MTaskTranslateAtlasServiceImpl
implements MTaskTranslateAtlasService {
    private static final GiLoger log = GwLoger.getLoger();
    private static final int BATCH_COUNT = 50;
    @Autowired
    TskTaskBizService taskBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    MTbTaskTranslateTemplateService taskTranslateTemplateService;
    @Autowired
    MTbTaskTranslateFieldService taskTranslateFieldService;
    @Autowired
    MTbTaskTranslateAttachService taskTranslateAttachService;
    @Autowired
    MTbTaskTranslateTaskService tbTaskTranslateTaskService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    AppMediaService appMediaService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public Boolean setRelationTemplate(String templateId, String taskId, String atlasId) {
        Optional<SpatialIntersectOptionDto> optional;
        TbTaskTranslateTask task = this.tbTaskTranslateTaskService.select(atlasId);
        TaskRelationAtlasDTO dto = (TaskRelationAtlasDTO)JSONObject.parseObject((String)task.getParam(), TaskRelationAtlasDTO.class);
        if (dto.getOptions() != null && (optional = dto.getOptions().stream().filter(t -> t.getTaskId().equals(taskId)).findFirst()).isPresent()) {
            SpatialIntersectOptionDto op = optional.get();
            op.setTemplateId(templateId);
            String param = JSONObject.toJSONString((Object)dto);
            this.tbTaskTranslateTaskService.updateParam(task.getId(), param);
            return true;
        }
        return false;
    }

    public String getRelationTemplate(String taskId, String atlasId) {
        Optional<SpatialIntersectOptionDto> optional;
        TbTaskTranslateTask task = this.tbTaskTranslateTaskService.select(atlasId);
        TaskRelationAtlasDTO dto = (TaskRelationAtlasDTO)JSONObject.parseObject((String)task.getParam(), TaskRelationAtlasDTO.class);
        if (dto.getOptions() != null && (optional = dto.getOptions().stream().filter(t -> t.getTaskId().equals(taskId)).findFirst()).isPresent()) {
            SpatialIntersectOptionDto op = optional.get();
            return op.getTemplateId();
        }
        return null;
    }

    public Map createRelationAtlasTask(TaskRelationAtlasDTO dto, long userId) {
        GutilAssert.notNull((Object)dto, (String)"parameter 'dto' must not be null .");
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", "");
        try {
            if (StringUtils.isEmpty((CharSequence)dto.getTargetTaskId())) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1id\u4e3a\u7a7a\u3002");
                return retVal;
            }
            TskTaskBiz targetTaskBiz = this.taskBizService.findByTaskId(dto.getTargetTaskId());
            if (targetTaskBiz == null) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u3002");
                return retVal;
            }
            TbtskObjectinfo targetTableInfo = this.tbtskObjectinfoService.getObjectByTableId(targetTaskBiz.getTableId());
            if (targetTableInfo == null) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u6570\u636e\u8868\u4e0d\u5b58\u5728\u3002");
                return retVal;
            }
            String tableName = targetTableInfo.getfTablename();
            if (StringUtils.isBlank((CharSequence)tableName)) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u6570\u636e\u8868\u540d\u4e3a\u7a7a\u3002");
                return retVal;
            }
            if (dto.getTransMode() == null || dto.getTransMode() != 1 && dto.getTransMode() != 2) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u6a21\u5f0f\u672a\u77e5\u30101\u4e3a\u7a7a\u95f4\u53e0\u52a0\u8f6c\u6362\uff0c2\u552f\u4e00\u503c\u8f6c\u6362\u3011");
                return retVal;
            }
            if (dto.getSourceTaskIds() == null || dto.getSourceTaskIds().isEmpty()) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u6e90\u6570\u636e\u4e3a\u7a7a\u3002");
                return retVal;
            }
            if (StringUtils.isBlank((CharSequence)dto.getTargetPrimaryField())) {
                dto.setTargetPrimaryField("f_id");
            }
            if (StringUtils.isBlank((CharSequence)dto.getTargetShapeField())) {
                dto.setTargetShapeField("f_shape");
            }
            if (dto.getTargetWhereClause() == null) {
                dto.setTargetWhereClause("");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date time = new Date();
            String createTime = df.format(time);
            String name = "\u4efb\u52a1\u8f6c\u6362-" + targetTaskBiz.getName() + "-" + createTime;
            String desc = "\u4efb\u52a1\u8f6c\u6362-" + targetTaskBiz.getName();
            Integer priority = 100;
            String userName = String.valueOf(userId);
            String primaryField = dto.getTargetPrimaryField();
            String shapeField = dto.getTargetShapeField();
            String whereClause = dto.getTargetWhereClause();
            int splitCount = dto.getSplitCount() == null || dto.getSplitCount() <= 0 ? 500 : dto.getSplitCount();
            dto.setSplitCount(Integer.valueOf(splitCount));
            double areaRate = dto.getAreaRate() == null || dto.getAreaRate() <= 0.0 || dto.getAreaRate() >= 1.0 ? 0.9 : (double)dto.getSplitCount().intValue();
            dto.setAreaRate(Double.valueOf(areaRate));
            ArrayList<SpatialIntersectOptionDto> layerInfos = new ArrayList<SpatialIntersectOptionDto>();
            for (String id : dto.getSourceTaskIds()) {
                TskTaskBiz sourceTaskBiz = this.taskBizService.findByTaskId(id);
                if (sourceTaskBiz == null) {
                    retVal.put("error", "\u8f6c\u6362\u6e90\u4efb\u52a1" + id + "\u4e0d\u5b58\u5728\u3002");
                    return retVal;
                }
                TbtskObjectinfo sourceTableInfo = this.tbtskObjectinfoService.getObjectByTableId(sourceTaskBiz.getTableId());
                if (sourceTableInfo == null) {
                    retVal.put("error", "\u8f6c\u6362\u6e90\u4efb\u52a1" + id + "\u6570\u636e\u8868\u4e0d\u5b58\u5728\u3002");
                    return retVal;
                }
                String layer = sourceTableInfo.getfTablename();
                String where = "";
                String primary = "f_id";
                String shape = "f_shape";
                String intersectName = "intersect_" + UUID.randomUUID().toString().replace("-", "");
                SpatialIntersectOptionDto option = new SpatialIntersectOptionDto();
                option.setLayerName(layer);
                option.setPrimaryField(primary);
                option.setShapeField(shape);
                option.setWhereClause(where);
                option.setIntersectName(intersectName);
                option.setTaskId(id);
                option.setTaskName(sourceTaskBiz.getName());
                layerInfos.add(option);
            }
            String pathClassPath = Thread.currentThread().getContextClassLoader().getResource("").getPath();
            String pathRoot = "";
            try {
                pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), new Object[]{ex});
                retVal.put("error", "\u83b7\u53d6\u5173\u8054\u4efb\u52a1\u6a21\u677fjson\u6587\u4ef6\u5931\u8d25\u3002");
                return retVal;
            }
            String jsonFile = pathRoot + "data" + File.separator + "taskRelationAtlas.json";
            File file = new File(jsonFile);
            if (!file.exists()) {
                log.error("\u5173\u8054\u4efb\u52a1\u6a21\u677fjson\u4e0d\u5b58\u5728\uff1a" + jsonFile, new Object[0]);
                retVal.put("error", "\u5173\u8054\u4efb\u52a1\u6a21\u677fjson\u6587\u4ef6\u4e0d\u5b58\u5728\u3002");
                return retVal;
            }
            String jsonStr = this.readFile(file);
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            jsonObject.put("Name", (Object)name);
            jsonObject.put("Desc", (Object)desc);
            jsonObject.put("CreateTime", (Object)createTime);
            jsonObject.put("Priority", (Object)priority);
            jsonObject.put("UserName", (Object)userName);
            JSONArray jsonArray = jsonObject.getJSONArray("JobsList");
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject job = jsonArray.getJSONObject(i);
                String jobName = job.getString("Name");
                JSONArray params = job.getJSONArray("ParamsList");
                if (!jobName.startsWith("\u6570\u636e\u5173\u8054\u6a21\u578b")) continue;
                block26: for (int j = 0; j < params.size(); ++j) {
                    String paramName;
                    JSONObject param = params.getJSONObject(j);
                    switch (paramName = param.getString("Name")) {
                        case "LayerName": {
                            param.put("ValueString", (Object)tableName);
                            continue block26;
                        }
                        case "PrimaryField": {
                            param.put("ValueString", (Object)primaryField);
                            continue block26;
                        }
                        case "ShapeField": {
                            param.put("ValueString", (Object)shapeField);
                            continue block26;
                        }
                        case "WhereClause": {
                            param.put("ValueString", (Object)whereClause);
                            continue block26;
                        }
                        case "LayerInfos": {
                            param.put("ValueString", (Object)JSONArray.toJSONString(layerInfos));
                            continue block26;
                        }
                        case "TransMode": {
                            param.put("ValueString", (Object)dto.getTransMode());
                            continue block26;
                        }
                        case "SplitCount": {
                            param.put("ValueString", (Object)splitCount);
                            continue block26;
                        }
                        case "Rate": {
                            param.put("ValueString", (Object)areaRate);
                        }
                    }
                }
            }
            SysConfig config = this.sysConfigService.findOne("atlas-url");
            if (config == null) {
                retVal.put("error", "\u672a\u914d\u7f6eatlas\u8ba1\u7b97\u6846\u67b6\u5730\u5740\u3002");
                return retVal;
            }
            String data = HttpUtil.JsonPostInvoke((String)(config.getValue() + "/atlas/task/create"), (String)("taskdata=[" + jsonObject.toJSONString() + "]"));
            JSONObject dataJons = JSONObject.parseObject((String)data);
            if ("true".equals(dataJons.getString("flag"))) {
                String atlasId = dataJons.getString("taskid");
                dto.setOptions(layerInfos);
                TbTaskTranslateTask task = new TbTaskTranslateTask();
                task.setName(targetTaskBiz.getName() + "-\u5339\u914d\u4efb\u52a1");
                task.setId(atlasId);
                task.setTaskId(dto.getTargetTaskId());
                task.setCreateTime(new Date());
                task.setRelationCount(Integer.valueOf(0));
                task.setRelationingCount(Integer.valueOf(0));
                task.setStatus(Short.valueOf("0"));
                task.setParam(JSONObject.toJSONString((Object)dto));
                task.setUseingCount(Integer.valueOf(0));
                task.setUseCount(Integer.valueOf(0));
                task.setIsUsed(Short.valueOf("0"));
                task.setUserId(String.valueOf(userId));
                this.tbTaskTranslateTaskService.insert(task);
                retVal.put("result", true);
                retVal.put("data", atlasId);
            } else {
                retVal.put("result", false);
                retVal.put("data", dataJons.getString("msg"));
            }
        }
        catch (Exception e) {
            retVal.put("error", e.getMessage());
        }
        return retVal;
    }

    public Map startTask(String id) {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", "");
        SysConfig config = this.sysConfigService.findOne("atlas-url");
        if (config == null) {
            retVal.put("error", "\u672a\u914d\u7f6eatlas\u8ba1\u7b97\u6846\u67b6\u5730\u5740\u3002");
            return retVal;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair param = new BasicNameValuePair("id", id);
        params.add(param);
        try {
            JSONObject json = RequestUtil.sendHttpRequest(null, (String)config.getValue(), (String)"/atlas/task/start", null, params, (boolean)false);
            if (json != null) {
                if ("true".equals(json.getString("flag"))) {
                    this.tbTaskTranslateTaskService.update(id, Integer.valueOf(1), new Date());
                    retVal.put("result", true);
                    retVal.put("data", "\u4efb\u52a1\u542f\u52a8\u6210\u529f");
                } else {
                    this.tbTaskTranslateTaskService.update(id, Integer.valueOf(-1), new Date());
                    retVal.put("error", "\u4efb\u52a1\u542f\u52a8\u5931\u8d25");
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), new Object[]{ex});
            retVal.put("error", "\u542f\u52a8\u4efb\u52a1\u5931\u8d25");
        }
        return retVal;
    }

    public Map progressTask(String id) {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", "");
        SysConfig config = this.sysConfigService.findOne("atlas-url");
        if (config == null) {
            retVal.put("error", "\u672a\u914d\u7f6eatlas\u8ba1\u7b97\u6846\u67b6\u5730\u5740\u3002");
            return retVal;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair param = new BasicNameValuePair("id", id);
        params.add(param);
        try {
            JSONObject json = RequestUtil.sendHttpRequest(null, (String)config.getValue(), (String)"/atlas/task/get", null, params, (boolean)false);
            if (json != null) {
                if ("true".equals(json.getString("IsSucceed"))) {
                    retVal.put("result", true);
                    retVal.put("data", json.getIntValue("Progress"));
                } else {
                    retVal.put("error", "\u4efb\u52a1\u6267\u884c\u5931\u8d25");
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), new Object[]{ex});
            retVal.put("error", "\u83b7\u53d6\u4efb\u52a1\u8fdb\u5ea6\u5931\u8d25");
        }
        return retVal;
    }

    public Map finishedTask(String id) {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", "");
        SysConfig config = this.sysConfigService.findOne("atlas-url");
        if (config == null) {
            retVal.put("error", "\u672a\u914d\u7f6eatlas\u8ba1\u7b97\u6846\u67b6\u5730\u5740\u3002");
            return retVal;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        BasicNameValuePair param = new BasicNameValuePair("id", id);
        params.add(param);
        try {
            JSONObject json = RequestUtil.sendHttpRequest(null, (String)config.getValue(), (String)"/atlas/task/get", null, params, (boolean)false);
            if (json != null) {
                if ("true".equals(json.getString("IsSucceed"))) {
                    retVal.put("result", true);
                    retVal.put("data", json.getIntValue("Progress") == 100);
                } else {
                    retVal.put("error", "\u4efb\u52a1\u6267\u884c\u5931\u8d25");
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), new Object[]{ex});
            retVal.put("error", "\u83b7\u53d6\u4efb\u52a1\u8fdb\u5ea6\u5931\u8d25");
        }
        return retVal;
    }

    public Map createTranslateAtlasTask(TaskTranslateAtlasDTO dto, long userId) {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", "");
        Object taskTranslateLog = null;
        try {
            String checkResult = this.checkBeforeTranslate(dto);
            if (StringUtils.isNotBlank((CharSequence)checkResult)) {
                retVal.put("error", checkResult);
                return retVal;
            }
            this.tbTaskTranslateTaskService.updateUseCount(dto.getId(), dto.getTotalCount());
            this.tbTaskTranslateTaskService.updateUseingCount(dto.getId(), Integer.valueOf(0));
            int useingCount = 0;
            for (TaskTranslateAtlasDTO.TranslateRecord recort : dto.getTasks()) {
                String where;
                List ids;
                int endIndex;
                int startIndex;
                int i;
                TbTaskTranslateTemplate translateTemplate = this.taskTranslateTemplateService.findOneById(recort.getTemplateId());
                List taskTranslateFields = this.taskTranslateFieldService.queryFieldsByTemplateId(translateTemplate.getId());
                List taskTranslateAttaches = this.taskTranslateAttachService.queryAttachsByTemplateId(translateTemplate.getId());
                HashMap<String, String> translateFieldMapping = new HashMap<String, String>(taskTranslateFields.size());
                for (TbTaskTranslateField field : taskTranslateFields) {
                    translateFieldMapping.put(field.getFieldName(), field.getSourceFieldName());
                }
                TskTaskBiz targetTaskBiz = this.taskBizService.findByTaskId(recort.getTaskId());
                TbtskObjectinfo targetTableInfo = this.tbtskObjectinfoService.getObjectByTableId(targetTaskBiz.getTableId());
                if (targetTableInfo == null) continue;
                String relationName = this.getRelation(recort.getTemplateId(), recort.getTaskId(), dto.getId());
                if (StringUtils.isBlank((CharSequence)relationName)) {
                    retVal.put("error", "\u5173\u8054\u7ed3\u679c\u8868\u540d\u4e3a\u7a7a");
                    return retVal;
                }
                if (!this.dataBizService.isExistTableName(relationName)) {
                    retVal.put("error", "\u5173\u8054\u7ed3\u679c\u8868\u4e0d\u5b58\u5728");
                    return retVal;
                }
                List<String> fieldNameList = taskTranslateFields.stream().map(TbTaskTranslateField::getFieldName).collect(Collectors.toList());
                fieldNameList.add("f_key1");
                fieldNameList.add("f_key2");
                int pageCount = recort.getTbIds().size() / 50 + 1;
                List<Object> pageData = null;
                HashMap<String, List<String>> tbIdMap = new HashMap<String, List<String>>();
                if (translateTemplate.getTranslateType().intValue() == 1) {
                    for (i = 0; i < pageCount; ++i) {
                        startIndex = i * 50;
                        endIndex = (i + 1) * 50;
                        if (endIndex >= recort.getTbIds().size()) {
                            endIndex = recort.getTbIds().size();
                        }
                        ids = recort.getTbIds().subList(startIndex, endIndex);
                        where = "f_id in ('" + StringUtils.join(ids, (CharSequence)"','") + "')";
                        pageData = new ArrayList(50);
                        pageData = this.dataBizService.queryAllData(relationName, fieldNameList, where);
                        this.translateAndSaveTbData(pageData, translateFieldMapping, tbIdMap, targetTableInfo.getfTablename());
                        this.tbTaskTranslateTaskService.updateUseingCount(dto.getId(), Integer.valueOf(useingCount += ids.size()));
                    }
                    continue;
                }
                if (translateTemplate.getTranslateType().intValue() == 3) {
                    for (i = 0; i < pageCount; ++i) {
                        startIndex = i * 50;
                        endIndex = (i + 1) * 50;
                        if (endIndex >= recort.getTbIds().size()) {
                            endIndex = recort.getTbIds().size();
                        }
                        ids = recort.getTbIds().subList(startIndex, endIndex);
                        where = "f_id in ('" + StringUtils.join(ids, (CharSequence)"','") + "')";
                        ArrayList fields = ListUtil.toList((Object[])new String[]{"f_key2", "f_key1"});
                        pageData = new ArrayList(50);
                        pageData = this.dataBizService.queryAllData(relationName, fields, where);
                        for (Map map : pageData) {
                            String key1 = map.get("f_key1").toString();
                            String key2 = map.get("f_key2").toString();
                            if (tbIdMap.containsKey(key2)) {
                                ((List)tbIdMap.get(key2)).add(key1);
                                continue;
                            }
                            ArrayList<String> keys = new ArrayList<String>();
                            keys.add(key1);
                            tbIdMap.put(key2, keys);
                        }
                        List tbIds = pageData.stream().map(m -> m.get("f_key2").toString()).collect(Collectors.toList());
                        List list = this.appMediaService.queryByGalleryids(tbIds);
                        this.translateAndSaveAttachData(list, tbIdMap, taskTranslateAttaches, userId);
                        this.tbTaskTranslateTaskService.updateUseingCount(dto.getId(), Integer.valueOf(useingCount += ids.size()));
                    }
                    continue;
                }
                if (translateTemplate.getTranslateType().intValue() != 2) continue;
                for (i = 0; i < pageCount; ++i) {
                    startIndex = i * 50;
                    endIndex = (i + 1) * 50;
                    if (endIndex >= recort.getTbIds().size()) {
                        endIndex = recort.getTbIds().size();
                    }
                    ids = recort.getTbIds().subList(startIndex, endIndex);
                    where = "f_id in ('" + StringUtils.join(ids, (CharSequence)"','") + "')";
                    pageData = new ArrayList(50);
                    pageData = this.dataBizService.queryAllData(relationName, fieldNameList, where);
                    this.translateAndSaveTbData(pageData, translateFieldMapping, tbIdMap, targetTableInfo.getfTablename());
                    List tbIds = pageData.stream().map(m -> m.get("f_key2").toString()).collect(Collectors.toList());
                    List appMediaList = this.appMediaService.queryByGalleryids(tbIds);
                    this.translateAndSaveAttachData(appMediaList, tbIdMap, taskTranslateAttaches, userId);
                    this.tbTaskTranslateTaskService.updateUseingCount(dto.getId(), Integer.valueOf(useingCount += ids.size()));
                }
            }
            this.tbTaskTranslateTaskService.setUse(dto.getId());
        }
        catch (Exception e) {
            log.error(e.getMessage(), new Object[]{e});
            retVal.put("error", "\u590d\u7528\u5931\u8d25");
            return retVal;
        }
        retVal.put("result", true);
        return retVal;
    }

    public Map list(String taskId, Integer top, long userId) {
        List tasks = null;
        tasks = this.tbTaskTranslateTaskService.queryLatestNWithoutParam(taskId, top, String.valueOf(userId));
        for (TbTaskTranslateTask task : tasks) {
            if (task.getStatus() != 1) continue;
            Map map = this.finishedTask(task.getId());
            if (MapUtils.getBoolean((Map)map, (Object)"result").booleanValue()) {
                if (!MapUtils.getBoolean((Map)map, (Object)"data").booleanValue()) continue;
                task.setStatus(Short.valueOf("2"));
                this.tbTaskTranslateTaskService.updateStatus(task.getId(), Integer.valueOf(2));
                continue;
            }
            task.setStatus(Short.valueOf("-2"));
            this.tbTaskTranslateTaskService.updateStatus(task.getId(), Integer.valueOf(-2));
        }
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", true);
        retVal.put("data", tasks);
        retVal.put("error", "");
        return retVal;
    }

    public List<TbTaskTranslateTask> getDelete() {
        return this.tbTaskTranslateTaskService.getDelete();
    }

    public List<TbTaskTranslateTask> getDeleteByShard(int total, int index) {
        return this.tbTaskTranslateTaskService.getDeleteByShard(total, index);
    }

    public TbTaskTranslateTask find(String id) {
        TbTaskTranslateTask task = this.tbTaskTranslateTaskService.selectSimple(id);
        if (task.getStatus() == 1) {
            Map map = this.finishedTask(task.getId());
            if (MapUtils.getBoolean((Map)map, (Object)"result").booleanValue()) {
                if (MapUtils.getBoolean((Map)map, (Object)"data").booleanValue()) {
                    task.setStatus(Short.valueOf("2"));
                    this.tbTaskTranslateTaskService.updateStatus(task.getId(), Integer.valueOf(2));
                }
            } else {
                task.setStatus(Short.valueOf("-2"));
                this.tbTaskTranslateTaskService.updateStatus(task.getId(), Integer.valueOf(-2));
            }
        }
        return task;
    }

    public Boolean delete(String id) {
        this.tbTaskTranslateTaskService.setDelete(id);
        return true;
    }

    public Boolean deleteWholeTask(TbTaskTranslateTask task) {
        TaskRelationAtlasDTO dto = (TaskRelationAtlasDTO)JSONObject.parseObject((String)task.getParam(), TaskRelationAtlasDTO.class);
        if (dto.getOptions() != null) {
            for (SpatialIntersectOptionDto op : dto.getOptions()) {
                String intersect = op.getIntersectName();
                if (!this.dataBizService.isExistTableName(intersect)) continue;
                String sql = "drop table " + intersect;
                this.jdbcTemplate.execute(sql);
            }
        }
        String sql = "delete from tb_task_translate_tbid where f_atlasid = '" + task.getId() + "'";
        this.jdbcTemplate.execute(sql);
        this.tbTaskTranslateTaskService.delete(task.getId());
        return true;
    }

    public Map detialRelationAtlasTask(String id) {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", true);
        retVal.put("data", "");
        retVal.put("error", "");
        ArrayList<TaskRelationAtalsResultDto> results = new ArrayList<TaskRelationAtalsResultDto>();
        TbTaskTranslateTask task = this.tbTaskTranslateTaskService.select(id);
        String param = task.getParam();
        TaskRelationAtlasDTO dto = (TaskRelationAtlasDTO)JSONObject.parseObject((String)param, TaskRelationAtlasDTO.class);
        List options = dto.getOptions();
        for (SpatialIntersectOptionDto item : options) {
            TaskRelationAtalsResultDto result = new TaskRelationAtalsResultDto();
            result.setId(id);
            result.setTaskId1(task.getTaskId());
            result.setTaskName1(task.getName().replace("-\u5339\u914d\u4efb\u52a1", ""));
            result.setTaskId2(item.getTaskId());
            result.setTaskName2(item.getTaskName());
            result.setTransMode(dto.getTransMode());
            result.setTemplateId(item.getTemplateId());
            if (this.dataBizService.isExistTableName(item.getIntersectName())) {
                Integer count = this.dataBizService.getCount(item.getIntersectName(), "");
                result.setCount(count);
            }
            results.add(result);
        }
        retVal.put("data", results);
        return retVal;
    }

    public Map detialTaskRelationAtlasTask(String id, String taskId, int pageSize, int page) {
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", true);
        retVal.put("data", "");
        retVal.put("error", "");
        ArrayList results = new ArrayList();
        TbTaskTranslateTask task = this.tbTaskTranslateTaskService.select(id);
        String param = task.getParam();
        TaskRelationAtlasDTO dto = (TaskRelationAtlasDTO)JSONObject.parseObject((String)param, TaskRelationAtlasDTO.class);
        List options = dto.getOptions();
        Optional<SpatialIntersectOptionDto> optional = options.stream().filter(t -> t.getTaskId().equals(taskId)).findFirst();
        if (optional.isPresent()) {
            SpatialIntersectOptionDto option = optional.get();
            ArrayList fields = ListUtil.toList((Object[])new String[]{"f_id", "f_key1", "f_key2", "f_unique1", "f_unique2", "f_rate1", "f_rate2"});
            List<Map> maps = this.dataBizService.queryPageData(option.getIntersectName(), fields, pageSize, page, "");
            JSONObject json = new JSONObject();
            json.put("id", (Object)id);
            json.put("taskId1", (Object)task.getTaskId());
            json.put("taskId2", (Object)option.getTaskId());
            json.put("taskName1", (Object)task.getName().replace("-\u5339\u914d\u4efb\u52a1", ""));
            json.put("taskName2", (Object)option.getTaskName());
            json.put("page", maps);
            retVal.put("data", json);
        } else {
            retVal.put("result", false);
            retVal.put("data", "");
            retVal.put("error", "\u672a\u627e\u5230\u4efb\u52a1\u4fe1\u606f");
        }
        return retVal;
    }

    private String readFile(File file) throws Exception {
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            String encode = "utf-8";
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, encode);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            String result = "";
            String text = null;
            while ((text = reader.readLine()) != null) {
                if (!StringUtils.isNotBlank((CharSequence)(text = text.trim()))) continue;
                result = result + text;
            }
            return result;
        }
        return "";
    }

    private String checkBeforeTranslate(TaskTranslateAtlasDTO dto) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)dto.getId())) {
            sb.append(" \u5f85\u8f6c\u6362ID\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
            return sb.toString();
        }
        if (dto.getTasks() == null || dto.getTasks().isEmpty()) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u96c6\u5408\u4e3a\u7a7a\u3002");
            return sb.toString();
        }
        TbTaskTranslateTask task = this.tbTaskTranslateTaskService.select(dto.getId());
        TaskRelationAtlasDTO relaton = (TaskRelationAtlasDTO)JSONObject.parseObject((String)task.getParam(), TaskRelationAtlasDTO.class);
        int totalCount = 0;
        for (TaskTranslateAtlasDTO.TranslateRecord record : dto.getTasks()) {
            List taskTranslateAttaches;
            List taskTranslateFields;
            Optional<SpatialIntersectOptionDto> optional;
            if (StringUtils.isEmpty((CharSequence)record.getTaskId())) {
                sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return sb.toString();
            }
            List tbIds = record.getTbIds();
            if (tbIds == null || tbIds.isEmpty()) {
                sb.append(" \u8bf7\u8bbe\u7f6e\u5f85\u8f6c\u6362\u6570\u636e\u3002 ");
                return sb.toString();
            }
            if (relaton.getOptions() != null && (optional = relaton.getOptions().stream().filter(t -> t.getTaskId().equals(record.getTaskId())).findFirst()).isPresent()) {
                SpatialIntersectOptionDto op = optional.get();
                record.setTemplateId(op.getTemplateId());
                if (tbIds.size() == 1 && ((String)tbIds.get(0)).equals("all")) {
                    tbIds.clear();
                    ArrayList<String> fields = new ArrayList<String>();
                    fields.add("f_id");
                    List<Map> maps = this.dataBizService.queryAllData(op.getIntersectName(), fields, "1=1");
                    maps.forEach(t -> tbIds.add(t.get("f_id").toString()));
                    totalCount += maps.size();
                } else {
                    totalCount += tbIds.size();
                }
            }
            if (StringUtils.isEmpty((CharSequence)record.getTemplateId())) {
                sb.append(" \u8bf7\u8fdb\u884c\u5339\u914d\u8bbe\u7f6e\u3002 ");
                return sb.toString();
            }
            TskTaskBiz targetTaskBiz = this.taskBizService.findByTaskId(record.getTaskId());
            if (targetTaskBiz == null) {
                sb.append(" \u76ee\u6807\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
                return sb.toString();
            }
            TbTaskTranslateTemplate template = this.taskTranslateTemplateService.findOneById(record.getTemplateId());
            if (template == null) {
                sb.append(" \u4efb\u52a1\u8f6c\u6362\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
                return sb.toString();
            }
            TskTaskBiz sourceTaskBiz = this.taskBizService.findByTaskId(template.getSourceTaskId());
            if (sourceTaskBiz == null) {
                sb.append(" \u6e90\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
                return sb.toString();
            }
            if ((template.getTranslateType().intValue() == 1 || template.getTranslateType().intValue() == 3) && GutilCollection.isEmpty((Collection)(taskTranslateFields = this.taskTranslateFieldService.queryFieldsByTemplateId(template.getId())))) {
                sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
                return sb.toString();
            }
            if (template.getTranslateType().intValue() != 2 && template.getTranslateType().intValue() != 3 || !GutilCollection.isEmpty((Collection)(taskTranslateAttaches = this.taskTranslateAttachService.queryAttachsByTemplateId(template.getId())))) continue;
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u9644\u4ef6\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        dto.setTotalCount(Integer.valueOf(totalCount));
        return sb.toString();
    }

    private void translateAndSaveTbData(List<Map> sourceData, Map<String, String> filedNameMapping, Map<String, List<String>> tbIdMap, String dataTableName) {
        if (GutilCollection.isEmpty(sourceData)) {
            return;
        }
        for (Map map : sourceData) {
            String sourceId = map.get("f_key2").toString();
            String targetId = map.get("f_key1").toString();
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            for (Object key : map.keySet()) {
                if (!filedNameMapping.containsKey(key)) continue;
                newMap.put(filedNameMapping.get(key), map.get(key));
            }
            if (tbIdMap.containsKey(sourceId)) {
                tbIdMap.get(sourceId).add(targetId);
            } else {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(targetId);
                tbIdMap.put(sourceId, ids);
            }
            try {
                int ids = this.dataBizService.updateData(dataTableName, newMap, "f_id ='" + targetId + "'");
            }
            catch (Exception e) {
                log.error(e.getMessage(), new Object[]{e});
            }
        }
    }

    private void translateAndSaveAttachData(List<AppMedia> appMediaList, Map<String, List<String>> tbIdMap, List<TbTaskTranslateAttach> taskTranslateAttaches, Long userId) {
        if (appMediaList != null) {
            for (AppMedia appMedia : appMediaList) {
                try {
                    List<String> targetIds = tbIdMap.get(appMedia.getGalleryid());
                    for (String targetId : targetIds) {
                        String ossUrl;
                        AppMedia media = new AppMedia();
                        BeanUtil.copyProperties((Object)appMedia, (Object)media, (boolean)true);
                        String newAttachId = UUID.randomUUID().toString();
                        media.setId(newAttachId);
                        media.setGalleryid(targetId);
                        if (media.getTypetype() != null && taskTranslateAttaches != null) {
                            for (TbTaskTranslateAttach taskTranslateAttach : taskTranslateAttaches) {
                                if (!taskTranslateAttach.getSourceTypeName().equals(media.getTypetype().toString())) continue;
                                media.setTypetype(Integer.valueOf(taskTranslateAttach.getTargetTypeName()));
                            }
                        }
                        String url = media.getServerpath();
                        String name = url.substring(url.lastIndexOf(47) + 1);
                        String newUrl = "media/" + userId + "/" + targetId + "/" + name;
                        if (this.appMediaService.isExist(targetId, newUrl)) continue;
                        String sourceUrl = appMedia.getServerpath();
                        if (sourceUrl.startsWith("https")) {
                            sourceUrl = sourceUrl.replace("https", "http");
                        } else if (sourceUrl.startsWith("HTTPS")) {
                            sourceUrl = sourceUrl.replace("HTTPS", "http");
                        } else if (sourceUrl.startsWith("HTTP")) {
                            sourceUrl = sourceUrl.replace("HTTP", "http");
                        }
                        if (sourceUrl.startsWith("http")) {
                            sourceUrl = sourceUrl.replace("http://", "");
                            sourceUrl = sourceUrl.substring(sourceUrl.indexOf(47) + 1);
                        }
                        if (StringUtils.isNotBlank((CharSequence)(ossUrl = this.ossOperatorService.copyObject(sourceUrl, newUrl)))) {
                            media.setServerpath(newUrl);
                        }
                        int n = this.appMediaService.saveOne(media);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), new Object[]{e});
                }
            }
        }
    }

    public String getRelation(String templateId, String taskId, String atlasId) {
        Optional<SpatialIntersectOptionDto> optional;
        TbTaskTranslateTask task = this.tbTaskTranslateTaskService.select(atlasId);
        TaskRelationAtlasDTO dto = (TaskRelationAtlasDTO)JSONObject.parseObject((String)task.getParam(), TaskRelationAtlasDTO.class);
        if (dto.getOptions() != null && (optional = dto.getOptions().stream().filter(t -> t.getTaskId().equals(taskId)).findFirst()).isPresent()) {
            SpatialIntersectOptionDto op = optional.get();
            return op.getIntersectName();
        }
        return null;
    }
}

