/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;

import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.AttachTranslateLogItem;
import com.geoway.landteam.customtask.taskTranslate.entity.TaskTranslateLog;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateAttach;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateField;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateRecord;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTemplate;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTranslateLogItem;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTaskTranslateService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateAttachService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateFieldService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateRecordService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTemplateService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTaskTranslateServiceImpl
implements MTaskTranslateService {
    private final GiLoger logger = GwLoger.getLoger(MTaskTranslateServiceImpl.class);
    private static final int BATCH_COUNT = 50;
    @Autowired
    MTbTaskTranslateRecordService taskTranslateRecordService;
    @Autowired
    MTskTaskBizService taskBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    MTbTaskTranslateTemplateService taskTranslateTemplateService;
    @Autowired
    MTbTaskTranslateFieldService taskTranslateFieldService;
    @Autowired
    MTbTaskTranslateAttachService taskTranslateAttachService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    AppMediaService appMediaService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    UserNameService userNameService;
    protected String tempDir;

    public Map createTranslateRecord(TaskTranslateDTO dto, long userId) {
        GutilAssert.notNull((Object)dto, (String)"parameter 'dto' must not be null .");
        HashMap<String, Object> retVal = new HashMap<String, Object>();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", "");
        try {
            if (StringUtils.isEmpty((CharSequence)dto.getSourceTaskId())) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return retVal;
            }
            if (StringUtils.isEmpty((CharSequence)dto.getSourceTaskName())) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return retVal;
            }
            if (StringUtils.isEmpty((CharSequence)dto.getTemplateId())) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u6a21\u677fid\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                return retVal;
            }
            if (dto.getTranslateType() == null || dto.getTranslateType() < 1 || dto.getTranslateType() > 3) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u7c7b\u578b\u4e0d\u6b63\u786e\u3002");
                return retVal;
            }
            if (GutilCollection.isEmpty((Collection)dto.getTbIdList())) {
                retVal.put("error", "\u8f6c\u6362\u4efb\u52a1\u56fe\u6591\u6570\u91cf\u4e0d\u80fd\u4e3a\u96f6\u3002");
                return retVal;
            }
            TbTaskTranslateRecord record = new TbTaskTranslateRecord();
            record.setId(UUID.randomUUID().toString());
            record.setCreateTime(new Date());
            record.setCreateUserId(String.valueOf(userId));
            record.setTaskId(dto.getSourceTaskId());
            record.setTaskName(dto.getSourceTaskName());
            record.setTbCount(Integer.valueOf(dto.getTbIdList().size()));
            record.setTemplateId(dto.getTemplateId());
            record.setStatus(Short.valueOf("0"));
            record.setTranslateType(dto.getTranslateType());
            this.taskTranslateRecordService.insertSelective(record);
            retVal.put("result", true);
            retVal.put("data", record.getId());
        }
        catch (Exception e) {
            retVal.put("error", e.getMessage());
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTranslate(TbTaskTranslateRecord record) {
        GutilAssert.notNull((Object)record, (String)"parameter 'record' must not be null .");
        TaskTranslateLog taskTranslateLog = null;
        try {
            String checkResult = this.checkRecordBeforeTranslate(record);
            if (StringUtils.isNotBlank((CharSequence)checkResult)) {
                taskTranslateLog = new TaskTranslateLog();
                taskTranslateLog.setTaskId(StringUtils.isNotBlank((CharSequence)record.getTaskId()) ? record.getTaskId() : "\u8f6c\u6362\u8bb0\u5f55\u7684\u4efb\u52a1id\u4e3a\u7a7a");
                taskTranslateLog.setTaskName(StringUtils.isNotBlank((CharSequence)record.getTaskName()) ? record.getTaskName() : "\u8f6c\u6362\u8bb0\u5f55\u7684\u4efb\u52a1\u540d\u79f0\u4e3a\u7a7a");
                taskTranslateLog.setTranslateType(Short.valueOf(record.getTranslateType() != null ? record.getTranslateType() : (short)0));
                taskTranslateLog.setTranslateUser(this.userNameService.getUserRealNameByUserId(record.getCreateUserId()));
                taskTranslateLog.setTranslateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                record.setErrorInfo(checkResult);
                record.setTbSuccessCount(Integer.valueOf(0));
                record.setAttachSuccessCount(Integer.valueOf(0));
            } else {
                taskTranslateLog = new TaskTranslateLog(record.getTaskId(), record.getTaskName(), record.getTranslateType());
                taskTranslateLog.setTranslateUser(this.userNameService.getUserRealNameByUserId(record.getCreateUserId()));
                taskTranslateLog.setTranslateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                TbTaskTranslateTemplate translateTemplate = this.taskTranslateTemplateService.findOneById(record.getTemplateId());
                List taskTranslateFields = this.taskTranslateFieldService.queryFieldsByTemplateId(translateTemplate.getId());
                List taskTranslateAttaches = this.taskTranslateAttachService.queryAttachsByTemplateId(translateTemplate.getId());
                HashMap<String, String> translateFieldMapping = new HashMap<String, String>(taskTranslateFields.size());
                for (TbTaskTranslateField field : taskTranslateFields) {
                    translateFieldMapping.put(field.getFieldName(), field.getSourceFieldName());
                }
                TskTaskBiz sourceTaskBiz = this.taskBizService.findByTaskId(record.getTaskId());
                TbtskObjectinfo sourceTableInfo = this.tbtskObjectinfoService.getObjectByTableId(sourceTaskBiz.getTableId());
                if (sourceTableInfo != null) {
                    TskTaskBiz targetTaskBiz = this.taskBizService.findByTaskId(translateTemplate.getTargetTaskId());
                    TbtskObjectinfo targetTableInfo = this.tbtskObjectinfoService.getObjectByTableId(targetTaskBiz.getTableId());
                    int totalCount = this.dataBizService.getCount(sourceTableInfo.getfTablename(), "");
                    if (totalCount > 0) {
                        record.setTbCount(Integer.valueOf(totalCount));
                        List fieldNameList = taskTranslateFields.stream().map(TbTaskTranslateField::getFieldName).collect(Collectors.toList());
                        fieldNameList.addAll(this.getSystemFields());
                        int pageCount = totalCount / 50 + 1;
                        List<Map> pageData = null;
                        ArrayList targetInsertDataList = new ArrayList(50);
                        HashMap<String, String> tbIdChangedMap = new HashMap<String, String>();
                        if (record.getTranslateType().intValue() == 1) {
                            for (int i = 0; i < pageCount; ++i) {
                                pageData = new ArrayList(50);
                                pageData = this.dataBizService.queryPageData(sourceTableInfo.getfTablename(), fieldNameList, 50, i + 1, "");
                                taskTranslateLog.setTbCount(Integer.valueOf(taskTranslateLog.getTbCount() + pageData.size()));
                                ArrayList<TbTranslateLogItem> tbTranslateLogItems = new ArrayList<TbTranslateLogItem>(pageData.size());
                                this.translateAndSaveTbData(pageData, translateFieldMapping, tbIdChangedMap, tbTranslateLogItems, targetTableInfo.getfTablename());
                                if (!GutilCollection.isEmpty(tbTranslateLogItems)) {
                                    taskTranslateLog.getTbTaskTranslateLogItems().addAll(tbTranslateLogItems);
                                }
                                taskTranslateLog.setTbSuccessCount(Integer.valueOf(taskTranslateLog.getTbSuccessCount() + (int)tbTranslateLogItems.stream().filter(t -> t.isTransSuccess()).count()));
                            }
                        } else if (record.getTranslateType().intValue() != 2 && record.getTranslateType().intValue() == 3) {
                            for (int i = 0; i < pageCount; ++i) {
                                pageData = new ArrayList(50);
                                pageData = this.dataBizService.queryPageData(sourceTableInfo.getfTablename(), fieldNameList, 50, i, "");
                                taskTranslateLog.setTbCount(Integer.valueOf(taskTranslateLog.getTbCount() + pageData.size()));
                                ArrayList<TbTranslateLogItem> tbTranslateLogItems = new ArrayList<TbTranslateLogItem>(pageData.size());
                                this.translateAndSaveTbData(pageData, translateFieldMapping, tbIdChangedMap, tbTranslateLogItems, targetTableInfo.getfTablename());
                                if (!GutilCollection.isEmpty(tbTranslateLogItems)) {
                                    taskTranslateLog.getTbTaskTranslateLogItems().addAll(tbTranslateLogItems);
                                }
                                List tbIds = pageData.stream().map(m -> m.get("f_id").toString()).collect(Collectors.toList());
                                List appMediaList = this.appMediaService.queryByGalleryids(tbIds);
                                taskTranslateLog.setAttachCount(Integer.valueOf(taskTranslateLog.getAttachCount() + appMediaList.size()));
                                ArrayList<AttachTranslateLogItem> attachTranslateLogItems = new ArrayList<AttachTranslateLogItem>();
                                this.translateAndSaveAttachData(appMediaList, tbIdChangedMap, taskTranslateAttaches, attachTranslateLogItems);
                                if (!GutilCollection.isEmpty(attachTranslateLogItems)) {
                                    taskTranslateLog.getAttachTranslateLogItems().addAll(attachTranslateLogItems);
                                    taskTranslateLog.setAttachSuccessCount(Integer.valueOf(taskTranslateLog.getAttachSuccessCount() + (int)attachTranslateLogItems.stream().filter(t -> t.isTransSuccess()).count()));
                                    for (AttachTranslateLogItem attachTranslateLogItem : attachTranslateLogItems) {
                                        if (attachTranslateLogItem.isTransSuccess()) continue;
                                        for (TbTranslateLogItem tbTranslateLogItem : tbTranslateLogItems) {
                                            if (!attachTranslateLogItem.getTbId().equalsIgnoreCase(tbTranslateLogItem.getTbId())) continue;
                                            tbTranslateLogItem.setTransSuccess(false);
                                            tbTranslateLogItem.setErrorInfo(tbTranslateLogItem.getErrorInfo() + attachTranslateLogItem.getErrorInfo());
                                        }
                                    }
                                }
                                taskTranslateLog.setTbSuccessCount(Integer.valueOf(taskTranslateLog.getTbSuccessCount() + (int)tbTranslateLogItems.stream().filter(t -> t.isTransSuccess()).count()));
                            }
                        }
                    }
                }
            }
            String logFileUrl = this.generateLogFileAndUploadToOss(taskTranslateLog);
            if (StringUtils.isNotBlank((CharSequence)logFileUrl)) {
                record.setTbCount(taskTranslateLog.getTbCount());
                record.setAttachCount(taskTranslateLog.getAttachCount());
                record.setTbSuccessCount(taskTranslateLog.getTbSuccessCount());
                record.setAttachSuccessCount(taskTranslateLog.getAttachSuccessCount());
                record.setLogUrl(logFileUrl);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), new Object[]{e});
            record.setErrorInfo(e.getMessage());
        }
        finally {
            record.setEndTime(new Date());
            record.setStatus(new Short("2"));
            this.taskTranslateRecordService.updateByPrimaryKeySelective(record);
        }
    }

    private String generateTranslateLog(String tempFilePath, String fileName, TaskTranslateLog taskTranslateLog) throws IOException {
        String filePath = "";
        SXSSFWorkbook workbook = null;
        OutputStream os = null;
        try {
            filePath = tempFilePath + File.separator + fileName;
            FileUtil.creatDirectoryIfNotExist((String)tempFilePath);
            workbook = new SXSSFWorkbook(new XSSFWorkbook(), 500);
            workbook.setCompressTempFiles(true);
            this.createTaskSheet(taskTranslateLog, workbook);
            this.createTbSheet(taskTranslateLog, workbook);
            this.createAttachSheet(taskTranslateLog, workbook);
            if (workbook != null) {
                File file = new File(filePath);
                os = new FileOutputStream(file);
                workbook.write(os);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            try {
                if (workbook != null) {
                    workbook.dispose();
                }
            }
            catch (Exception exception) {}
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
        }
        return filePath;
    }

    private Sheet createAttachSheet(TaskTranslateLog taskTranslateLog, SXSSFWorkbook workbook) {
        SXSSFSheet sheet = workbook.createSheet("\u9644\u4ef6\u8f6c\u6362\u7ed3\u679c");
        Row row = sheet.createRow(0);
        row.createCell(0).setCellValue("\u6e90\u56fe\u6591id");
        row.createCell(1).setCellValue("\u65b0\u56fe\u6591id");
        row.createCell(2).setCellValue("\u6e90\u9644\u4ef6id");
        row.createCell(3).setCellValue("\u65b0\u9644\u4ef6id");
        row.createCell(4).setCellValue("\u9644\u4ef6\u540d\u79f0");
        row.createCell(5).setCellValue("\u662f\u5426\u8f6c\u6362\u6210\u529f");
        row.createCell(6).setCellValue("\u9519\u8bef\u539f\u56e0");
        int dataRowIndex = 1;
        if (!GutilCollection.isEmpty((Collection)taskTranslateLog.getAttachTranslateLogItems())) {
            for (AttachTranslateLogItem attachTranslateLogItem : taskTranslateLog.getAttachTranslateLogItems()) {
                row = sheet.createRow(dataRowIndex);
                row.createCell(0).setCellValue(attachTranslateLogItem.getTbId());
                row.createCell(1).setCellValue(attachTranslateLogItem.getNewTbId());
                row.createCell(2).setCellValue(attachTranslateLogItem.getNewTbId());
                row.createCell(3).setCellValue(attachTranslateLogItem.getNewAttachId());
                row.createCell(4).setCellValue(attachTranslateLogItem.getAttachName());
                row.createCell(5).setCellValue(attachTranslateLogItem.isTransSuccess() ? "\u6210\u529f" : "\u5931\u8d25");
                row.createCell(6).setCellValue(attachTranslateLogItem.getErrorInfo());
                ++dataRowIndex;
            }
        }
        return sheet;
    }

    private Sheet createTbSheet(TaskTranslateLog taskTranslateLog, SXSSFWorkbook workbook) {
        SXSSFSheet sheet = workbook.createSheet("\u56fe\u6591\u8f6c\u6362\u7ed3\u679c");
        Row row = sheet.createRow(0);
        row.createCell(0).setCellValue("\u6e90\u56fe\u6591id");
        row.createCell(1).setCellValue("\u65b0\u56fe\u6591id");
        row.createCell(2).setCellValue("\u552f\u4e00\u503c\u5b57\u6bb5");
        row.createCell(3).setCellValue("\u662f\u5426\u8f6c\u6362\u6210\u529f");
        row.createCell(4).setCellValue("\u9519\u8bef\u539f\u56e0");
        int dataRowIndex = 1;
        if (!GutilCollection.isEmpty((Collection)taskTranslateLog.getTbTaskTranslateLogItems())) {
            for (TbTranslateLogItem tbTranslateLogItem : taskTranslateLog.getTbTaskTranslateLogItems()) {
                row = sheet.createRow(dataRowIndex);
                row.createCell(0).setCellValue(tbTranslateLogItem.getTbId());
                row.createCell(1).setCellValue(tbTranslateLogItem.getNewTbId());
                row.createCell(2).setCellValue(tbTranslateLogItem.getUniqueValue());
                row.createCell(3).setCellValue(tbTranslateLogItem.isTransSuccess() ? "\u6210\u529f" : "\u5931\u8d25");
                row.createCell(4).setCellValue(tbTranslateLogItem.getErrorInfo());
                ++dataRowIndex;
            }
        }
        return sheet;
    }

    private Sheet createTaskSheet(TaskTranslateLog taskTranslateLog, SXSSFWorkbook workbook) {
        SXSSFSheet sheet = workbook.createSheet("\u4efb\u52a1\u8f6c\u6362\u7ed3\u679c");
        Row row = sheet.createRow(0);
        row.createCell(0).setCellValue("\u4efb\u52a1\u7f16\u53f7");
        row.createCell(1).setCellValue("\u4efb\u52a1\u540d\u79f0");
        row.createCell(2).setCellValue("\u8f6c\u6362\u7c7b\u578b");
        row.createCell(3).setCellValue("\u56fe\u6591\u603b\u6570\u91cf");
        row.createCell(4).setCellValue("\u56fe\u6591\u6210\u529f\u6570\u91cf");
        row.createCell(5).setCellValue("\u56fe\u6591\u5931\u8d25\u6570\u91cf");
        row.createCell(6).setCellValue("\u9644\u4ef6\u603b\u6570\u91cf");
        row.createCell(7).setCellValue("\u9644\u4ef6\u6210\u529f\u6570\u91cf");
        row.createCell(8).setCellValue("\u9644\u4ef6\u5931\u8d25\u6570\u91cf");
        row.createCell(9).setCellValue("\u8f6c\u6362\u4eba");
        row.createCell(10).setCellValue("\u8f6c\u6362\u65f6\u95f4");
        row.createCell(11).setCellValue("\u5931\u8d25\u539f\u56e0");
        row = sheet.createRow(1);
        row.createCell(0).setCellValue(taskTranslateLog.getTaskId());
        row.createCell(1).setCellValue(taskTranslateLog.getTaskName());
        if (taskTranslateLog.getTranslateType().equals(1)) {
            row.createCell(2).setCellValue("\u8f6c\u6362\u56fe\u6591\u5b57\u6bb5");
        } else if (taskTranslateLog.getTranslateType().equals(2)) {
            row.createCell(2).setCellValue("\u8f6c\u6362\u9644\u4ef6");
        } else {
            row.createCell(2).setCellValue("\u8f6c\u6362\u56fe\u6591\u5b57\u6bb5\u548c\u9644\u4ef6");
        }
        row.createCell(3).setCellValue((double)taskTranslateLog.getTbCount().intValue());
        row.createCell(4).setCellValue((double)taskTranslateLog.getTbSuccessCount().intValue());
        row.createCell(5).setCellValue((double)Math.max(taskTranslateLog.getTbCount() - taskTranslateLog.getTbSuccessCount(), 0));
        row.createCell(6).setCellValue((double)taskTranslateLog.getAttachCount().intValue());
        row.createCell(7).setCellValue((double)taskTranslateLog.getAttachSuccessCount().intValue());
        row.createCell(8).setCellValue((double)Math.max(taskTranslateLog.getAttachCount() - taskTranslateLog.getAttachSuccessCount(), 0));
        row.createCell(9).setCellValue(taskTranslateLog.getTranslateUser());
        row.createCell(10).setCellValue(taskTranslateLog.getTranslateTime());
        row.createCell(11).setCellValue("");
        return sheet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateLogFileAndUploadToOss(TaskTranslateLog taskTranslateLog) {
        this.tempDir = (String)ProjectConfig.getConfig((String)ProjectConfigEnum.UPLOAD_DIR.getKey());
        String filePath = "";
        try {
            filePath = this.generateTranslateLog(this.tempDir, "\u4efb\u52a1\u8f6c\u6362\u65e5\u5fd7", taskTranslateLog);
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                String url;
                String string = url = this.ossOperatorService.sendObject2Oss("TaskTranslate/" + taskTranslateLog.getTaskId() + "/" + taskTranslateLog.getTaskName() + System.currentTimeMillis() + "\u4efb\u52a1\u8f6c\u6362\u65e5\u5fd7.xlsx", filePath);
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage(), new Object[]{e});
        }
        finally {
            if (StringUtils.isNotBlank((CharSequence)filePath)) {
                try {
                    File file = new File(filePath);
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    private void translateAndSaveAttachData(List<AppMedia> appMediaList, Map<String, String> tbIdChangedMap, List<TbTaskTranslateAttach> taskTranslateAttaches, List<AttachTranslateLogItem> attachTranslateLogItems) {
        if (appMediaList != null) {
            for (AppMedia appMedia : appMediaList) {
                AttachTranslateLogItem attachTranslateLogItem = new AttachTranslateLogItem();
                try {
                    int row;
                    String newUrl;
                    String attachId = appMedia.getId();
                    String newAttachId = UUID.randomUUID().toString();
                    String tbId = appMedia.getGalleryid();
                    String newTbId = tbIdChangedMap.get(appMedia.getGalleryid());
                    attachTranslateLogItem.setAttachId(attachId);
                    attachTranslateLogItem.setNewAttachId(newAttachId);
                    attachTranslateLogItem.setTbId(tbId);
                    attachTranslateLogItem.setNewTbId(newTbId);
                    appMedia.setGalleryid(newTbId);
                    if (appMedia.getTypetype() != null && taskTranslateAttaches != null) {
                        for (TbTaskTranslateAttach taskTranslateAttach : taskTranslateAttaches) {
                            if (!taskTranslateAttach.getSourceTypeName().equals(appMedia.getTypetype().toString())) continue;
                            appMedia.setTypetype(Integer.valueOf(taskTranslateAttach.getTargetTypeName()));
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)(newUrl = this.ossOperatorService.copyObject(appMedia.getServerpath(), "media/" + UUID.randomUUID().toString())))) {
                        appMedia.setServerpath(newUrl);
                    }
                    attachTranslateLogItem.setTransSuccess((row = this.appMediaService.saveOne(appMedia)) == 1);
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), new Object[]{e});
                    attachTranslateLogItem.setTransSuccess(false);
                    attachTranslateLogItem.setErrorInfo(e.getMessage());
                }
                attachTranslateLogItems.add(attachTranslateLogItem);
            }
        }
    }

    private Collection<String> getSystemFields() {
        ArrayList<String> retVal = new ArrayList<String>();
        retVal.add("f_id");
        retVal.add("f_ismy");
        retVal.add("f_xzqdmsys");
        retVal.add("f_requestid");
        retVal.add("f_createtime");
        retVal.add("f_ismycreate");
        retVal.add("f_shape");
        retVal.add("f_shape1");
        retVal.add("f_lat");
        retVal.add("f_lon");
        retVal.add("f_committime");
        retVal.add("f_userid");
        retVal.add("f_status");
        retVal.add("f_submit_userid");
        return retVal;
    }

    private void translateAndSaveTbData(List<Map> sourcePageData, Map<String, String> filedNameMapping, Map<String, String> tbIdChangedMap, List<TbTranslateLogItem> tbTranslateLogItems, String dataTableName) {
        if (GutilCollection.isEmpty(sourcePageData)) {
            return;
        }
        for (Map map : sourcePageData) {
            TbTranslateLogItem tbTranslateLogItem = new TbTranslateLogItem();
            String tbId = map.get("f_id").toString();
            String newTbId = UUID.randomUUID().toString();
            tbTranslateLogItem.setTbId(tbId);
            tbTranslateLogItem.setNewTbId(newTbId);
            HashMap newMap = new HashMap();
            for (Object key : map.keySet()) {
                if (filedNameMapping.containsKey(key.toString())) {
                    newMap.put(filedNameMapping.get(key), map.get(key));
                    continue;
                }
                newMap.put(key.toString(), map.get(key));
            }
            tbIdChangedMap.put(tbId, newTbId);
            newMap.put("f_id", newTbId);
            newMap.put("f_status", TbStatusEnum.DISTRIBUTED.getCode());
            newMap.put("f_review_stage", ReviewStageEnum.OPERATOR_VERIFY.getCode());
            try {
                int rows = this.dataBizService.insertData(dataTableName, newMap, "f_shape");
                tbTranslateLogItem.setTransSuccess(rows == 1);
            }
            catch (Exception e) {
                tbTranslateLogItem.setTransSuccess(false);
                tbTranslateLogItem.setErrorInfo(e.getMessage());
            }
            tbTranslateLogItems.add(tbTranslateLogItem);
        }
    }

    private String checkRecordBeforeTranslate(TbTaskTranslateRecord record) {
        List taskTranslateAttaches;
        List taskTranslateFields;
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)record.getTaskId())) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return sb.toString();
        }
        if (StringUtils.isEmpty((CharSequence)record.getTemplateId())) {
            sb.append(" \u4efb\u52a1\u8f6c\u6362\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
            return sb.toString();
        }
        TskTaskBiz sourceTaskBiz = this.taskBizService.findByTaskId(record.getTaskId());
        if (sourceTaskBiz == null) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        TbTaskTranslateTemplate template = this.taskTranslateTemplateService.findOneById(record.getTemplateId());
        if (template == null) {
            sb.append(" \u4efb\u52a1\u8f6c\u6362\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        TskTaskBiz targetTaskBiz = this.taskBizService.findByTaskId(template.getTargetTaskId());
        if (targetTaskBiz == null) {
            sb.append(" \u76ee\u6807\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        if ((template.getTranslateType().intValue() == 1 || template.getTranslateType().intValue() == 3) && GutilCollection.isEmpty((Collection)(taskTranslateFields = this.taskTranslateFieldService.queryFieldsByTemplateId(template.getId())))) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        if ((template.getTranslateType().intValue() == 2 || template.getTranslateType().intValue() == 3) && GutilCollection.isEmpty((Collection)(taskTranslateAttaches = this.taskTranslateAttachService.queryAttachsByTemplateId(template.getId())))) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u9644\u4ef6\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        return sb.toString();
    }
}

