/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.mapper.taskTranslate.TbTaskTranslateAttachMapper;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateAttachItemDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateAttachMappingDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateTemplateAttachDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.AttachConfig;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateAttach;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTemplate;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateAttachService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTemplateService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MTbTaskTranslateAttachServiceImpl
implements MTbTaskTranslateAttachService {
    @Autowired
    private TbTaskTranslateAttachMapper tbTaskTranslateAttachMapper;
    @Autowired
    MTbTaskTranslateTemplateService templateService;
    @Autowired
    MTskTaskBizService taskBizService;

    public int deleteByPrimaryKey(String id) {
        return this.tbTaskTranslateAttachMapper.deleteByPrimaryKey((Object)id);
    }

    public int insert(TbTaskTranslateAttach record) {
        return this.tbTaskTranslateAttachMapper.insert((Object)record);
    }

    public int insertSelective(TbTaskTranslateAttach record) {
        return this.tbTaskTranslateAttachMapper.insertSelective((Object)record);
    }

    public TbTaskTranslateAttach selectByPrimaryKey(String id) {
        return (TbTaskTranslateAttach)this.tbTaskTranslateAttachMapper.selectByPrimaryKey((Object)id);
    }

    public int updateByPrimaryKeySelective(TbTaskTranslateAttach record) {
        return this.tbTaskTranslateAttachMapper.updateByPrimaryKeySelective((Object)record);
    }

    public int updateByPrimaryKey(TbTaskTranslateAttach record) {
        return this.tbTaskTranslateAttachMapper.updateByPrimaryKey((Object)record);
    }

    public Map saveAttachMapping(TaskTranslateTemplateAttachDTO dto, long userId) {
        GutilAssert.notNull((Object)dto, (String)"parameter 'dto' must not be null .");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        resultMap.put("data", "");
        resultMap.put("error", "");
        String checkResult = this.checkMapping(dto);
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            resultMap.put("error", checkResult);
        } else {
            this.doSaveAttachMapping(dto, userId);
            resultMap.put("result", true);
            resultMap.put("data", dto.getTemplateId());
        }
        return resultMap;
    }

    private void doSaveAttachMapping(TaskTranslateTemplateAttachDTO dto, long userId) {
        TskTaskBiz targetTaskBiz;
        TbTaskTranslateTemplate template;
        TskTaskBiz sourceTaskBiz = this.taskBizService.findByTaskId(dto.getSourceTaskId());
        if (sourceTaskBiz != null && (template = this.templateService.findOneById(dto.getTemplateId())) != null && StringUtils.isNotBlank((CharSequence)template.getTargetTaskId()) && (targetTaskBiz = this.taskBizService.findByTaskId(template.getTargetTaskId())) != null && !GutilCollection.isEmpty((Collection)dto.getAttachMappingList())) {
            ArrayList<TbTaskTranslateAttach> list = new ArrayList<TbTaskTranslateAttach>();
            TbTaskTranslateAttach attach = null;
            for (TaskTranslateAttachMappingDTO attachMappingDTO : dto.getAttachMappingList()) {
                attach = new TbTaskTranslateAttach();
                attach.setId(StringUtils.isNoneBlank((CharSequence)attachMappingDTO.getId()) ? attachMappingDTO.getId() : UUID.randomUUID().toString());
                attach.setEnable(new Short("1"));
                attach.setTemplateId(dto.getTemplateId());
                attach.setSourceCategoryId(this.getStringValue(attachMappingDTO.getSourceCategoryId()));
                attach.setSourceCategoryName(this.getStringValue(attachMappingDTO.getSourceCategoryName()));
                attach.setSourceTypeId(this.getStringValue(attachMappingDTO.getSourceTypeId()));
                attach.setSourceTypeName(this.getStringValue(attachMappingDTO.getSourceTypeName()));
                attach.setTargetCategoryId(this.getStringValue(attachMappingDTO.getTargetCategoryId()));
                attach.setTargetCategoryName(this.getStringValue(attachMappingDTO.getTargetCategoryName()));
                attach.setTargetTypeId(this.getStringValue(attachMappingDTO.getTargetTypeId()));
                attach.setTargetTypeName(this.getStringValue(attachMappingDTO.getTargetTypeName()));
                list.add(attach);
            }
            if (!GutilCollection.isEmpty(list)) {
                this.deleteOldMappingAndInsertNewMapping(dto, list);
                this.templateService.updateTemplateFinishStatus(dto.getTemplateId(), new Short("1"), userId);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOldMappingAndInsertNewMapping(TaskTranslateTemplateAttachDTO dto, List<TbTaskTranslateAttach> list) {
        this.tbTaskTranslateAttachMapper.deleteByTemplateId(dto.getTemplateId());
        this.tbTaskTranslateAttachMapper.insertList(list);
    }

    private String checkMapping(TaskTranslateTemplateAttachDTO dto) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)dto.getSourceTaskId())) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return sb.toString();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getTemplateId())) {
            sb.append(" \u4efb\u52a1\u8f6c\u6362\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
            return sb.toString();
        }
        if (GutilCollection.isEmpty((Collection)dto.getAttachMappingList())) {
            sb.append(" \u9644\u4ef6\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
            return sb.toString();
        }
        TskTaskBiz sourceTaskBiz = this.taskBizService.findByTaskId(dto.getSourceTaskId());
        if (sourceTaskBiz == null) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        TbTaskTranslateTemplate template = this.templateService.findOneById(dto.getTemplateId());
        if (template == null) {
            sb.append(" \u4efb\u52a1\u8f6c\u6362\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        if (StringUtils.isEmpty((CharSequence)template.getTargetTaskId())) {
            sb.append(" \u76ee\u6807\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        return sb.toString();
    }

    public List<TbTaskTranslateAttach> queryAttachsByTemplateId(String templateId) {
        return this.tbTaskTranslateAttachMapper.queryByTemplateId(templateId);
    }

    public List<TaskTranslateAttachItemDTO> queryAttachListByTaskId(String taskId, long userId) {
        GutilAssert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)taskId), (String)"parameter 'taskId' must not be null or empty .");
        ArrayList<TaskTranslateAttachItemDTO> retVal = new ArrayList<TaskTranslateAttachItemDTO>();
        TskTaskBiz tskTaskBiz = this.taskBizService.findByTaskId(taskId);
        if (tskTaskBiz != null) {
            if (StringUtils.isNotBlank((CharSequence)tskTaskBiz.getPicConfig())) {
                JSONArray jsonArray = JSONArray.parseArray((String)tskTaskBiz.getPicConfig(), (Feature[])new Feature[0]);
                if (jsonArray != null) {
                    for (Object obj : jsonArray) {
                        AttachConfig attachConfig;
                        JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString(obj));
                        if (jsonObject == null || (attachConfig = (AttachConfig)JSONObject.toJavaObject((JSON)jsonObject, AttachConfig.class)) == null) continue;
                        TaskTranslateAttachItemDTO dto = new TaskTranslateAttachItemDTO();
                        dto.setId(StringUtils.isNoneBlank((CharSequence)attachConfig.getId()) ? attachConfig.getId() : UUID.randomUUID().toString());
                        dto.setCategoryId(attachConfig.getPictureGroupCode() != null ? attachConfig.getPictureGroupCode().toString() : "1");
                        dto.setCategoryName(StringUtils.isNotBlank((CharSequence)attachConfig.getPictureGroupName()) ? attachConfig.getPictureGroupName() : "\u5b9e\u5730\u7167\u7247");
                        dto.setTypeId(attachConfig.getTypetype() != null ? attachConfig.getTypetype().toString() : "1");
                        dto.setTypeName(StringUtils.isNotBlank((CharSequence)attachConfig.getType()) ? attachConfig.getType() : "\u5b9e\u5730\u7167\u7247");
                        retVal.add(dto);
                    }
                }
            } else {
                TaskTranslateAttachItemDTO dto = new TaskTranslateAttachItemDTO();
                dto.setId(UUID.randomUUID().toString());
                dto.setCategoryId("1");
                dto.setCategoryName("\u5b9e\u5730\u7167\u7247");
                dto.setTypeId("1");
                dto.setTypeName("\u5b9e\u5730\u7167\u7247");
                retVal.add(dto);
            }
        }
        this.doGroup(retVal);
        return retVal;
    }

    private void doGroup(List<TaskTranslateAttachItemDTO> attachItemDTOList) {
        if (!GutilCollection.isEmpty(attachItemDTOList)) {
            for (TaskTranslateAttachItemDTO dto : attachItemDTOList) {
                dto.setChildrenType(new JSONArray());
                for (TaskTranslateAttachItemDTO itemDTO : attachItemDTOList) {
                    if (!dto.getCategoryId().equalsIgnoreCase(itemDTO.getCategoryId())) continue;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("typeId", (Object)itemDTO.getTypeId());
                    jsonObject.put("typeName", (Object)itemDTO.getTypeName());
                    dto.getChildrenType().add((Object)jsonObject);
                }
            }
        }
    }

    public List<TaskTranslateAttachMappingDTO> queryAttachsByTemplateIdAndUserId(String templateId, long userId) {
        GutilAssert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)templateId), (String)"parameter 'templateId' must not be null or empty .");
        ArrayList<TaskTranslateAttachMappingDTO> retVal = new ArrayList<TaskTranslateAttachMappingDTO>();
        List translateAttaches = this.tbTaskTranslateAttachMapper.queryByTemplateId(templateId);
        if (!GutilCollection.isEmpty((Collection)translateAttaches)) {
            TaskTranslateAttachMappingDTO dto = null;
            for (TbTaskTranslateAttach attach : translateAttaches) {
                dto = new TaskTranslateAttachMappingDTO();
                dto.setId(attach.getId());
                dto.setSourceCategoryId(this.getStringValue(attach.getSourceCategoryId()));
                dto.setSourceCategoryName(this.getStringValue(attach.getSourceCategoryName()));
                dto.setSourceTypeId(this.getStringValue(attach.getSourceTypeId()));
                dto.setSourceTypeName(this.getStringValue(attach.getSourceTypeName()));
                dto.setTargetCategoryId(this.getStringValue(attach.getTargetCategoryId()));
                dto.setTargetCategoryName(this.getStringValue(attach.getTargetCategoryName()));
                dto.setTargetTypeId(this.getStringValue(attach.getTargetTypeId()));
                dto.setTargetTypeName(this.getStringValue(attach.getTargetTypeName()));
                retVal.add(dto);
            }
        }
        return retVal;
    }

    private String getStringValue(String value) {
        return StringUtils.isNoneBlank((CharSequence)value) ? value : "";
    }
}

