/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;

import com.geoway.landteam.customtask.mapper.taskTranslate.TbTaskTranslateFieldMapper;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateFieldDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateFieldMappingDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateTemplateFiledDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateField;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTemplate;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.bean.MapUtil;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateFieldService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTemplateService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MTbTaskTranslateFieldServiceImpl
implements MTbTaskTranslateFieldService {
    @Autowired
    TbTaskTranslateFieldMapper tbTaskTranslateFieldMapper;
    @Autowired
    MTbTaskTranslateTemplateService templateService;
    @Autowired
    MTskTaskBizService taskBizService;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    private static final Map SYSTEM_FIELD_MAP = new HashMap();

    public int deleteByPrimaryKey(String id) {
        return this.tbTaskTranslateFieldMapper.deleteByPrimaryKey((Object)id);
    }

    public int insert(TbTaskTranslateField record) {
        return this.tbTaskTranslateFieldMapper.insert((Object)record);
    }

    public int insertSelective(TbTaskTranslateField record) {
        return this.tbTaskTranslateFieldMapper.insertSelective((Object)record);
    }

    public TbTaskTranslateField selectByPrimaryKey(String id) {
        return (TbTaskTranslateField)this.tbTaskTranslateFieldMapper.selectByPrimaryKey((Object)id);
    }

    public int updateByPrimaryKeySelective(TbTaskTranslateField record) {
        return this.tbTaskTranslateFieldMapper.updateByPrimaryKeySelective((Object)record);
    }

    public int updateByPrimaryKey(TbTaskTranslateField record) {
        return this.tbTaskTranslateFieldMapper.updateByPrimaryKey((Object)record);
    }

    public Map saveFieldMapping(TaskTranslateTemplateFiledDTO dto, long userId) {
        GutilAssert.notNull((Object)dto, (String)"parameter 'dto' must not be null .");
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        resultMap.put("data", "");
        resultMap.put("error", "");
        String checkResult = this.checkMapping(dto);
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            resultMap.put("error", checkResult);
        } else {
            this.doSaveFieldMapping(dto, userId);
            resultMap.put("result", true);
            resultMap.put("data", dto.getTemplateId());
        }
        return resultMap;
    }

    public void doSaveFieldMapping(TaskTranslateTemplateFiledDTO dto, long userId) {
        List targetTaskFieldList;
        List sourceTaskFieldList;
        TskTaskBiz targetTaskBiz;
        TbTaskTranslateTemplate template;
        TskTaskBiz sourceTaskBiz = this.taskBizService.findByTaskId(dto.getSourceTaskId());
        if (sourceTaskBiz != null && (template = this.templateService.findOneById(dto.getTemplateId())) != null && StringUtils.isNotBlank((CharSequence)template.getTargetTaskId()) && (targetTaskBiz = this.taskBizService.findByTaskId(template.getTargetTaskId())) != null && !GutilCollection.isEmpty((Collection)(sourceTaskFieldList = this.tbtskFieldsRepository.getTbtskFieldsByTableid(sourceTaskBiz.getTableId()))) && !GutilCollection.isEmpty((Collection)(targetTaskFieldList = this.tbtskFieldsRepository.getTbtskFieldsByTableid(targetTaskBiz.getTableId())))) {
            HashMap<String, TbtskFields> sourceFieldMap = new HashMap<String, TbtskFields>();
            for (Object tbtskFields : sourceTaskFieldList) {
                sourceFieldMap.put(tbtskFields.getfId(), (TbtskFields)tbtskFields);
            }
            HashMap<String, TbtskFields> targetFieldMap = new HashMap<String, TbtskFields>();
            for (TbtskFields tbtskFields : targetTaskFieldList) {
                targetFieldMap.put(tbtskFields.getfId(), tbtskFields);
            }
            TbTaskTranslateField field = null;
            Object sourceField = null;
            Object targetField = null;
            ArrayList<TbTaskTranslateField> fieldList = new ArrayList<TbTaskTranslateField>();
            for (TaskTranslateFieldMappingDTO fieldDto : dto.getFieldMappingList()) {
                field = this.getTaskTranslateField(dto, sourceFieldMap, targetFieldMap, fieldDto);
                fieldList.add(field);
            }
            if (!GutilCollection.isEmpty(fieldList)) {
                this.deleteOldFieldMappingAndInsertNewMapping(dto, fieldList);
                if (template.getTranslateType().intValue() == 1) {
                    this.templateService.updateTemplateFinishStatus(dto.getTemplateId(), new Short("1"), userId);
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteOldFieldMappingAndInsertNewMapping(TaskTranslateTemplateFiledDTO dto, List<TbTaskTranslateField> fieldList) {
        this.tbTaskTranslateFieldMapper.deleteByTemplateId(dto.getTemplateId());
        this.tbTaskTranslateFieldMapper.insertList(fieldList);
    }

    private TbTaskTranslateField getTaskTranslateField(TaskTranslateTemplateFiledDTO dto, HashMap<String, TbtskFields> sourceFieldMap, HashMap<String, TbtskFields> targetFieldMap, TaskTranslateFieldMappingDTO fieldDto) {
        TbtskFields sourceField = sourceFieldMap.get(fieldDto.getSourceFieldId());
        TbtskFields targetField = targetFieldMap.get(fieldDto.getTargetFieldId());
        TbTaskTranslateField field = new TbTaskTranslateField();
        field.setEnable(new Short("1"));
        field.setId(UUID.randomUUID().toString());
        field.setFieldName(StringUtils.isNotBlank((CharSequence)targetField.getfFieldname()) ? targetField.getfFieldname() : "");
        field.setFieldType(StringUtils.isNotBlank((CharSequence)targetField.getfFieldtype()) ? targetField.getfFieldtype() : "");
        field.setFieldAlias(StringUtils.isNotBlank((CharSequence)targetField.getfAlias()) ? targetField.getfAlias() : "");
        field.setLength(targetField.getfLength() != null ? targetField.getfLength() : null);
        field.setIsUnique(targetField.getfUnique() != null ? Short.valueOf(targetField.getfUnique().shortValue()) : null);
        field.setDefaultValue(StringUtils.isNotBlank((CharSequence)targetField.getfDefaultvalue()) ? targetField.getfDefaultvalue() : "");
        field.setEnumDicCode(StringUtils.isNotBlank((CharSequence)targetField.getfCodetableid()) ? targetField.getfCodetableid() : "");
        field.setIsPrimary(Short.valueOf(targetField.getfIsprimary() != null ? targetField.getfIsprimary().shortValue() : new Short("0").shortValue()));
        field.setPrecision(Integer.valueOf(targetField.getfPrecision() != null ? targetField.getfPrecision() : 0));
        field.setNullable(targetField.getfNullable() != null ? Short.valueOf(targetField.getfNullable().shortValue()) : null);
        field.setRemark(StringUtils.isNotBlank((CharSequence)targetField.getfRemark()) ? targetField.getfRemark() : "");
        field.setTemplateId(dto.getTemplateId());
        field.setSourceFieldId(StringUtils.isNotBlank((CharSequence)sourceField.getfId()) ? sourceField.getfId() : "");
        field.setSourceFieldName(StringUtils.isNotBlank((CharSequence)sourceField.getfFieldname()) ? sourceField.getfFieldname() : "");
        field.setSourceFieldAlias(StringUtils.isNotBlank((CharSequence)sourceField.getfAlias()) ? sourceField.getfAlias() : "");
        field.setFieldInnerOuterSys(targetField.getfFieldInnerOuterSys() != null ? Short.valueOf(targetField.getfFieldInnerOuterSys().shortValue()) : null);
        field.setTargetFieldId(StringUtils.isNotBlank((CharSequence)targetField.getfId()) ? targetField.getfId() : "");
        return field;
    }

    private String checkMapping(TaskTranslateTemplateFiledDTO dto) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)dto.getSourceTaskId())) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return sb.toString();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getTemplateId())) {
            sb.append(" \u4efb\u52a1\u8f6c\u6362\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
            return sb.toString();
        }
        if (GutilCollection.isEmpty((Collection)dto.getFieldMappingList())) {
            sb.append(" \u5b57\u6bb5\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
            return sb.toString();
        }
        TskTaskBiz sourceTaskBiz = this.taskBizService.findByTaskId(dto.getSourceTaskId());
        if (sourceTaskBiz == null) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        TbTaskTranslateTemplate template = this.templateService.findOneById(dto.getTemplateId());
        if (template == null) {
            sb.append(" \u4efb\u52a1\u8f6c\u6362\u6a21\u677f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        if (StringUtils.isEmpty((CharSequence)template.getTargetTaskId())) {
            sb.append(" \u76ee\u6807\u8f6c\u6362\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        TskTaskBiz targetTaskBiz = this.taskBizService.findByTaskId(template.getTargetTaskId());
        List sourceTaskFieldList = this.tbtskFieldsRepository.getTbtskFieldsByTableid(sourceTaskBiz.getTableId());
        if (GutilCollection.isEmpty((Collection)sourceTaskFieldList)) {
            sb.append(" \u5f85\u8f6c\u6362\u4efb\u52a1\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        List targetTaskFieldList = this.tbtskFieldsRepository.getTbtskFieldsByTableid(targetTaskBiz.getTableId());
        if (GutilCollection.isEmpty((Collection)targetTaskFieldList)) {
            sb.append(" \u76ee\u6807\u8f6c\u6362\u4efb\u52a1\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\u3002 ");
            return sb.toString();
        }
        HashMap<String, TbtskFields> sourceFieldMap = new HashMap<String, TbtskFields>();
        for (TbtskFields tbtskFields : sourceTaskFieldList) {
            sourceFieldMap.put(tbtskFields.getfId(), tbtskFields);
        }
        HashMap<String, TbtskFields> targetFieldMap = new HashMap<String, TbtskFields>();
        for (TbtskFields tbtskFields : targetTaskFieldList) {
            targetFieldMap.put(tbtskFields.getfId(), tbtskFields);
        }
        for (TaskTranslateFieldMappingDTO fieldMappingDTO : dto.getFieldMappingList()) {
            String result = this.checkFieldItem(fieldMappingDTO, sourceFieldMap, targetFieldMap);
            if (!StringUtils.isNotBlank((CharSequence)result)) continue;
            sb.append(result);
        }
        return sb.toString();
    }

    private String checkFieldItem(TaskTranslateFieldMappingDTO field, HashMap<String, TbtskFields> sourceFieldMap, HashMap<String, TbtskFields> targetFieldMap) {
        String sourceFieldAlias;
        StringBuilder sb = new StringBuilder();
        if (MapUtil.isEmpty(sourceFieldMap) || MapUtil.isEmpty(targetFieldMap)) {
            sb.append(" \u6e90\u5b57\u6bb5\u96c6\u5408\u4e3a\u7a7a\u6216\u76ee\u6807\u5b57\u6bb5\u96c6\u5408\u4e3a\u7a7a\u3002 ");
            return sb.toString();
        }
        if (StringUtils.isEmpty((CharSequence)field.getSourceFieldId())) {
            sb.append(" \u6e90\u5b57\u6bb5Id\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
        }
        if (StringUtils.isEmpty((CharSequence)field.getTargetFieldId())) {
            sb.append(" \u76ee\u6807\u5b57\u6bb5Id\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
        }
        String string = StringUtils.isNotBlank((CharSequence)field.getSourceFieldAlias()) ? field.getSourceFieldAlias() : (sourceFieldAlias = StringUtils.isNotBlank((CharSequence)field.getSourceFieldId()) ? field.getSourceFieldId() : "");
        String targetFieldAlias = StringUtils.isNotBlank((CharSequence)field.getTargetFieldAlias()) ? field.getTargetFieldAlias() : (StringUtils.isNotBlank((CharSequence)field.getTargetFieldId()) ? field.getTargetFieldId() : "");
        TbtskFields sourceField = sourceFieldMap.get(field.getSourceFieldId());
        if (sourceField == null) {
            sb.append(String.format(" \u6e90\u5b57\u6bb5%s\u7684\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", sourceFieldAlias));
            return sb.toString();
        }
        TbtskFields targetField = targetFieldMap.get(field.getTargetFieldId());
        if (targetField == null) {
            sb.append(String.format(" \u76ee\u6807\u5b57\u6bb5%s\u7684\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728\u3002", targetFieldAlias));
            return sb.toString();
        }
        if (StringUtils.isNotBlank((CharSequence)sourceField.getfCodetableid()) && StringUtils.isNotBlank((CharSequence)targetField.getfCodetableid())) {
            if (!sourceField.getfCodetableid().equalsIgnoreCase(targetField.getfCodetableid())) {
                sb.append(String.format(" \u76ee\u6807\u5b57\u6bb5%s\u7684\u4e0e\u6e90\u5b57\u6bb5%s\u7684\u6570\u636e\u5b57\u5178\u4e0d\u4e00\u81f4\u3002", targetFieldAlias, sourceFieldAlias));
            }
        } else if (StringUtils.isNotBlank((CharSequence)sourceField.getfCodetableid()) && StringUtils.isEmpty((CharSequence)targetField.getfCodetableid()) || StringUtils.isEmpty((CharSequence)sourceField.getfCodetableid()) && StringUtils.isNotBlank((CharSequence)targetField.getfCodetableid())) {
            sb.append(String.format(" \u76ee\u6807\u5b57\u6bb5%s\u7684\u4e0e\u6e90\u5b57\u6bb5%s\u7684\u6570\u636e\u5b57\u5178\u4e0d\u4e00\u81f4\u3002", targetFieldAlias, sourceFieldAlias));
        }
        String sourceType = TskTaskBizDBUtil.getDBType((String)sourceField.getfFieldtype());
        String targetType = TskTaskBizDBUtil.getDBType((String)targetField.getfFieldtype());
        if (sourceType.equalsIgnoreCase("varchar")) {
            if (!targetType.equalsIgnoreCase("text") && !targetType.equalsIgnoreCase("varchar")) {
                sb.append(String.format(" \u76ee\u6807\u5b57\u6bb5%s\u7684\u4e0e\u6e90\u5b57\u6bb5%s\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", targetFieldAlias, sourceFieldAlias));
            } else if (targetType.equalsIgnoreCase("varchar") && sourceField.getfLength() > targetField.getfLength()) {
                sb.append(String.format(" \u6240\u9009\u6e90\u5b57\u6bb5\u5b57\u6bb5%s\u7684\u76ee\u6807\u5b57\u6bb5\u957f\u5ea6\u5927\u4e8e%s\u7684\u957f\u5ea6\u3002", sourceFieldAlias, targetFieldAlias));
            }
        } else if (sourceType.equalsIgnoreCase("int4")) {
            if (!(targetType.equalsIgnoreCase("decimal") || targetType.equalsIgnoreCase("int4") || targetType.equalsIgnoreCase("text") || targetType.equalsIgnoreCase("varchar"))) {
                sb.append(String.format(" \u76ee\u6807\u5b57\u6bb5%s\u7684\u4e0e\u6e90\u5b57\u6bb5%s\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", targetFieldAlias, sourceFieldAlias));
            }
        } else if (sourceType.equalsIgnoreCase("decimal")) {
            if (!targetType.equalsIgnoreCase("decimal")) {
                sb.append(String.format(" \u76ee\u6807\u5b57\u6bb5%s\u7684\u4e0e\u6e90\u5b57\u6bb5%s\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", targetFieldAlias, sourceFieldAlias));
            }
        } else if (!sourceField.getfFieldtype().equalsIgnoreCase(targetField.getfFieldtype())) {
            sb.append(String.format(" \u76ee\u6807\u5b57\u6bb5%s\u7684\u4e0e\u6e90\u5b57\u6bb5%s\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", targetFieldAlias, sourceFieldAlias));
        }
        return sb.toString();
    }

    public List<TaskTranslateFieldDTO> queryFieldsByTaskId(String taskId, String templateId, long userId) {
        List tbtskFieldsList;
        GutilAssert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)taskId), (String)"parameter 'taskId' must not be null or empty .");
        ArrayList<TaskTranslateFieldDTO> retVal = new ArrayList<TaskTranslateFieldDTO>();
        TskTaskBiz tskTaskBiz = this.taskBizService.findByTaskId(taskId);
        if (tskTaskBiz != null && !GutilCollection.isEmpty((Collection)(tbtskFieldsList = this.tbtskFieldsRepository.queryInnerAndOuterFields(tskTaskBiz.getTableId())))) {
            TaskTranslateFieldDTO dto = null;
            List<TbTaskTranslateField> existedFieldMappings = null;
            if (StringUtils.isNotBlank((CharSequence)templateId)) {
                existedFieldMappings = this.queryFieldsByTemplateId(templateId);
            }
            for (TbtskFields tbtskFields : tbtskFieldsList) {
                if (!this.needTranslate(tbtskFields)) continue;
                dto = this.convertFieldToDTO(tbtskFields);
                if (!GutilCollection.isEmpty(existedFieldMappings)) {
                    for (TbTaskTranslateField existedField : existedFieldMappings) {
                        if (!existedField.getTargetFieldId().equalsIgnoreCase(dto.getId())) continue;
                        dto.setSourceFieldId(StringUtils.isNotBlank((CharSequence)existedField.getSourceFieldId()) ? existedField.getSourceFieldId() : "");
                        dto.setSourceFieldName(StringUtils.isNotBlank((CharSequence)existedField.getSourceFieldName()) ? existedField.getSourceFieldName() : "");
                        dto.setSourceFieldAlias(StringUtils.isNotBlank((CharSequence)existedField.getSourceFieldAlias()) ? existedField.getSourceFieldAlias() : "");
                        dto.setTargetFieldId(StringUtils.isNotBlank((CharSequence)existedField.getTargetFieldId()) ? existedField.getTargetFieldId() : "");
                    }
                }
                retVal.add(dto);
            }
        }
        return retVal;
    }

    private TaskTranslateFieldDTO convertFieldToDTO(TbtskFields tbtskFields) {
        TaskTranslateFieldDTO dto = new TaskTranslateFieldDTO();
        dto.setId(StringUtils.isNotBlank((CharSequence)tbtskFields.getfId()) ? tbtskFields.getfId() : "");
        dto.setFieldName(StringUtils.isNotBlank((CharSequence)tbtskFields.getfFieldname()) ? tbtskFields.getfFieldname() : "");
        dto.setFieldAlias(StringUtils.isNotBlank((CharSequence)tbtskFields.getfAlias()) ? tbtskFields.getfAlias() : "");
        dto.setFieldType(StringUtils.isNotBlank((CharSequence)tbtskFields.getfFieldtype()) ? tbtskFields.getfFieldtype() : "");
        dto.setPrecision(tbtskFields.getfPrecision() != null ? tbtskFields.getfPrecision() : null);
        dto.setLength(tbtskFields.getfLength() != null ? tbtskFields.getfLength() : null);
        dto.setEnumDicCode(StringUtils.isNotBlank((CharSequence)tbtskFields.getfCodetableid()) ? tbtskFields.getfCodetableid() : "");
        dto.setNullable(tbtskFields.getfNullable() != null ? Short.valueOf(tbtskFields.getfNullable().shortValue()) : null);
        dto.setIsUnique(tbtskFields.getfUnique() != null ? Short.valueOf(tbtskFields.getfUnique().shortValue()) : null);
        return dto;
    }

    private boolean needTranslate(TbtskFields field) {
        if (field == null) {
            return false;
        }
        return !this.isSystemField(field);
    }

    private boolean isSystemField(TbtskFields field) {
        return SYSTEM_FIELD_MAP.containsKey(field.getfFieldname());
    }

    public List<TbTaskTranslateField> queryFieldsByTemplateId(String templateId) {
        return this.tbTaskTranslateFieldMapper.queryByTemplateId(templateId);
    }

    public List<TaskTranslateFieldDTO> queryFieldsByTemplateId(String templateId, long userId) {
        ArrayList<TaskTranslateFieldDTO> retVal = new ArrayList<TaskTranslateFieldDTO>();
        List fieldList = this.tbTaskTranslateFieldMapper.queryByTemplateId(templateId);
        if (!GutilCollection.isEmpty((Collection)fieldList)) {
            TaskTranslateFieldDTO dto = null;
            for (TbTaskTranslateField field : fieldList) {
                dto = new TaskTranslateFieldDTO();
                BeanUtil.copyProperties((Object)field, (Object)dto);
                retVal.add(dto);
            }
        }
        return retVal;
    }

    static {
        SYSTEM_FIELD_MAP.put("f_xzqdmsys", "");
        SYSTEM_FIELD_MAP.put("f_lon", "");
        SYSTEM_FIELD_MAP.put("f_lat", "");
        SYSTEM_FIELD_MAP.put("f_status", "");
        SYSTEM_FIELD_MAP.put("f_ismycreate", "");
        SYSTEM_FIELD_MAP.put("f_createtime", "");
        SYSTEM_FIELD_MAP.put("f_requestid", "");
        SYSTEM_FIELD_MAP.put("f_ismy", "");
        SYSTEM_FIELD_MAP.put("f_submit_userid", "");
        SYSTEM_FIELD_MAP.put("f_reject_count", "");
        SYSTEM_FIELD_MAP.put("f_review_stage", "");
        SYSTEM_FIELD_MAP.put("f_reject_status", "");
        SYSTEM_FIELD_MAP.put("f_shape", "");
        SYSTEM_FIELD_MAP.put("f_shape1", "");
        SYSTEM_FIELD_MAP.put("f_shape_b", "");
        SYSTEM_FIELD_MAP.put("f_lat_b", "");
        SYSTEM_FIELD_MAP.put("f_lon_b", "");
        SYSTEM_FIELD_MAP.put("f_shape_g", "");
        SYSTEM_FIELD_MAP.put("f_lat_g", "");
        SYSTEM_FIELD_MAP.put("f_lon_g", "");
        SYSTEM_FIELD_MAP.put("f_userid", "");
        SYSTEM_FIELD_MAP.put("f_committime", "");
        SYSTEM_FIELD_MAP.put("f_upload_userid", "");
        SYSTEM_FIELD_MAP.put("f_qm", "");
    }
}

