/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;

import com.geoway.landteam.customtask.mapper.taskTranslate.TbTaskTranslateTemplateMapper;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateTemplateDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTemplate;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTemplateService;
import com.github.pagehelper.PageHelper;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MTbTaskTranslateTemplateServiceImpl
implements MTbTaskTranslateTemplateService {
    private static final GiLoger log = GwLoger.getLoger();
    @Autowired
    private TbTaskTranslateTemplateMapper templateMapper;
    @Autowired
    UserNameService userNameService;

    public int deleteByPrimaryKey(String id) {
        return this.templateMapper.deleteByPrimaryKey((Object)id);
    }

    public int insert(TbTaskTranslateTemplate record) {
        return this.templateMapper.insert((Object)record);
    }

    public int insertSelective(TbTaskTranslateTemplate record) {
        return this.templateMapper.insertSelective((Object)record);
    }

    public TbTaskTranslateTemplate selectByPrimaryKey(String id) {
        return (TbTaskTranslateTemplate)this.templateMapper.selectByPrimaryKey((Object)id);
    }

    public int updateByPrimaryKeySelective(TbTaskTranslateTemplate record) {
        return this.templateMapper.updateByPrimaryKeySelective((Object)record);
    }

    public int updateByPrimaryKey(TbTaskTranslateTemplate record) {
        return this.templateMapper.updateByPrimaryKey((Object)record);
    }

    public List<TaskTranslateTemplateDTO> findListByPageNumSize(String templateName, String sourceTaskId, Integer pageNum, Integer pageSize, long userId, Integer templateType) {
        GutilAssert.notNull((Object)pageNum, (String)"pageNum must not be null.");
        GutilAssert.isTrue((pageSize != null && pageSize > 0 ? 1 : 0) != 0, (String)"PageSize must not be null and must be a positive number.");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List templateList = null;
        templateList = this.templateMapper.queryByNameLikeAndSourceTaskIdAndCreateUserIdOrScope(StringUtils.isNotBlank((CharSequence)templateName) ? templateName : "", StringUtils.isNotBlank((CharSequence)sourceTaskId) ? sourceTaskId : "", String.valueOf(userId), "1", templateType);
        return this.convertEntityToDTO(templateList);
    }

    public List<TbTaskTranslateTemplate> findListByPageNumAndSize(String templateName, Integer pageNum, Integer pageSize, long userId) {
        GutilAssert.notNull((Object)pageNum, (String)"pageNum must not be null.");
        GutilAssert.isTrue((pageSize != null && pageSize > 0 ? 1 : 0) != 0, (String)"PageSize must not be null and must be a positive number.");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List templateList = this.templateMapper.queryByNameLikeAndCreateUserId(StringUtils.isNotBlank((CharSequence)templateName) ? templateName : "", String.valueOf(userId));
        return templateList;
    }

    public TaskTranslateTemplateDTO findOneByPrimaryKey(String templateId) {
        TbTaskTranslateTemplate template = (TbTaskTranslateTemplate)this.templateMapper.selectByPrimaryKey((Object)templateId);
        return this.convertEntityToDTO(template);
    }

    public TbTaskTranslateTemplate findOneById(String templateId) {
        return (TbTaskTranslateTemplate)this.templateMapper.selectByPrimaryKey((Object)templateId);
    }

    public String saveOne(TaskTranslateTemplateDTO dto, long userId) throws Exception {
        TbTaskTranslateTemplate template = this.convertDtoToEntity(dto);
        if (StringUtils.isEmpty((CharSequence)template.getId())) {
            template.setId(UUID.randomUUID().toString());
        }
        template.setCreateTime(new Date());
        template.setCreateUserId(String.valueOf(userId));
        template.setUpdateTime(new Date());
        template.setCreateUserId(String.valueOf(userId));
        String checkResult = this.checkDto(template, true);
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            throw new GwValidateException(checkResult);
        }
        int count = this.templateMapper.countById(template.getId());
        if (count > 0) {
            this.templateMapper.updateByPrimaryKeySelective((Object)template);
        } else {
            this.templateMapper.insertSelective((Object)template);
        }
        return template.getId();
    }

    public String updateOne(TaskTranslateTemplateDTO dto, long userId) throws Exception {
        TbTaskTranslateTemplate template = this.convertDtoToEntity(dto);
        template.setUpdateTime(new Date());
        template.setUpdateUserId(String.valueOf(userId));
        String checkResult = this.checkDto(template, true);
        if (StringUtils.isNotBlank((CharSequence)checkResult)) {
            throw new GwValidateException(checkResult);
        }
        this.templateMapper.updateByPrimaryKey((Object)template);
        return template.getId();
    }

    public void deleteOne(String templateId) throws Exception {
        GutilAssert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)templateId), (String)"parameter 'templateId' must not be null or empty.");
        int count = this.templateMapper.countById(templateId);
        if (count <= 0) {
            throw new GwValidateException("\u4efb\u52a1\u8f6c\u6362\u6a21\u677f\u4e0d\u5b58\u5728");
        }
        this.templateMapper.deleteByPrimaryKey((Object)templateId);
    }

    private String checkDto(TbTaskTranslateTemplate template, boolean checkPrimaryKey) {
        StringBuilder sb = new StringBuilder();
        if (checkPrimaryKey && StringUtils.isEmpty((CharSequence)template.getId())) {
            sb.append(" \u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
        }
        if (template.getTranslateType() == null) {
            sb.append(" \u8f6c\u6362\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
        }
        if (template.getTranslateType() < 1 || template.getTranslateType() > 3) {
            sb.append(" \u8f6c\u6362\u5185\u5bb9\u4e0d\u6b63\u786e\u636e\u3002 ");
        }
        if (StringUtils.isEmpty((CharSequence)template.getTargetTaskId())) {
            sb.append(" \u76ee\u6807\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002 ");
        }
        return sb.toString();
    }

    private List<TaskTranslateTemplateDTO> convertEntityToDTO(List<TbTaskTranslateTemplate> templateList) {
        ArrayList<TaskTranslateTemplateDTO> result = new ArrayList<TaskTranslateTemplateDTO>();
        if (!GutilCollection.isEmpty(templateList)) {
            TaskTranslateTemplateDTO dto = null;
            for (TbTaskTranslateTemplate template : templateList) {
                dto = this.convertEntityToDTO(template);
                result.add(dto);
            }
        }
        return result;
    }

    private TaskTranslateTemplateDTO convertEntityToDTO(TbTaskTranslateTemplate template) {
        TaskTranslateTemplateDTO result = new TaskTranslateTemplateDTO();
        BeanUtil.copyProperties((Object)template, (Object)result);
        if (StringUtils.isNotBlank((CharSequence)template.getCreateUserId())) {
            result.setCreateUserName(this.userNameService.getUserRealNameByUserId(template.getCreateUserId()));
        }
        return result;
    }

    private TbTaskTranslateTemplate convertDtoToEntity(TaskTranslateTemplateDTO dto) {
        TbTaskTranslateTemplate result = new TbTaskTranslateTemplate();
        BeanUtil.copyProperties((Object)dto, (Object)result);
        return result;
    }

    public boolean exist(String templateId) {
        return this.templateMapper.countById(templateId) > 0;
    }

    public Map isTemplateNameExist(String templateName, long userId) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("result", false);
        resultMap.put("isExist", false);
        resultMap.put("error", "");
        try {
            if (this.templateMapper.countByName(templateName) > 0) {
                resultMap.put("isExist", true);
            } else {
                resultMap.put("isExist", false);
            }
            resultMap.put("result", true);
        }
        catch (Exception e) {
            log.error(e.getMessage(), new Object[]{e});
            resultMap.put("result", false);
            resultMap.put("error", e.getMessage());
        }
        return resultMap;
    }

    public void updateTemplateFinishStatus(String templateId, Short finish, long userId) {
        this.templateMapper.updateFinish(finish, templateId);
    }

    public List<TaskTranslateTemplateDTO> findListByTargetTaskId(String targetTaskId, Integer pageNum, Integer pageSize, long userId) {
        GutilAssert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)targetTaskId), (String)"targetTaskId must not be null or empty.");
        GutilAssert.notNull((Object)pageNum, (String)"pageNum must not be null.");
        GutilAssert.isTrue((pageSize != null && pageSize > 0 ? 1 : 0) != 0, (String)"PageSize must not be null and must be a positive number.");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List templateList = null;
        templateList = this.templateMapper.queryByTargetTaskIdAndCreateUserIdOrScope(targetTaskId, String.valueOf(userId), "1");
        return this.convertEntityToDTO(templateList);
    }

    public List<TaskTranslateTemplateDTO> findListByTargetTaskId(String targetTaskId, Integer pageNum, Integer pageSize, long userId, Integer templateType) {
        GutilAssert.isTrue((boolean)StringUtils.isNotBlank((CharSequence)targetTaskId), (String)"targetTaskId must not be null or empty.");
        GutilAssert.notNull((Object)pageNum, (String)"pageNum must not be null.");
        GutilAssert.isTrue((pageSize != null && pageSize > 0 ? 1 : 0) != 0, (String)"PageSize must not be null and must be a positive number.");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List templateList = null;
        templateList = this.templateMapper.queryByTargetTaskIdAndCreateUserIdOrScope2(targetTaskId, String.valueOf(userId), "1", templateType);
        return this.convertEntityToDTO(templateList);
    }

    public List<TaskTranslateTemplateDTO> findListByTargetTaskId(String sourceTaskId, String targetTaskId, long userId, Integer templateType) {
        List templateList = null;
        templateList = this.templateMapper.queryByTargetTaskIdAndCreateUserIdOrScope3(sourceTaskId, targetTaskId, String.valueOf(userId), "1", templateType);
        return this.convertEntityToDTO(templateList);
    }
}

