/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.customtask.thirdData;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.pub.TbExchangeFieldRelDao;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.entity.TbtskApproveRecord;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.servface.customtask.thirdData.WpzfService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ExportDataUtils;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class WpzfServiceImpl
implements WpzfService {
    GiLoger logger = GwLoger.getLoger(WpzfServiceImpl.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    TbExchangeFieldRelDao tbExchangeFieldRelDao;
    @Autowired
    protected TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    protected TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public void sendTask(List<String> idList) throws Exception {
        String tablename = Optional.ofNullable("wpzf").map(arg_0 -> ((SysConfigService)this.sysConfigService).findOne(arg_0)).map(SysConfig::getValue).map(arg_0 -> ((TskTaskBizRepository)this.tskTaskBizRepository).findById(arg_0)).map(e -> (TskTaskBiz)e.orElseThrow(RuntimeException::new)).map(TskTaskBiz::getTableId).map(arg_0 -> ((TbtskObjectinfoRepository)this.tbtskObjectinfoRepository).findById(arg_0)).map(e -> (TbtskObjectinfo)e.orElseThrow(RuntimeException::new)).map(TbtskObjectinfo::getfTablename).orElseThrow(() -> new RuntimeException("\u65e0\u6548\u7684\u4efb\u52a1\u8868"));
        List rels = this.tbExchangeFieldRelDao.getRelListByConfigid("ab002");
        String sql = "select * from " + tablename + " where f_id in ('" + String.join((CharSequence)"','", idList) + "')";
        List tbs = this.jdbcTemplate.queryForList(sql);
        Map<String, String> fields = rels.stream().collect(Collectors.toMap(TbExchangeFieldRel::getInFieldName, TbExchangeFieldRel::getOutFieldName));
        String tempdb = this.createDbtemplate();
        File temp = new File(tempdb);
        SqlliteConnTool connTool = new SqlliteConnTool(tempdb);
        Connection conn = connTool.getConnection();
        conn.setAutoCommit(false);
        this.insert(conn, tbs, fields, "tbtsk_task");
        connTool.Dispose();
        JSONObject config = this.sysConfigService.findToJson("transferConfig");
        String appkey = config.getString("wpzfKey");
        String moudle = config.getString("taskMoudle");
        String url = config.getString("url");
        HttpUtil.sendRrquestByFile(appkey, moudle, temp, url);
        temp.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWpzfReject(TbtskApproveRecord record) {
        String tempdb = null;
        File temp = null;
        Statement pre = null;
        SqlliteConnTool connTool = null;
        try {
            String customid = Optional.ofNullable("wpzfCustomId").map(arg_0 -> ((SysConfigService)this.sysConfigService).findOne(arg_0)).map(SysConfig::getValue).orElse(null);
            if (StringUtils.isBlank((CharSequence)customid) || !customid.contains(record.getTaskid())) {
                return;
            }
            tempdb = this.createApprovedDbtemplate();
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
            String tableName = Optional.of(record.getTaskid()).map(arg_0 -> ((TskTaskBizRepository)this.tskTaskBizRepository).findById(arg_0)).map(e -> (TskTaskBiz)e.orElseThrow(RuntimeException::new)).map(TskTaskBiz::getTableId).map(arg_0 -> ((TbtskObjectinfoRepository)this.tbtskObjectinfoRepository).findById(arg_0)).map(e -> (TbtskObjectinfo)e.orElseThrow(RuntimeException::new)).map(TbtskObjectinfo::getfTablename).orElseThrow(() -> new RuntimeException("\u65e0\u6548\u7684\u4efb\u52a1\u8868"));
            String wpzfid = Optional.ofNullable("wpzf").map(arg_0 -> ((SysConfigService)this.sysConfigService).findOne(arg_0)).map(SysConfig::getValue).orElse("");
            String shlx = "jcjgwtcz";
            String idField = "f_tbbsm";
            if (wpzfid.equals(record.getTaskid())) {
                shlx = "jcjgdk_dktb";
                idField = "f_dkbsm";
            }
            Map data = null;
            try {
                String sql = String.format("select %s,f_gzly from %s where f_id = '%s';", idField, tableName, record.getTbid());
                data = this.jdbcTemplate.queryForMap(sql);
            }
            catch (Exception e2) {
                String sql = String.format("select %s,f_gzly from %s where f_id = '%s';", idField, tableName + "_child", record.getTbid());
                data = this.jdbcTemplate.queryForMap(sql);
            }
            String tbbsm = (String)data.get(idField);
            String gzly = (String)data.get("f_gzly");
            temp = new File(tempdb);
            connTool = new SqlliteConnTool(tempdb);
            Connection conn = connTool.getConnection();
            conn.setAutoCommit(false);
            String insertSql = "INSERT INTO approve_record(f_id, f_tbbsm, f_approvetime, f_content, f_stepname, f_approveuser, f_audittype, f_status, f_gzly) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
            pre = conn.prepareStatement(insertSql);
            pre.setString(1, record.getTbid());
            pre.setString(2, tbbsm);
            pre.setString(3, sdf.format(new Date()));
            pre.setString(4, record.getRemark());
            pre.setString(5, "\u5e02\u7ea7\u5ba1\u6838");
            pre.setString(6, record.getApproveUser());
            pre.setString(7, shlx);
            pre.setString(8, record.getOption() == 1 ? "\u901a\u8fc7" : "\u4e0d\u901a\u8fc7");
            pre.setString(9, gzly);
            pre.addBatch();
            pre.executeBatch();
            conn.commit();
            pre.clearBatch();
            pre.close();
            connTool.Dispose();
            JSONObject config = this.sysConfigService.findToJson("transferConfig");
            String appkey = config.getString("wpzfKey");
            String moudle = config.getString("approveMoudle");
            String url = config.getString("url");
            HttpUtil.sendRrquestByFile(appkey, moudle, temp, url);
        }
        catch (Exception e3) {
            this.logger.warn("\u5ba1\u6838\u63a8\u9001\u5931\u8d25", new Object[]{e3});
        }
        finally {
            try {
                if (pre != null) {
                    pre.close();
                }
                if (connTool != null) {
                    connTool.Dispose();
                }
                if (temp != null && temp.exists()) {
                    temp.delete();
                }
            }
            catch (Exception e4) {
                this.logger.warn((Throwable)e4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWpzfReject(String tbid, String taskid, String userName, String remark) {
        String tempdb = null;
        File temp = null;
        Statement pre = null;
        SqlliteConnTool connTool = null;
        try {
            String customid = Optional.ofNullable("wpzfCustomId").map(arg_0 -> ((SysConfigService)this.sysConfigService).findOne(arg_0)).map(SysConfig::getValue).orElse(null);
            if (StringUtils.isBlank((CharSequence)customid) || !customid.contains(taskid)) {
                return;
            }
            tempdb = this.createApprovedDbtemplate();
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
            String tableName = Optional.of(taskid).map(arg_0 -> ((TskTaskBizRepository)this.tskTaskBizRepository).findById(arg_0)).map(e -> (TskTaskBiz)e.orElseThrow(RuntimeException::new)).map(TskTaskBiz::getTableId).map(arg_0 -> ((TbtskObjectinfoRepository)this.tbtskObjectinfoRepository).findById(arg_0)).map(e -> (TbtskObjectinfo)e.orElseThrow(RuntimeException::new)).map(TbtskObjectinfo::getfTablename).orElseThrow(() -> new RuntimeException("\u65e0\u6548\u7684\u4efb\u52a1\u8868"));
            String wpzfid = Optional.ofNullable("wpzf").map(arg_0 -> ((SysConfigService)this.sysConfigService).findOne(arg_0)).map(SysConfig::getValue).orElse("");
            String shlx = "jcjgwtcz";
            String idField = "f_tbbsm";
            if (wpzfid.equals(taskid)) {
                shlx = "jcjgdk_dktb";
                idField = "f_dkbsm";
            }
            Map data = null;
            try {
                String sql = String.format("select %s,f_gzly from %s where f_id = '%s';", idField, tableName, tbid);
                data = this.jdbcTemplate.queryForMap(sql);
            }
            catch (Exception e2) {
                String sql = String.format("select %s,f_gzly from %s where f_id = '%s';", idField, tableName + "_child", tbid);
                data = this.jdbcTemplate.queryForMap(sql);
            }
            String tbbsm = (String)data.get(idField);
            String gzly = (String)data.get("f_gzly");
            temp = new File(tempdb);
            connTool = new SqlliteConnTool(tempdb);
            Connection conn = connTool.getConnection();
            conn.setAutoCommit(false);
            String insertSql = "INSERT INTO approve_record(f_id, f_tbbsm, f_approvetime, f_content, f_stepname, f_approveuser, f_audittype, f_status, f_gzly) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
            pre = conn.prepareStatement(insertSql);
            pre.setString(1, tbid);
            pre.setString(2, tbbsm);
            pre.setString(3, sdf.format(new Date()));
            pre.setString(4, remark);
            pre.setString(5, "\u5e02\u7ea7\u5ba1\u6838");
            pre.setString(6, userName);
            pre.setString(7, shlx);
            pre.setString(8, "\u4e0d\u901a\u8fc7");
            pre.setString(9, gzly);
            pre.addBatch();
            pre.executeBatch();
            conn.commit();
            pre.clearBatch();
            pre.close();
            connTool.Dispose();
            JSONObject config = this.sysConfigService.findToJson("transferConfig");
            String appkey = config.getString("wpzfKey");
            String moudle = config.getString("approveMoudle");
            String url = config.getString("url");
            HttpUtil.sendRrquestByFile(appkey, moudle, temp, url);
        }
        catch (Exception e3) {
            this.logger.warn("\u5ba1\u6838\u63a8\u9001\u5931\u8d25", new Object[]{e3});
        }
        finally {
            try {
                if (pre != null) {
                    pre.close();
                }
                if (connTool != null) {
                    connTool.Dispose();
                }
                if (temp != null && temp.exists()) {
                    temp.delete();
                }
            }
            catch (Exception e4) {
                this.logger.warn((Throwable)e4);
            }
        }
    }

    private void insert(Connection conn, List<Map<String, Object>> mapList, Map<String, String> fields, String tablename) throws Exception {
        List inFields = fields.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        List<String> outFields = fields.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        String insertSql = "INSERT INTO " + tablename + " (" + WpzfServiceImpl.getInsertFields(outFields) + ") ";
        insertSql = insertSql + " VALUES (" + WpzfServiceImpl.getQuestionMark(outFields) + ")";
        PreparedStatement pre = conn.prepareStatement(insertSql);
        for (int i = 0; i < mapList.size(); ++i) {
            Map<String, Object> map = mapList.get(i);
            for (int j = 0; j < fields.size(); ++j) {
                ExportDataUtils.setStringData(pre, map, (String)inFields.get(j), j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        conn.commit();
        pre.close();
    }

    private String createDbtemplate() throws IOException {
        String destFileName = "";
        String srcFileName = "";
        FileUtil.creatDirectoryIfNotExist((String)this.uploadDir);
        ClassPathResource meta = new ClassPathResource("/static/wpzftask.db");
        InputStream simheiinputStream = meta.getInputStream();
        File metaFile = File.createTempFile("wpzf" + System.currentTimeMillis(), ".db");
        FileUtils.copyInputStreamToFile((InputStream)simheiinputStream, (File)metaFile);
        destFileName = this.uploadDir + File.separator + ("wpzftask" + System.currentTimeMillis() + ".db");
        FileUtils.copyFile((File)metaFile, (File)new File(destFileName));
        return destFileName;
    }

    public static String getInsertFields(List<String> fields) {
        String result = "";
        for (int i = 0; i < fields.size(); ++i) {
            result = result + "'" + fields.get(i) + "'";
            if (i == fields.size() - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public static String getQuestionMark(List<String> fields) {
        String result = "";
        for (int i = 0; i < fields.size(); ++i) {
            result = result + "?";
            if (i == fields.size() - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public static void setStringData(PreparedStatement pre, Map<String, Object> map, String key, int index) throws SQLException {
        if (null == map.get(key)) {
            pre.setString(index, null);
        } else {
            pre.setString(index, map.get(key).toString());
        }
    }

    private String createApprovedDbtemplate() throws IOException {
        String destFileName = "";
        FileUtil.creatDirectoryIfNotExist((String)this.uploadDir);
        ClassPathResource meta = new ClassPathResource("/static/wpzfapprove.db");
        InputStream inputStream = meta.getInputStream();
        destFileName = this.uploadDir + File.separator + ("wpzfapprove" + System.currentTimeMillis() + ".db");
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(destFileName));
        return destFileName;
    }
}

