/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.CommonInfoCQ;
import com.geoway.landteam.landcloud.model.datacq.analyze.EnumAnalyzeResult;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.ResultInfo;
import com.geoway.landteam.landcloud.servface.datacq.BysxzService;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQService;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service(value="CloudAnalyzeCQBysxzService")
@Primary
public class CloudAnalyzeCQBysxzService
extends CloudAnalyzeCQService {
    @Autowired
    private BysxzService bysxzService;

    public boolean ExportReport(List<ProjectInfo> infoList, String requestId) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            document = this.createPdf(info);
            document.addTitle("\u6751\u9547\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a");
            this.addTitle(info.projectName + "\u6751\u9547\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a", this.titleFont, document);
            String content = "\u6309\u7167\u60a8\u52fe\u7ed8\u7684\u9879\u76ee\u8303\u56f4\uff0c\u4f9d\u636e\u56fd\u571f\u8c03\u67e5\u4e91\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684\u6751\u9547\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a\u5982\u4e0b\u3002\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\uff0c\u4e0d\u5177\u6709\u6cd5\u5f8b\u6548\u5e94\u3002";
            this.addContent(content, document);
            ResultInfo result = new ResultInfo();
            List czxzList = this.bysxzService.getBysxzData(requestId);
            this.BaseInfo(infoList, czxzList, document);
            this.secondPart(infoList, result, document);
            this.thirdPart(infoList, result, document);
            this.fourthPart(infoList, result, document);
            this.fifthPart(infoList, result, document);
            this.SummarizeAnalysis(info, result, document);
            this.AddSign(info, czxzList, document);
            this.addDescribe(document);
            document.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    protected void BaseInfo(List<ProjectInfo> infoList, List<Map<String, Object>> czxzList, Document document) throws DocumentException, IOException {
        Map<String, Object> objMap;
        ProjectInfo info = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e00\u3001\u57fa\u672c\u60c5\u51b5", document);
        String content = "%s\u9879\u76ee\u4f4d\u4e8e%s%s%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u9879\u76ee\u5730\u5757\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
        if (StringUtils.isEmpty((CharSequence)info.location)) {
            content = String.format(content, info.projectName, info.provinceName, info.logicCity ? "" : info.cityName, info.countyName, info.villageName, info.lontitude, info.latitude, String.valueOf(PdfAnalyzeUtil.Round(info.area, 2)));
        } else {
            content = "%s\u9879\u76ee\u4f4d\u4e8e%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u9879\u76ee\u5730\u5757\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
            content = String.format(content, info.projectName, info.provinceName, info.location, info.lontitude, info.latitude, String.valueOf(PdfAnalyzeUtil.Round(info.area, 2)));
        }
        if (null != czxzList && !czxzList.isEmpty() && (objMap = czxzList.get(0)) != null) {
            content = "\u9879\u76ee\u540d\u79f0\u4e3a\uff1a" + objMap.get("f_xmmz").toString() + "\uff0c\u9879\u76ee\u7528\u5730\u6027\u8d28\u4e3a" + objMap.get("f_sqlx").toString() + "\uff0c" + content;
        }
        content = this.getAreaContent(info, content);
        this.addContent(content, document);
        this.addTable(info, document);
        this.AddBaseImg(infoList, document);
    }

    protected String getAreaContent(ProjectInfo info, String content) {
        String dlinfo = "";
        if (info.tdghCqInfos != null && info.tdghCqInfos.size() > 0) {
            dlinfo = "\u571f\u5730\u5229\u7528\u73b0\u72b6\uff1a";
            dlinfo = dlinfo + this.getTdlyxz(info);
            dlinfo = info.tdqsInfos != null && info.tdqsInfos.size() > 0 ? dlinfo + "\uff1b" : dlinfo + "\u3002";
        }
        if (info.tdqsInfos != null && info.tdqsInfos.size() > 0) {
            dlinfo = dlinfo + "\u571f\u5730\u6743\u5c5e\u4e3a";
            Map<String, Double> tdqsMap = this.getTdqs(info);
            for (Map.Entry entry : tdqsMap.entrySet()) {
                dlinfo = dlinfo + (String)entry.getKey() + PdfAnalyzeUtil.Round((Double)entry.getValue(), 2) + "\u5e73\u65b9\u7c73\u3001";
            }
            if (dlinfo.endsWith("\u3001")) {
                dlinfo = dlinfo.substring(0, dlinfo.length() - 1) + "\uff1b";
            }
        }
        if (info.cqsdInfos != null && info.cqsdInfos.size() > 0) {
            Double area = 0.0;
            for (CommonInfoCQ commonInfoCQ : info.cqsdInfos) {
                area = area + commonInfoCQ.area;
            }
            dlinfo = dlinfo + "\u6e7f\u5730" + PdfAnalyzeUtil.Round(area, 2) + "\u5e73\u65b9\u7c73\u3002";
        } else {
            dlinfo = dlinfo + "\u4e0d\u5360\u7528\u6e7f\u5730\u3002";
        }
        content = content + dlinfo;
        return content;
    }

    protected String getTdlyxz(ProjectInfo info) {
        String dlinfo = "";
        double otherArea = 0.0;
        int count = 0;
        for (CommonInfoCQ item : info.tdghCqInfos) {
            if (++count > 2) {
                otherArea += item.area.doubleValue();
                continue;
            }
            dlinfo = dlinfo + item.type + PdfAnalyzeUtil.Round(item.area, 2) + "\u5e73\u65b9\u7c73";
            if (count >= info.tdghCqInfos.size()) continue;
            dlinfo = dlinfo + "\u3001";
        }
        if (otherArea > 0.0) {
            dlinfo = dlinfo + "\u5176\u4ed6" + PdfAnalyzeUtil.Round(otherArea, 2) + "\u5e73\u65b9\u7c73";
        }
        return dlinfo;
    }

    @Override
    protected void AddBaseImg(List<ProjectInfo> infoList, Document document) throws DocumentException {
        ProjectInfo otherInfo = this.getOtherNode(infoList);
        PdfPCell c1 = this.createImgTitle("\u9879\u76ee\u533a\u4f4d\u7f6e");
        PdfPCell cimg1 = null;
        PdfPCell meta1 = null;
        if (null != otherInfo.ownershipImg) {
            cimg1 = this.creaeteImgCell(otherInfo.ownershipImg);
            meta1 = this.createImgRoot(otherInfo.ownershipImgMeta);
        }
        int col = 2;
        if (otherInfo.narrow) {
            col = 1;
            PdfPTable t1 = new PdfPTable(col);
            t1.setSpacingBefore(this.pgSpace);
            t1.setSpacingAfter(this.pgSpace);
            t1.setWidthPercentage(80.0f);
            if (otherInfo.ownershipImg != null) {
                t1.addCell(c1);
                t1.addCell(cimg1);
                t1.addCell(meta1);
            }
            document.add((Element)t1);
        } else {
            PdfPTable t = new PdfPTable(col);
            t.setSpacingBefore(this.pgSpace);
            t.setSpacingAfter(this.pgSpace);
            t.setWidthPercentage(100.0f);
            t.addCell(c1);
            t.addCell(cimg1);
            t.addCell(meta1);
            if (otherInfo.photo1 != null || otherInfo.photo2 != null) {
                this.addPhoto(otherInfo, t);
            }
            document.add((Element)t);
        }
    }

    protected void addTable(ProjectInfo info, Document document) throws DocumentException {
        this.addTitle("\u571f\u5730\u5229\u7528\u73b0\u72b6\u8868", this.sectionFont, document);
        this.addTableRightTxt("\u5355\u4f4d\uff1a\u5e73\u65b9\u7c73", document);
        int[] tableWidth = new int[]{30, 30, 30};
        PdfPTable table = this.getPdfPTable(3, tableWidth);
        table.addCell(this.createTableCell(info.tdghCqInfos.size() + 1, "\u73b0\u72b6\u5730\u7c7b\u540d\u79f0"));
        table.addCell(this.createImgTitle("\u5730\u7c7b"));
        table.addCell(this.createImgTitle("\u9762\u79ef"));
        for (int i = 0; i < info.tdghCqInfos.size(); ++i) {
            CommonInfoCQ obj = (CommonInfoCQ)info.tdghCqInfos.get(i);
            table.addCell(this.createImgTitle(obj.type));
            table.addCell(this.createImgTitle(String.valueOf(PdfAnalyzeUtil.Round(obj.area, 2)) + "\u5e73\u65b9\u7c73"));
        }
        Map<String, Double> tdqsMap = this.getTdqs(info);
        table.addCell(this.createTableCell(tdqsMap.size() + 1, "\u6743\u5c5e\u6027\u8d28"));
        table.addCell(this.createImgTitle("\u6743\u5c5e\u6027\u8d28"));
        table.addCell(this.createImgTitle("\u9762\u79ef"));
        for (Map.Entry entry : tdqsMap.entrySet()) {
            table.addCell(this.createImgTitle((String)entry.getKey()));
            table.addCell(this.createImgTitle(String.valueOf(PdfAnalyzeUtil.Round((Double)entry.getValue(), 2)) + "\u5e73\u65b9\u7c73"));
        }
        if (null != info.cqsdInfos && !info.cqsdInfos.isEmpty()) {
            table.addCell(this.createTableCell(info.cqsdInfos.size() + 1, "\u6e7f\u5730\u8303\u56f4\u5185\u5730\u7c7b"));
            table.addCell(this.createImgTitle("\u5730\u7c7b"));
            table.addCell(this.createImgTitle("\u9762\u79ef"));
            for (int i = 0; i < info.cqsdInfos.size(); ++i) {
                CommonInfoCQ commonInfoCQ = (CommonInfoCQ)info.cqsdInfos.get(i);
                table.addCell(this.createImgTitle(this.getSdByType(commonInfoCQ.type)));
                table.addCell(this.createImgTitle(String.valueOf(PdfAnalyzeUtil.Round(commonInfoCQ.area, 2)) + "\u5e73\u65b9\u7c73"));
            }
        }
        document.add((Element)table);
    }

    protected Map<String, Double> getTdqs(ProjectInfo info) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (CommonInfoCQ item : info.tdqsInfos) {
            String type = this.getQsxzByType(item.type);
            if (!result.containsKey(type)) {
                result.put(type, 0.0);
            }
            result.put(type, result.get(type) + item.area);
        }
        return result;
    }

    private PdfPCell createTableCell(Integer col, String content) {
        PdfPCell cell = new PdfPCell(new Phrase(content, this.normalFont));
        cell.setRowspan(col.intValue());
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setPaddingTop(5.0f);
        cell.setPaddingBottom(5.0f);
        return cell;
    }

    protected void addTableRightTxt(String sign, Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(sign, this.normalFont);
        paragraph.setAlignment(2);
        document.add((Element)paragraph);
    }

    protected PdfPTable getPdfPTable(int column, int[] tableWidth) throws DocumentException {
        PdfPTable table = new PdfPTable(column);
        table.setWidths(tableWidth);
        table.setSpacingBefore(this.pgSpace);
        table.setSpacingAfter(this.pgSpace);
        table.getDefaultCell().setBorder(0);
        table.setWidthPercentage(90.0f);
        return table;
    }

    private String getQsxzByType(String type) {
        switch (type) {
            case "10": {
                return "\u56fd\u6709\u571f\u5730\u6240\u6709\u6743";
            }
            case "20": {
                return "\u56fd\u6709\u571f\u5730\u4f7f\u7528\u6743";
            }
            case "30": {
                return "\u96c6\u4f53\u571f\u5730\u6240\u6709\u6743";
            }
        }
        return type;
    }

    private String getSdByType(String type) {
        switch (type) {
            case "201": {
                return "\u6c38\u4e45\u6027\u6cb3\u6d41";
            }
            case "203": {
                return "\u6cdb\u6d2a\u5e73\u539f\u6e7f\u5730";
            }
            case "301": {
                return "\u6c38\u4e45\u6027\u6de1\u6c34\u6e56";
            }
            case "402": {
                return "\u8349\u672c\u6cbc\u6cfd";
            }
            case "407": {
                return "\u5730\u70ed\u6e7f\u5730";
            }
            case "501": {
                return "\u84c4\u6c34\u533a";
            }
            case "502": {
                return "\u6de1\u6c34\u517b\u6b96\u6c60\u5858";
            }
        }
        return type;
    }

    protected void secondPart(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        ProjectInfo info = null;
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e8c\u3001\u751f\u6001\u4fdd\u62a4\u5e95\u7ebf\u5206\u6790", document);
        this.addSthxMessage(result, info, other, "(\u4e00)\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u60c5\u51b5\u5206\u6790", document);
        this.addZrbhdMessage(result, other, "(\u4e8c)\u81ea\u7136\u4fdd\u62a4\u5730\u60c5\u51b5\u5206\u6790", document);
    }

    protected void thirdPart(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        ProjectInfo info = null;
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e09\u3001\u6c38\u4e45\u57fa\u672c\u519c\u7530\u5206\u6790", document);
        this.addJbntMessageContent(result, info, other, document);
    }

    protected void fourthPart(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u56db\u3001\u56fd\u571f\u7a7a\u95f4\u89c4\u5212\u5206\u6790", document);
        this.addCzkfbjMessage(result, other, "(\u4e00)\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u60c5\u51b5\u5206\u6790", document);
        this.addSencondTitle("(\u4e8c)\u9547\u6751\u56fd\u571f\u7a7a\u95f4\u89c4\u5212", document);
        this.addCghContent(result, other, document);
        if (EnumAnalyzeResult.AllPass != result.passCgh || other.cghInfos == null) {
            this.addTdghCQMessage(result, other, document);
        } else {
            result.passTdgh = result.passCgh;
        }
    }

    protected void fifthPart(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e94\u3001\u5730\u8d28\u707e\u5bb3\u5b89\u5168\u5206\u6790", document);
        this.addDzzhCQMessageContent(other, result, document);
    }

    @Override
    protected void SummarizeAnalysis(ProjectInfo info, ResultInfo result, Document document) throws DocumentException {
        boolean allPass;
        this.addFirstTitle("\u516d\u3001\u603b\u4f53\u5206\u6790", document);
        String content = "\u6839\u636e\u5df2\u6709\u6570\u636e\u5206\u6790\u7ed3\u679c\uff0c\u62df\u5efa\u8bbe\u9879\u76ee\u533a";
        boolean legal = result.passSthx == EnumAnalyzeResult.AllPass && result.passZrbhd == EnumAnalyzeResult.AllPass && result.passJbnt == EnumAnalyzeResult.AllPass && result.passCgh == EnumAnalyzeResult.AllPass && result.passTdgh == EnumAnalyzeResult.AllPass;
        boolean suitable = result.passDzfx == EnumAnalyzeResult.AllPass;
        boolean unlegal = result.passSthx == EnumAnalyzeResult.NoPass || result.passZrbhd == EnumAnalyzeResult.NoPass || result.passJbnt == EnumAnalyzeResult.NoPass || result.passCgh == EnumAnalyzeResult.NoPass || result.passTdgh == EnumAnalyzeResult.NoPass;
        boolean unsuitable = result.passDzfx == EnumAnalyzeResult.NoPass;
        boolean bl = allPass = legal && suitable;
        if (allPass) {
            content = content + "\u5408\u6cd5\u3001\u9002\u5b9c\u3002";
            content = content + "\u4e0d\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf";
            content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
            content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
            content = content + "\u7b26\u5408\u6751\u89c4\u5212\u3001";
            content = content + "\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
            content = content + "\u4e0d\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u3002";
        } else if (unlegal) {
            content = content + "\u4e0d\u5408\u6cd5\u3001\u4e0d\u9002\u5b9c\u3002";
            switch (result.passSthx) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                }
            }
            switch (result.passZrbhd) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                }
            }
            switch (result.passJbnt) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                }
            }
            if (result.passTdgh == EnumAnalyzeResult.NoPass && result.passCgh == EnumAnalyzeResult.NoPass) {
                content = content + "\u4e0d\u7b26\u5408\u6751\u5e84\u89c4\u5212\u6216\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
            }
            switch (result.passDzfx) {
                case NoPass: {
                    content = content + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u3001";
                }
            }
            content = content.substring(0, content.length() - 1) + "\u3002";
        } else if (unsuitable) {
            content = content + "\u4e0d\u9002\u5b9c\u3002";
            switch (result.passDzfx) {
                case NoPass: {
                    content = content + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u3001";
                }
            }
            content = content.substring(0, content.length() - 1) + "\u3002";
        } else {
            boolean partlegal = false;
            boolean partsuitable = false;
            String tmp = "";
            if (result.passSthx == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                partlegal = true;
            }
            if (result.passZrbhd == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                partlegal = true;
            }
            if (result.passJbnt == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                partlegal = true;
            }
            if (result.passTdgh == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                partlegal = true;
            }
            if (result.passCgh == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u4e0d\u7b26\u5408\u6751\u5e84\u89c4\u5212\u3001";
                partlegal = true;
            }
            if (result.passDzfx == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u3001";
                partsuitable = true;
            }
            if (!StringUtils.isEmpty((CharSequence)tmp)) {
                tmp = tmp.substring(0, tmp.length() - 1) + "\u3002";
            }
            if (partlegal && partsuitable) {
                content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u3001\u4e0d\u9002\u5b9c\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
            } else if (partlegal) {
                content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
            } else if (partsuitable) {
                content = content + "\u5b58\u5728\u4e0d\u9002\u5b9c\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
            }
            content = content + tmp;
        }
        this.addContent(content, document);
    }

    protected void addDescribe(Document document) throws DocumentException {
        document.newPage();
        this.addFirstTitle("\u9644\uff1a\u6d89\u53ca\u653f\u7b56\u89e3\u8bfb", document);
        this.addSthxDescribe("1\u3001\u5173\u4e8e\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf", document);
        this.addZrbhqDescribe("2\u3001\u5173\u4e8e\u81ea\u7136\u4fdd\u62a4\u5730", document);
        this.addJbntDescribe("3\u3001\u5173\u4e8e\u6c38\u4e45\u57fa\u672c\u519c\u7530", document);
        this.addCzkfbjDescribe("4\u3001\u5173\u4e8e\u57ce\u9547\u5f00\u53d1\u8fb9\u754c", document);
        this.addTdghDescribe("5\u3001\u5173\u4e8e\u6751\u9547\u56fd\u571f\u7a7a\u95f4\u89c4\u5212", document);
        this.addDzzhDescribe("6\u3001\u5173\u4e8e\u5730\u5740\u707e\u5bb3\u5b89\u5168", document);
    }

    protected void AddSign(ProjectInfo info, List<Map<String, Object>> czxzList, Document document) throws DocumentException {
        Map<String, Object> objMap;
        if (!czxzList.isEmpty() && (objMap = czxzList.get(0)) != null) {
            String sign = "\u7533\u8bf7\u4eba\uff1a " + objMap.get("f_lxr").toString();
            this.addSignContent(info.narrow, sign, document);
        }
        String sign = "\u8e0f\u52d8\u4eba\u5458\uff1a " + info.userName;
        this.addSignContent(info.narrow, sign, document);
        String timeStr = "\u65f6  \u95f4\uff1a " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        this.addSignContent(info.narrow, timeStr, document);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void addZrbhdMessage(ResultInfo result, ProjectInfo other, String title, Document document) throws DocumentException {
        this.addSencondTitle(title, document);
        String zrbhdDesc = "\u57fa\u4e8e\u91cd\u5e86\u81ea\u7136\u4fdd\u62a4\u5730\u6570\u636e\u5206\u6790\uff1a";
        Double area = 0.0;
        if (null != other.zrbhdInfos && other.zrbhdInfos.size() > 0) {
            result.passZrbhd = EnumAnalyzeResult.NoPass;
            Double hxqarea = 0.0;
            zrbhdDesc = zrbhdDesc + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\uff0c\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\u9762\u79ef\u4e3a";
            for (int i = 0; i < other.zrbhdInfos.size(); ++i) {
                zrbhdDesc = zrbhdDesc + ((CommonInfoCQ)other.zrbhdInfos.get((int)i)).type + PdfAnalyzeUtil.Round(((CommonInfoCQ)other.zrbhdInfos.get((int)i)).area, 2) + "\u5e73\u65b9\u7c73";
                area = area + ((CommonInfoCQ)other.zrbhdInfos.get((int)i)).area;
                if (i != other.zrbhdInfos.size() - 1) {
                    zrbhdDesc = zrbhdDesc + "\u3001";
                }
                if (!((CommonInfoCQ)other.zrbhdInfos.get((int)i)).type.contains("\u6838\u5fc3")) continue;
                hxqarea = hxqarea + ((CommonInfoCQ)other.zrbhdInfos.get((int)i)).area;
            }
            if (area < other.area) {
                result.passZrbhd = EnumAnalyzeResult.PartPass;
            }
            if (hxqarea == 0.0) {
                // empty if block
            }
        } else {
            result.passZrbhd = EnumAnalyzeResult.AllPass;
            zrbhdDesc = zrbhdDesc + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\u3002";
        }
        this.addContent(zrbhdDesc, document);
        if (other.zrbhdImg != null) {
            String desc = "\u81ea\u7136\u4fdd\u62a4\u5730\uff1a" + PdfAnalyzeUtil.Round(area, 2) + "\u5e73\u65b9\u7c73";
            this.AddImg("\u81ea\u7136\u4fdd\u62a4\u7528\u5730", other.zrbhdImg, desc, document);
        }
    }

    protected void addTdghCQMessage(ResultInfo result, ProjectInfo info, Document document) throws DocumentException {
        String tdghResult = "\u57fa\u4e8e\u91cd\u5e86\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u6570\u636e\u5206\u6790\uff1a";
        Boolean cantBuild = true;
        String tdghDesc = "";
        if (info.tdghCqInfos != null) {
            tdghResult = tdghResult + "\u62df\u5efa\u9879\u76ee\u533a\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u4e2d\u89c4\u5212\u5730\u7c7b\u4e3a";
            for (int i = 0; i < info.tdghCqInfos.size(); ++i) {
                CommonInfoCQ item = (CommonInfoCQ)info.tdghCqInfos.get(i);
                String type = item.type;
                Double typeArea = item.area;
                tdghDesc = tdghDesc + type + ":" + PdfAnalyzeUtil.Round(typeArea, 2) + "\u5e73\u65b9\u7c73";
                if (i != info.tdghCqInfos.size() - 1) {
                    tdghDesc = tdghDesc + "\uff0c";
                }
                if ("\u519c\u6751\u5c45\u6c11\u70b9\u7528\u5730".equals(type) || "\u57ce\u9547\u7528\u5730".equals(type) || !(typeArea > 0.0)) continue;
                cantBuild = false;
            }
            tdghResult = tdghResult + tdghDesc + "\u3002";
        }
        if (!cantBuild.booleanValue()) {
            result.passTdgh = EnumAnalyzeResult.NoPass;
            if (EnumAnalyzeResult.NoPass == result.passCgh && info.cghInfos != null) {
                return;
            }
            tdghResult = tdghResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3002";
        } else {
            result.passTdgh = EnumAnalyzeResult.AllPass;
            tdghResult = tdghResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3002";
        }
        this.addContent(tdghResult, document);
        if (info.tdghCqImg != null) {
            this.AddImg("\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212", info.tdghCqImg, tdghDesc, document);
        }
    }

    protected void addDzzhCQMessageContent(ProjectInfo other, ResultInfo result, Document document) throws DocumentException {
        String dzzhResult = "\u57fa\u4e8e\u91cd\u5e86\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u6570\u636e\u5206\u6790\uff1a";
        double dzfxArea = 0.0;
        if (null != other.dzzhArea && other.dzzhArea > 0.0) {
            result.passDzfx = EnumAnalyzeResult.NoPass;
            if (dzfxArea < other.area) {
                result.passDzfx = EnumAnalyzeResult.PartPass;
            }
            dzzhResult = dzzhResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u3002";
        } else {
            result.passDzfx = EnumAnalyzeResult.AllPass;
            dzzhResult = dzzhResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\u3002";
        }
        this.addContent(dzzhResult, document);
        if (other.dzzhImg != null) {
            String desc = "\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a\uff1a" + PdfAnalyzeUtil.Round(other.dzzhArea, 2) + "\u5e73\u65b9\u7c73";
            this.AddImg("\u5730\u8d28\u707e\u5bb3\u9ad8\u6613\u53d1\u533a", other.dzzhImg, desc, document);
        }
    }
}

