/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQuery;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQueryNode;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryNodeRepository;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryRepository;
import com.geoway.landteam.cloudquery.servface.pub.CloudQueryService;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionCorrect;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionCorrectService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.datacq.analyze.CommonInfoCQ;
import com.geoway.landteam.landcloud.model.datacq.analyze.DzfxInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.EnumAnalyzeResult;
import com.geoway.landteam.landcloud.model.datacq.analyze.LandType;
import com.geoway.landteam.landcloud.model.datacq.analyze.LandUseGrade;
import com.geoway.landteam.landcloud.model.datacq.analyze.Ownership;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.ResultInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.SpbaInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.TdghInfo;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="CloudAnalyzeCQService")
@Transactional(rollbackFor={Exception.class})
public class CloudAnalyzeCQService {
    private GiLoger logger = GwLoger.getLoger(CloudAnalyzeCQService.class);
    @Autowired
    protected CloudQueryNodeRepository nodeRepository;
    @Value(value="${project.downloadDir}")
    String downloadDir;
    @Autowired
    CloudQueryRepository cloudQueryDao;
    @Autowired
    RegionCorrectService regionCorrectService;
    @Autowired
    RegionService regionService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    CloudQueryService cloudQueryService;
    Font titleFont;
    Font chapterFont;
    Font sectionFont;
    Font normalFont;
    Font roleFont;
    Font redFont;
    Font greenFont;
    Font redItalicFont;
    float pgSpace = 18.0f;
    float lineSpace = 16.0f;
    float firstLineIndent = 24.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudAnalyzeCQService() throws IOException, DocumentException {
        ClassPathResource STSONG = new ClassPathResource("/static/STSONG.TTF");
        ClassPathResource simhei = new ClassPathResource("/static/simhei.ttf");
        ClassPathResource simkai = new ClassPathResource("/static/simkai.ttf");
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        if (STSONG.exists()) {
            InputStream STSONGinputStream = STSONG.getInputStream();
            InputStream simheiinputStream = simhei.getInputStream();
            InputStream simkaiinputStream = simkai.getInputStream();
            File STSONGFile = File.createTempFile("template_STSONG_copy", ".TTF");
            File simheiFile = File.createTempFile("template_simhei_copy", ".ttf");
            File simkaiFile = File.createTempFile("template_simkai_copy", ".ttf");
            try {
                FileUtils.copyInputStreamToFile((InputStream)STSONGinputStream, (File)STSONGFile);
                FileUtils.copyInputStreamToFile((InputStream)simheiinputStream, (File)simheiFile);
                FileUtils.copyInputStreamToFile((InputStream)simkaiinputStream, (File)simkaiFile);
                this.titleFont = new Font(BaseFont.createFont((String)simheiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 16.0f);
                this.titleFont.setStyle(1);
                this.chapterFont = new Font(BaseFont.createFont((String)simheiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 14.0f);
                this.chapterFont.setStyle(1);
                this.sectionFont = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.sectionFont.setStyle(1);
                this.normalFont = new Font(BaseFont.createFont((String)STSONGFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.roleFont = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 10.0f);
                this.redFont = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.redFont.setColor(255, 0, 0);
                this.greenFont = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.greenFont.setColor(0, 255, 0);
                this.redItalicFont = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.redItalicFont.setColor(255, 0, 0);
                this.redItalicFont.setStyle(2);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable[])new Closeable[]{STSONGinputStream, simheiinputStream, simkaiinputStream});
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable[])new Closeable[]{STSONGinputStream, simheiinputStream, simkaiinputStream});
        }
    }

    public void destory() {
        this.titleFont = null;
        this.chapterFont = null;
        this.sectionFont = null;
        this.normalFont = null;
        this.roleFont = null;
        this.redFont = null;
        this.greenFont = null;
    }

    public List<ProjectInfo> Parse(String requestId, String tbid, String userName, int analyzeType, String tag) throws Exception {
        List cloudQueryList = this.cloudQueryDao.findByRequestIdTag(requestId, analyzeType, tag);
        ArrayList<CloudQuery> templist = new ArrayList<CloudQuery>();
        if (cloudQueryList == null || cloudQueryList.size() < 1) {
            throw new RuntimeException("\u65e0\u67e5\u8be2\u7ed3\u679c");
        }
        if (cloudQueryList.size() >= 1) {
            for (CloudQuery cq : cloudQueryList) {
                if (!cq.getState().equals(1) && !cq.getState().equals(2)) continue;
                cq.setResult(this.cloudQueryService.getDBUrl(cq.getId(), cq.getNodeId()));
                templist.add(cq);
            }
        }
        ArrayList<ProjectInfo> result = new ArrayList<ProjectInfo>();
        for (CloudQuery query : templist) {
            SqlliteConnTool dbHelper;
            ArrayList tables;
            File lsFile;
            String url;
            String[] paths;
            String fileName;
            ProjectInfo info = new ProjectInfo();
            info.nodeRegion = this.getRegionByNode(query.getNodeId());
            if (info.lontitude == null || info.lontitude.isEmpty()) {
                String countyCode;
                double lat;
                String param = query.getParam();
                JSONObject detail = JSONObject.parseObject((String)param);
                if (detail.containsKey((Object)"lon")) {
                    info.lontitude = detail.get((Object)"lon").toString();
                }
                if (detail.containsKey((Object)"lat")) {
                    info.latitude = detail.get((Object)"lat").toString();
                }
                if (detail.containsKey((Object)"mj")) {
                    String mj = detail.get((Object)"mj").toString();
                    info.area = Double.parseDouble(mj) * 666.6666;
                }
                String lonStr = info.lontitude;
                String latStr = info.latitude;
                double lon = Double.parseDouble(lonStr);
                RegionCorrect regionCorrect = this.regionCorrectService.getOfCoord(lon, lat = Double.parseDouble(latStr));
                if (regionCorrect != null && (countyCode = regionCorrect.getId()).length() == 6) {
                    String cityCode = countyCode.substring(0, 4) + "00";
                    String provinceCode = countyCode.substring(0, 2) + "0000";
                    Region county = this.regionService.findRegionByCode(countyCode);
                    Region city = this.regionService.findRegionByCode(cityCode);
                    Region province = this.regionService.findRegionByCode(provinceCode);
                    info.provinceCode = provinceCode;
                    info.cityCode = cityCode;
                    info.countyCode = countyCode;
                    info.location = query.getName();
                    if (province != null) {
                        info.provinceName = province.getName();
                    }
                    if (city != null) {
                        info.cityName = city.getName();
                        if ("500000".equals(province.getCode())) {
                            info.logicCity = true;
                        }
                    }
                    if (county != null) {
                        info.countyName = county.getName();
                    }
                }
            }
            if ((fileName = (paths = (url = query.getResult()).split("/"))[paths.length - 1]).indexOf("?") > -1) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }
            if (!(lsFile = new File(this.downloadDir, fileName)).exists()) {
                FileUtils.copyURLToFile((URL)new URL(url), (File)lsFile);
            }
            if ((tables = (dbHelper = new SqlliteConnTool(lsFile.getAbsolutePath())).getTables()) == null || tables.size() == 0) continue;
            if (analyzeType != 0) {
                for (String table : tables) {
                    if ("1".equals(info.nodeRegion)) {
                        PdfAnalyzeUtil.Parse(dbHelper, table, info);
                        continue;
                    }
                    if (!"500000".equals(info.nodeRegion)) continue;
                    PdfAnalyzeUtil.ParseCQ(dbHelper, table, info);
                }
            } else if (tables.contains("Image_Analyze")) {
                for (String table : tables) {
                    String tn = table.toLowerCase();
                    System.out.println("table:" + tn);
                    switch (tn) {
                        case "image_analyze": {
                            info.ownershipImgMeta = PdfAnalyzeUtil.GetImageMeta(dbHelper, "Image_Analyze");
                        }
                    }
                }
            } else {
                for (String table : tables) {
                    PdfAnalyzeUtil.Parse(dbHelper, table, info);
                }
            }
            dbHelper.Dispose();
            result.add(info);
        }
        return result;
    }

    public Document createPdf(ProjectInfo info) throws DocumentException, FileNotFoundException {
        File file = new File(info.outFile);
        file.getParentFile().mkdirs();
        Rectangle size = PageSize.A4;
        if (info.narrow) {
            size = PageSize.A5;
        }
        Rectangle rectPageSize = new Rectangle(size);
        Document document = new Document(rectPageSize, 40.0f, 40.0f, 40.0f, 40.0f);
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(info.outFile));
        pdfWriter.setInitialLeading(30.0f);
        document.open();
        return document;
    }

    public boolean ExportReport(List<ProjectInfo> infoList) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            document = this.createPdf(info);
            document.addTitle("\u5efa\u8bbe\u7528\u5730\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a");
            Paragraph title = new Paragraph(info.projectName + "\u5efa\u8bbe\u7528\u5730\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a", this.titleFont);
            title.setAlignment(1);
            document.add((Element)title);
            String content = "\u6309\u7167\u60a8\u52fe\u7ed8\u7684\u9879\u76ee\u8303\u56f4\uff0c\u4f9d\u636e\u56fd\u571f\u8c03\u67e5\u4e91\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684\u5efa\u8bbe\u7528\u5730\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a\u5982\u4e0b\u3002\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\uff0c\u4e0d\u5177\u6709\u6cd5\u5f8b\u6548\u5e94\u3002";
            this.addContent(content, document);
            ResultInfo result = new ResultInfo();
            this.BaseInfo(infoList, result, document);
            this.LegalAnalysis(infoList, result, document);
            this.SuitableAnalysis(infoList, result, document);
            this.SummarizeAnalysis(info, result, document);
            this.AddSign(info, document);
            document.close();
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    protected void BaseInfo(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException, IOException {
        ProjectInfo info = this.getCountryNode(infoList);
        this.addFirstTitle("\u4e00\u3001\u57fa\u672c\u60c5\u51b5", document);
        String content = "%s\u9879\u76ee\u4f4d\u4e8e%s%s%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u9879\u76ee\u5730\u5757\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
        content = String.format(content, info.projectName, info.provinceName, info.logicCity ? "" : info.cityName, info.countyName, info.villageName, info.lontitude, info.latitude, String.valueOf(PdfAnalyzeUtil.Round(info.area, 2)));
        String dlinfo = "";
        int lengLy = 0;
        int lengOw = 0;
        if (info.landTypes != null && info.landTypes.size() > 0) {
            lengLy = info.landTypes.size();
        }
        if (info.ownerships != null && info.ownerships.size() > 0) {
            lengOw = info.ownerships.size();
        }
        if (lengLy > 0) {
            dlinfo = "\u571f\u5730\u5229\u7528\u73b0\u72b6\uff1a";
            double otherArea = 0.0;
            int count = 0;
            for (LandType item : info.landTypes) {
                if (++count > 2) {
                    otherArea += item.area;
                    continue;
                }
                dlinfo = dlinfo + item.dlmc + PdfAnalyzeUtil.Round(item.area, 2) + "\u5e73\u65b9\u7c73";
                if (count >= lengLy) continue;
                dlinfo = dlinfo + "\u3001";
            }
            if (otherArea > 0.0) {
                dlinfo = dlinfo + "\u5176\u4ed6" + PdfAnalyzeUtil.Round(otherArea, 2) + "\u5e73\u65b9\u7c73";
            }
            dlinfo = lengOw > 0 ? dlinfo + "\uff1b" : dlinfo + "\u3002";
        }
        if (lengOw > 0) {
            dlinfo = dlinfo + "\u571f\u5730\u6743\u5c5e\u4e3a";
            HashMap<String, Double> dic = new HashMap<String, Double>();
            dic.put("\u56fd\u6709", 0.0);
            dic.put("\u96c6\u4f53", 0.0);
            dic.put("\u5176\u4ed6", 0.0);
            for (Ownership item : info.ownerships) {
                if (item.detail == null) continue;
                dic.put("\u56fd\u6709", (Double)dic.get("\u56fd\u6709") + item.detail.lx10);
                dic.put("\u56fd\u6709", (Double)dic.get("\u56fd\u6709") + item.detail.lx20);
                dic.put("\u96c6\u4f53", (Double)dic.get("\u96c6\u4f53") + item.detail.lx30);
                dic.put("\u96c6\u4f53", (Double)dic.get("\u96c6\u4f53") + item.detail.lx40);
                dic.put("\u5176\u4ed6", (Double)dic.get("\u5176\u4ed6") + item.detail.lx99);
            }
            if (PdfAnalyzeUtil.Round((Double)dic.get("\u56fd\u6709"), 2) > 0.0) {
                dlinfo = dlinfo + "\u56fd\u6709" + PdfAnalyzeUtil.Round((Double)dic.get("\u56fd\u6709"), 2) + "\u5e73\u65b9\u7c73\u3001";
            }
            if (PdfAnalyzeUtil.Round((Double)dic.get("\u96c6\u4f53"), 2) > 0.0) {
                dlinfo = dlinfo + "\u96c6\u4f53" + PdfAnalyzeUtil.Round((Double)dic.get("\u96c6\u4f53"), 2) + "\u5e73\u65b9\u7c73\u3001";
            }
            if (PdfAnalyzeUtil.Round((Double)dic.get("\u5176\u4ed6"), 2) > 0.0) {
                dlinfo = dlinfo + "\u5176\u4ed6" + PdfAnalyzeUtil.Round((Double)dic.get("\u5176\u4ed6"), 2) + "\u5e73\u65b9\u7c73\u3001";
            }
            if (dlinfo.endsWith("\u3001")) {
                dlinfo = dlinfo.substring(0, dlinfo.length() - 1) + "\u3002";
            }
        }
        content = content + dlinfo;
        this.addContent(content, document);
        this.AddBaseImg(infoList, document);
    }

    protected void LegalAnalysis(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        ProjectInfo info = this.getCountryNode(infoList);
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e8c\u3001\u5408\u6cd5\u6027\u5206\u6790", document);
        this.addJbntMessage(result, info, other, document);
        this.addJbntDescribe("\u653f\u7b56\u89e3\u8bfb", document);
        this.addTdghMessage(result, info, document);
        this.addSpbaMessage(result, info, document);
        this.addZrbhqMessage(result, info, other, "(\u56db)\u81ea\u7136\u4fdd\u62a4\u5730\u60c5\u51b5\u5206\u6790", document);
        this.addZrbhqDescribe("\u653f\u7b56\u89e3\u8bfb", document);
        this.addSthxMessage(result, info, other, "(\u4e94)\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u60c5\u51b5\u5206\u6790", document);
        this.addSthxDescribe("\u653f\u7b56\u89e3\u8bfb", document);
        if (info.cityCode.startsWith("50")) {
            this.addJsydgzqMessage(result, other, document);
            this.addCzkfbjMessage(result, other, "(\u4e03)\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u60c5\u51b5\u5206\u6790", document);
            this.addCzkfbjDescribe("\u653f\u7b56\u89e3\u8bfb", document);
        }
        this.BzInfo(document);
    }

    protected void addJsydgzqMessage(ResultInfo result, ProjectInfo info, Document document) throws DocumentException {
        this.addSencondTitle("(\u516d)\u5efa\u8bbe\u7528\u5730\u60c5\u51b5\u5206\u6790", document);
        this.addJsgzqElement(info.jsydgzqArea, info.jsydgzqImg, info.area, "\u57fa\u4e8e\u91cd\u5e86\u5efa\u8bbe\u7528\u5730\u6570\u636e\u5206\u6790\uff1a", info.jsydInfos, document);
        if (info.jsydInfos != null) {
            result.passJsydgzq = EnumAnalyzeResult.AllPass;
            for (int i = 0; i < info.jsydInfos.size(); ++i) {
                if (!"040".equals(((CommonInfoCQ)info.jsydInfos.get((int)i)).type)) continue;
                result.passJsydgzq = EnumAnalyzeResult.NoPass;
                break;
            }
        }
        this.AddRoleDesc("\u300a\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c\u4e09\u5341\u4e09\u6761 \u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u5212\u5b9a\u7684\u57ce\u4e61\u5efa\u8bbe\u7528\u5730\u7ba1\u5236\u8fb9\u754c\u548c\u7ba1\u5236\u533a\u57df\uff0c\u5fc5\u987b\u4e25\u683c\u6267\u884c\uff0c\u672a\u7ecf\u4f9d\u6cd5\u6279\u51c6\uff0c\u4e0d\u5f97\u64c5\u81ea\u7a81\u7834\u3002", "\u653f\u7b56\u89e3\u8bfb", document);
        this.AddRoleDesc("\u9700\u8981\u4f7f\u7528\u571f\u5730\u7684\u57ce\u3001\u9547\u3001\u6751\u548c\u5de5\u77ff\u5efa\u8bbe\u9879\u76ee\uff0c\u5e94\u5f53\u5728\u5141\u8bb8\u5efa\u8bbe\u533a\u5185\u5b89\u6392\u5efa\u8bbe\u7528\u5730\u3002", null, document);
        this.AddRoleDesc("\u4e25\u7981\u5728\u9650\u5236\u5efa\u8bbe\u533a\u548c\u7981\u6b62\u5efa\u8bbe\u533a\u5185\u5b89\u6392\u57ce\u9547\u5efa\u8bbe\u9879\u76ee\u3002\u4ea4\u901a\u3001\u80fd\u6e90\u3001\u6c34\u5229\u3001\u519b\u4e8b\u3001\u56fd\u5bb6\u5b89\u5168\u3001\u77ff\u5c71\u548c\u5176\u4ed6\u56e0\u751f\u6001\u73af\u5883\u4fdd\u62a4\u8981\u6c42\u786e\u9700\u5728\u9650\u5236\u5efa\u8bbe\u533a\u548c\u7981\u6b62\u5efa\u8bbe\u533a\u5185\u5355\u72ec\u9009\u5740\u7684\u5efa\u8bbe\u9879\u76ee\uff0c\u5fc5\u987b\u7ecf\u4f9d\u6cd5\u6279\u51c6\u3002", null, document);
    }

    protected void addJsgzqElement(Double area, Image img, Double allArea, String text, List<CommonInfoCQ> jsydInfos, Document document) throws DocumentException {
        String desc = text;
        desc = area != null ? desc + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u5efa\u8bbe\u7528\u5730\u3002" : desc + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u5efa\u8bbe\u7528\u5730\u3002";
        this.addContent(desc, document);
        if (img != null) {
            String desc2 = "\u5efa\u8bbe\u7528\u5730\u7ba1\u5236\u533a\uff1a";
            for (int i = 0; i < jsydInfos.size(); ++i) {
                String type = jsydInfos.get((int)i).type;
                Double typeArea = jsydInfos.get((int)i).area;
                desc2 = desc2 + type + ":" + PdfAnalyzeUtil.Round(typeArea, 2) + "\u5e73\u65b9\u7c73\uff0c";
            }
            desc2 = desc2 + "\u975e\u5efa\u8bbe\u7528\u5730\u7ba1\u5236\u533a\uff1a" + PdfAnalyzeUtil.Round(allArea - area, 2) + "\u5e73\u65b9\u7c73";
            this.AddImg("\u5efa\u8bbe\u7528\u5730\u7ba1\u5236\u533a", img, desc2, document);
        }
    }

    protected void addCzkfbjMessage(ResultInfo result, ProjectInfo info, String title, Document document) throws DocumentException {
        if (null != title) {
            this.addSencondTitle(title, document);
        }
        String czkfDesc = "\u57fa\u4e8e\u91cd\u5e86\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u5206\u6790\uff1a";
        czkfDesc = info.czkfImg != null ? czkfDesc + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u57ce\u9547\u5f00\u53d1\u8fb9\u754c" + PdfAnalyzeUtil.Round(info.czkfArea, 2) + "\u5e73\u65b9\u7c73\u3002" : czkfDesc + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u3002";
        this.addContent(czkfDesc, document);
        if (info.czkfImg != null) {
            String desc = "\u6d89\u53ca\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\uff1a" + PdfAnalyzeUtil.Round(info.czkfArea, 2) + "\u5e73\u65b9\u7c73";
            this.AddImg("\u57ce\u9547\u5f00\u53d1\u8fb9\u754c", info.czkfImg, desc, document);
        }
    }

    protected void addCzkfbjDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u5173\u4e8e\u5728\u56fd\u571f\u7a7a\u95f4\u89c4\u5212\u4e2d\u7edf\u7b79\u5212\u5b9a\u843d\u5b9e\u4e09\u6761\u63a7\u5236\u7ebf\u7684\u6307\u5bfc\u610f\u89c1\u300b\u7b2c\u516d\u6761 \u6309\u7167\u96c6\u7ea6\u9002\u5ea6\u3001\u7eff\u8272\u53d1\u5c55\u8981\u6c42\u5212\u5b9a\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u3002\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u662f\u5728\u4e00\u5b9a\u65f6\u671f\u5185\u56e0\u57ce\u9547\u53d1\u5c55\u9700\u8981\uff0c\u53ef\u4ee5\u96c6\u4e2d\u8fdb\u884c\u57ce\u9547\u5f00\u53d1\u5efa\u8bbe\u3001\u4ee5\u57ce\u9547\u529f\u80fd\u4e3a\u4e3b\u7684\u533a\u57df\u8fb9\u754c\uff0c\u6d89\u53ca\u57ce\u5e02\u3001\u5efa\u5236\u9547\u4ee5\u53ca\u5404\u7c7b\u5f00\u53d1\u533a\u7b49\u3002\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u5212\u5b9a\u4ee5\u57ce\u9547\u5f00\u53d1\u5efa\u8bbe\u73b0\u72b6\u4e3a\u57fa\u7840\uff0c\u7efc\u5408\u8003\u8651\u8d44\u6e90\u627f\u8f7d\u80fd\u529b\u3001\u4eba\u53e3\u5206\u5e03\u3001\u7ecf\u6d4e\u5e03\u5c40\u3001\u57ce\u4e61\u7edf\u7b79\u3001\u57ce\u9547\u53d1\u5c55\u9636\u6bb5\u548c\u53d1\u5c55\u6f5c\u529b\uff0c\u6846\u5b9a\u603b\u91cf\uff0c\u9650\u5b9a\u5bb9\u91cf\uff0c\u9632\u6b62\u57ce\u9547\u65e0\u5e8f\u8513\u5ef6\u3002\u79d1\u5b66\u9884\u7559\u4e00\u5b9a\u6bd4\u4f8b\u7684\u7559\u767d\u533a\uff0c\u4e3a\u672a\u6765\u53d1\u5c55\u7559\u6709\u5f00\u53d1\u7a7a\u95f4\u3002\u57ce\u9547\u5efa\u8bbe\u548c\u53d1\u5c55\u4e0d\u5f97\u8fdd\u6cd5\u8fdd\u89c4\u4fb5\u5360\u6cb3\u9053\u3001\u6e56\u9762\u3001\u6ee9\u5730\u3002", role, document);
    }

    protected void addSthxMessage(ResultInfo result, ProjectInfo info, ProjectInfo other, String title, Document document) throws DocumentException {
        if (title != null) {
            this.addSencondTitle(title, document);
        }
        ProjectInfo temp = null;
        String zrbhqDesc = "";
        if (other.provinceCode.startsWith("50")) {
            temp = other;
            zrbhqDesc = "\u57fa\u4e8e\u91cd\u5e86\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u6570\u636e\u5206\u6790\uff1a";
        } else {
            temp = info;
            zrbhqDesc = "\u57fa\u4e8e\u56fd\u5bb6\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u6570\u636e\u5206\u6790\uff1a";
        }
        this.addSthxElement(temp.sthxArea, temp.sthxImg, temp.area, zrbhqDesc, result, document);
    }

    protected void addSthxDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u5173\u4e8e\u5212\u5b9a\u5e76\u4e25\u5b88\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u7684\u82e5\u5e72\u610f\u89c1\u300b\u7b2c\u516b\u6761 \u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u5212\u5b9a\u540e\uff0c\u76f8\u5173\u89c4\u5212\u8981\u7b26\u5408\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u7a7a\u95f4\u7ba1\u63a7\u8981\u6c42\uff0c\u4e0d\u7b26\u5408\u7684\u8981\u53ca\u65f6\u8fdb\u884c\u8c03\u6574\u3002\u7a7a\u95f4\u89c4\u5212\u7f16\u5236\u8981\u5c06\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u4f5c\u4e3a\u91cd\u8981\u57fa\u7840\uff0c\u53d1\u6325\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u5bf9\u4e8e\u56fd\u571f\u7a7a\u95f4\u5f00\u53d1\u7684\u5e95\u7ebf\u4f5c\u7528\u3002", role, document);
        this.AddRoleDesc("\u300a\u5173\u4e8e\u5212\u5b9a\u5e76\u4e25\u5b88\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u7684\u82e5\u5e72\u610f\u89c1\u300b\u7b2c\u4e5d\u6761 \u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u539f\u5219\u4e0a\u6309\u7981\u6b62\u5f00\u53d1\u533a\u57df\u7684\u8981\u6c42\u8fdb\u884c\u7ba1\u7406\u3002\u4e25\u7981\u4e0d\u7b26\u5408\u4e3b\u4f53\u529f\u80fd\u5b9a\u4f4d\u7684\u5404\u7c7b\u5f00\u53d1\u6d3b\u52a8\uff0c\u4e25\u7981\u4efb\u610f\u6539\u53d8\u7528\u9014\u3002\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u5212\u5b9a\u540e\uff0c\u53ea\u80fd\u589e\u52a0\u3001\u4e0d\u80fd\u51cf\u5c11\uff0c\u56e0\u56fd\u5bb6\u91cd\u5927\u57fa\u7840\u8bbe\u65bd\u3001\u91cd\u5927\u6c11\u751f\u4fdd\u969c\u9879\u76ee\u5efa\u8bbe\u7b49\u9700\u8981\u8c03\u6574\u7684\uff0c\u7531\u7701\u7ea7\u653f\u5e9c\u7ec4\u7ec7\u8bba\u8bc1\uff0c\u63d0\u51fa\u8c03\u6574\u65b9\u6848\uff0c\u7ecf\u73af\u5883\u4fdd\u62a4\u90e8\u3001\u56fd\u5bb6\u53d1\u5c55\u6539\u9769\u59d4\u4f1a\u540c\u6709\u5173\u90e8\u95e8\u63d0\u51fa\u5ba1\u6838\u610f\u89c1\u540e\uff0c\u62a5\u56fd\u52a1\u9662\u6279\u51c6\u3002\u56e0\u56fd\u5bb6\u91cd\u5927\u6218\u7565\u8d44\u6e90\u52d8\u67e5\u9700\u8981\uff0c\u5728\u4e0d\u5f71\u54cd\u4e3b\u4f53\u529f\u80fd\u5b9a\u4f4d\u7684\u524d\u63d0\u4e0b\uff0c\u7ecf\u4f9d\u6cd5\u6279\u51c6\u540e\u4e88\u4ee5\u5b89\u6392\u52d8\u67e5\u9879\u76ee\u3002", null, document);
    }

    protected void addSthxElement(Double area, Image img, Double allArea, String text, ResultInfo result, Document document) throws DocumentException {
        String desc1 = text;
        if (area != null && area > 0.0) {
            result.passSthx = EnumAnalyzeResult.NoPass;
            if (area < allArea) {
                result.passSthx = EnumAnalyzeResult.PartPass;
            }
            desc1 = desc1 + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf" + PdfAnalyzeUtil.Round(area, 2) + "\u5e73\u65b9\u7c73\u3002";
        } else {
            result.passSthx = EnumAnalyzeResult.AllPass;
            desc1 = desc1 + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3002";
        }
        this.addContent(desc1, document);
        if (img != null) {
            String desc = "\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\uff1a" + PdfAnalyzeUtil.Round(area, 2) + "\u5e73\u65b9\u7c73";
            this.AddImg("\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf", img, desc, document);
        }
    }

    protected void addZrbhqMessage(ResultInfo result, ProjectInfo info, ProjectInfo other, String title, Document document) throws DocumentException {
        this.addSencondTitle(title, document);
        ProjectInfo temp = null;
        String zrbhqDesc = "";
        if (info.provinceCode.startsWith("50")) {
            temp = other;
            zrbhqDesc = "\u57fa\u4e8e\u91cd\u5e86\u81ea\u7136\u4fdd\u62a4\u5730\u6570\u636e\u5206\u6790\uff1a";
        } else {
            temp = info;
            zrbhqDesc = "\u57fa\u4e8e\u56fd\u5bb6\u81ea\u7136\u4fdd\u62a4\u5730\u6570\u636e\u5206\u6790\uff1a";
        }
        if (null != temp.zrbhqArea && temp.zrbhqArea > 0.0) {
            result.passZrbhq = EnumAnalyzeResult.NoPass;
            if (temp.zrbhqArea < temp.area) {
                result.passZrbhq = EnumAnalyzeResult.PartPass;
            }
            zrbhqDesc = zrbhqDesc + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\uff0c\u5171 " + PdfAnalyzeUtil.Round(temp.zrbhqArea, 2) + "\u5e73\u65b9\u7c73";
        } else {
            result.passZrbhq = EnumAnalyzeResult.AllPass;
            zrbhqDesc = zrbhqDesc + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\u3002";
        }
        this.addContent(zrbhqDesc, document);
        if (temp.zrbhqImg != null) {
            String desc = "\u81ea\u7136\u4fdd\u62a4\u5730\uff1a" + PdfAnalyzeUtil.Round(temp.zrbhqArea, 2) + "\u5e73\u65b9\u7c73\uff0c\u975e\u81ea\u7136\u4fdd\u62a4\u5730\uff1a" + PdfAnalyzeUtil.Round(temp.area - temp.zrbhqArea, 2) + "\u5e73\u65b9\u7c73";
            this.AddImg("\u81ea\u7136\u4fdd\u62a4\u7528\u5730", temp.zrbhqImg, desc, document);
        }
    }

    protected void addZrbhqDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u81ea\u7136\u4fdd\u62a4\u533a\u571f\u5730\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c\u5341\u4e94\u6761 \u81ea\u7136\u4fdd\u62a4\u533a\u5185\u571f\u5730\u7684\u4f7f\u7528\uff0c\u4e0d\u5f97\u8fdd\u53cd\u6709\u5173\u73af\u5883\u548c\u8d44\u6e90\u4fdd\u62a4\u6cd5\u5f8b\u7684\u89c4\u5b9a\u3002", role, document);
        this.AddRoleDesc("\u4f9d\u6cd5\u4f7f\u7528\u81ea\u7136\u4fdd\u62a4\u533a\u5185\u571f\u5730\u7684\u5355\u4f4d\u548c\u4e2a\u4eba\u5fc5\u987b\u4e25\u683c\u6309\u7167\u571f\u5730\u767b\u8bb0\u548c\u571f\u5730\u8bc1\u4e66\u89c4\u5b9a\u7684\u7528\u9014\u4f7f\u7528\u571f\u5730\uff0c\u5e76\u4e25\u683c\u9075\u5b88\u6709\u5173\u6cd5\u5f8b\u7684\u89c4\u5b9a\u3002\u6539\u53d8\u7528\u9014\u65f6\uff0c\u9700\u4e8b\u5148\u5f81\u6c42\u73af\u5883\u4fdd\u62a4\u53ca\u6709\u5173\u81ea\u7136\u4fdd\u62a4\u533a\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u7684\u610f\u89c1\uff0c\u7531\u53bf\u7ea7\u4ee5\u4e0a\u4eba\u6c11\u653f\u5e9c\u571f\u5730\u7ba1\u7406\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u5ba1\u67e5\uff0c\u62a5\u53bf\u7ea7\u4ee5\u4e0a\u4eba\u6c11\u653f\u5e9c\u6279\u51c6\u3002", null, document);
    }

    protected void addSpbaMessage(ResultInfo result, ProjectInfo info, Document document) throws DocumentException {
        this.addSencondTitle("(\u4e09)\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u60c5\u51b5\u5206\u6790", document);
        String spbaResult = "\u57fa\u4e8e\u56fd\u5bb6\u7528\u5730\u5ba1\u6279\u60c5\u51b5\u6570\u636e\u5206\u6790\uff1a";
        double spbaArea = 0.0;
        if (info.spbaInfos != null && info.spbaInfos.size() > 0) {
            String license = "";
            int count = 0;
            for (SpbaInfo sp : info.spbaInfos) {
                spbaArea += sp.area;
                license = license + sp.license;
                if (++count >= info.spbaInfos.size()) continue;
                license = license + "\u3001";
            }
            result.passSpba = EnumAnalyzeResult.NoPass;
            if (spbaArea > 0.0) {
                if (spbaArea < info.area) {
                    result.passSpba = EnumAnalyzeResult.PartPass;
                    spbaResult = spbaResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6709\u90e8\u5206\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
                } else {
                    result.passSpba = EnumAnalyzeResult.AllPass;
                    spbaResult = spbaResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6709\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
                }
                if (license != null && !license.isEmpty()) {
                    spbaResult = spbaResult + "\u5907\u6848\u53f7\u4e3a\uff1a" + license;
                }
            } else {
                result.passSpba = EnumAnalyzeResult.NoPass;
                spbaResult = spbaResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u65e0\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
            }
        } else {
            result.passSpba = EnumAnalyzeResult.NoPass;
            spbaResult = spbaResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u65e0\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
        }
        this.addContent(spbaResult, document);
        if (info.spbaImg != null) {
            String desc = "\u6709\u5ba1\u6279\uff1a" + PdfAnalyzeUtil.Round(spbaArea, 2) + "\u5e73\u65b9\u7c73\uff0c\u65e0\u5ba1\u6279\uff1a" + PdfAnalyzeUtil.Round(info.area - spbaArea, 2) + "\u5e73\u65b9\u7c73";
            this.AddImg("\u7528\u5730\u5ba1\u6279", info.spbaImg, desc, document);
        }
        this.AddRoleDesc("\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u56db\u5341\u56db\u6761 \u5efa\u8bbe\u5360\u571f\u5730\uff0c\u6d89\u53ca\u519c\u7528\u5730\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u5e94\u5f53\u529e\u7406\u519c\u7528\u5730\u8f6c\u7528\u5ba1\u6279\u624b\u7eed\u3002", "\u653f\u7b56\u89e3\u8bfb", document);
        this.AddRoleDesc("\u6c38\u4e45\u57fa\u672c\u519c\u7530\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u7531\u56fd\u52a1\u9662\u5ba1\u6279\u3002", null, document);
        this.AddRoleDesc("\u5728\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u786e\u5b9a\u7684\u57ce\u5e02\u548c\u6751\u5e84\u3001\u96c6\u9547\u5efa\u8bbe\u7528\u5730\u89c4\u6a21\u8303\u56f4\u5185\uff0c\u672a\u5b9e\u65bd\u8be5\u89c4\u5b9a\u800c\u5c06\u6c38\u4e45\u57fa\u672c\u519c\u7530\u4ee5\u5916\u7684\u519c\u7528\u5730\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u6309\u571f\u5730\u5229\u7528\u5e74\u5ea6\u8ba1\u5212\u5206\u6279\u6b21\u6309\u7167\u56fd\u52a1\u9662\u89c4\u5b9a\u7531\u539f\u5ba1\u6279\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u7684\u673a\u5173\u5355\u4f4d\u6216\u8005\u5176\u6388\u6743\u7684\u673a\u5173\u5ba1\u6279\u3002\u5728\u5df2\u6279\u51c6\u7684\u519c\u7528\u5730\u8f6c\u7528\u8303\u56f4\u5185\uff0c\u5177\u4f53\u5efa\u8bbe\u9879\u76ee\u7528\u5730\u53ef\u4ee5\u7531\u5e02\u3001\u53bf\u4eba\u6c11\u653f\u5e9c\u6279\u51c6\u3002", null, document);
        this.AddRoleDesc("\u7b2c\u56db\u5341\u516d\u6761 \u5f81\u6536\u4e0b\u5217\u571f\u5730\u7684\uff0c\u7531\u56fd\u52a1\u9662\u6279\u51c6\uff1a", null, document);
        this.AddRoleDesc("\uff08\u4e00\uff09\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff1b", null, document);
        this.AddRoleDesc("\uff08\u4e8c\uff09\u6c38\u4e45\u57fa\u672c\u519c\u7530\u4ee5\u5916\u7684\u8015\u5730\u8d85\u8fc7\u4e09\u5341\u4e94\u516c\u9877\u7684\uff1b", null, document);
        this.AddRoleDesc("\uff08\u4e09\uff09\u5176\u4ed6\u571f\u5730\u8d85\u8fc7\u4e03\u5341\u516c\u9877\u7684\u3002", null, document);
        this.AddRoleDesc("\u5f81\u6536\u524d\u6b3e\u89c4\u5b9a\u4ee5\u5916\u7684\u571f\u5730\u7684\uff0c\u7531\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u5ba1\u6279\u3002", null, document);
        this.AddRoleDesc("\u5f81\u6536\u519c\u7528\u5730\u7684\uff0c\u5e94\u5f53\u4f9d\u7167\u672c\u6cd5\u7b2c\u56db\u5341\u56db\u6761\u7684\u89c4\u5b9a\u5148\u884c\u529e\u7406\u519c\u7528\u5730\u8f6c\u7528\u5ba1\u6279\u3002\u5176\u4e2d\uff0c\u7ecf\u56fd\u52a1\u9662\u6279\u51c6\u519c\u7528\u5730\u8f6c\u7528\u7684\uff0c\u540c\u65f6\u529e\u7406\u5f81\u5730\u5ba1\u6279\u624b\u7eed\uff0c\u4e0d\u518d\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\uff1b\u7ecf\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u5728\u5f81\u5730\u6279\u51c6\u6743\u9650\u5185\u6279\u51c6\u519c\u7528\u5730\u8f6c\u7528\u7684\uff0c\u540c\u65f6\u529e\u7406\u5f81\u5730\u5ba1\u6279\u624b\u7eed\uff0c\u4e0d\u518d\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\uff0c\u8d85\u8fc7\u5f81\u5730\u6279\u51c6\u6743\u9650\u7684\uff0c\u5e94\u5f53\u4f9d\u7167\u672c\u6761\u7b2c\u4e00\u6b3e\u7684\u89c4\u5b9a\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\u3002", null, document);
    }

    protected void addTdghMessage(ResultInfo result, ProjectInfo info, Document document) throws DocumentException {
        this.addSencondTitle("(\u4e8c)\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u60c5\u51b5\u5206\u6790", document);
        String tdghDesc = "";
        String tdghResult = "\u57fa\u4e8e\u56fd\u5bb6\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u6570\u636e\u5206\u6790\uff1a";
        double cantJsArea = 0.0;
        if (info.tdghInfos != null) {
            int count = 0;
            int leng = info.tdghInfos.size();
            for (TdghInfo item : info.tdghInfos) {
                tdghDesc = tdghDesc + item.jsmc + "(" + item.jsbm + ")\uff1a" + PdfAnalyzeUtil.Round(item.area, 2) + "\u5e73\u65b9\u7c73";
                if (++count < leng) {
                    tdghDesc = tdghDesc + "/";
                }
                if ("040".equals(item.jsbm)) {
                    cantJsArea += item.area;
                }
                if (!"030".equals(item.jsbm)) continue;
                cantJsArea += item.area;
            }
        }
        if (cantJsArea > 0.0) {
            result.passTdgh = EnumAnalyzeResult.NoPass;
            tdghResult = tdghResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3002";
        } else {
            result.passTdgh = EnumAnalyzeResult.AllPass;
            tdghResult = tdghResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3002";
        }
        this.addContent(tdghResult, document);
        if (info.tdghImg != null) {
            this.AddImg("\u571f\u5730\u89c4\u5212", info.tdghImg, tdghDesc, document);
        }
        this.addTdghDescribe("\u653f\u7b56\u89e3\u8bfb", document);
    }

    protected void addTdghDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u4e8c\u5341\u4e94\u6761 \u7ecf\u6279\u51c6\u7684\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u7684\u4fee\u6539\uff0c\u987b\u7ecf\u539f\u5ba1\u6279\u673a\u5173\u6279\u51c6\uff1b\u672a\u7ecf\u6279\u51c6\uff0c\u4e0d\u5f97\u6539\u53d8\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u786e\u5b9a\u7684\u571f\u5730\u7528\u9014\u3002", role, document);
    }

    protected void addJbntMessage(ResultInfo result, ProjectInfo info, ProjectInfo other, Document document) throws DocumentException {
        this.addSencondTitle("(\u4e00)\u6c38\u4e45\u57fa\u672c\u519c\u7530\u60c5\u51b5\u5206\u6790", document);
        this.addJbntMessageContent(result, info, other, document);
    }

    protected void addJbntMessageContent(ResultInfo result, ProjectInfo info, ProjectInfo other, Document document) throws DocumentException {
        if (other.cityCode.startsWith("50")) {
            String jbntResult = "\u57fa\u4e8e\u91cd\u5e86\u57fa\u672c\u519c\u7530\u6570\u636e\u5206\u6790\uff1a";
            if (null != other.jbntArea && other.jbntArea > 0.0) {
                result.passJbnt = EnumAnalyzeResult.NoPass;
                if (other.jbntArea < other.area) {
                    result.passJbnt = EnumAnalyzeResult.PartPass;
                }
                jbntResult = jbntResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u5171" + PdfAnalyzeUtil.Round(other.jbntArea, 2) + "\u5e73\u65b9\u7c73\u3002";
            } else {
                result.passJbnt = EnumAnalyzeResult.AllPass;
                jbntResult = jbntResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3002";
            }
            this.addContent(jbntResult, document);
            if (other.jbntImg != null) {
                String desc = "\u57fa\u672c\u519c\u7530\uff1a" + PdfAnalyzeUtil.Round(other.jbntArea, 2) + "\u5e73\u65b9\u7c73";
                this.AddImg("\u6c38\u4e45\u57fa\u672c\u519c\u7530", other.jbntImg, desc, document);
            }
        } else {
            String jbntResult = "\u57fa\u4e8e\u56fd\u5bb6\u57fa\u672c\u519c\u7530\u6570\u636e\u5206\u6790\uff1a";
            if (info.jbntArea != null && info.jbntArea > 0.0) {
                result.passJbnt = EnumAnalyzeResult.NoPass;
                if (info.jbntArea < info.area) {
                    result.passJbnt = EnumAnalyzeResult.PartPass;
                }
                jbntResult = jbntResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u5171" + PdfAnalyzeUtil.Round(info.jbntArea, 2) + "\u5e73\u65b9\u7c73\u3002";
            } else {
                result.passJbnt = EnumAnalyzeResult.AllPass;
                jbntResult = jbntResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3002";
            }
            this.addContent(jbntResult, document);
            if (info.jbntImg != null) {
                String desc = "\u57fa\u672c\u519c\u7530\uff1a" + PdfAnalyzeUtil.Round(info.jbntArea, 2) + "\u5e73\u65b9\u7c73\uff0c\u975e\u57fa\u672c\u519c\u7530\uff1a" + PdfAnalyzeUtil.Round(info.area - info.jbntArea, 2) + "\u5e73\u65b9\u7c73";
                this.AddImg("\u6c38\u4e45\u57fa\u672c\u519c\u7530", info.jbntImg, desc, document);
            }
        }
    }

    protected void addJbntDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u4e09\u5341\u4e94\u6761  \u57fa\u672c\u519c\u7530\u7ecf\u4f9d\u6cd5\u5212\u5b9a\u540e\uff0c\u4efb\u4f55\u5355\u4f4d\u548c\u4e2a\u4eba\u4e0d\u5f97\u64c5\u81ea\u5360\u7528\u6216\u8005\u6539\u53d8\u5176\u7528\u9014\u3002\u56fd\u5bb6\u80fd\u6e90\u3001\u4ea4\u901a\u3001\u6c34\u5229\u3001\u519b\u4e8b\u8bbe\u65bd\u7b49\u91cd\u70b9\u5efa\u8bbe\u9879\u76ee\u9009\u5740\u786e\u5b9e\u96be\u4ee5\u907f\u8ba9\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u6d89\u53ca\u519c\u7528\u5730\u8f6c\u7528\u6216\u8005\u571f\u5730\u5f81\u6536\u7684\uff0c\u5fc5\u987b\u7ecf\u56fd\u52a1\u9662\u6279\u51c6\u3002", role, document);
    }

    protected void BzInfo(Document document) throws DocumentException {
        String content = "\u8bf4\u660e\uff1a\u7531\u4e8e\u6211\u4eec\u4e0d\u638c\u63e1\u73af\u8bc4\u4fe1\u606f\u548c\u57ce\u4e61\u89c4\u5212\u6570\u636e\u7b49\u76f8\u5173\u7ba1\u7406\u6570\u636e\uff0c\u4e91\u5206\u6790\u62a5\u544a\u4e0d\u6d89\u53ca\u73af\u8bc4\u548c\u57ce\u4e61\u89c4\u5212\u7b26\u5408\u6027\u7b49\u5206\u6790\u5185\u5bb9\u3002";
        Paragraph contentPg = new Paragraph(content, this.redFont);
        contentPg.setFirstLineIndent(this.firstLineIndent);
        contentPg.setExtraParagraphSpace(30.0f);
        contentPg.setSpacingBefore(this.pgSpace);
        contentPg.setLeading(this.lineSpace);
        document.add((Element)contentPg);
    }

    protected void SuitableAnalysis(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        ProjectInfo info = this.getCountryNode(infoList);
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e09\u3001\u9002\u5b9c\u6027\u5206\u6790", document);
        this.addZdpqdjfzMessage(info, document);
        this.addDzzhMessage(info, result, "(\u4e8c)\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u5206\u6790", document);
        this.addDzzhDescribe("\u653f\u7b56\u89e3\u8bfb", document);
        this.addStydMessage(info, result, document);
        boolean hasGradeInfo = false;
        if (info.gradeInfos != null && info.gradeInfos.size() > 0) {
            hasGradeInfo = true;
            this.addZbphMessage(info, document);
        }
        this.addCghMessage(result, other, hasGradeInfo, document);
    }

    protected void addCghMessage(ResultInfo result, ProjectInfo info, boolean hasGradeInfo, Document document) throws DocumentException {
        String xh = hasGradeInfo ? "\u4e94" : "\u56db";
        String title = "(" + xh + ")\u6751\u89c4\u5212\u60c5\u51b5\u5206\u6790";
        this.addSencondTitle(title, document);
        this.addCghContent(result, info, document);
        this.addCghDescribe("\u653f\u7b56\u89e3\u8bfb", document);
    }

    protected void addCghContent(ResultInfo result, ProjectInfo info, Document document) throws DocumentException {
        String resultMessage = "\u57fa\u4e8e\u91cd\u5e86\u6751\u89c4\u5212\u6570\u636e\u5206\u6790\uff1a";
        Boolean cantBuild = true;
        String desc = "";
        if (info.cghInfos != null) {
            resultMessage = resultMessage + "\u62df\u5efa\u9879\u76ee\u533a\u6751\u89c4\u5212\u4e2d\u89c4\u5212\u5730\u7c7b\u4e3a";
            for (int i = 0; i < info.cghInfos.size(); ++i) {
                CommonInfoCQ item = (CommonInfoCQ)info.cghInfos.get(i);
                String type = item.type;
                Double typeArea = item.area;
                desc = desc + type + ":" + PdfAnalyzeUtil.Round(typeArea, 2) + "\u5e73\u65b9\u7c73";
                if (i != info.cghInfos.size() - 1) {
                    desc = desc + "\uff0c";
                }
                if ("\u6751\u5c45\u4f4f\u7528\u5730".equals(type) || "\u6751\u5c45\u4f4f\u7528\u5730(\u5b85\u57fa\u5730)".equals(type) || "\u6751\u5c45\u4f4f\u7528\u5730\uff08\u5b85\u57fa\u5730\uff09".equals(type) || "\u519c\u6751\u5c45\u6c11\u70b9\u7528\u5730".equals(type) || "\u5b85\u57fa\u5730".equals(type) || "\u5b85\u57fa\u5730(\u6751\u5c45\u4f4f\u7528\u5730)".equals(type) || "\u5b85\u57fa\u5730(\u6751\u5c45\u4f4f\u7528\u5730\uff09".equals(type) || "\u5b85\u57fa\u5730\uff08\u6751\u5c45\u4f4f\u7528\u5730\uff09".equals(type) || "\u5b85\u57fa\u5730\uff08\u6751\u5c45\u4f4f\u7528\u5730)".equals(type) || !(typeArea > 0.0)) continue;
                cantBuild = false;
            }
        } else {
            result.passCgh = EnumAnalyzeResult.AllPass;
            return;
        }
        resultMessage = resultMessage + desc + "\u3002";
        if (!cantBuild.booleanValue()) {
            result.passCgh = EnumAnalyzeResult.NoPass;
            resultMessage = resultMessage + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u7b26\u5408\u6751\u5e84\u89c4\u5212\u3002";
        } else {
            result.passCgh = EnumAnalyzeResult.AllPass;
            resultMessage = resultMessage + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u7b26\u5408\u6751\u5e84\u89c4\u5212\u3002";
        }
        this.addContent(resultMessage, document);
        if (info.cghImg != null) {
            this.AddImg("\u6751\u89c4\u5212", info.cghImg, desc, document);
        }
    }

    protected void addCghDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u81ea\u7136\u8d44\u6e90\u90e8\u529e\u516c\u5385\u5173\u4e8e\u52a0\u5f3a\u6751\u5e84\u89c4\u5212\u4fc3\u8fdb\u4e61\u6751\u632f\u5174\u7684\u901a\u77e5\u300b \u7b2c\u5341\u4e09\u6761 \u4f18\u5316\u8c03\u6574\u7528\u5730\u5e03\u5c40\u3002\u5141\u8bb8\u5728\u4e0d\u6539\u53d8\u53bf\u7ea7\u56fd\u571f\u7a7a\u95f4\u89c4\u5212\u4e3b\u8981\u63a7\u5236\u6307\u6807\u60c5\u51b5\u4e0b\uff0c\u4f18\u5316\u8c03\u6574\u6751\u5e84\u5404\u7c7b\u7528\u5730\u5e03\u5c40\u3002\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\u548c\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u8c03\u6574\u7684\uff0c\u4e25\u683c\u6309\u56fd\u5bb6\u6709\u5173\u89c4\u5b9a\u6267\u884c\uff0c\u8c03\u6574\u7ed3\u679c\u4f9d\u6cd5\u843d\u5b9e\u5230\u6751\u5e84\u89c4\u5212\u4e2d\u3002", role, document);
    }

    protected void addZbphMessage(ProjectInfo info, Document document) throws DocumentException {
        this.addSencondTitle("(\u56db)\u5360\u8865\u5e73\u8861\u60c5\u51b5\u5206\u6790", document);
        String zbphResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a";
        String first = "";
        double area = 0.0;
        String second = "";
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (LandUseGrade g : info.gradeInfos) {
            if (map.containsKey(g.field2)) {
                double gradeArea = (Double)map.get(g.field2) + g.area;
                map.put(g.field2, gradeArea);
            } else {
                map.put(g.field2, g.area);
            }
            if (!first.equalsIgnoreCase(g.field1)) {
                if (second != null && !second.isEmpty()) {
                    zbphResult = zbphResult + "\u5360" + first + PdfAnalyzeUtil.Round(area, 2) + "\u5e73\u65b9\u7c73\uff0c";
                    second = second.substring(0, second.length() - 1);
                    zbphResult = zbphResult + second + "\uff1b";
                }
                area = 0.0;
                second = "";
                first = g.field1;
            }
            area += g.area;
            if (g.field2 == null) {
                second = second + "\u8015\u5730\u7b49\u522b\u672a\u77e5" + PdfAnalyzeUtil.Round(g.area, 2) + "\u5e73\u65b9\u7c73,";
                continue;
            }
            second = second + "\u8015\u5730\u7b49\u522b\u4e3a" + g.field2 + "\u7b49" + PdfAnalyzeUtil.Round(g.area, 2) + "\u5e73\u65b9\u7c73\uff0c";
        }
        if (second != null && !second.isEmpty()) {
            zbphResult = zbphResult + "\u5360" + first + PdfAnalyzeUtil.Round(area, 2) + "\u5e73\u65b9\u7c73\uff0c";
            second = second.substring(0, second.length() - 1);
            zbphResult = zbphResult + second + "\u3002";
        }
        this.addContent(zbphResult, document);
        if (info.gradeImg != null) {
            String desc = "";
            for (Map.Entry m : map.entrySet()) {
                Object obj = m.getKey();
                String key = "";
                if (obj == null) {
                    key = "\u672a\u77e5";
                } else {
                    key = obj.toString();
                    key = key + "\u7b49";
                }
                desc = desc + key + PdfAnalyzeUtil.Round((Double)m.getValue(), 2) + "\u5e73\u65b9\u7c73/";
            }
            desc = desc.substring(0, desc.length() - 1);
            this.AddImg("\u8015\u5730\u7b49\u522b", info.gradeImg, desc, document);
        }
        this.AddRoleDesc("\u300a\u5173\u4e8e\u8865\u8db3\u8015\u5730\u6570\u91cf\u4e0e\u63d0\u5347\u8015\u5730\u8d28\u91cf\u76f8\u7ed3\u5408\u843d\u5b9e\u5360\u8865\u5e73\u8861\u7684\u6307\u5bfc\u610f\u89c1\u300b\u63d0\u51fa\uff0c\u8865\u6539\u7ed3\u5408\u3001\u63d0\u8d28\u6539\u9020\u5fc5\u987b\u575a\u6301\u653f\u5e9c\u4e3b\u5bfc\u3001\u56e0\u5730\u5236\u5b9c\u3001\u7ef4\u62a4\u519c\u6c11\u6743\u76ca\u548c\u5ba1\u614e\u7a33\u59a5\u63a8\u8fdb\u7684\u539f\u5219\u3002", "\u653f\u7b56\u89e3\u8bfb", document);
        this.AddRoleDesc("\u300a\u6307\u5bfc\u610f\u89c1\u300b\u660e\u786e\u4e86\u8865\u6539\u7ed3\u5408\u7684\u9002\u7528\u8303\u56f4\uff0c\u5373\u5bf9\u4e8e\u5355\u72ec\u9009\u5740\u5efa\u8bbe\u9879\u76ee\u53d7\u8d44\u6e90\u6761\u4ef6\u9650\u5236\uff0c\u65e0\u6cd5\u843d\u5b9e\u5360\u4f18\u8865\u4f18\u3001\u5360\u6c34\u7530\u8865\u6c34\u7530\u7684\uff0c\u53ef\u901a\u8fc7\u8865\u6539\u7ed3\u5408\u843d\u5b9e\uff1b\u5404\u7c7b\u57ce\u5e02\u5efa\u8bbe\u6d89\u53ca\u5360\u7528\u8015\u5730\u7684\uff0c\u4ecd\u575a\u6301\u5148\u8865\u540e\u5360\u548c\u76f4\u63a5\u8865\u5145\u4f18\u8d28\u8015\u5730\uff0c\u843d\u5b9e\u5360\u4f18\u8865\u4f18\u3001\u5360\u6c34\u7530\u8865\u6c34\u7530\u3002", null, document);
    }

    protected void addStydMessage(ProjectInfo info, ResultInfo result, Document document) throws DocumentException {
        this.addSencondTitle("(\u4e09)\u751f\u6001\u7528\u5730\u5206\u6790", document);
        String stydResult = "\u57fa\u4e8e\u56fd\u5bb6\u751f\u6001\u7528\u5730\u6570\u636e\u5206\u6790\uff1a";
        if (info.sdArea != null && info.sdArea > 0.0) {
            result.passSd = EnumAnalyzeResult.NoPass;
            if (info.sdArea < info.area) {
                result.passSd = EnumAnalyzeResult.PartPass;
            }
            stydResult = stydResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5360\u7528\u6e7f\u5730\uff0c\u5171" + PdfAnalyzeUtil.Round(info.sdArea, 2) + "\u5e73\u65b9\u7c73";
        } else {
            result.passSd = EnumAnalyzeResult.AllPass;
            stydResult = stydResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u5360\u7528\u6e7f\u5730\u3002";
        }
        this.addContent(stydResult, document);
        if (info.sdImg != null) {
            this.AddImg("\u751f\u6001\u7528\u5730", info.sdImg, "\u751f\u6001\u7528\u5730\u9762\u79ef\uff1a" + PdfAnalyzeUtil.Round(info.sdArea, 2) + "\u5e73\u65b9\u7c73", document);
        }
        this.AddRoleDesc("\u300a\u6e7f\u5730\u4fdd\u62a4\u7ba1\u7406\u89c4\u5b9a\u300b\u7b2c\u5341\u516b\u6761 \u56e0\u5de5\u7a0b\u5efa\u8bbe\u7b49\u9020\u6210\u56fd\u9645\u91cd\u8981\u6e7f\u5730\u751f\u6001\u7279\u5f81\u9000\u5316\u751a\u81f3\u6d88\u5931\u7684\uff0c\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u6797\u4e1a\u4e3b\u7ba1\u90e8\u95e8\u5e94\u5f53\u4f1a\u540c\u540c\u7ea7\u4eba\u6c11\u653f\u5e9c\u6709\u5173\u90e8\u95e8\u7763\u4fc3\u3001\u6307\u5bfc\u9879\u76ee\u5efa\u8bbe\u5355\u4f4d\u9650\u671f\u6062\u590d\uff0c\u5e76\u5411\u540c\u7ea7\u4eba\u6c11\u653f\u5e9c\u548c\u56fd\u5bb6\u6797\u4e1a\u5c40\u62a5\u544a\uff1b\u5bf9\u903e\u671f\u4e0d\u4e88\u6062\u590d\u6216\u8005\u786e\u5b9e\u65e0\u6cd5\u6062\u590d\u7684\uff0c\u7531\u56fd\u5bb6\u6797\u4e1a\u5c40\u4f1a\u5546\u6240\u5728\u5730\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u548c\u56fd\u52a1\u9662\u6709\u5173\u90e8\u95e8\u540e\uff0c\u6309\u7167\u6709\u5173\u89c4\u5b9a\u5904\u7406\u3002", "\u653f\u7b56\u89e3\u8bfb", document);
        this.AddRoleDesc("\u300a\u6e7f\u5730\u4fdd\u62a4\u7ba1\u7406\u89c4\u5b9a\u300b\u7b2c\u4e09\u5341\u6761\u5efa\u8bbe\u9879\u76ee\u5e94\u5f53\u4e0d\u5360\u6216\u8005\u5c11\u5360\u6e7f\u5730\uff0c\u7ecf\u6279\u51c6\u786e\u9700\u5f81\u6536\u3001\u5360\u7528\u6e7f\u5730\u5e76\u8f6c\u4e3a\u5176\u4ed6\u7528\u9014\u7684\uff0c\u7528\u5730\u5355\u4f4d\u5e94\u5f53\u6309\u7167\u201c\u5148\u8865\u540e\u5360\u3001\u5360\u8865\u5e73\u8861\u201d\u7684\u539f\u5219\uff0c\u4f9d\u6cd5\u529e\u7406\u76f8\u5173\u624b\u7eed\u3002", null, document);
        this.AddRoleDesc("\u4e34\u65f6\u5360\u7528\u6e7f\u5730\u7684\uff0c\u671f\u9650\u4e0d\u5f97\u8d85\u8fc72\u5e74\uff1b\u4e34\u65f6\u5360\u7528\u671f\u9650\u5c4a\u6ee1\uff0c\u5360\u7528\u5355\u4f4d\u5e94\u5f53\u5bf9\u6240\u5360\u6e7f\u5730\u9650\u671f\u8fdb\u884c\u751f\u6001\u4fee\u590d\u3002", null, document);
    }

    protected void addDzzhMessage(ProjectInfo info, ResultInfo result, String title, Document document) throws DocumentException {
        this.addSencondTitle(title, document);
        this.addDzzhMessageContent(info, result, document);
    }

    protected void addDzzhMessageContent(ProjectInfo info, ResultInfo result, Document document) throws DocumentException {
        String dzzhResult = "\u57fa\u4e8e\u56fd\u5bb6\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u6570\u636e\u5206\u6790\uff1a";
        double dzfxArea = 0.0;
        String dzfxDesc = "";
        if (info.dzfxInfos != null && info.dzfxInfos.size() > 0) {
            int count = 0;
            for (DzfxInfo dzfx : info.dzfxInfos) {
                dzfxArea += dzfx.area;
                dzfxDesc = dzfxDesc + dzfx.level + PdfAnalyzeUtil.Round(dzfx.area, 2) + "\u5e73\u65b9\u7c73";
                if (++count >= info.dzfxInfos.size()) continue;
                dzfxDesc = dzfxDesc + "/";
            }
        }
        if (dzfxArea > 0.0) {
            result.passDzfx = EnumAnalyzeResult.NoPass;
            if (dzfxArea < info.area) {
                result.passDzfx = EnumAnalyzeResult.PartPass;
            }
            dzzhResult = dzzhResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3002";
        } else {
            result.passDzfx = EnumAnalyzeResult.AllPass;
            dzzhResult = info.provinceCode != null && info.provinceCode.startsWith("22") ? dzzhResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3002" : dzzhResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u60c5\u51b5\u4e0d\u8be6\uff08\u65e0\u8be5\u533a\u57df\u5730\u8d28\u707e\u5bb3\u6570\u636e\uff09\u3002";
        }
        this.addContent(dzzhResult, document);
        if (info.dzfxImg != null) {
            this.AddImg("\u5730\u8d28\u707e\u5bb3\u9690\u60a3", info.dzfxImg, dzfxDesc, document);
        }
    }

    protected void addDzzhDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u5730\u8d28\u707e\u5bb3\u9632\u6cbb\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c25\u6761\u660e\u786e\u89c4\u5b9a\uff1a\u201c\u57ce\u5e02\u5efa\u8bbe\u6709\u53ef\u80fd\u5bfc\u81f4\u5730\u8d28\u707e\u5bb3\u53d1\u751f\u7684\u5de5\u7a0b\u9879\u76ee\u5efa\u8bbe\u548c\u5730\u8d28\u707e\u5bb3\u6613\u53d1\u533a\u5185\u8fdb\u884c\u7684\u5de5\u7a0b\u5efa\u8bbe\u5728\u7533\u8bf7\u5efa\u8bbe\u7528\u5730\u4e4b\u524d\u5fc5\u987b\u8fdb\u884c\u5730\u8d28\u707e\u5bb3\u98ce\u9669\u6027\u8bc4\u4f30\uff0c\u8bc4\u4f30\u7ed3\u679c\u7531\u7701\u7ea7\u4ee5\u4e0a\u5730\u8d28\u77ff\u4ea7\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u8ba4\u5b9a\u3002\u4e0d\u7b26\u5408\u6761\u4ef6\u7684\uff0c\u571f\u5730\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u4e0d\u4e88\u529e\u7406\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u201d\u3002", role, document);
    }

    protected void addZdpqdjfzMessage(ProjectInfo info, Document document) throws DocumentException {
        this.addSencondTitle("(\u4e00)\u5f81\u5730\u533a\u7247\u5730\u4ef7\u5206\u6790", document);
        String jzdjResult = "\u57fa\u4e8e\u56fd\u5bb6\u5f81\u5730\u533a\u7247\u5730\u4ef7\u6570\u636e\u5206\u6790\uff1a";
        jzdjResult = info.landPrice != null && info.landPrice > 0.0 ? jzdjResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5f81\u5730\u533a\u7247\u5730\u4ef7\u4e3a\uff1a" + PdfAnalyzeUtil.Round(info.landPrice, 2) + "\u5143/\u5e73\u65b9\u7c73" : jzdjResult + "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5f81\u5730\u533a\u7247\u5730\u4ef7\u672a\u77e5 ";
        this.addContent(jzdjResult, document);
        if (info.landPriceImg != null) {
            this.AddImg("\u5f81\u5730\u533a\u7247\u5730\u4ef7", info.landPriceImg, PdfAnalyzeUtil.Round(info.landPrice, 2) + "\u5143/\u5e73\u65b9\u7c73", document);
        }
        this.AddRoleDesc("\u300a\u81ea\u7136\u4fdd\u62a4\u533a\u571f\u5730\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c\u56db\u5341\u516b\u6761\u7b2c\u4e09\u6b3e  \u5f81\u6536\u519c\u7528\u5730\u7684\u571f\u5730\u8865\u507f\u8d39\u3001\u5b89\u7f6e\u8865\u52a9\u8d39\u6807\u51c6\u7531\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u901a\u8fc7\u5236\u5b9a\u516c\u5e03\u533a\u7247\u7efc\u5408\u5730\u4ef7\u786e\u5b9a\u3002\u5236\u5b9a\u533a\u7247\u7efc\u5408\u5730\u4ef7\u5e94\u5f53\u7efc\u5408\u8003\u8651\u571f\u5730\u539f\u7528\u9014\u3001\u571f\u5730\u8d44\u6e90\u6761\u4ef6\u3001\u571f\u5730\u4ea7\u503c\u3001\u571f\u5730\u533a\u4f4d\u3001\u571f\u5730\u4f9b\u6c42\u5173\u7cfb\u3001\u4eba\u53e3\u4ee5\u53ca\u7ecf\u6d4e\u793e\u4f1a\u53d1\u5c55\u6c34\u5e73\u7b49\u56e0\u7d20\uff0c\u5e76\u81f3\u5c11\u6bcf\u4e09\u5e74\u8c03\u6574\u6216\u8005\u91cd\u65b0\u516c\u5e03\u4e00\u6b21\u3002", "\u653f\u7b56\u89e3\u8bfb", document);
    }

    protected void SummarizeAnalysis(ProjectInfo info, ResultInfo result, Document document) throws DocumentException {
        boolean allPass;
        this.addFirstTitle("\u56db\u3001\u603b\u4f53\u5206\u6790", document);
        String content = "\u6839\u636e\u5df2\u6709\u6570\u636e\u5206\u6790\u7ed3\u679c\uff0c\u62df\u5efa\u8bbe\u9879\u76ee\u533a";
        boolean legal = result.passJbnt == EnumAnalyzeResult.AllPass && result.passTdgh == EnumAnalyzeResult.AllPass && result.passSpba == EnumAnalyzeResult.AllPass && result.passZrbhq == EnumAnalyzeResult.AllPass && result.passSthx == EnumAnalyzeResult.AllPass && result.passJsydgzq == EnumAnalyzeResult.AllPass;
        boolean suitable = result.passDzfx == EnumAnalyzeResult.AllPass && result.passSd == EnumAnalyzeResult.AllPass;
        boolean unlegal = result.passJbnt == EnumAnalyzeResult.NoPass || result.passTdgh == EnumAnalyzeResult.NoPass || result.passSpba == EnumAnalyzeResult.NoPass || result.passZrbhq == EnumAnalyzeResult.NoPass || result.passSthx == EnumAnalyzeResult.NoPass || result.passJsydgzq == EnumAnalyzeResult.NoPass;
        boolean unsuitable = result.passDzfx == EnumAnalyzeResult.NoPass || result.passSd == EnumAnalyzeResult.NoPass;
        boolean bl = allPass = legal && suitable;
        if (allPass) {
            content = content + "\u5408\u6cd5\u3001\u9002\u5b9c\u3002";
            content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
            content = content + "\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
            content = content + "\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
            content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
            content = content + "\u4e0d\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf";
            content = content + "\u6d89\u53ca\u5efa\u8bbe\u7528\u5730\u5408\u6cd5";
            content = content + "\u4e0d\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
            content = content + "\u4e0d\u5360\u7528\u6e7f\u5730\u3002";
        } else if (unlegal) {
            content = content + "\u4e0d\u5408\u6cd5\u3001\u4e0d\u9002\u5b9c\u3002";
            switch (result.passJbnt) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                }
            }
            switch (result.passTdgh) {
                case NoPass: {
                    content = content + "\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                }
            }
            switch (result.passSpba) {
                case NoPass: {
                    content = content + "\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                }
            }
            switch (result.passZrbhq) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                }
            }
            switch (result.passSthx) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                }
            }
            switch (result.passJsydgzq) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u5efa\u8bbe\u7528\u5730\u4e0d\u5408\u6cd5\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5efa\u8bbe\u7528\u5730\u4e0d\u5408\u6cd5\u3001";
                }
            }
            switch (result.passDzfx) {
                case NoPass: {
                    content = content + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                }
            }
            switch (result.passSd) {
                case NoPass: {
                    content = content + "\u5360\u7528\u6e7f\u5730\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u6e7f\u5730\u3001";
                }
            }
            content = content.substring(0, content.length() - 1) + "\u3002";
        } else if (unsuitable) {
            content = content + "\u4e0d\u9002\u5b9c\u3002";
            switch (result.passDzfx) {
                case NoPass: {
                    content = content + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                }
            }
            switch (result.passSd) {
                case NoPass: {
                    content = content + "\u5360\u7528\u6e7f\u5730\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u6e7f\u5730\u3001";
                }
            }
            content = content.substring(0, content.length() - 1) + "\u3002";
        } else {
            boolean partlegal = false;
            boolean partsuitable = false;
            String tmp = "";
            if (result.passJbnt == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                partlegal = true;
            }
            if (result.passTdgh == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                partlegal = true;
            }
            if (result.passSpba == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                partlegal = true;
            }
            if (result.passZrbhq == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                partlegal = true;
            }
            if (result.passSthx == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                partlegal = true;
            }
            if (result.passDzfx == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                partsuitable = true;
            }
            if (result.passSd == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u5360\u7528\u6e7f\u5730\u3001";
                partsuitable = true;
            }
            if (!StringUtils.isEmpty((CharSequence)tmp)) {
                tmp = tmp.substring(0, tmp.length() - 1) + "\u3002";
            }
            if (partlegal && partsuitable) {
                content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u3001\u4e0d\u9002\u5b9c\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
            } else if (partlegal) {
                content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
            } else if (partsuitable) {
                content = content + "\u5b58\u5728\u4e0d\u9002\u5b9c\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
            }
            content = content + tmp;
        }
        this.addContent(content, document);
    }

    protected void AddBaseImg(List<ProjectInfo> infoList, Document document) throws DocumentException {
        ProjectInfo info = this.getCountryNode(infoList);
        ProjectInfo otherInfo = this.getOtherNode(infoList);
        PdfPCell c1 = this.createImgTitle("\u9879\u76ee\u533a\u4f4d\u7f6e");
        PdfPCell c2 = this.createImgTitle("\u571f\u5730\u5229\u7528\u73b0\u72b6\u56fe");
        PdfPCell cimg1 = null;
        PdfPCell meta1 = null;
        if (null != otherInfo.ownershipImg) {
            cimg1 = this.creaeteImgCell(otherInfo.ownershipImg);
            meta1 = this.createImgRoot(otherInfo.ownershipImgMeta);
        } else {
            cimg1 = this.creaeteImgCell(info.ownershipImg);
            meta1 = this.createImgRoot(info.ownershipImgMeta);
        }
        PdfPCell cimg2 = this.creaeteImgCell(info.landtypeImg);
        PdfPCell meta2 = this.createImgRoot(info.landtypeImgMeta);
        int col = 2;
        if (info.narrow) {
            col = 1;
            PdfPTable t1 = new PdfPTable(col);
            t1.setSpacingBefore(this.pgSpace);
            t1.setSpacingAfter(this.pgSpace);
            t1.setWidthPercentage(80.0f);
            PdfPTable t2 = new PdfPTable(col);
            t2.setSpacingBefore(this.pgSpace);
            t2.setSpacingAfter(this.pgSpace);
            t2.setWidthPercentage(80.0f);
            if (info.ownershipImg != null) {
                t1.addCell(c1);
                t1.addCell(cimg1);
                t1.addCell(meta1);
            }
            if (info.landtypeImg != null) {
                t2.addCell(c2);
                t2.addCell(cimg2);
                t2.addCell(meta2);
            }
            if (info.photo1 != null || info.photo2 != null) {
                this.addPhoto(info, t2);
            }
            document.add((Element)t1);
            document.newPage();
            document.add((Element)t2);
        } else {
            PdfPTable t = new PdfPTable(col);
            t.setSpacingBefore(this.pgSpace);
            t.setSpacingAfter(this.pgSpace);
            t.setWidthPercentage(100.0f);
            t.addCell(c1);
            t.addCell(c2);
            t.addCell(cimg1);
            t.addCell(cimg2);
            t.addCell(meta1);
            t.addCell(meta2);
            if (info.photo1 != null || info.photo2 != null) {
                this.addPhoto(info, t);
            }
            document.add((Element)t);
        }
    }

    protected void AddImg(String title, Image img, String desc, Document document) throws DocumentException {
        PdfPTable t = new PdfPTable(1);
        t.setKeepTogether(true);
        t.setSpacingBefore(this.pgSpace);
        t.setSpacingAfter(this.pgSpace);
        t.setWidthPercentage(80.0f);
        if (!StringUtils.isEmpty((CharSequence)title)) {
            PdfPCell titleCell = this.createImgTitle(title);
            t.addCell(titleCell);
        }
        PdfPCell cimg1 = this.creaeteImgCell(img);
        t.addCell(cimg1);
        PdfPCell descCell = this.createImgRoot(desc);
        t.addCell(descCell);
        document.add((Element)t);
    }

    protected void AddRoleDesc(String desc, String role, Document document) throws DocumentException {
        float spaceBefore = 0.0f;
        if (role != null && !role.isEmpty()) {
            String roleInfo = role + "\uff1a";
            Paragraph rolePg = new Paragraph(roleInfo, this.roleFont);
            rolePg.setFirstLineIndent(this.firstLineIndent);
            rolePg.setExtraParagraphSpace(30.0f);
            rolePg.setSpacingBefore(7.0f);
            rolePg.setLeading(this.lineSpace);
            document.add((Element)rolePg);
            spaceBefore = 5.0f;
        }
        Paragraph descPg = new Paragraph(desc, this.roleFont);
        descPg.setFirstLineIndent(this.firstLineIndent);
        descPg.setExtraParagraphSpace(30.0f);
        descPg.setSpacingBefore(spaceBefore);
        descPg.setLeading(this.lineSpace);
        document.add((Element)descPg);
    }

    protected void AddSign(ProjectInfo info, Document document) throws DocumentException {
        String sign = "\u62a5\u544a\u4eba\uff1a " + info.userName;
        this.addSignContent(info.narrow, sign, document);
        String timeStr = "\u65f6  \u95f4\uff1a " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        this.addSignContent(info.narrow, timeStr, document);
    }

    protected String getRegionByNode(String nodeid) {
        Optional node = this.nodeRepository.findById((Object)nodeid);
        return node.isPresent() ? ((CloudQueryNode)node.get()).getRegioncode() : "";
    }

    protected ProjectInfo getCountryNode(List<ProjectInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get((int)i).nodeRegion.equals("1")) continue;
            return list.get(i);
        }
        return null;
    }

    protected ProjectInfo getOtherNode(List<ProjectInfo> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (list.get((int)i).nodeRegion.equals("1")) continue;
            return list.get(i);
        }
        return null;
    }

    protected void addTitle(String txt, Font font, Document document) throws DocumentException {
        Paragraph title = new Paragraph(txt, font);
        title.setAlignment(1);
        document.add((Element)title);
    }

    protected void addFirstTitle(String title, Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(title, this.chapterFont);
        this.addContentTxtFormat(paragraph, document);
    }

    protected void addSencondTitle(String title, Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(title, this.sectionFont);
        this.addContentTxtFormat(paragraph, document);
    }

    protected void addContent(String content, Document document) throws DocumentException {
        this.addContent(content, 30, document);
    }

    protected void addContent(String content, Integer paragraphSpace, Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(content, this.normalFont);
        paragraph.setFirstLineIndent(this.firstLineIndent);
        this.addContentTxtFormat(paragraph, paragraphSpace, document);
    }

    protected void addContentItalicRed(String content, Document document) throws DocumentException {
        this.addContentItalicRed(content, 30, document);
    }

    protected void addContentItalicRed(String content, Integer paragraphSpace, Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(content, this.redItalicFont);
        paragraph.setFirstLineIndent(this.firstLineIndent);
        this.addContentTxtFormat(paragraph, paragraphSpace, document);
    }

    protected void addContentTxtFormat(Paragraph paragraph, Document document) throws DocumentException {
        this.addContentTxtFormat(paragraph, 30, document);
    }

    protected void addContentTxtFormat(Paragraph paragraph, Integer paragraphSpace, Document document) throws DocumentException {
        paragraph.setExtraParagraphSpace((float)paragraphSpace.intValue());
        paragraph.setSpacingBefore(this.pgSpace);
        paragraph.setLeading(this.lineSpace);
        document.add((Element)paragraph);
    }

    protected PdfPCell createImgTitle(String title) {
        if (StringUtils.isEmpty((CharSequence)title)) {
            return null;
        }
        PdfPCell cell = new PdfPCell(new Phrase(title, this.normalFont));
        this.addImgTxtFormat(cell);
        return cell;
    }

    protected PdfPCell createContent(String title, Font font) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        this.addImgTxtFormat(cell);
        return cell;
    }

    protected PdfPCell creaeteImgCell(Image img) {
        PdfPCell cimg = null;
        if (null == img) {
            cimg = new PdfPCell();
        } else {
            float width = 250.0f;
            float heigth = img.getHeight() / (img.getWidth() / width);
            img.scaleToFit(width, heigth);
            cimg = new PdfPCell(img);
        }
        cimg.setVerticalAlignment(1);
        cimg.setHorizontalAlignment(1);
        cimg.setPaddingTop(5.0f);
        cimg.setPaddingBottom(5.0f);
        cimg.setPaddingLeft(5.0f);
        cimg.setPaddingRight(5.0f);
        return cimg;
    }

    protected PdfPCell createImgRoot(String text) {
        PdfPCell meta = new PdfPCell(new Phrase(text, this.roleFont));
        this.addImgTxtFormat(meta);
        return meta;
    }

    void addImgTxtFormat(PdfPCell cell) {
        cell.setVerticalAlignment(1);
        cell.setHorizontalAlignment(1);
        cell.setPaddingTop(5.0f);
        cell.setPaddingBottom(5.0f);
    }

    protected void addPhoto(ProjectInfo info, PdfPTable t) {
        PdfPCell photo1 = this.createImgTitle("\u5b9e\u5730\u7167\u72471");
        PdfPCell photo2 = this.createImgTitle("\u5b9e\u5730\u7167\u72472");
        PdfPCell cp1 = null;
        if (info.photo1 != null) {
            Image img1 = Image.getInstance((Image)info.photo1);
            cp1 = this.creaeteImgCell(img1);
        } else {
            cp1 = this.creaeteImgCell(null);
        }
        PdfPCell cp2 = null;
        if (info.photo2 != null) {
            Image img2 = Image.getInstance((Image)info.photo2);
            cp2 = this.creaeteImgCell(img2);
        } else {
            cp2 = this.creaeteImgCell(null);
        }
        PdfPCell pmeta1 = this.createImgRoot(info.photoMeta1);
        PdfPCell pmeta2 = this.createImgRoot(info.photoMeta2);
        t.addCell(photo1);
        t.addCell(photo2);
        t.addCell(cp1);
        t.addCell(cp2);
        t.addCell(pmeta1);
        t.addCell(pmeta2);
    }

    protected void addSignContent(boolean narrow, String sign, Document document) throws DocumentException {
        Paragraph signPg = new Paragraph(sign, this.normalFont);
        signPg.setAlignment(0);
        if (narrow) {
            signPg.setFirstLineIndent(200.0f);
        } else {
            signPg.setFirstLineIndent(300.0f);
        }
        signPg.setExtraParagraphSpace(30.0f);
        signPg.setSpacingBefore(24.0f);
        signPg.setLeading(22.0f);
        document.add((Element)signPg);
    }
}

