/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.EnumAnalyzeResult;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.ResultInfo;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQBysxzService;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service(value="CloudAnalyzeCQXcjshxService")
@Primary
public class CloudAnalyzeCQXcjshxService
extends CloudAnalyzeCQBysxzService {
    private GiLoger logger = GwLoger.getLoger(CloudAnalyzeCQXcjshxService.class);
    Font italic;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudAnalyzeCQXcjshxService() throws IOException, DocumentException {
        ClassPathResource simkai = new ClassPathResource("/static/simkai.ttf");
        if (simkai.exists()) {
            InputStream simkaiinputStream = simkai.getInputStream();
            File simkaiFile = File.createTempFile("template_simkai_copy", ".ttf");
            try {
                FileUtils.copyInputStreamToFile((InputStream)simkaiinputStream, (File)simkaiFile);
            }
            finally {
                IOUtils.closeQuietly((InputStream)simkaiinputStream);
            }
            this.italic = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)true), 12.0f, 2);
            this.italic.setColor(255, 0, 0);
        }
    }

    @Override
    public boolean ExportReport(List<ProjectInfo> infoList) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            document = this.createPdf(info);
            document.addTitle("\u201c\u4e61\u6751\u5efa\u8bbe\u6709\u7ea2\u7ebf\uff0c\u8c03\u67e5\u4e91\u4e2d\u770b\u4e00\u770b\u201d\u5206\u6790\u62a5\u544a");
            this.addTitle(info.projectName + "\u201c\u4e61\u6751\u5efa\u8bbe\u6709\u7ea2\u7ebf\uff0c\u8c03\u67e5\u4e91\u4e2d\u770b\u4e00\u770b\u201d\u5206\u6790\u62a5\u544a", this.titleFont, document);
            this.addContent(document);
            ResultInfo result = new ResultInfo();
            this.BaseInfo(infoList, result, document);
            this.secondPart(infoList, result, document);
            this.thirdPart(infoList, result, document);
            this.fourthPart(infoList, result, document);
            this.SummarizeAnalysis(info, result, document);
            this.AddSign(info, document);
            this.addDescribeXcjshx(document);
            document.close();
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    protected void addContent(Document document) throws DocumentException {
        String content1 = "\u6309\u7167\u60a8\u52fe\u7ed8\u7684\u9879\u76ee\u8303\u56f4\uff0c\u4f9d\u636e\u56fd\u571f\u8c03\u67e5\u4e91\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684\u201c\u4e61\u6751\u5efa\u8bbe\u6709\u7ea2\u7ebf\uff0c\u8c03\u67e5\u4e91\u4e2d\u770b\u4e00\u770b\u201d\u5206\u6790\u62a5\u544a\u5982\u4e0b\u3002";
        String content2 = "\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\uff0c\u4e0d\u5177\u6709\u6cd5\u5f8b\u6548\u5e94\u3002";
        Chunk chunk1 = new Chunk(content1, this.normalFont);
        Chunk chunk2 = new Chunk(content2, this.italic);
        Paragraph paragraph = new Paragraph();
        paragraph.add((Element)chunk1);
        paragraph.add((Element)chunk2);
        paragraph.setFirstLineIndent(this.firstLineIndent);
        this.addContentTxtFormat(paragraph, document);
    }

    @Override
    protected void BaseInfo(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException, IOException {
        ProjectInfo info = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e00\u3001\u57fa\u672c\u60c5\u51b5", document);
        String content = "%s\u9879\u76ee\u4f4d\u4e8e%s%s%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u9879\u76ee\u5730\u5757\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
        if (StringUtils.isEmpty((CharSequence)info.location)) {
            content = String.format(content, info.projectName, info.provinceName, info.logicCity ? "" : info.cityName, info.countyName, info.villageName, info.lontitude, info.latitude, String.valueOf(PdfAnalyzeUtil.Round(info.area, 2)));
        } else {
            content = "%s\u9879\u76ee\u4f4d\u4e8e%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u9879\u76ee\u5730\u5757\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
            content = String.format(content, info.projectName, info.provinceName, info.location, info.lontitude, info.latitude, String.valueOf(PdfAnalyzeUtil.Round(info.area, 2)));
        }
        this.addContent(content, document);
    }

    @Override
    protected void secondPart(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        ProjectInfo info = null;
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e8c\u3001\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u5206\u6790", document);
        this.addSthxMessage(result, info, other, null, document);
    }

    @Override
    protected void fourthPart(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u56db\u3001\u57ce\u9547\u5f00\u53d1\u8fb9\u754c", document);
        this.addCzkfbjMessage(result, other, null, document);
    }

    @Override
    protected void SummarizeAnalysis(ProjectInfo info, ResultInfo result, Document document) throws DocumentException {
        this.addFirstTitle("\u4e94\u3001\u603b\u4f53\u5206\u6790", document);
        String content = "\u6839\u636e\u5df2\u6709\u6570\u636e\u5206\u6790\u7ed3\u679c\uff0c\u62df\u5efa\u8bbe\u9879\u76ee\u533a";
        boolean legal = result.passSthx == EnumAnalyzeResult.AllPass && result.passJbnt == EnumAnalyzeResult.AllPass;
        boolean unlegal = result.passSthx == EnumAnalyzeResult.NoPass || result.passJbnt == EnumAnalyzeResult.NoPass;
        boolean allPass = legal;
        if (allPass) {
            content = content + "\u5408\u6cd5\u3002";
            content = content + "\u4e0d\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
            content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3002";
        } else if (unlegal) {
            content = content + "\u4e0d\u5408\u6cd5\u3002";
            switch (result.passSthx) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                }
            }
            switch (result.passJbnt) {
                case NoPass: {
                    content = content + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                    break;
                }
                case PartPass: {
                    content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                }
            }
            content = content.substring(0, content.length() - 1) + "\u3002";
        } else {
            boolean partlegal = false;
            String tmp = "";
            if (result.passSthx == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6d89\u53ca\u751f\u6001\u7ea2\u7ebf\u3001";
                partlegal = true;
            }
            if (result.passJbnt == EnumAnalyzeResult.PartPass) {
                tmp = tmp + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                partlegal = true;
            }
            if (!StringUtils.isEmpty((CharSequence)tmp)) {
                tmp = tmp.substring(0, tmp.length() - 1) + "\u3002";
            }
            if (partlegal) {
                content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
            }
            content = content + tmp;
        }
        this.addContent(content, document);
    }

    @Override
    protected void AddSign(ProjectInfo info, Document document) throws DocumentException {
        String sign = "\u67e5\u8be2\u4eba\u5458\uff1a " + info.userName;
        this.addSignContent(info.narrow, sign, document);
        String timeStr = "\u65f6  \u95f4\uff1a " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        this.addSignContent(info.narrow, timeStr, document);
    }

    protected void addDescribeXcjshx(Document document) throws DocumentException, IOException {
        document.newPage();
        this.addFirstTitle("\u9644\uff1a\u6d89\u53ca\u653f\u7b56\u89e3\u8bfb", document);
        this.addSthxDescribe("1\u3001\u5173\u4e8e\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf", document);
        this.addDescribeImage("1.png", document);
        this.addJbntDescribe("2\u3001\u5173\u4e8e\u6c38\u4e45\u57fa\u672c\u519c\u7530", document);
        this.addDescribeImage("2.png", document);
        this.addCzkfbjDescribe("3\u3001\u5173\u4e8e\u57ce\u9547\u5f00\u53d1\u8fb9\u754c", document);
        this.addDescribeImage("3.png", document);
    }

    @Override
    protected void addSthxDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u5173\u4e8e\u5212\u5b9a\u5e76\u4e25\u5b88\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u7684\u82e5\u5e72\u610f\u89c1\u300b\u7b2c\u516b\u6761 \u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u5212\u5b9a\u540e\uff0c\u76f8\u5173\u89c4\u5212\u8981\u7b26\u5408\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u7a7a\u95f4\u7ba1\u63a7\u8981\u6c42\uff0c\u4e0d\u7b26\u5408\u7684\u8981\u53ca\u65f6\u8fdb\u884c\u8c03\u6574\u3002", role, document);
        this.AddRoleDesc("\u300a\u5173\u4e8e\u5212\u5b9a\u5e76\u4e25\u5b88\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u7684\u82e5\u5e72\u610f\u89c1\u300b\u7b2c\u4e5d\u6761 \u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u539f\u5219\u4e0a\u6309\u7981\u6b62\u5f00\u53d1\u533a\u57df\u7684\u8981\u6c42\u8fdb\u884c\u7ba1\u7406\u3002\u4e25\u7981\u4e0d\u7b26\u5408\u4e3b\u4f53\u529f\u80fd\u5b9a\u4f4d\u7684\u5404\u7c7b\u5f00\u53d1\u6d3b\u52a8\uff0c\u4e25\u7981\u4efb\u610f\u6539\u53d8\u7528\u9014\u3002", null, document);
    }

    @Override
    protected void addCzkfbjDescribe(String role, Document document) throws DocumentException {
        this.AddRoleDesc("\u300a\u5173\u4e8e\u5728\u56fd\u571f\u7a7a\u95f4\u89c4\u5212\u4e2d\u7edf\u7b79\u5212\u5b9a\u843d\u5b9e\u4e09\u6761\u63a7\u5236\u7ebf\u7684\u6307\u5bfc\u610f\u89c1\u300b\u7b2c\u516d\u6761 \u6309\u7167\u96c6\u7ea6\u9002\u5ea6\u3001\u7eff\u8272\u53d1\u5c55\u8981\u6c42\u5212\u5b9a\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u3002\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u5212\u5b9a\u4ee5\u57ce\u9547\u5f00\u53d1\u5efa\u8bbe\u73b0\u72b6\u4e3a\u57fa\u7840\uff0c\u7efc\u5408\u8003\u8651\u8d44\u6e90\u627f\u8f7d\u80fd\u529b\u3001\u4eba\u53e3\u5206\u5e03\u3001\u7ecf\u6d4e\u5e03\u5c40\u3001\u57ce\u4e61\u7edf\u7b79\u3001\u57ce\u9547\u53d1\u5c55\u9636\u6bb5\u548c\u53d1\u5c55\u6f5c\u529b\uff0c\u6846\u5b9a\u603b\u91cf\uff0c\u9650\u5b9a\u5bb9\u91cf\uff0c\u9632\u6b62\u57ce\u9547\u65e0\u5e8f\u8513\u5ef6\u3002\u79d1\u5b66\u9884\u7559\u4e00\u5b9a\u6bd4\u4f8b\u7684\u7559\u767d\u533a\uff0c\u4e3a\u672a\u6765\u53d1\u5c55\u7559\u6709\u5f00\u53d1\u7a7a\u95f4\u3002\u57ce\u9547\u5efa\u8bbe\u548c\u53d1\u5c55\u4e0d\u5f97\u8fdd\u6cd5\u8fdd\u89c4\u4fb5\u5360\u6cb3\u9053\u3001\u6e56\u9762\u3001\u6ee9\u5730\u3002", role, document);
    }

    protected void addDescribeImage(String file, Document document) throws IOException, DocumentException {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String rootPath = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        Image image = Image.getInstance((String)(rootPath + "data/xcjshx/" + file));
        PdfPCell cell = this.creaeteImgCell(image);
        PdfPTable t = new PdfPTable(1);
        t.setKeepTogether(true);
        t.setSpacingBefore(this.pgSpace);
        t.setSpacingAfter(this.pgSpace);
        t.setWidthPercentage(80.0f);
        t.addCell(cell);
        document.add((Element)t);
    }
}

