/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.CommonInfoCQ;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQBysxzService;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service(value="CloudAnalyzeCQXcjshxService2")
@Primary
public class CloudAnalyzeCQXcjshxService2
extends CloudAnalyzeCQBysxzService {
    private GiLoger logger;
    Font italic;
    Font tableTitle;
    Font tableContent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudAnalyzeCQXcjshxService2() throws IOException, DocumentException {
        block2: {
            this.logger = GwLoger.getLoger(CloudAnalyzeCQXcjshxService2.class);
            ClassPathResource simkai = new ClassPathResource("/static/simkai.ttf");
            if (!simkai.exists()) break block2;
            InputStream simkaiinputStream = simkai.getInputStream();
            File simkaiFile = File.createTempFile("template_simkai_copy", ".ttf");
            ClassPathResource STSONG = new ClassPathResource("/static/STSONG.TTF");
            InputStream STSONGinputStream = STSONG.getInputStream();
            File STSONGFile = File.createTempFile("template_STSONG_copy", ".TTF");
            try {
                FileUtils.copyInputStreamToFile((InputStream)STSONGinputStream, (File)STSONGFile);
                FileUtils.copyInputStreamToFile((InputStream)simkaiinputStream, (File)simkaiFile);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable[])new Closeable[]{STSONGinputStream, simkaiinputStream});
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable[])new Closeable[]{STSONGinputStream, simkaiinputStream});
            this.italic = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)true), 10.0f, 2);
            this.italic.setColor(255, 0, 0);
            this.normalFont = new Font(BaseFont.createFont((String)STSONGFile.getAbsolutePath(), (String)"Identity-H", (boolean)true), 10.0f);
            this.tableTitle = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)true), 8.0f);
            this.tableTitle.setStyle(1);
            this.tableContent = new Font(BaseFont.createFont((String)STSONGFile.getAbsolutePath(), (String)"Identity-H", (boolean)true), 8.0f);
        }
    }

    @Override
    public boolean ExportReport(List<ProjectInfo> infoList) throws DocumentException, IOException {
        Document document = null;
        try {
            PdfPTable table4;
            PdfPTable table3;
            PdfPCell img;
            PdfPCell cimg1;
            ArrayList<String> data;
            PdfPCell img2;
            ProjectInfo info = infoList.get(0);
            document = this.createPdf(info);
            document.addTitle("\u201c\u4e61\u6751\u5efa\u8bbe\u6709\u7ea2\u7ebf\uff0c\u8c03\u67e5\u4e91\u4e2d\u770b\u4e00\u770b\u201d\u67e5\u8be2\u7ed3\u679c");
            this.addTitle("\u201c\u4e61\u6751\u5efa\u8bbe\u6709\u7ea2\u7ebf\uff0c\u8c03\u67e5\u4e91\u4e2d\u770b\u4e00\u770b\u201d\u67e5\u8be2\u7ed3\u679c", this.titleFont, document);
            this.addContent(info, document);
            PdfPTable table = this.createTable(10, 20);
            if (null != info.tdlyxzImg) {
                img2 = this.creaeteImgCell(info.tdlyxzImg);
                table.addCell(img2);
            } else {
                img2 = this.getDefaultImage("4.png");
                table.addCell(img2);
            }
            if (null != info.sthxImg) {
                img2 = this.creaeteImgCell(info.sthxImg);
                table.addCell(img2);
            } else {
                img2 = this.getDefaultImage("5.png");
                table.addCell(img2);
            }
            if (null != info.tdlyxzImg) {
                data = new ArrayList<String>();
                BigDecimal gd = new BigDecimal(0);
                BigDecimal ld = new BigDecimal(0);
                BigDecimal other = new BigDecimal(0);
                for (int i = 0; i < info.tdlyxzInfos.size(); ++i) {
                    CommonInfoCQ obj = (CommonInfoCQ)info.tdlyxzInfos.get(i);
                    if (obj.type.startsWith("01")) {
                        gd = gd.add(new BigDecimal(obj.area));
                        continue;
                    }
                    if (obj.type.startsWith("03")) {
                        ld = ld.add(new BigDecimal(obj.area));
                        continue;
                    }
                    other = other.add(new BigDecimal(obj.area));
                }
                data.add("\u8015\u5730");
                data.add(gd.setScale(2, 4).toString());
                data.add("\u6797\u5730");
                data.add(ld.setScale(2, 4).toString());
                data.add("\u5176\u4ed6");
                data.add(other.setScale(2, 4).toString());
                PdfPTable txtTable = this.addTable(data);
                PdfPCell cell = new PdfPCell();
                cell.setRowspan(2);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                PdfPCell cellBox = new PdfPCell(txtTable, cell);
                cellBox.setBorder(0);
                table.addCell(cellBox);
            } else {
                data = new ArrayList();
                data.add("\u571f\u5730\u5229\u7528\u73b0\u72b6");
                data.add("0");
                PdfPTable txtTable = this.addTable(data);
                PdfPCell cell = new PdfPCell();
                cell.setRowspan(2);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                PdfPCell cellBox = new PdfPCell(txtTable, cell);
                cellBox.setBorder(0);
                table.addCell(cellBox);
            }
            PdfPTable table6 = null;
            table6 = null != info.sthxImg ? this.addTable("\u751f\u6001\u7ea2\u7ebf", "\u662f", String.valueOf(PdfAnalyzeUtil.Round(info.sthxArea, 2)), "\u662f\u5426\u538b\u5360") : this.addTable("\u751f\u6001\u7ea2\u7ebf", "\u5426", "0", "\u662f\u5426\u538b\u5360");
            PdfPCell cell = new PdfPCell();
            cell.setRowspan(1);
            cell.setHorizontalAlignment(1);
            cell.setVerticalAlignment(5);
            PdfPCell cellBox = new PdfPCell(table6, cell);
            cellBox.setBorder(0);
            table.addCell(cellBox);
            PdfPCell cell2 = new PdfPCell();
            cell2.setBorder(0);
            table.addCell(cell2);
            PdfPTable table2 = this.createTable(0, 0);
            if (null != info.jbntImg) {
                cimg1 = this.creaeteImgCell(info.jbntImg);
                table2.addCell(cimg1);
            } else {
                img = this.getDefaultImage("6.png");
                table2.addCell(img);
            }
            if (null != info.czkfImg) {
                cimg1 = this.creaeteImgCell(info.czkfImg);
                table2.addCell(cimg1);
            } else {
                img = this.getDefaultImage("7.png");
                table2.addCell(img);
            }
            if (null != info.jbntImg) {
                table3 = this.addTable("\u6c38\u4e45\u57fa\u672c\u519c\u7530", "\u662f", String.valueOf(PdfAnalyzeUtil.Round(info.jbntArea, 2)), "\u662f\u5426\u538b\u5360");
                table2.addCell(table3);
            } else {
                table3 = this.addTable("\u6c38\u4e45\u57fa\u672c\u519c\u7530", "\u5426", "0", "\u662f\u5426\u538b\u5360");
                table2.addCell(table3);
            }
            if (null != info.czkfImg) {
                table4 = this.addTable("\u57ce\u9547\u5f00\u53d1\u8fb9\u754c", "\u662f", String.valueOf(PdfAnalyzeUtil.Round(info.czkfArea, 2)), "\u662f\u5426\u903e\u8d8a");
                table2.addCell(table4);
            } else {
                table4 = this.addTable("\u57ce\u9547\u5f00\u53d1\u8fb9\u754c", "\u5426", "0", "\u662f\u5426\u903e\u8d8a");
                table2.addCell(table4);
            }
            document.add((Element)table);
            document.add((Element)table2);
            document.close();
            return true;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    private PdfPTable addTable(List<String> data) throws DocumentException {
        int[] tableWidth = new int[]{15, 25};
        PdfPTable table = this.getPdfPTable(2, tableWidth, 0, 0);
        table.addCell(this.createTableTitleCell("\u5730\u7c7b"));
        table.addCell(this.createTableTitleCell("\u9762\u79ef"));
        for (int i = 0; i < data.size(); ++i) {
            table.addCell(this.createTableContent(data.get(i)));
        }
        return table;
    }

    private PdfPTable addTable(String value1, String value2, String value3, String secondName) throws DocumentException {
        int[] tableWidth = new int[]{15, 15, 15};
        PdfPTable table = this.getPdfPTable(3, tableWidth, 0, 0);
        table.addCell(this.createTableTitleCell("\u56fe\u5c42\u540d\u79f0"));
        table.addCell(this.createTableTitleCell(secondName));
        table.addCell(this.createTableTitleCell("\u8986\u76d6\u9762\u79ef"));
        table.addCell(this.createTableContent(value1));
        table.addCell(this.createTableContent(value2));
        table.addCell(this.createTableContent(value3));
        return table;
    }

    private PdfPCell createTableTitleCell(String content) {
        PdfPCell cell = new PdfPCell(new Phrase(content, this.tableTitle));
        cell.setHorizontalAlignment(1);
        cell.setVerticalAlignment(5);
        cell.setPaddingTop(5.0f);
        cell.setPaddingBottom(5.0f);
        return cell;
    }

    private PdfPTable createTable(Integer before, Integer after) throws DocumentException {
        int[] tableWidth = new int[]{50, 50};
        PdfPTable table = this.getPdfPTable(2, tableWidth, before, after);
        return table;
    }

    protected void addContent(ProjectInfo info, Document document) throws DocumentException {
        String content1 = "\u6839\u636e\u5df2\u6709\u6570\u636e\u5206\u6790\u7ed3\u679c\uff0c\u8be5\u67e5\u8be2\u533a\u57df";
        if (null == info.sthxImg) {
            content1 = content1 + "\u4e0d";
        }
        content1 = content1 + "\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3001";
        if (null == info.jbntImg) {
            content1 = content1 + "\u4e0d";
        }
        content1 = content1 + "\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
        if (null == info.czkfImg) {
            content1 = content1 + "\u672a";
        }
        content1 = content1 + "\u903e\u8d8a\u57ce\u9547\u5f00\u53d1\u8fb9\u754c\u3002";
        String content2 = "\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u7ed3\u679c\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\uff0c\u4e0d\u5177\u6709\u6cd5\u5f8b\u6548\u5e94\u3002\u5982\u6709\u7591\u95ee\u8bf7\u8054\u7cfb\u5f53\u5730\u89c4\u5212\u548c\u81ea\u7136\u8d44\u6e90\u7ba1\u7406\u90e8\u95e8\u3002";
        Chunk chunk1 = new Chunk(content1, this.normalFont);
        Chunk chunk2 = new Chunk(content2, this.italic);
        Paragraph paragraph = new Paragraph();
        paragraph.add((Element)chunk1);
        paragraph.add((Element)chunk2);
        paragraph.setFirstLineIndent(this.firstLineIndent);
        this.addContentTxtFormat(paragraph, document);
    }

    @Override
    protected PdfPCell creaeteImgCell(Image img) {
        PdfPCell cimg = null;
        if (null == img) {
            cimg = new PdfPCell();
        } else {
            float width = 120.0f;
            float heigth = img.getHeight() / (img.getWidth() / width);
            img.scaleToFit(width, heigth);
            cimg = new PdfPCell(img);
        }
        cimg.setVerticalAlignment(1);
        cimg.setHorizontalAlignment(1);
        cimg.setPaddingTop(5.0f);
        cimg.setPaddingBottom(5.0f);
        cimg.setPaddingLeft(5.0f);
        cimg.setPaddingRight(5.0f);
        return cimg;
    }

    protected PdfPCell getDefaultImage(String file) throws IOException, DocumentException {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String rootPath = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        Image image = Image.getInstance((String)(rootPath + "data/xcjshx/" + file));
        PdfPCell cell = this.creaeteImgCell(image);
        return cell;
    }

    protected PdfPCell createTableContent(String title) {
        PdfPCell cell = new PdfPCell(new Phrase(title, this.tableContent));
        this.addImgTxtFormat(cell);
        return cell;
    }

    protected PdfPTable getPdfPTable(int column, int[] tableWidth, Integer before, Integer after) throws DocumentException {
        PdfPTable table = new PdfPTable(column);
        table.setWidths(tableWidth);
        table.setSpacingBefore((float)before.intValue());
        table.setSpacingAfter((float)after.intValue());
        table.getDefaultCell().setBorder(0);
        table.setWidthPercentage(90.0f);
        return table;
    }
}

