/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.EnumAnalyzeResult;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.ResultInfo;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQBysxzService;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.pdf.PdfPTable;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service(value="CloudAnalyzeGdbhApplyService")
@Primary
public class CloudAnalyzeGdbhApplyService
extends CloudAnalyzeCQBysxzService {
    public boolean ExportReport(List<ProjectInfo> infoList, Integer type) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            document = this.createPdf(info);
            document.addTitle(this.getName(type) + "\u7533\u8bf7\u4e91\u5206\u6790\u62a5\u544a");
            this.addTitle(this.getName(type) + "\u7533\u8bf7\u4e91\u5206\u6790\u62a5\u544a", this.titleFont, document);
            String content = "\u6309\u7167\u60a8\u52fe\u7ed8\u7684" + this.getName(type) + "\u7533\u8bf7\u8303\u56f4\uff0c\u4f9d\u636e\u6e1d\u8015\u4fdd\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684" + this.getName(type) + "\u7533\u8bf7\u4e91\u5206\u6790\u62a5\u544a\u5982\u4e0b\u3002";
            this.addContent(content, 1, document);
            this.addContentItalicRed("\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\uff0c\u4e0d\u5177\u6709\u6cd5\u5f8b\u6548\u5e94\u3002", document);
            ResultInfo result = new ResultInfo();
            this.BaseInfo(infoList, type, document);
            this.secondPart(infoList, result, document);
            this.thirdPart(infoList, result, document);
            this.fourthPart(infoList, result, document);
            this.fifthPart(infoList, result, document);
            this.SummarizeAnalysis(info, result, document);
            this.AddSign(info, document);
            this.addDescribe(type, document);
            document.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    protected void BaseInfo(List<ProjectInfo> infoList, Integer type, Document document) throws DocumentException, IOException {
        ProjectInfo info = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e00\u3001\u57fa\u672c\u60c5\u51b5", document);
        String content = "\u4f4d\u4e8e%s%s%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u5730\u5757\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
        if (StringUtils.isEmpty((CharSequence)info.location)) {
            content = String.format(content, info.provinceName, info.logicCity ? "" : info.cityName, info.countyName, info.villageName, PdfAnalyzeUtil.Round(Double.valueOf(info.lontitude), 4), PdfAnalyzeUtil.Round(Double.valueOf(info.latitude), 4), PdfAnalyzeUtil.Round(info.area, 2));
        } else {
            content = "\u4f4d\u4e8e%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u5730\u5757\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
            content = String.format(content, info.provinceName, info.location, PdfAnalyzeUtil.Round(Double.valueOf(info.lontitude), 4), PdfAnalyzeUtil.Round(Double.valueOf(info.latitude), 4), PdfAnalyzeUtil.Round(info.area, 2));
        }
        content = "\u60a8\u6240\u7533\u8bf7\u7684" + this.getName(type) + "\uff0c" + content;
        content = this.getAreaContent(info, content);
        this.addContent(content, document);
        this.addTable(info, type, document);
        this.AddBaseImg(infoList, document);
    }

    protected void addTable(ProjectInfo info, Integer type, Document document) throws DocumentException {
        this.addTitle("\u8868." + this.getName(type) + "\u7533\u8bf7\u76f8\u5173\u89c4\u5b9a", this.sectionFont, document);
        int[] tableWidth = new int[]{45, 45};
        PdfPTable table = this.getPdfPTable(2, tableWidth);
        table.addCell(this.createImgTitle("\u662f\u5426\u5360\u7528"));
        table.addCell(this.createImgTitle("\u7ea6\u675f\u8303\u56f4"));
        if (info.sthxImg != null) {
            table.addCell(this.createContent("\u5360\u7528", this.redFont));
        } else {
            table.addCell(this.createContent("\u4e0d\u5360\u7528", this.greenFont));
        }
        table.addCell(this.createImgTitle("\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf"));
        if (info.zrbhdImg != null) {
            table.addCell(this.createContent("\u5360\u7528", this.redFont));
        } else {
            table.addCell(this.createContent("\u4e0d\u5360\u7528", this.greenFont));
        }
        table.addCell(this.createImgTitle("\u81ea\u7136\u4fdd\u62a4\u5730"));
        if (info.jbntImg != null) {
            table.addCell(this.createContent("\u5360\u7528", this.redFont));
        } else {
            table.addCell(this.createContent("\u4e0d\u5360\u7528", this.greenFont));
        }
        table.addCell(this.createImgTitle("\u6c38\u4e45\u57fa\u672c\u519c\u7530"));
        if (info.czkfImg != null) {
            table.addCell(this.createContent("\u5360\u7528", this.redFont));
        } else {
            table.addCell(this.createContent("\u4e0d\u5360\u7528", this.greenFont));
        }
        table.addCell(this.createImgTitle("\u57ce\u9547\u5f00\u53d1\u8fb9\u754c"));
        document.add((Element)table);
    }

    @Override
    protected void thirdPart(List<ProjectInfo> infoList, ResultInfo result, Document document) throws DocumentException {
        Object info = null;
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e09\u3001\u6c38\u4e45\u57fa\u672c\u519c\u7530\u5206\u6790", document);
        this.addJbntMessageContent(result, other, document);
        this.addBhyjjbnt(document);
    }

    protected void addJbntMessageContent(ResultInfo result, ProjectInfo other, Document document) throws DocumentException {
        this.addSencondTitle("(\u4e00)\u6c38\u4e45\u57fa\u672c\u519c\u7530", document);
        String jbntResult = "\u57fa\u4e8e\u91cd\u5e86\u57fa\u672c\u519c\u7530\u6570\u636e\u5206\u6790\uff1a";
        if (null != other.jbntArea && other.jbntArea > 0.0) {
            result.passJbnt = EnumAnalyzeResult.NoPass;
            if (other.jbntArea < other.area) {
                result.passJbnt = EnumAnalyzeResult.PartPass;
            }
            jbntResult = jbntResult + "\u62df\u7533\u8bf7\u533a\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u5171" + PdfAnalyzeUtil.Round(other.jbntArea, 2) + "\u5e73\u65b9\u7c73\u3002";
        } else {
            result.passJbnt = EnumAnalyzeResult.AllPass;
            jbntResult = jbntResult + "\u62df\u7533\u8bf7\u533a\u4e0d\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3002";
        }
        this.addContent(jbntResult, document);
        if (other.jbntImg != null) {
            String desc = "\u57fa\u672c\u519c\u7530\uff1a" + PdfAnalyzeUtil.Round(other.jbntArea, 2) + "\u5e73\u65b9\u7c73";
            this.AddImg("\u6c38\u4e45\u57fa\u672c\u519c\u7530", other.jbntImg, desc, document);
        }
    }

    protected void addBhyjjbnt(Document document) throws DocumentException {
        this.addSencondTitle("(\u4e8c)\u8865\u5212\u6c38\u4e45\u57fa\u672c\u519c\u7530", document);
        this.addContent("\u6682\u65e0\u6570\u636e", document);
    }

    private String getName(Integer type) {
        if (1 == type) {
            return "\u8bbe\u65bd\u519c\u7528\u5730\u9009\u5740\u590d\u6838";
        }
        if (2 == type) {
            return "\u4e34\u65f6\u7528\u5730";
        }
        if (3 == type) {
            return "\u519c\u623f";
        }
        return "";
    }

    @Override
    protected void AddSign(ProjectInfo info, Document document) throws DocumentException {
        String timeStr = "\u65f6  \u95f4\uff1a " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        this.addSignContent(info.narrow, timeStr, document);
    }

    protected void addDescribe(Integer type, Document document) throws DocumentException {
        document.newPage();
        this.addFirstTitle("\u9644\uff1a\u6d89\u53ca\u653f\u7b56\u89e3\u8bfb", document);
        this.addSthxDescribe("1\u3001\u5173\u4e8e\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf", document);
        this.addZrbhqDescribe("2\u3001\u5173\u4e8e\u81ea\u7136\u4fdd\u62a4\u5730", document);
        this.addJbntDescribe("3\u3001\u5173\u4e8e\u6c38\u4e45\u57fa\u672c\u519c\u7530", document);
        this.addCzkfbjDescribe("4\u3001\u5173\u4e8e\u57ce\u9547\u5f00\u53d1\u8fb9\u754c", document);
        if (2 == type) {
            this.addTdghDescribe("5\u3001\u5173\u4e8e\u6751\u9547\u56fd\u571f\u7a7a\u95f4\u89c4\u5212", document);
            this.addDzzhDescribe("6\u3001\u5730\u5740\u707e\u5bb3\u5b89\u5168", document);
        }
    }
}

