/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq;

import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQBysxzService;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service(value="CloudAnalyzeGdbhService")
@Primary
public class CloudAnalyzeGdbhService
extends CloudAnalyzeCQBysxzService {
    @Override
    public boolean ExportReport(List<ProjectInfo> infoList) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            ProjectInfo otherInfo = this.getOtherNode(infoList);
            document = this.createPdf(info);
            document.addTitle("\u8015\u5730\u67e5\u8be2\u62a5\u544a");
            this.addTitle("\u8015\u5730\u67e5\u8be2\u62a5\u544a", this.titleFont, document);
            String content = "\u6309\u7167\u60a8\u52fe\u7ed8\u7684\u8015\u5730\u67e5\u8be2\u533a\u57df\uff0c\u4f9d\u636e\u6e1d\u8015\u4fdd\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684\u8015\u5730\u67e5\u8be2\u62a5\u544a\u5982\u4e0b\u3002";
            this.addContent(content, 0, document);
            this.addContentItalicRed("\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\uff0c\u4e0d\u5177\u6709\u6cd5\u5f8b\u6548\u5e94\u3002", document);
            this.BaseInfo(infoList, document);
            this.secondPart(otherInfo, "\u4e8c\u3001\u571f\u5730\u5229\u7528\u73b0\u72b6\u67e5\u8be2", document);
            this.thirdPart(otherInfo, "\u4e09\u3001\u8015\u5730\u5761\u5ea6\u67e5\u8be2", document);
            this.thirdPart(otherInfo, "\u56db\u3001\u8015\u5730\u8d28\u91cf\u67e5\u8be2", document);
            this.fifthPart(otherInfo, "\u4e94\u3001\u6c38\u4e45\u57fa\u672c\u519c\u7530\u67e5\u8be2", document);
            this.thirdPart(otherInfo, "\u516d\u3001\u8865\u5145\u8015\u5730\u67e5\u8be2", document);
            document.close();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }

    protected void BaseInfo(List<ProjectInfo> infoList, Document document) throws DocumentException, IOException {
        ProjectInfo info = this.getOtherNode(infoList);
        this.addFirstTitle("\u4e00\u3001\u57fa\u672c\u60c5\u51b5", document);
        String content = "\u4f4d\u4e8e%s%s%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u603b\u67e5\u8be2\u533a\u57df\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
        if (StringUtils.isEmpty((CharSequence)info.location)) {
            content = String.format(content, info.provinceName, info.logicCity ? "" : info.cityName, info.countyName, info.villageName, PdfAnalyzeUtil.Round(Double.valueOf(info.lontitude), 4), PdfAnalyzeUtil.Round(Double.valueOf(info.latitude), 4), PdfAnalyzeUtil.Round(info.area, 2));
        } else {
            content = "\u4f4d\u4e8e%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u603b\u67e5\u8be2\u533a\u57df\u9762\u79ef%s\u5e73\u65b9\u7c73\u3002";
            content = String.format(content, info.provinceName, info.location, PdfAnalyzeUtil.Round(Double.valueOf(info.lontitude), 4), PdfAnalyzeUtil.Round(Double.valueOf(info.latitude), 4), PdfAnalyzeUtil.Round(info.area, 2));
        }
        this.addContent(content, document);
        this.AddBaseImg(infoList, document);
    }

    protected void secondPart(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addFirstTitle(title, document);
        String desc = "\u6839\u636e\u67e5\u8be2\u7ed3\u679c\u663e\u793a\uff0c";
        desc = info.tdghCqInfos != null && info.tdghCqInfos.size() > 0 ? desc + "\u60a8\u6240\u52fe\u7ed8\u7684\u67e5\u8be2\u8303\u56f4\u6709" + this.getTdlyxz(info) + "\uff0c\u5177\u4f53\u5206\u5e03\u53ef\u67e5\u770b\u8be6\u7ec6\u5206\u6790\u56fe\u3002" : desc + "\u60a8\u6240\u52fe\u7ed8\u7684\u67e5\u8be2\u8303\u56f4\u6ca1\u6709\u5360\u7528\u571f\u5730\u5229\u7528\u73b0\u72b6\u56fe\u5c42";
        this.addContent(desc, document);
        if (info.tdghCqImg != null) {
            this.AddImg(null, info.tdghCqImg, "\u571f\u5730\u5229\u7528\u73b0\u72b6\u53e0\u52a0\u5206\u6790\u56fe", document);
        }
    }

    protected void thirdPart(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addFirstTitle(title, document);
        String desc = "\u6682\u65e0\u6570\u636e";
        this.addContent(desc, document);
    }

    protected void fifthPart(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addFirstTitle(title, document);
        this.addYjjbnt(info, "\uff08\u4e00\uff09\u6c38\u4e45\u57fa\u672c\u519c\u7530", document);
        this.addBhyjjbnt(info, "\uff08\u4e8c\uff09\u8865\u5212\u6c38\u4e45\u57fa\u672c\u519c\u7530", document);
    }

    protected void addYjjbnt(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addSencondTitle(title, document);
        String desc = "";
        desc = info.jbntArea != null && info.jbntArea > 0.0 ? desc + "\u67e5\u8be2\u8303\u56f4\u5185\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u5176\u4e2d\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530" + PdfAnalyzeUtil.Round(info.jbntArea, 2) + "\u5e73\u65b9\u7c73\u3002" : desc + "\u67e5\u8be2\u8303\u56f4\u5185\u4e0d\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3002";
        this.addContent(desc, document);
        if (info.jbntImg != null) {
            this.AddImg(null, info.jbntImg, "\u6c38\u4e45\u57fa\u672c\u519c\u7530\u53e0\u52a0\u5206\u6790\u56fe", document);
        }
    }

    protected void addBhyjjbnt(ProjectInfo info, String title, Document document) throws DocumentException {
        this.addSencondTitle(title, document);
        String desc = "\u6682\u65e0\u6570\u636e";
        this.addContent(desc, document);
    }
}

