/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQuery;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryRepository;
import com.geoway.landteam.cloudquery.servface.pub.CloudQueryService;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.geometry.GeometryUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionCorrect;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionCorrectService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.datacq.analyze.DzfxInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.EnumAnalyzeResult;
import com.geoway.landteam.landcloud.model.datacq.analyze.LandType;
import com.geoway.landteam.landcloud.model.datacq.analyze.LandUseGrade;
import com.geoway.landteam.landcloud.model.datacq.analyze.LawlessInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.OwnerDetailInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.Ownership;
import com.geoway.landteam.landcloud.model.datacq.analyze.ProjectInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.ResultInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.SpbaInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.TdghInfo;
import com.geoway.landteam.landcloud.model.datacq.analyze.YnbhInfo;
import com.geoway.landteam.landcloud.model.datacq.entity.CloudAnalyzeConfig;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKTReader;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class CloudAnalyzeService {
    private GiLoger logger = GwLoger.getLoger(CloudAnalyzeService.class);
    @Value(value="${project.downloadDir}")
    String downloadDir;
    @Autowired
    CloudQueryRepository cloudQueryDao;
    @Autowired
    RegionCorrectService regionCorrectService;
    @Autowired
    RegionService regionService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    CloudQueryService cloudQueryService;
    Font titleFont;
    Font chapterFont;
    Font sectionFont;
    Font normalFont;
    Font boldFont;
    Font roleFont;
    Font redFont;
    float pgSpace = 18.0f;
    float lineSpace = 16.0f;
    float firstLineIndent = 24.0f;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CloudAnalyzeService() throws IOException, DocumentException {
        ClassPathResource STSONG = new ClassPathResource("/static/STSONG.TTF");
        ClassPathResource simhei = new ClassPathResource("/static/simhei.ttf");
        ClassPathResource simkai = new ClassPathResource("/static/simkai.ttf");
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        if (STSONG.exists()) {
            InputStream STSONGinputStream = STSONG.getInputStream();
            InputStream simheiinputStream = simhei.getInputStream();
            InputStream simkaiinputStream = simkai.getInputStream();
            File STSONGFile = File.createTempFile("template_STSONG_copy", ".TTF");
            File simheiFile = File.createTempFile("template_simhei_copy", ".ttf");
            File simkaiFile = File.createTempFile("template_simkai_copy", ".ttf");
            try {
                FileUtils.copyInputStreamToFile((InputStream)STSONGinputStream, (File)STSONGFile);
                FileUtils.copyInputStreamToFile((InputStream)simheiinputStream, (File)simheiFile);
                FileUtils.copyInputStreamToFile((InputStream)simkaiinputStream, (File)simkaiFile);
                this.titleFont = new Font(BaseFont.createFont((String)simheiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 16.0f);
                this.titleFont.setStyle(1);
                this.chapterFont = new Font(BaseFont.createFont((String)simheiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 14.0f);
                this.chapterFont.setStyle(1);
                this.sectionFont = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.sectionFont.setStyle(1);
                this.normalFont = new Font(BaseFont.createFont((String)STSONGFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.boldFont = new Font(BaseFont.createFont((String)STSONGFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.boldFont.setStyle(1);
                this.roleFont = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 10.0f);
                this.redFont = new Font(BaseFont.createFont((String)simkaiFile.getAbsolutePath(), (String)"Identity-H", (boolean)false, (boolean)false, null, null), 12.0f);
                this.redFont.setColor(255, 0, 0);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((Closeable[])new Closeable[]{STSONGinputStream, simheiinputStream, simkaiinputStream});
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable[])new Closeable[]{STSONGinputStream, simheiinputStream, simkaiinputStream});
        }
    }

    public Document createPdf(String outFile, boolean narrow) throws DocumentException, FileNotFoundException {
        File file = new File(outFile);
        file.getParentFile().mkdirs();
        Rectangle size = PageSize.A4;
        if (narrow) {
            size = PageSize.A5;
        }
        Rectangle rectPageSize = new Rectangle(size);
        Document document = new Document(rectPageSize, 40.0f, 40.0f, 40.0f, 40.0f);
        PdfWriter pdfWriter = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(outFile));
        pdfWriter.setInitialLeading(30.0f);
        document.open();
        return document;
    }

    public ProjectInfo Parse(String requestId, String tbid, String userName, int analyzeType, String tag, boolean px) throws Exception {
        List cloudQueryList;
        String url;
        List medias;
        ProjectInfo info = new ProjectInfo();
        if (tbid != null && !tbid.isEmpty() && (medias = this.appMediaDao.queryPhotosByGid(tbid)) != null) {
            Date dTime;
            String time;
            double azid;
            String azi;
            FileInputStream fis1;
            String fileName;
            File lsFile;
            AppMedia media;
            int count = medias.size();
            if (count >= 1) {
                media = (AppMedia)medias.get(0);
                url = media.getDownloadUrl();
                if ((url = this.temporarySignedUrlService.getTemporarySignedUrl("", url, null)).indexOf("%3D") > -1) {
                    url = url.replace("%3D", "=");
                }
                if (!(lsFile = new File(this.downloadDir, fileName = media.getId() + ".jpg")).exists()) {
                    FileUtils.copyURLToFile((URL)new URL(url), (File)lsFile);
                }
                fis1 = new FileInputStream(lsFile);
                byte[] photo1 = new byte[(int)lsFile.length()];
                fis1.read(photo1);
                fis1.close();
                info.photo1 = Image.getInstance((byte[])photo1);
                lsFile.delete();
                info.photoMeta1 = userName + " " + media.getLon().toString() + "\u00b0E " + media.getLat().toString() + "\u00b0N";
                azi = media.getAzimuth();
                azid = Double.parseDouble(azi);
                time = media.getTime();
                dTime = new Date(Long.parseLong(time));
                time = new SimpleDateFormat("yyyy-MM-dd").format(dTime).toString();
                info.photoMeta1 = info.photoMeta1 + " " + this.GetDirction(azid) + " " + time;
            }
            if (count >= 2) {
                media = (AppMedia)medias.get(1);
                url = media.getDownloadUrl();
                if (url.indexOf("%3D") > -1) {
                    url = url.replace("%3D", "=");
                }
                url = this.temporarySignedUrlService.getTemporarySignedUrl("", url, null);
                fileName = media.getId() + ".jpg";
                lsFile = new File(this.downloadDir, fileName);
                if (!lsFile.exists()) {
                    FileUtils.copyURLToFile((URL)new URL(url), (File)lsFile);
                }
                fis1 = new FileInputStream(lsFile);
                byte[] photo2 = new byte[(int)lsFile.length()];
                fis1.read(photo2);
                fis1.close();
                info.photo2 = Image.getInstance((byte[])photo2);
                lsFile.delete();
                info.photoMeta2 = userName + " " + media.getLon().toString() + "\u00b0E " + media.getLat().toString() + "\u00b0N";
                azi = media.getAzimuth();
                azid = Double.parseDouble(azi);
                time = media.getTime();
                dTime = new Date(Long.parseLong(time));
                time = new SimpleDateFormat("yyyy-MM-dd").format(dTime).toString();
                info.photoMeta2 = info.photoMeta2 + " " + this.GetDirction(azid) + " " + time;
            }
        }
        if ((cloudQueryList = this.cloudQueryDao.findByRequestIdTag(requestId, analyzeType, tag)) == null || cloudQueryList.size() < 1) {
            throw new RuntimeException("\u65e0\u67e5\u8be2\u7ed3\u679c");
        }
        for (CloudQuery query : cloudQueryList) {
            SqlliteConnTool dbHelper;
            ArrayList tables;
            File lsFile;
            String[] paths;
            String fileName;
            if (info.lontitude == null || info.lontitude.isEmpty()) {
                String countyCode;
                double lat;
                String param = query.getParam();
                JSONObject detail = JSONObject.parseObject((String)param);
                if (detail.containsKey((Object)"lon")) {
                    info.lontitude = detail.get((Object)"lon").toString();
                }
                if (detail.containsKey((Object)"lat")) {
                    info.latitude = detail.get((Object)"lat").toString();
                }
                if (detail.containsKey((Object)"mj")) {
                    String mj = detail.get((Object)"mj").toString();
                    info.area = Double.parseDouble(mj);
                }
                String lonStr = info.lontitude;
                String latStr = info.latitude;
                double lon = Double.parseDouble(lonStr);
                RegionCorrect regionCorrect = this.regionCorrectService.getOfCoord(lon, lat = Double.parseDouble(latStr));
                if (regionCorrect != null && (countyCode = regionCorrect.getId()).length() == 6) {
                    String cityCode = countyCode.substring(0, 4) + "00";
                    String provinceCode = countyCode.substring(0, 2) + "0000";
                    Region county = this.regionService.findRegionByCode(countyCode);
                    Region city = this.regionService.findRegionByCode(cityCode);
                    Region province = this.regionService.findRegionByCode(provinceCode);
                    info.provinceCode = provinceCode;
                    info.cityCode = cityCode;
                    info.countyCode = countyCode;
                    if (province != null) {
                        info.provinceName = province.getName();
                    }
                    if (city != null) {
                        info.cityName = city.getName();
                    }
                    if (county != null) {
                        info.countyName = county.getName();
                    }
                }
            }
            if ((fileName = (paths = (url = this.cloudQueryService.getDBUrl(query.getId(), null)).split("/"))[paths.length - 1]).indexOf("?") > -1) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }
            if (!(lsFile = new File(this.downloadDir, fileName)).exists()) {
                FileUtils.copyURLToFile((URL)new URL(url), (File)lsFile);
            }
            if ((tables = (dbHelper = new SqlliteConnTool(lsFile.getAbsolutePath())).getTables()) == null || tables.size() == 0) continue;
            if (analyzeType != 0) {
                for (String table : tables) {
                    this.Parse(dbHelper, table, info);
                }
                break;
            }
            if (tables.contains("Image_Analyze")) {
                for (String table : tables) {
                    String tn = table.toLowerCase();
                    System.out.println("table:" + tn);
                    switch (tn) {
                        case "image_analyze": {
                            info.ownershipImgMeta = this.GetImageMeta(dbHelper, "Image_Analyze");
                        }
                    }
                }
            } else {
                for (String table : tables) {
                    this.Parse(dbHelper, table, info);
                }
            }
            dbHelper.Dispose();
        }
        return info;
    }

    public LawlessInfo ParseLawless(String requestId, String tbid, String userName, int analyzeType, String tag) throws Exception {
        LawlessInfo info = new LawlessInfo();
        info.userName = userName;
        List cloudQueryList = this.cloudQueryDao.findByRequestIdTag(requestId, analyzeType, tag);
        if (cloudQueryList == null || cloudQueryList.size() < 1) {
            throw new RuntimeException("\u65e0\u67e5\u8be2\u7ed3\u679c");
        }
        for (CloudQuery query : cloudQueryList) {
            SqlliteConnTool dbHelper;
            ArrayList tables;
            File lsFile;
            String url;
            String[] paths;
            String fileName;
            if (info.lontitude == null || info.lontitude.isEmpty()) {
                String countyCode;
                double lat;
                String param = query.getParam();
                JSONObject detail = JSONObject.parseObject((String)param);
                if (detail.containsKey((Object)"lon")) {
                    info.lontitude = detail.get((Object)"lon").toString();
                }
                if (detail.containsKey((Object)"lat")) {
                    info.latitude = detail.get((Object)"lat").toString();
                }
                if (detail.containsKey((Object)"mj")) {
                    String mj = detail.get((Object)"mj").toString();
                    info.area = Double.parseDouble(mj);
                }
                String lonStr = info.lontitude;
                String latStr = info.latitude;
                double lon = Double.parseDouble(lonStr);
                RegionCorrect regionCorrect = this.regionCorrectService.getOfCoord(lon, lat = Double.parseDouble(latStr));
                if (regionCorrect != null && (countyCode = regionCorrect.getId()).length() == 6) {
                    String cityCode = countyCode.substring(0, 4) + "00";
                    String provinceCode = countyCode.substring(0, 2) + "0000";
                    Region county = this.regionService.findRegionByCode(countyCode);
                    Region city = this.regionService.findRegionByCode(cityCode);
                    Region province = this.regionService.findRegionByCode(provinceCode);
                    info.provinceCode = provinceCode;
                    info.cityCode = cityCode;
                    info.countyCode = countyCode;
                    if (province != null) {
                        info.provinceName = province.getName();
                    }
                    if (city != null) {
                        info.cityName = city.getName();
                    }
                    if (county != null) {
                        info.countyName = county.getName();
                    }
                }
            }
            if ((fileName = (paths = (url = this.cloudQueryService.getDBUrl(query.getId(), null)).split("/"))[paths.length - 1]).indexOf("?") > -1) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }
            if (!(lsFile = new File(this.downloadDir, fileName)).exists()) {
                FileUtils.copyURLToFile((URL)new URL(url), (File)lsFile);
            }
            if ((tables = (dbHelper = new SqlliteConnTool(lsFile.getAbsolutePath())).getTables()) == null || tables.size() == 0) continue;
            if (analyzeType != 0) {
                for (String table : tables) {
                    this.ParseLawless(dbHelper, table, info);
                }
                break;
            }
            if (tables.contains("Image_Analyze")) {
                for (String table : tables) {
                    String tn = table.toLowerCase();
                    System.out.println("table:" + tn);
                    switch (tn) {
                        case "image_analyze": {
                            info.ownershipImgMeta = this.GetImageMeta(dbHelper, "Image_Analyze");
                            this.ParseLawlessImgCompare(dbHelper, "Image_Analyze", info);
                        }
                    }
                }
            } else {
                for (String table : tables) {
                    this.ParseLawless(dbHelper, table, info);
                }
            }
            dbHelper.Dispose();
        }
        return info;
    }

    public YnbhInfo ParseYnbh(String requestId, String tbid, String userName, int analyzeType, String tag) throws Exception {
        YnbhInfo info = new YnbhInfo();
        info.userName = userName;
        List cloudQueryList = this.cloudQueryDao.findByRequestIdTag(requestId, analyzeType, tag);
        if (cloudQueryList == null || cloudQueryList.size() < 1) {
            throw new RuntimeException("\u65e0\u67e5\u8be2\u7ed3\u679c");
        }
        for (CloudQuery query : cloudQueryList) {
            SqlliteConnTool dbHelper;
            ArrayList tables;
            File lsFile;
            String url;
            String[] paths;
            String fileName;
            if (info.lontitude == null || info.lontitude.isEmpty()) {
                String countyCode;
                double lat;
                String param = query.getParam();
                JSONObject detail = JSONObject.parseObject((String)param);
                if (detail.containsKey((Object)"lon")) {
                    info.lontitude = detail.get((Object)"lon").toString();
                }
                if (detail.containsKey((Object)"lat")) {
                    info.latitude = detail.get((Object)"lat").toString();
                }
                if (detail.containsKey((Object)"mj")) {
                    String mj = detail.get((Object)"mj").toString();
                    info.area = Double.parseDouble(mj);
                }
                if (detail.containsKey((Object)"range2000")) {
                    String wkt = detail.getString("range2000").toString();
                    WKTReader wktReader = new WKTReader();
                    Geometry geo = wktReader.read(wkt);
                    CoordinateReferenceSystem prjRef = GeometryUtil.getCgcsPrjCoordinateReferenceSystem((Geometry)geo);
                    geo = GeometryUtil.transCgcs2000ToPrj((Geometry)geo, (CoordinateReferenceSystem)prjRef);
                    info.dkgzd = geo.getArea() / geo.getLength();
                }
                String lonStr = info.lontitude;
                String latStr = info.latitude;
                double lon = Double.parseDouble(lonStr);
                RegionCorrect regionCorrect = this.regionCorrectService.getOfCoord(lon, lat = Double.parseDouble(latStr));
                if (regionCorrect != null && (countyCode = regionCorrect.getId()).length() == 6) {
                    String cityCode = countyCode.substring(0, 4) + "00";
                    String provinceCode = countyCode.substring(0, 2) + "0000";
                    Region county = this.regionService.findRegionByCode(countyCode);
                    Region city = this.regionService.findRegionByCode(cityCode);
                    Region province = this.regionService.findRegionByCode(provinceCode);
                    info.provinceCode = provinceCode;
                    info.cityCode = cityCode;
                    info.countyCode = countyCode;
                    if (province != null) {
                        info.provinceName = province.getName();
                    }
                    if (city != null) {
                        info.cityName = city.getName();
                    }
                    if (county != null) {
                        info.countyName = county.getName();
                    }
                }
            }
            if ((fileName = (paths = (url = this.cloudQueryService.getDBUrl2(query.getId(), "https://xcx.geoway.com.cn:18381")).split("/"))[paths.length - 1]).indexOf("?") > -1) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }
            if (!(lsFile = new File(this.downloadDir, fileName)).exists()) {
                FileUtils.copyURLToFile((URL)new URL(url), (File)lsFile);
            }
            if ((tables = (dbHelper = new SqlliteConnTool(lsFile.getAbsolutePath())).getTables()) == null || tables.size() == 0) continue;
            if (analyzeType != 0) {
                for (String table : tables) {
                    this.ParseYnbh(dbHelper, table, info);
                }
                break;
            }
            dbHelper.Dispose();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ExportReport(ProjectInfo info, Boolean px) throws DocumentException, IOException {
        Document document = null;
        try {
            Paragraph first;
            Paragraph title;
            document = this.createPdf(info.outFile, info.narrow);
            if (px.booleanValue()) {
                document.addTitle("\u571f\u5730\u5f00\u53d1\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a");
                title = new Paragraph(info.projectName + "\u571f\u5730\u5f00\u53d1\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a", this.titleFont);
                title.setAlignment(1);
                document.add((Element)title);
                first = new Paragraph("\u6309\u7167\u60a8\u52fe\u7ed8\u7684\u9879\u76ee\u8303\u56f4\uff0c\u4f9d\u636e\u56fd\u571f\u8c03\u67e5\u4e91\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684\u571f\u5730\u5f00\u53d1\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a\u5982\u4e0b\u3002\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\u3002 ", this.normalFont);
                first.setFirstLineIndent(this.firstLineIndent);
                first.setExtraParagraphSpace(30.0f);
                first.setSpacingBefore(this.pgSpace);
                first.setLeading(this.lineSpace);
                document.add((Element)first);
            } else {
                document.addTitle("\u5efa\u8bbe\u7528\u5730\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a");
                title = new Paragraph(info.projectName + "\u5efa\u8bbe\u7528\u5730\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a", this.titleFont);
                title.setAlignment(1);
                document.add((Element)title);
                first = new Paragraph("\u6309\u7167\u60a8\u52fe\u7ed8\u7684\u9879\u76ee\u8303\u56f4\uff0c\u4f9d\u636e\u56fd\u571f\u8c03\u67e5\u4e91\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684\u5efa\u8bbe\u7528\u5730\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a\u5982\u4e0b\u3002\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\u3002 ", this.normalFont);
                first.setFirstLineIndent(this.firstLineIndent);
                first.setExtraParagraphSpace(30.0f);
                first.setSpacingBefore(this.pgSpace);
                first.setLeading(this.lineSpace);
                document.add((Element)first);
            }
            ResultInfo result = new ResultInfo();
            this.BaseInfo(document, info, result);
            this.LegalAnalysis(document, info, result);
            this.BzInfo(document);
            this.SuitableAnalysis(document, info, result, px);
            this.SummarizeAnalysis(document, info, result, px);
            this.AddSign(document, info);
            document.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (document != null && document.isOpen()) {
                document.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ExportReportLawLess(LawlessInfo info) {
        Document document = null;
        try {
            document = this.createPdf(info.outFile, info.narrow);
            document.addTitle("\u8fdd\u6cd5\u7528\u5730\u4e91\u5206\u6790\u62a5\u544a");
            Paragraph title = new Paragraph("\u9065\u611f\u76d1\u6d4b\u7591\u4f3c\u8fdd\u6cd5\u7528\u5730\u4e91\u5206\u6790\u62a5\u544a", this.titleFont);
            title.setAlignment(1);
            document.add((Element)title);
            Paragraph first = new Paragraph("\u4f9d\u636e\u56fd\u571f\u8c03\u67e5\u4e91\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684\u9065\u611f\u76d1\u6d4b\u7591\u4f3c\u8fdd\u6cd5\u7528\u5730\u4e91\u5206\u6790\u62a5\u544a\u5982\u4e0b\u3002\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\u3002", this.normalFont);
            first.setFirstLineIndent(this.firstLineIndent);
            first.setExtraParagraphSpace(30.0f);
            first.setSpacingBefore(this.pgSpace);
            first.setLeading(this.lineSpace);
            document.add((Element)first);
            ResultInfo result = new ResultInfo();
            this.BaseInfoLawless(document, info, result);
            this.JcqkAnalysis(document, info, result);
            this.LegalAnalysisLawless(document, info, result);
            this.BzInfo(document);
            this.SummarizeAnalysisLawless(document, info, result);
            this.AddSign(document, info);
            document.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (document != null && document.isOpen()) {
                document.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ExportReportYn(YnbhInfo info) throws DocumentException, IOException {
        Document document = null;
        try {
            document = this.createPdf(info.outFile, info.narrow);
            document.addTitle("\u6c38\u4e45\u57fa\u672c\u519c\u7530\u8865\u5212\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a");
            Paragraph title = new Paragraph("\u6c38\u4e45\u57fa\u672c\u519c\u7530\u8865\u5212\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a", this.titleFont);
            title.setAlignment(1);
            document.add((Element)title);
            Paragraph first = new Paragraph("\u6309\u7167\u60a8\u52fe\u7ed8\u7684\u5730\u5757\u8303\u56f4\uff0c\u4f9d\u636e\u540e\u53f0\u6570\u636e\uff0c\u751f\u6210\u7684\u6c38\u4e45\u57fa\u672c\u519c\u7530\u8865\u5212\u9009\u5740\u4e91\u5206\u6790\u62a5\u544a\u5982\u4e0b\u3002\u53d7\u6570\u636e\u9f50\u5168\u6027\u3001\u65f6\u6548\u6027\u548c\u7cbe\u5ea6\u9650\u5236\uff0c\u672c\u5206\u6790\u62a5\u544a\u4ec5\u7528\u4e8e\u8f85\u52a9\u53c2\u8003\u3002", this.normalFont);
            first.setFirstLineIndent(this.firstLineIndent);
            first.setExtraParagraphSpace(30.0f);
            first.setSpacingBefore(this.pgSpace);
            first.setLeading(this.lineSpace);
            document.add((Element)first);
            Paragraph chapter1Pg = new Paragraph("\u4e00\u3001\u57fa\u672c\u60c5\u51b5", this.chapterFont);
            chapter1Pg.setExtraParagraphSpace(30.0f);
            chapter1Pg.setSpacingBefore(this.pgSpace);
            chapter1Pg.setLeading(this.lineSpace);
            document.add((Element)chapter1Pg);
            String content = "\u5730\u5757\u4f4d\u4e8e\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u9879\u76ee\u5730\u5757\u9762\u79ef%s\u4ea9\u3002";
            content = String.format(content, info.lontitude, info.latitude, String.valueOf(this.Round(info.area, 2)));
            Paragraph baseInfo = new Paragraph(content, this.normalFont);
            baseInfo.setFirstLineIndent(this.firstLineIndent);
            baseInfo.setExtraParagraphSpace(30.0f);
            baseInfo.setSpacingBefore(this.pgSpace);
            baseInfo.setLeading(this.lineSpace);
            document.add((Element)baseInfo);
            Paragraph chapter2Pg = new Paragraph("\u4e8c\u3001\u5408\u6cd5\u6027\u5206\u6790", this.chapterFont);
            chapter2Pg.setExtraParagraphSpace(30.0f);
            chapter2Pg.setSpacingBefore(this.pgSpace);
            chapter2Pg.setLeading(this.lineSpace);
            document.add((Element)chapter2Pg);
            Paragraph jbntPg = new Paragraph("(\u4e00)\u662f\u5426\u6d89\u53ca\u73b0\u6709\u6c38\u4e45\u57fa\u672c\u519c\u7530\u60c5\u51b5\u5206\u6790", this.sectionFont);
            jbntPg.setExtraParagraphSpace(30.0f);
            jbntPg.setSpacingBefore(this.pgSpace);
            jbntPg.setLeading(this.lineSpace);
            document.add((Element)jbntPg);
            String jbntResult = "\u62df\u9009\u5740\u5730\u5757" + (info.jbntArea > 0.0 ? "\u6d89\u53ca" : "\u4e0d\u6d89\u53ca") + "\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3002";
            Paragraph jbntInfo = new Paragraph(jbntResult, this.normalFont);
            jbntInfo.setFirstLineIndent(this.firstLineIndent);
            jbntInfo.setExtraParagraphSpace(30.0f);
            jbntInfo.setSpacingBefore(this.pgSpace);
            jbntInfo.setLeading(this.lineSpace);
            document.add((Element)jbntInfo);
            Paragraph sthxPg = new Paragraph("\uff08\u4e8c\uff09\u662f\u5426\u6d89\u53ca\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u60c5\u51b5\u5206\u6790", this.sectionFont);
            sthxPg.setExtraParagraphSpace(30.0f);
            sthxPg.setSpacingBefore(this.pgSpace);
            sthxPg.setLeading(this.lineSpace);
            document.add((Element)sthxPg);
            String sthxResult = "\u62df\u9009\u5740\u5730\u5757" + (info.sthxArea > 0.0 ? "\u6d89\u53ca" : "\u4e0d\u6d89\u53ca") + "\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3002";
            Paragraph sthxInfo = new Paragraph(sthxResult, this.normalFont);
            sthxInfo.setFirstLineIndent(this.firstLineIndent);
            sthxInfo.setExtraParagraphSpace(30.0f);
            sthxInfo.setSpacingBefore(this.pgSpace);
            sthxInfo.setLeading(this.lineSpace);
            document.add((Element)sthxInfo);
            Paragraph bwdgdPg = new Paragraph("\uff08\u4e09\uff09\u662f\u5426\u6d89\u53ca\u4e0d\u7a33\u5b9a\u8015\u5730\u6216\u975e\u8015\u5730\u8303\u56f4\u60c5\u51b5\u5206\u6790", this.sectionFont);
            bwdgdPg.setExtraParagraphSpace(30.0f);
            bwdgdPg.setSpacingBefore(this.pgSpace);
            bwdgdPg.setLeading(this.lineSpace);
            document.add((Element)bwdgdPg);
            String bwdgdResult = "\u62df\u9009\u5740\u5730\u5757" + (info.bwdgdArea > 0.0 ? "\u6d89\u53ca" : "\u4e0d\u6d89\u53ca") + "\u4e0d\u7a33\u5b9a\u8015\u5730\u6216\u975e\u8015\u5730\u8303\u56f4\u3002";
            Paragraph bwdgdInfo = new Paragraph(bwdgdResult, this.normalFont);
            bwdgdInfo.setFirstLineIndent(this.firstLineIndent);
            bwdgdInfo.setExtraParagraphSpace(30.0f);
            bwdgdInfo.setSpacingBefore(this.pgSpace);
            bwdgdInfo.setLeading(this.lineSpace);
            document.add((Element)bwdgdInfo);
            Paragraph xctbPg = new Paragraph("\uff08\u56db\uff09\u662f\u5426\u662f\u72ed\u957f\u56fe\u6591\u60c5\u51b5\u5206\u6790", this.sectionFont);
            xctbPg.setExtraParagraphSpace(30.0f);
            xctbPg.setSpacingBefore(this.pgSpace);
            xctbPg.setLeading(this.lineSpace);
            document.add((Element)xctbPg);
            String xctbResult = "\u62df\u9009\u5740\u5730\u5757" + (info.dkgzd < 0.2 ? "\u662f" : "\u4e0d\u662f") + "\u72ed\u957f\u56fe\u6591\u3002";
            Paragraph xctbInfo = new Paragraph(xctbResult, this.normalFont);
            xctbInfo.setFirstLineIndent(this.firstLineIndent);
            xctbInfo.setExtraParagraphSpace(30.0f);
            xctbInfo.setSpacingBefore(this.pgSpace);
            xctbInfo.setLeading(this.lineSpace);
            document.add((Element)xctbInfo);
            Paragraph czcPg = new Paragraph("\uff08\u4e94\uff09\u662f\u5426\u6d89\u53ca\u57ce\u9547\u6751\u7b49\u7528\u5730\u8303\u56f4\u60c5\u51b5\u5206\u6790", this.sectionFont);
            czcPg.setExtraParagraphSpace(30.0f);
            czcPg.setSpacingBefore(this.pgSpace);
            czcPg.setLeading(this.lineSpace);
            document.add((Element)czcPg);
            String czcResult = "\u62df\u9009\u5740\u5730\u5757" + (info.czcdydArea > 0.0 ? "\u6d89\u53ca" : "\u4e0d\u6d89\u53ca") + "\u57ce\u9547\u6751\u7b49\u7528\u5730\u8303\u56f4\u3002";
            Paragraph czcInfo = new Paragraph(czcResult, this.normalFont);
            czcInfo.setFirstLineIndent(this.firstLineIndent);
            czcInfo.setExtraParagraphSpace(30.0f);
            czcInfo.setSpacingBefore(this.pgSpace);
            czcInfo.setLeading(this.lineSpace);
            document.add((Element)czcInfo);
            Paragraph nyzPg = new Paragraph("\uff08\u516d\uff09\u662f\u5426\u6d89\u53ca\u519c\u8f6c\u7528\u8303\u56f4\u60c5\u51b5\u5206\u6790", this.sectionFont);
            nyzPg.setExtraParagraphSpace(30.0f);
            nyzPg.setSpacingBefore(this.pgSpace);
            nyzPg.setLeading(this.lineSpace);
            document.add((Element)nyzPg);
            String nzyResult = "\u62df\u9009\u5740\u5730\u5757" + (info.pewyMj > 0.0 ? "\u6d89\u53ca" : "\u4e0d\u6d89\u53ca") + "\u519c\u8f6c\u7528\u8303\u56f4\u3002";
            Paragraph nzyInfo = new Paragraph(nzyResult, this.normalFont);
            nzyInfo.setFirstLineIndent(this.firstLineIndent);
            nzyInfo.setExtraParagraphSpace(30.0f);
            nzyInfo.setSpacingBefore(this.pgSpace);
            nzyInfo.setLeading(this.lineSpace);
            document.add((Element)nzyInfo);
            Paragraph chapter3Pg = new Paragraph("\u4e09\u3001\u9002\u5b9c\u6027\u8bc4\u4ef7", this.chapterFont);
            chapter3Pg.setExtraParagraphSpace(30.0f);
            chapter3Pg.setSpacingBefore(this.pgSpace);
            chapter3Pg.setLeading(this.lineSpace);
            document.add((Element)chapter3Pg);
            Paragraph tdzlPg = new Paragraph("\uff08\u4e00\uff09\u571f\u5730\u8d28\u91cf\u6761\u4ef6", this.sectionFont);
            tdzlPg.setExtraParagraphSpace(30.0f);
            tdzlPg.setSpacingBefore(this.pgSpace);
            tdzlPg.setLeading(this.lineSpace);
            document.add((Element)tdzlPg);
            String tdzlResult = String.format("\u62df\u9009\u5740\u5730\u5757\u7684\u5761\u5ea6\u8bc4\u5206\u4e3a%s\uff0c\u8015\u5730\u7b49\u522b\u8bc4\u5206\u4e3a%s\uff0c\u7530\u574e\u7cfb\u6570\u8bc4\u5206\u4e3a%s\u3002", info.pddj.score, info.gddb.score, info.kcxs.score);
            Paragraph tdzlInfo = new Paragraph(tdzlResult, this.normalFont);
            tdzlInfo.setFirstLineIndent(this.firstLineIndent);
            tdzlInfo.setExtraParagraphSpace(30.0f);
            tdzlInfo.setSpacingBefore(this.pgSpace);
            tdzlInfo.setLeading(this.lineSpace);
            document.add((Element)tdzlInfo);
            Paragraph gdqwPg = new Paragraph("\uff08\u4e8c\uff09\u8015\u5730\u533a\u4f4d\u6761\u4ef6", this.sectionFont);
            gdqwPg.setExtraParagraphSpace(30.0f);
            gdqwPg.setSpacingBefore(this.pgSpace);
            gdqwPg.setLeading(this.lineSpace);
            document.add((Element)gdqwPg);
            String gdqwResult = String.format("\u62df\u9009\u5740\u5730\u5757\u7684\u9053\u8def\u901a\u8fbe\u5ea6\u8bc4\u5206\u4e3a%s\uff0c\u4e0e\u5c45\u6c11\u70b9\u8ddd\u79bb\u533a\u4f4d\u6761\u4ef6\u8bc4\u5206\u4e3a%s\u3002", info.dlScore, info.jmdScore);
            Paragraph gdqwInfo = new Paragraph(gdqwResult, this.normalFont);
            gdqwInfo.setFirstLineIndent(this.firstLineIndent);
            gdqwInfo.setExtraParagraphSpace(30.0f);
            gdqwInfo.setSpacingBefore(this.pgSpace);
            gdqwInfo.setLeading(this.lineSpace);
            document.add((Element)gdqwInfo);
            Paragraph dkkjxtPg = new Paragraph("\uff08\u4e09\uff09\u5730\u5757\u7a7a\u95f4\u5f62\u6001", this.sectionFont);
            dkkjxtPg.setExtraParagraphSpace(30.0f);
            dkkjxtPg.setSpacingBefore(this.pgSpace);
            dkkjxtPg.setLeading(this.lineSpace);
            document.add((Element)dkkjxtPg);
            String dkkjxtResult = String.format("\u62df\u9009\u5740\u5730\u5757\u4e0e\u90bb\u8fd1\u7684\u6c38\u4e45\u57fa\u672c\u519c\u7530\u7684\u96c6\u4e2d\u8fde\u7247\u5ea6\u8bc4\u5206\u4e3a%s\u3002", info.jzlpScore);
            Paragraph dkkjxtInfo = new Paragraph(dkkjxtResult, this.normalFont);
            dkkjxtInfo.setFirstLineIndent(this.firstLineIndent);
            dkkjxtInfo.setExtraParagraphSpace(30.0f);
            dkkjxtInfo.setSpacingBefore(this.pgSpace);
            dkkjxtInfo.setLeading(this.lineSpace);
            document.add((Element)dkkjxtInfo);
            Paragraph chapter4Pg = new Paragraph("\u4e09\u3001\u603b\u4f53\u5206\u6790", this.chapterFont);
            chapter4Pg.setExtraParagraphSpace(30.0f);
            chapter4Pg.setSpacingBefore(this.pgSpace);
            chapter4Pg.setLeading(this.lineSpace);
            document.add((Element)chapter4Pg);
            double allScore = 0.25 * info.pddj.score + 0.21 * info.gddb.score + 0.12 * info.kcxs.score + 0.16 * info.dlScore + 0.1 * info.jmdScore + 0.16 * info.jzlpScore;
            boolean wf = false;
            if (info.jbntArea > 0.0) {
                wf = true;
            }
            if (info.sthxArea > 0.0) {
                wf = true;
            }
            if (info.bwdgdArea > 0.0) {
                wf = true;
            }
            if (info.dkgzd < 0.2) {
                wf = true;
            }
            if (info.czcdydArea > 0.0) {
                wf = true;
            }
            if (info.pewyMj > 0.0) {
                wf = true;
            }
            String zzpfResult = String.format("\u6839\u636e\u5df2\u6709\u6570\u636e\u5206\u6790\u7ed3\u679c\uff0c\u62df\u9009\u5740\u5730\u5757\u6700\u7ec8\u8bc4\u5206\u4e3a%s\u3002", wf ? 0.0 : allScore);
            Paragraph zzpfInfo = new Paragraph(zzpfResult, this.normalFont);
            zzpfInfo.setFirstLineIndent(this.firstLineIndent);
            zzpfInfo.setExtraParagraphSpace(30.0f);
            zzpfInfo.setSpacingBefore(this.pgSpace);
            zzpfInfo.setLeading(this.lineSpace);
            document.add((Element)zzpfInfo);
            this.AddSign(document, info);
            document.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (document != null && document.isOpen()) {
                document.close();
            }
        }
    }

    private void Parse(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String tn = tableName.toLowerCase();
            System.out.println("table:" + tn);
            switch (tn) {
                case "landtype_analyze": {
                    this.ParseLandType(db, tableName, info);
                    break;
                }
                case "landtype_analyze_image": {
                    this.ParseLandTypeImage(db, tableName, info);
                    break;
                }
                case "ownership_analyze": {
                    this.ParseOwnerShip(db, tableName, info);
                    break;
                }
                case "ownership_analyze_image": {
                    this.ParseOwnerShipImage(db, tableName, info);
                    break;
                }
                case "primefarm_analyze": {
                    this.ParsePrimeFarm(db, tableName, info);
                    break;
                }
                case "primefarm_analyze_image": {
                    this.ParsePrimeFarmImage(db, tableName, info);
                    break;
                }
                case "plan_analyze": {
                    this.ParseTdgh(db, tableName, info);
                    break;
                }
                case "plan_analyze_image": {
                    this.ParseTdghImage(db, tableName, info);
                    break;
                }
                case "spba_analyze": {
                    this.ParseSpba(db, tableName, info);
                    break;
                }
                case "spba_analyze_image": {
                    this.ParseSpbaImage(db, tableName, info);
                    break;
                }
                case "naturereserve_analyze": {
                    this.ParseZrbhq(db, tableName, info);
                    break;
                }
                case "naturereserve_analyze_image": {
                    this.ParseZrbhqImage(db, tableName, info);
                    break;
                }
                case "dzfx_analyze": {
                    this.ParseDzfx(db, tableName, info);
                    break;
                }
                case "dzfx_analyze_image": {
                    this.ParseDzfxImage(db, tableName, info);
                    break;
                }
                case "ecologicalland_analyze": {
                    this.ParseEcologicalLand(db, tableName, info);
                    break;
                }
                case "ecologicalland_analyze_image": {
                    this.ParseEcologicalLandImage(db, tableName, info);
                    break;
                }
                case "landprice_analyze": {
                    this.ParseLandPrice(db, tableName, info);
                    break;
                }
                case "landprice_analyze_image": {
                    this.ParseLandPriceImage(db, tableName, info);
                    break;
                }
                case "aggregate_analyze": {
                    this.ParseLandUseGrade(db, tableName, info);
                    break;
                }
                case "aggregate_analyze_image": {
                    this.ParseLandUseGradeImage(db, tableName, info);
                    break;
                }
                case "image_analyze": {
                    info.ownershipImgMeta = this.GetImageMeta(db, "Image_Analyze");
                    break;
                }
                case "pxstbhhx_analyze": {
                    this.ParsePxStbhhx(db, tableName, info);
                    break;
                }
                case "pxstbhhx_analyze_image": {
                    this.ParsePxStbhhxImage(db, tableName, info);
                    break;
                }
                case "pxgyl_analyze": {
                    this.ParsePxGyl(db, tableName, info);
                    break;
                }
                case "pxgyl_analyze_image": {
                    this.ParsePxGylImage(db, tableName, info);
                    break;
                }
                case "pxpd_analyze": {
                    this.ParsePxPd(db, tableName, info);
                    break;
                }
                case "pxpd_analyze_image": {
                    this.ParsePxPdImage(db, tableName, info);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        try {
            String tn = tableName.toLowerCase();
            System.out.println("table:" + tn);
            switch (tn) {
                case "landtype_analyze": {
                    this.ParseLandTypeLawless(db, tableName, info);
                    break;
                }
                case "landtype_analyze_image": {
                    this.ParseLandTypeImageLawless(db, tableName, info);
                    break;
                }
                case "ownership_analyze": {
                    this.ParseOwnerShipLawless(db, tableName, info);
                    break;
                }
                case "ownership_analyze_image": {
                    this.ParseOwnerShipImageLawless(db, tableName, info);
                    break;
                }
                case "primefarm_analyze": {
                    this.ParsePrimeFarmLawless(db, tableName, info);
                    break;
                }
                case "primefarm_analyze_image": {
                    this.ParsePrimeFarmImageLawless(db, tableName, info);
                    break;
                }
                case "plan_analyze": {
                    this.ParseTdghLawless(db, tableName, info);
                    break;
                }
                case "plan_analyze_image": {
                    this.ParseTdghImageLawless(db, tableName, info);
                    break;
                }
                case "spba_analyze": {
                    this.ParseSpbaLawless(db, tableName, info);
                    break;
                }
                case "spba_analyze_image": {
                    this.ParseSpbaImageLawless(db, tableName, info);
                    break;
                }
                case "naturereserve_analyze": {
                    this.ParseZrbhqLawless(db, tableName, info);
                    break;
                }
                case "naturereserve_analyze_image": {
                    this.ParseZrbhqImageLawless(db, tableName, info);
                    break;
                }
                case "image_analyze": {
                    info.ownershipImgMeta = this.GetImageMeta(db, "Image_Analyze");
                    this.ParseLawlessImgCompare(db, tableName, info);
                    break;
                }
                case "jctb_analyze": {
                    this.ParseJctb(db, tableName, info);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseYnbh(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String tn = tableName.toLowerCase();
            System.out.println("table:" + tn);
            switch (tn) {
                case "primefarm_analyze": {
                    this.ParsePrimeFarmYn(db, tableName, info);
                    break;
                }
                case "sthx_analyze": {
                    this.ParseSthxYn(db, tableName, info);
                    break;
                }
                case "bwdgd_analyze": {
                    this.ParseBwdgdYn(db, tableName, info);
                    break;
                }
                case "sdczcdyd_analyze": {
                    this.ParseCzcdydYn(db, tableName, info);
                    break;
                }
                case "hhax_analyze": {
                    this.ParseHhaxYn(db, tableName, info);
                    break;
                }
                case "pewy_analyze": {
                    this.ParsePewyYn(db, tableName, info);
                    break;
                }
                case "ssnyd_analyze": {
                    this.ParseSsnydYn(db, tableName, info);
                    break;
                }
                case "pddjavg_analyze": {
                    this.ParsePddjYn(db, tableName, info);
                    break;
                }
                case "gddbavg_analyze": {
                    this.ParseGddbYn(db, tableName, info);
                    break;
                }
                case "kcxsavg_analyze": {
                    this.ParseKcxsYn(db, tableName, info);
                    break;
                }
                case "dlbuffer_analyze": {
                    this.ParseDlYn(db, tableName, info);
                    break;
                }
                case "jmdbuffer_analyze": {
                    this.ParseJmdYn(db, tableName, info);
                    break;
                }
                case "jbntbuffer_analyze": {
                    this.ParseJzlpYn(db, tableName, info);
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePrimeFarmYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                if (set.findColumn("type") >= 0) {
                    String type = set.getString("type");
                    if (!"\u57fa\u672c\u519c\u7530".equals(type)) continue;
                    double mj = set.getDouble("mj");
                    area += mj;
                    continue;
                }
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.jbntArea = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseSthxYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.sthxArea = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseBwdgdYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ArrayList<String> dlbms = new ArrayList<String>();
            dlbms.add("010");
            dlbms.add("011");
            dlbms.add("012");
            dlbms.add("013");
            dlbms.add("0100");
            dlbms.add("0101");
            dlbms.add("0102");
            dlbms.add("0103");
            ArrayList<String> tbxhdms = new ArrayList<String>();
            tbxhdms.add("LQGD");
            tbxhdms.add("MQGD");
            tbxhdms.add("SMGD");
            tbxhdms.add("SHGD");
            tbxhdms.add("HDGD");
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String dlbm = set.getString("dlbm");
                String tbxhdm = set.getString("tbxhdm");
                String pddj = set.getString("gdpddj");
                boolean iswdgd = true;
                if (StringUtils.isBlank((CharSequence)dlbm) || !dlbms.contains(dlbm)) {
                    iswdgd = false;
                } else if (StringUtils.isBlank((CharSequence)tbxhdm) || tbxhdm.contains(tbxhdm.toUpperCase())) {
                    iswdgd = false;
                } else if (StringUtils.isNotBlank((CharSequence)pddj) && pddj.equals(5)) {
                    iswdgd = false;
                }
                if (iswdgd) continue;
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.bwdgdArea = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseCzcdydYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ArrayList<String> czclxs = new ArrayList<String>();
            czclxs.add("201");
            czclxs.add("202");
            czclxs.add("203");
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String czclx = set.getString("czclx");
                if (!StringUtils.isNotBlank((CharSequence)czclx) || !czclxs.contains(czclx)) continue;
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.czcdydArea = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseHhaxYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.hhaxMj = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePewyYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.pewyMj = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseSsnydYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.ssnydMj = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePddjYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double mj = 0.0;
            double pgdMj = 0.0;
            double pdttMj = 0.0;
            double maxPdjb = 0.0;
            double pgdPdjb = 0.0;
            ResultSet set = result.getResultSet();
            if (set.next()) {
                mj = set.getDouble("mj");
                pgdMj = set.getDouble("pgd_area");
                pdttMj = set.getDouble("pdtt_area");
                maxPdjb = set.getDouble("max_pdjb");
                pgdPdjb = set.getDouble("pgd_pdjb");
            }
            double pddj = pdttMj / mj * 100.0 + pgdMj / mj * ((maxPdjb - pgdPdjb) / maxPdjb * 100.0);
            DecimalFormat df = new DecimalFormat("#.00");
            info.pddj = new YnbhInfo.Pddj();
            info.pddj.area = mj;
            info.pddj.maxPdjb = maxPdjb;
            info.pddj.pgdPdjb = pgdPdjb;
            info.pddj.pdttArea = pdttMj;
            info.pddj.pgdArea = pgdMj;
            info.pddj.score = Double.parseDouble(df.format(pddj));
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseGddbYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double mj = 0.0;
            double maxGddb = 0.0;
            double avgGddb = 0.0;
            ResultSet set = result.getResultSet();
            if (set.next()) {
                mj = set.getDouble("mj");
                maxGddb = set.getDouble("max_gddb");
                avgGddb = set.getDouble("avg_gddb");
            }
            double gddb = avgGddb;
            Double score = 0.0;
            score = gddb >= 1.0 && gddb <= 4.0 ? Double.valueOf(100.0) : (gddb > 4.0 && gddb <= 8.0 ? Double.valueOf(80.0) : (gddb > 8.0 && gddb <= 12.0 ? Double.valueOf(60.0) : Double.valueOf(30.0)));
            info.gddb = new YnbhInfo.Gddb();
            info.gddb.area = mj;
            info.gddb.maxGddb = maxGddb;
            info.gddb.avgGddb = avgGddb;
            info.gddb.score = score;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseKcxsYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double mj = 0.0;
            double maxKcxs = 0.0;
            double avgKcxs = 0.0;
            ResultSet set = result.getResultSet();
            if (set.next()) {
                mj = set.getDouble("mj");
                maxKcxs = set.getDouble("max_kcxs");
                avgKcxs = set.getDouble("avg_kcxs");
            }
            double kcxs = (maxKcxs - avgKcxs) / maxKcxs * 100.0;
            DecimalFormat df = new DecimalFormat("#.00");
            info.kcxs = new YnbhInfo.Kcxs();
            info.kcxs.area = mj;
            info.kcxs.maxKcxs = maxKcxs;
            info.kcxs.avgKcxs = avgKcxs;
            info.kcxs.score = Double.parseDouble(df.format(kcxs));
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseDlYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double buffer = 0.0;
            ResultSet set = result.getResultSet();
            if (set.next()) {
                buffer = set.getDouble("buffer");
            }
            info.dlScore = 0.0;
            if (buffer == 100.0) {
                info.dlScore = 100.0;
            } else if (buffer == 500.0) {
                info.dlScore = 80.0;
            } else if (buffer == 1000.0) {
                info.dlScore = 40.0;
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseJmdYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double buffer = 0.0;
            ResultSet set = result.getResultSet();
            if (set.next()) {
                buffer = set.getDouble("buffer");
            }
            info.jmdScore = 0.0;
            if (buffer == 100.0) {
                info.jmdScore = 100.0;
            } else if (buffer == 500.0) {
                info.jmdScore = 80.0;
            } else if (buffer == 1000.0) {
                info.jmdScore = 40.0;
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseJzlpYn(SqlliteConnTool db, String tableName, YnbhInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double buffer = 0.0;
            ResultSet set = result.getResultSet();
            if (set.next()) {
                buffer = set.getDouble("buffer");
            }
            info.jzlpScore = 0.0;
            if (buffer == 100.0) {
                info.jzlpScore = 100.0;
            } else if (buffer == 500.0) {
                info.jzlpScore = 80.0;
            } else if (buffer == 1000.0) {
                info.jzlpScore = 40.0;
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseLandType(SqlliteConnTool db, String tableName, ProjectInfo info) throws SQLException {
        try {
            String sql;
            ResultSetInfo result;
            if (info.landTypes == null) {
                info.landTypes = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                LandType land = new LandType();
                land.dlmc = set.getString("name");
                land.dlbm = set.getString("code");
                land.area = set.getDouble("mj");
                info.landTypes.add(land);
            }
            Collections.sort(info.landTypes);
            Collections.reverse(info.landTypes);
            int count = 0;
            int leng = info.landTypes.size();
            String dlInfo = "";
            double otherArea = 0.0;
            for (LandType item : info.landTypes) {
                if (++count > 2) {
                    otherArea += item.area;
                    continue;
                }
                dlInfo = dlInfo + item.dlmc + this.Round(item.area, 2) + "\u4ea9";
                if (count >= leng) continue;
                dlInfo = dlInfo + "/";
            }
            if (otherArea > 0.0) {
                dlInfo = dlInfo + "\u5176\u4ed6" + this.Round(otherArea, 2) + "\u4ea9";
            }
            info.landtypeImgMeta = dlInfo;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseLandTypeImage(SqlliteConnTool db, String tableName, ProjectInfo info) throws SQLException {
        Image img;
        info.landtypeImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseLandTypeLawless(SqlliteConnTool db, String tableName, LawlessInfo info) throws SQLException {
        try {
            String sql;
            ResultSetInfo result;
            if (info.landTypes == null) {
                info.landTypes = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                LandType land = new LandType();
                land.dlmc = set.getString("name");
                land.dlbm = set.getString("code");
                land.area = set.getDouble("mj");
                info.landTypes.add(land);
            }
            Collections.sort(info.landTypes);
            Collections.reverse(info.landTypes);
            int count = 0;
            int leng = info.landTypes.size();
            String dlInfo = "";
            double otherArea = 0.0;
            for (LandType item : info.landTypes) {
                if (++count > 2) {
                    otherArea += item.area;
                    continue;
                }
                dlInfo = dlInfo + item.dlmc + this.Round(item.area, 2) + "\u4ea9";
                if (count >= leng) continue;
                dlInfo = dlInfo + "/";
            }
            if (otherArea > 0.0) {
                dlInfo = dlInfo + "\u5176\u4ed6" + this.Round(otherArea, 2) + "\u4ea9";
            }
            info.landtypeImgMeta = dlInfo;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseLandTypeImageLawless(SqlliteConnTool db, String tableName, LawlessInfo info) throws SQLException {
        Image img;
        info.landtypeImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseOwnerShip(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql;
            ResultSetInfo result;
            if (info.ownerships == null) {
                info.ownerships = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                Ownership owner = new Ownership();
                String code = set.getString("owner_dept_name");
                String name = set.getString("owner_dept_code");
                String jsonStr = set.getString("area_detail");
                double area = set.getDouble("mj");
                JSONObject json = JSONObject.parseObject((String)jsonStr);
                OwnerDetailInfo detail = (OwnerDetailInfo)JSON.toJavaObject((JSON)json, OwnerDetailInfo.class);
                owner.qsmc = name;
                owner.qsdm = code;
                owner.area = area;
                owner.detail = detail;
                info.ownerships.add(owner);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseOwnerShipImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.ownershipImg = img = this.GetImageByBlob(db, tableName, 1);
    }

    private void ParseOwnerShipLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        try {
            String sql;
            ResultSetInfo result;
            if (info.ownerships == null) {
                info.ownerships = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                Ownership owner = new Ownership();
                String code = set.getString("owner_dept_name");
                String name = set.getString("owner_dept_code");
                String jsonStr = set.getString("area_detail");
                double area = set.getDouble("mj");
                JSONObject json = JSONObject.parseObject((String)jsonStr);
                OwnerDetailInfo detail = (OwnerDetailInfo)JSON.toJavaObject((JSON)json, OwnerDetailInfo.class);
                owner.qsmc = name;
                owner.qsdm = code;
                owner.area = area;
                owner.detail = detail;
                info.ownerships.add(owner);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseOwnerShipImageLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        Image img;
        info.ownershipImg = img = this.GetImageByBlob(db, tableName, 1);
    }

    private void ParsePrimeFarm(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String type = set.getString("type");
                if (!"\u57fa\u672c\u519c\u7530".equals(type)) continue;
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.jbntArea = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePrimeFarmImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.jbntImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParsePrimeFarmLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String type = set.getString("type");
                if (!"\u57fa\u672c\u519c\u7530".equals(type)) continue;
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.jbntArea = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePrimeFarmImageLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        Image img;
        info.jbntImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseTdgh(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql;
            ResultSetInfo result;
            if (info.tdghInfos == null) {
                info.tdghInfos = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                TdghInfo tdgh = new TdghInfo();
                tdgh.jsbm = set.getString("code");
                tdgh.jsmc = set.getString("type");
                tdgh.area = set.getDouble("mj");
                info.tdghInfos.add(tdgh);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseTdghImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.tdghImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseTdghLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        try {
            String sql;
            ResultSetInfo result;
            if (info.tdghInfos == null) {
                info.tdghInfos = new ArrayList();
            }
            if ((result = db.doQuery(sql = "select * from " + tableName)) == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            while (set.next()) {
                TdghInfo tdgh = new TdghInfo();
                tdgh.jsbm = set.getString("code");
                tdgh.jsmc = set.getString("type");
                tdgh.area = set.getDouble("mj");
                info.tdghInfos.add(tdgh);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseTdghImageLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        Image img;
        info.tdghImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseSpba(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select license_number, sum(approval_mj) approval_mj from " + tableName + " group by license_number";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            ArrayList<SpbaInfo> spbaArr = new ArrayList<SpbaInfo>();
            while (set.next()) {
                SpbaInfo spba = new SpbaInfo();
                spba.area = set.getDouble("approval_mj");
                String license = set.getString("license_number") + "";
                if (license == null || license.isEmpty()) {
                    license = "\u672a\u77e5";
                }
                spba.license = license;
                spbaArr.add(spba);
            }
            info.spbaInfos = spbaArr;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseSpbaImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.spbaImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseSpbaLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        try {
            String sql = "select license_number, sum(approval_mj) approval_mj from " + tableName + " group by license_number";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            ArrayList<SpbaInfo> spbaArr = new ArrayList<SpbaInfo>();
            while (set.next()) {
                SpbaInfo spba = new SpbaInfo();
                spba.area = set.getDouble("approval_mj");
                String license = set.getString("license_number") + "";
                if (license == null || license.isEmpty()) {
                    license = "\u672a\u77e5";
                }
                spba.license = license;
                spbaArr.add(spba);
            }
            info.spbaInfos = spbaArr;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseSpbaImageLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        Image img;
        info.spbaImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseZrbhq(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select sum(mj) from " + tableName;
            Object obj = db.queryScale(sql);
            if (obj != null) {
                double area = Double.valueOf(obj.toString());
                info.zrbhqArea = area;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseZrbhqImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.zrbhqImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseZrbhqLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        try {
            String sql = "select sum(mj) from " + tableName;
            Object obj = db.queryScale(sql);
            if (obj != null) {
                double area;
                info.zrbhqArea = area = Double.valueOf(obj.toString()).doubleValue();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseZrbhqImageLawless(SqlliteConnTool db, String tableName, LawlessInfo info) {
        Image img;
        info.zrbhqImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseDzfx(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select level,sum(area) area from " + tableName + " group by level";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            ArrayList<DzfxInfo> dzfxArr = new ArrayList<DzfxInfo>();
            while (set.next()) {
                DzfxInfo dzfx = new DzfxInfo();
                dzfx.area = set.getDouble("area");
                String level = set.getString("level") + "";
                if (level == null || level.isEmpty()) {
                    level = "\u672a\u77e5";
                }
                dzfx.level = level;
                dzfxArr.add(dzfx);
            }
            info.dzfxInfos = dzfxArr;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseDzfxImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.dzfxImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseEcologicalLand(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select sum(area) from" + tableName;
            Object obj = db.queryScale(sql);
            if (obj != null) {
                double area = Double.valueOf(obj.toString());
                info.sdArea = area;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseEcologicalLandImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.sdImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseLandPrice(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select sum(area) mj,sum(price) price from" + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            double mj = 0.0;
            double price = 0.0;
            while (set.next()) {
                mj = set.getDouble("mj");
                price = set.getDouble("price");
            }
            info.landPrice = mj == 0.0 ? 0.0 : price / mj;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseLandPriceImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.landPriceImg = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParseLandUseGrade(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select content from " + tableName + " where analyze_name ='\u571f\u5730\u5229\u7528\u7b49\u522b\u5206\u6790'";
            Object obj = db.queryScale(sql);
            if (obj == null) {
                return;
            }
            String jsonStr = obj.toString();
            List detail = JSONArray.parseArray((String)jsonStr, LandUseGrade.class);
            if (detail != null) {
                for (LandUseGrade lg : detail) {
                    lg.field1 = lg.field1.replace(",", "-");
                }
            }
            info.gradeInfos = (ArrayList)detail;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParseLandUseGradeImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.gradeImg = img = this.GetImageByBlob(db, tableName, "\u571f\u5730\u5229\u7528\u7b49\u522b\u5206\u6790", 0);
    }

    private void ParseJctb(SqlliteConnTool db, String tableName, LawlessInfo info) {
        try {
            String sql = "select tblx,sum(mj) as mj from " + tableName + " group by tblx";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            info.jctbMap = new HashMap();
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String type = set.getString("tblx");
                double mj = set.getDouble("mj");
                info.jctbMap.put(type, mj);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePxStbhhx(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select * from " + tableName;
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String type = set.getString("type");
                if (!"\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf".equals(type)) continue;
                double mj = set.getDouble("mj");
                area += mj;
            }
            info.px_stbhhx_area = area;
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePxStbhhxImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.px_stbhhx_Img = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParsePxGyl(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select sum(mj) as mj from " + tableName;
            Object obj = db.queryScale(sql);
            if (obj != null) {
                double area = 0.0;
                area = Double.parseDouble(obj.toString());
                info.px_gyl_area = area;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePxGylImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.px_gyl_img = img = this.GetImageByBlob(db, tableName, 0);
    }

    private void ParsePxPd(SqlliteConnTool db, String tableName, ProjectInfo info) {
        try {
            String sql = "select pdjb,sum(mj) as mj from " + tableName + " group by pdjb";
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            info.px_pd = new HashMap();
            double area = 0.0;
            ResultSet set = result.getResultSet();
            while (set.next()) {
                String type = set.getString("pdjb");
                double mj = set.getDouble("mj");
                info.px_pd.put(type, mj);
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void ParsePxPdImage(SqlliteConnTool db, String tableName, ProjectInfo info) {
        Image img;
        info.px_pd_img = img = this.GetImageByBlob(db, tableName, 0);
    }

    private Image GetImageByBlob(SqlliteConnTool db, String tableName, int imageType) {
        try {
            byte[] imgBytes;
            Image img = null;
            String sql = "select layer_pic from " + tableName + " where image_type = " + imageType;
            ResultSetInfo info = db.doQuery(sql);
            if (info == null) {
                return null;
            }
            ResultSet set = info.getResultSet();
            if (set.next() && (imgBytes = set.getBytes("layer_pic")) != null) {
                img = Image.getInstance((byte[])imgBytes);
            }
            info.Close();
            return img;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    private Image GetImageByBlob(SqlliteConnTool db, String tableName, String analyzeName, int imageType) {
        try {
            byte[] imgBytes;
            Image img = null;
            String sql = "select layer_pic from " + tableName + " where analyze_name = '" + analyzeName + "' and image_subtype = " + imageType;
            ResultSetInfo info = db.doQuery(sql);
            if (info == null) {
                return null;
            }
            ResultSet set = info.getResultSet();
            if (set.next() && (imgBytes = set.getBytes("layer_pic")) != null) {
                img = Image.getInstance((byte[])imgBytes);
            }
            info.Close();
            return img;
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            return null;
        }
    }

    private String GetImageMeta(SqlliteConnTool db, String tableName) {
        String sql = "select meta_info from Image_Analyze where date is not null order by date desc limit 1";
        Object obj = db.queryScale(sql);
        if (obj == null) {
            return null;
        }
        String sjy = "";
        String sx = "";
        String jsonStr = obj.toString();
        JSONObject json = JSONObject.parseObject((String)jsonStr);
        if (json.containsKey((Object)"SJY")) {
            sjy = json.getString("SJY");
        }
        if (json.containsKey((Object)"SX")) {
            sx = json.getString("SX");
        }
        if (sjy == null || sjy.isEmpty()) {
            sjy = "\u672a\u77e5";
        }
        if (sx == null || sx.isEmpty()) {
            sx = "\u672a\u77e5";
        }
        String meta = "\u6570\u636e\u6e90\uff1a" + sjy + " \u65f6\u76f8\uff1a" + sx;
        return meta;
    }

    private void ParseLawlessImgCompare(SqlliteConnTool db, String tableName, LawlessInfo info) {
        String sql = "select * from Image_Analyze where date is not null order by date  desc limit 2";
        try {
            ResultSetInfo result = db.doQuery(sql);
            if (result == null) {
                return;
            }
            ResultSet set = result.getResultSet();
            int count = 0;
            while (set.next()) {
                String date;
                ++count;
                Image img = null;
                String meta = "";
                String year = "";
                byte[] imgBytes = set.getBytes("layer_pic");
                if (imgBytes != null) {
                    img = Image.getInstance((byte[])imgBytes);
                }
                if ((date = set.getString("date")) != null && !date.isEmpty() && date.length() >= 4) {
                    year = date.substring(0, 4);
                }
                String sjy = "";
                String sx = "";
                String jsonStr = set.getString("meta_info");
                JSONObject json = JSONObject.parseObject((String)jsonStr);
                if (json.containsKey((Object)"SJY")) {
                    sjy = json.getString("SJY");
                }
                if (json.containsKey((Object)"SX")) {
                    sx = json.getString("SX");
                }
                if (sjy == null || sjy.isEmpty()) {
                    sjy = "\u672a\u77e5";
                }
                if (sx == null || sx.isEmpty()) {
                    sx = "\u672a\u77e5";
                }
                meta = sjy + " " + sx;
                if (count == 1) {
                    info.year2 = year;
                    info.image2 = img;
                    info.imageMeta2 = meta;
                    continue;
                }
                info.year1 = year;
                info.image1 = img;
                info.imageMeta1 = meta;
            }
            result.Close();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private double Round(double value, int count) {
        String formate = "#.";
        for (int i = 0; i < count; ++i) {
            formate = formate + "0";
        }
        String temp = new DecimalFormat(formate).format(value);
        return Double.parseDouble(temp);
    }

    private void BaseInfo(Document document, ProjectInfo info, ResultInfo result) throws DocumentException, IOException {
        Paragraph chapter1Pg = new Paragraph("\u4e00\u3001\u57fa\u672c\u60c5\u51b5", this.chapterFont);
        chapter1Pg.setExtraParagraphSpace(30.0f);
        chapter1Pg.setSpacingBefore(this.pgSpace);
        chapter1Pg.setLeading(this.lineSpace);
        document.add((Element)chapter1Pg);
        String content = "%s\u9879\u76ee\u4f4d\u4e8e%s%s%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u9879\u76ee\u5730\u5757\u9762\u79ef%s\u4ea9\u3002";
        content = String.format(content, info.projectName, info.provinceName, info.cityName, info.countyName, info.villageName, info.lontitude, info.latitude, String.valueOf(this.Round(info.area, 2)));
        String dlinfo = "";
        int lengLy = 0;
        int lengOw = 0;
        if (info.landTypes != null && info.landTypes.size() > 0) {
            lengLy = info.landTypes.size();
        }
        if (info.ownerships != null && info.ownerships.size() > 0) {
            lengOw = info.ownerships.size();
        }
        if (lengLy > 0) {
            dlinfo = "\u571f\u5730\u5229\u7528\u73b0\u72b6\uff1a";
            double otherArea = 0.0;
            int count = 0;
            for (LandType item : info.landTypes) {
                if (++count > 2) {
                    otherArea += item.area;
                    continue;
                }
                dlinfo = dlinfo + item.dlmc + this.Round(item.area, 2) + "\u4ea9";
                if (count >= lengLy) continue;
                dlinfo = dlinfo + "\u3001";
            }
            if (otherArea > 0.0) {
                dlinfo = dlinfo + "\u5176\u4ed6" + this.Round(otherArea, 2) + "\u4ea9";
            }
            dlinfo = lengOw > 0 ? dlinfo + "\uff1b" : dlinfo + "\u3002";
        }
        if (lengOw > 0) {
            dlinfo = dlinfo + "\u571f\u5730\u6743\u5c5e\u4e3a";
            HashMap<String, Double> dic = new HashMap<String, Double>();
            dic.put("\u56fd\u6709", 0.0);
            dic.put("\u96c6\u4f53", 0.0);
            dic.put("\u5176\u4ed6", 0.0);
            for (Ownership item : info.ownerships) {
                if (item.detail == null) continue;
                dic.put("\u56fd\u6709", (Double)dic.get("\u56fd\u6709") + item.detail.lx10);
                dic.put("\u56fd\u6709", (Double)dic.get("\u56fd\u6709") + item.detail.lx20);
                dic.put("\u96c6\u4f53", (Double)dic.get("\u96c6\u4f53") + item.detail.lx30);
                dic.put("\u96c6\u4f53", (Double)dic.get("\u96c6\u4f53") + item.detail.lx40);
                dic.put("\u5176\u4ed6", (Double)dic.get("\u5176\u4ed6") + item.detail.lx99);
            }
            if (this.Round((Double)dic.get("\u56fd\u6709"), 2) > 0.0) {
                dlinfo = dlinfo + "\u56fd\u6709" + this.Round((Double)dic.get("\u56fd\u6709"), 2) + "\u4ea9\u3001";
            }
            if (this.Round((Double)dic.get("\u96c6\u4f53"), 2) > 0.0) {
                dlinfo = dlinfo + "\u96c6\u4f53" + this.Round((Double)dic.get("\u96c6\u4f53"), 2) + "\u4ea9\u3001";
            }
            if (this.Round((Double)dic.get("\u5176\u4ed6"), 2) > 0.0) {
                dlinfo = dlinfo + "\u5176\u4ed6" + this.Round((Double)dic.get("\u5176\u4ed6"), 2) + "\u4ea9\u3001";
            }
            if (dlinfo.endsWith("\u3001")) {
                dlinfo = dlinfo.substring(0, dlinfo.length() - 1) + "\u3002";
            }
        }
        content = content + dlinfo;
        Paragraph baseInfo = new Paragraph(content, this.normalFont);
        baseInfo.setFirstLineIndent(this.firstLineIndent);
        baseInfo.setExtraParagraphSpace(30.0f);
        baseInfo.setSpacingBefore(this.pgSpace);
        baseInfo.setLeading(this.lineSpace);
        document.add((Element)baseInfo);
        this.AddBaseImg(document, info);
    }

    private void BaseInfoLawless(Document document, LawlessInfo info, ResultInfo result) throws DocumentException, IOException {
        Paragraph chapter1Pg = new Paragraph("\u4e00\u3001\u57fa\u672c\u60c5\u51b5", this.chapterFont);
        chapter1Pg.setExtraParagraphSpace(30.0f);
        chapter1Pg.setSpacingBefore(this.pgSpace);
        chapter1Pg.setLeading(this.lineSpace);
        document.add((Element)chapter1Pg);
        String content = "\u8be5\u9065\u611f\u76d1\u6d4b\u7591\u4f3c\u8fdd\u6cd5\u7528\u5730\u4f4d\u4e8e%s%s%s\uff08\u4e1c\u7ecf\uff1a%s\u00b0\uff0c\u5317\u7eac\uff1a%s\u00b0\uff09\uff0c\u76d1\u6d4b\u9762\u79ef%s\u4ea9\u3002";
        content = String.format(content, info.provinceName, info.cityName, info.countyName, info.lontitude, info.latitude, String.valueOf(this.Round(info.area, 2)));
        String dlinfo = "";
        int lengLy = 0;
        int lengOw = 0;
        if (info.landTypes != null && info.landTypes.size() > 0) {
            lengLy = info.landTypes.size();
        }
        if (info.ownerships != null && info.ownerships.size() > 0) {
            lengOw = info.ownerships.size();
        }
        if (lengLy > 0) {
            dlinfo = "\u571f\u5730\u5229\u7528\u73b0\u72b6\uff1a";
            double otherArea = 0.0;
            int count = 0;
            for (LandType item : info.landTypes) {
                if (++count > 2) {
                    otherArea += item.area;
                    continue;
                }
                dlinfo = dlinfo + item.dlmc + this.Round(item.area, 2) + "\u4ea9";
                if (count >= lengLy) continue;
                dlinfo = dlinfo + "\u3001";
            }
            if (otherArea > 0.0) {
                dlinfo = dlinfo + "\u5176\u4ed6" + this.Round(otherArea, 2) + "\u4ea9";
            }
            dlinfo = lengOw > 0 ? dlinfo + "\uff1b" : dlinfo + "\u3002";
        }
        if (lengOw > 0) {
            dlinfo = dlinfo + "\u571f\u5730\u6743\u5c5e\u4e3a";
            HashMap<String, Double> dic = new HashMap<String, Double>();
            dic.put("\u56fd\u6709", 0.0);
            dic.put("\u96c6\u4f53", 0.0);
            dic.put("\u5176\u4ed6", 0.0);
            for (Ownership item : info.ownerships) {
                if (item.detail == null) continue;
                dic.put("\u56fd\u6709", (Double)dic.get("\u56fd\u6709") + item.detail.lx10);
                dic.put("\u56fd\u6709", (Double)dic.get("\u56fd\u6709") + item.detail.lx20);
                dic.put("\u96c6\u4f53", (Double)dic.get("\u96c6\u4f53") + item.detail.lx30);
                dic.put("\u96c6\u4f53", (Double)dic.get("\u96c6\u4f53") + item.detail.lx40);
                dic.put("\u5176\u4ed6", (Double)dic.get("\u5176\u4ed6") + item.detail.lx99);
            }
            if (this.Round((Double)dic.get("\u56fd\u6709"), 2) > 0.0) {
                dlinfo = dlinfo + "\u56fd\u6709" + this.Round((Double)dic.get("\u56fd\u6709"), 2) + "\u4ea9\u3001";
            }
            if (this.Round((Double)dic.get("\u96c6\u4f53"), 2) > 0.0) {
                dlinfo = dlinfo + "\u96c6\u4f53" + this.Round((Double)dic.get("\u96c6\u4f53"), 2) + "\u4ea9\u3001";
            }
            if (this.Round((Double)dic.get("\u5176\u4ed6"), 2) > 0.0) {
                dlinfo = dlinfo + "\u5176\u4ed6" + this.Round((Double)dic.get("\u5176\u4ed6"), 2) + "\u4ea9\u3001";
            }
            if (dlinfo.endsWith("\u3001")) {
                dlinfo = dlinfo.substring(0, dlinfo.length() - 1) + "\u3002";
            }
        }
        content = content + dlinfo;
        Paragraph baseInfo = new Paragraph(content, this.normalFont);
        baseInfo.setFirstLineIndent(this.firstLineIndent);
        baseInfo.setExtraParagraphSpace(30.0f);
        baseInfo.setSpacingBefore(this.pgSpace);
        baseInfo.setLeading(this.lineSpace);
        document.add((Element)baseInfo);
        this.AddBaseImgLawless(document, info);
    }

    private void JcqkAnalysis(Document document, LawlessInfo info, ResultInfo result) throws DocumentException {
        Paragraph chapter2Pg = new Paragraph("\u4e8c\u3001\u76d1\u6d4b\u60c5\u51b5\u5206\u6790", this.chapterFont);
        chapter2Pg.setExtraParagraphSpace(30.0f);
        chapter2Pg.setSpacingBefore(this.pgSpace);
        chapter2Pg.setLeading(this.lineSpace);
        document.add((Element)chapter2Pg);
        Paragraph comparePg = new Paragraph("(\u4e00)\u4e24\u671f\u5f71\u50cf\u6bd4\u5bf9\u63d0\u53d6", this.sectionFont);
        comparePg.setExtraParagraphSpace(30.0f);
        comparePg.setSpacingBefore(this.pgSpace);
        comparePg.setLeading(this.lineSpace);
        document.add((Element)comparePg);
        if (info.narrow) {
            this.AddImg2(document, info.year1 + "\u5ea6\u5f71\u50cf", info.image1, info.imageMeta1, true, false);
            this.AddImg2(document, info.year2 + "\u5ea6\u5f71\u50cf", info.image2, info.imageMeta2, false, true);
        } else {
            PdfPTable t = new PdfPTable(2);
            t.setSpacingBefore(this.pgSpace);
            t.setSpacingAfter(this.pgSpace);
            t.setWidthPercentage(100.0f);
            PdfPCell c1 = null;
            c1 = new PdfPCell(new Phrase(info.year1 + "\u5ea6\u5f71\u50cf", this.normalFont));
            c1.setVerticalAlignment(1);
            c1.setHorizontalAlignment(1);
            c1.setPaddingTop(5.0f);
            c1.setPaddingBottom(5.0f);
            PdfPCell c2 = null;
            c2 = new PdfPCell(new Phrase(info.year2 + "\u5ea6\u5f71\u50cf", this.normalFont));
            c2.setVerticalAlignment(1);
            c2.setHorizontalAlignment(1);
            c2.setPaddingTop(5.0f);
            c2.setPaddingBottom(5.0f);
            PdfPCell cimg1 = null;
            float width = 250.0f;
            float heigth = 250.0f;
            if (info.image1 != null) {
                heigth = info.image1.getHeight() / (info.image1.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.image1.scaleToFit(width, heigth);
                cimg1 = new PdfPCell(info.image1);
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            } else {
                cimg1 = new PdfPCell();
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            }
            PdfPCell cimg2 = null;
            if (info.image2 != null) {
                heigth = info.image2.getHeight() / (info.image2.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.image2.scaleToFit(width, heigth);
                cimg2 = new PdfPCell(info.image2);
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            } else {
                cimg2 = new PdfPCell();
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            }
            PdfPCell meta1 = null;
            meta1 = new PdfPCell(new Phrase(info.imageMeta1, this.roleFont));
            meta1.setVerticalAlignment(1);
            meta1.setHorizontalAlignment(1);
            meta1.setPaddingTop(5.0f);
            meta1.setPaddingBottom(5.0f);
            PdfPCell meta2 = null;
            meta2 = new PdfPCell(new Phrase(info.imageMeta2, this.roleFont));
            meta2.setVerticalAlignment(1);
            meta2.setHorizontalAlignment(1);
            meta2.setPaddingTop(5.0f);
            meta2.setPaddingBottom(5.0f);
            t.addCell(c1);
            t.addCell(c2);
            t.addCell(cimg1);
            t.addCell(cimg2);
            t.addCell(meta1);
            t.addCell(meta2);
            document.add((Element)t);
        }
        Paragraph analyzePg = new Paragraph("(\u4e8c)\u76d1\u6d4b\u7c7b\u578b\u5206\u6790", this.sectionFont);
        analyzePg.setExtraParagraphSpace(30.0f);
        analyzePg.setSpacingBefore(this.pgSpace);
        analyzePg.setLeading(this.lineSpace);
        document.add((Element)analyzePg);
        String content = "\u7ecf\u5206\u6790\uff0c\u9065\u611f\u76d1\u6d4b\u7591\u4f3c\u8fdd\u6cd5\u7528\u5730\u56fe\u6591\u76d1\u6d4b\u7c7b\u578b\u4e3a:";
        if (info.jctbMap != null && info.jctbMap.size() > 0) {
            int count = 0;
            for (Map.Entry kv : info.jctbMap.entrySet()) {
                ++count;
                Object key = kv.getKey();
                Object value = kv.getValue();
                String tblb = "\u672a\u77e5";
                if (key != null) {
                    tblb = key.toString();
                    if (info.configs != null) {
                        for (CloudAnalyzeConfig con : info.configs) {
                            if (!tblb.equals(con.getKey())) continue;
                            tblb = tblb + "(" + con.getValue() + ")";
                        }
                    }
                }
                if (count < info.jctbMap.size()) {
                    tblb = tblb + "\uff1b";
                }
                content = content + tblb;
            }
        } else {
            content = content + "\u672a\u77e5";
        }
        content = content + "\u3002";
        Paragraph analyzeDescPg = new Paragraph(content, this.normalFont);
        analyzeDescPg.setFirstLineIndent(this.firstLineIndent);
        analyzeDescPg.setExtraParagraphSpace(30.0f);
        analyzeDescPg.setSpacingBefore(this.pgSpace);
        analyzeDescPg.setLeading(this.lineSpace);
        document.add((Element)analyzeDescPg);
    }

    private void LegalAnalysis(Document document, ProjectInfo info, ResultInfo result) throws DocumentException {
        Paragraph chapter2Pg = new Paragraph("\u4e8c\u3001\u5408\u6cd5\u6027\u5206\u6790", this.chapterFont);
        chapter2Pg.setExtraParagraphSpace(30.0f);
        chapter2Pg.setSpacingBefore(this.pgSpace);
        chapter2Pg.setLeading(this.lineSpace);
        document.add((Element)chapter2Pg);
        Paragraph jbntPg = new Paragraph("(\u4e00)\u6c38\u4e45\u57fa\u672c\u519c\u7530\u60c5\u51b5\u5206\u6790", this.sectionFont);
        jbntPg.setExtraParagraphSpace(30.0f);
        jbntPg.setSpacingBefore(this.pgSpace);
        jbntPg.setLeading(this.lineSpace);
        document.add((Element)jbntPg);
        String jbntResult = "";
        if (info.jbntArea > 0.0) {
            result.passJbnt = EnumAnalyzeResult.NoPass;
            if (info.jbntArea < info.area) {
                result.passJbnt = EnumAnalyzeResult.PartPass;
            }
            jbntResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u5171" + this.Round(info.jbntArea, 2) + "\u4ea9\u3002";
        } else {
            result.passJbnt = EnumAnalyzeResult.AllPass;
            jbntResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3002";
        }
        Paragraph jbntInfo = new Paragraph(jbntResult, this.normalFont);
        jbntInfo.setFirstLineIndent(this.firstLineIndent);
        jbntInfo.setExtraParagraphSpace(30.0f);
        jbntInfo.setSpacingBefore(this.pgSpace);
        jbntInfo.setLeading(this.lineSpace);
        document.add((Element)jbntInfo);
        if (info.jbntImg != null) {
            String desc = "\u57fa\u672c\u519c\u7530\uff1a" + this.Round(info.jbntArea, 2) + "\u4ea9\uff0c\u975e\u57fa\u672c\u519c\u7530\uff1a" + this.Round(info.area - info.jbntArea, 2) + "\u4ea9";
            this.AddImg(document, "\u6c38\u4e45\u57fa\u672c\u519c\u7530", info.jbntImg, desc);
        }
        this.AddRoleDesc(document, "\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u4e09\u5341\u4e94\u6761  \u57fa\u672c\u519c\u7530\u7ecf\u4f9d\u6cd5\u5212\u5b9a\u540e\uff0c\u4efb\u4f55\u5355\u4f4d\u548c\u4e2a\u4eba\u4e0d\u5f97\u64c5\u81ea\u5360\u7528\u6216\u8005\u6539\u53d8\u5176\u7528\u9014\u3002\u56fd\u5bb6\u80fd\u6e90\u3001\u4ea4\u901a\u3001\u6c34\u5229\u3001\u519b\u4e8b\u8bbe\u65bd\u7b49\u91cd\u70b9\u5efa\u8bbe\u9879\u76ee\u9009\u5740\u786e\u5b9e\u96be\u4ee5\u907f\u8ba9\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u6d89\u53ca\u519c\u7528\u5730\u8f6c\u7528\u6216\u8005\u571f\u5730\u5f81\u6536\u7684\uff0c\u5fc5\u987b\u7ecf\u56fd\u52a1\u9662\u6279\u51c6\u3002", "\u653f\u7b56\u89e3\u8bfb");
        Paragraph tdghPg = new Paragraph("(\u4e8c)\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u60c5\u51b5\u5206\u6790", this.sectionFont);
        tdghPg.setExtraParagraphSpace(30.0f);
        tdghPg.setSpacingBefore(this.pgSpace);
        tdghPg.setLeading(this.lineSpace);
        document.add((Element)tdghPg);
        String tdghDesc = "";
        String tdghResult = "";
        double cantJsArea = 0.0;
        if (info.tdghInfos != null) {
            int count = 0;
            int leng = info.tdghInfos.size();
            for (TdghInfo item : info.tdghInfos) {
                tdghDesc = tdghDesc + item.jsmc + "(" + item.jsbm + ")-" + this.Round(item.area, 2);
                if (++count < leng) {
                    tdghDesc = tdghDesc + "/";
                }
                if ("040".equals(item.jsbm)) {
                    cantJsArea += item.area;
                }
                if (!"030".equals(item.jsbm)) continue;
                cantJsArea += item.area;
            }
        }
        if (cantJsArea > 0.0) {
            result.passTdgh = EnumAnalyzeResult.NoPass;
            tdghResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3002";
        } else {
            result.passTdgh = EnumAnalyzeResult.AllPass;
            tdghResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3002";
        }
        Paragraph tdghInfo = new Paragraph(tdghResult, this.normalFont);
        tdghInfo.setFirstLineIndent(this.firstLineIndent);
        tdghInfo.setExtraParagraphSpace(30.0f);
        tdghInfo.setSpacingBefore(this.pgSpace);
        tdghInfo.setLeading(this.lineSpace);
        document.add((Element)tdghInfo);
        if (info.tdghImg != null) {
            this.AddImg(document, "\u571f\u5730\u89c4\u5212", info.tdghImg, tdghDesc);
        }
        this.AddRoleDesc(document, "\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u4e8c\u5341\u4e94\u6761 \u7ecf\u6279\u51c6\u7684\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u7684\u4fee\u6539\uff0c\u987b\u7ecf\u539f\u5ba1\u6279\u673a\u5173\u6279\u51c6\uff1b\u672a\u7ecf\u6279\u51c6\uff0c\u4e0d\u5f97\u6539\u53d8\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u786e\u5b9a\u7684\u571f\u5730\u7528\u9014\u3002", "\u653f\u7b56\u89e3\u8bfb");
        Paragraph spbaPg = new Paragraph("(\u4e09)\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u60c5\u51b5\u5206\u6790", this.sectionFont);
        spbaPg.setExtraParagraphSpace(30.0f);
        spbaPg.setSpacingBefore(this.pgSpace);
        spbaPg.setLeading(this.lineSpace);
        document.add((Element)spbaPg);
        String spbaResult = "";
        double spbaArea = 0.0;
        if (info.spbaInfos != null && info.spbaInfos.size() > 0) {
            String license = "";
            int count = 0;
            for (SpbaInfo sp : info.spbaInfos) {
                spbaArea += sp.area;
                license = license + sp.license;
                if (++count >= info.spbaInfos.size()) continue;
                license = license + "\u3001";
            }
            result.passSpba = EnumAnalyzeResult.NoPass;
            if (spbaArea > 0.0) {
                if (spbaArea < info.area) {
                    result.passSpba = EnumAnalyzeResult.PartPass;
                    spbaResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6709\u90e8\u5206\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
                } else {
                    result.passSpba = EnumAnalyzeResult.AllPass;
                    spbaResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6709\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
                }
                if (license != null && !license.isEmpty()) {
                    spbaResult = spbaResult + "\u5907\u6848\u53f7\u4e3a\uff1a" + license;
                }
            } else {
                result.passSpba = EnumAnalyzeResult.NoPass;
                spbaResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u65e0\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
            }
        } else {
            result.passSpba = EnumAnalyzeResult.NoPass;
            spbaResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u65e0\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
        }
        Paragraph spbaInfo = new Paragraph(spbaResult, this.normalFont);
        spbaInfo.setFirstLineIndent(this.firstLineIndent);
        spbaInfo.setExtraParagraphSpace(30.0f);
        spbaInfo.setSpacingBefore(this.pgSpace);
        spbaInfo.setLeading(this.lineSpace);
        document.add((Element)spbaInfo);
        if (info.spbaImg != null) {
            String desc = "\u6709\u5ba1\u6279\uff1a" + this.Round(spbaArea, 2) + "\u4ea9\uff0c\u65e0\u5ba1\u6279\uff1a" + this.Round(info.area - spbaArea, 2) + "\u4ea9";
            this.AddImg(document, "\u7528\u5730\u5ba1\u6279", info.spbaImg, desc);
        }
        this.AddRoleDesc(document, "\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u56db\u5341\u56db\u6761 \u5efa\u8bbe\u5360\u571f\u5730\uff0c\u6d89\u53ca\u519c\u7528\u5730\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u5e94\u5f53\u529e\u7406\u519c\u7528\u5730\u8f6c\u7528\u5ba1\u6279\u624b\u7eed\u3002", "\u653f\u7b56\u89e3\u8bfb");
        this.AddRoleDesc(document, "\u6c38\u4e45\u57fa\u672c\u519c\u7530\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u7531\u56fd\u52a1\u9662\u5ba1\u6279\u3002", null);
        this.AddRoleDesc(document, "\u5728\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u786e\u5b9a\u7684\u57ce\u5e02\u548c\u6751\u5e84\u3001\u96c6\u9547\u5efa\u8bbe\u7528\u5730\u89c4\u6a21\u8303\u56f4\u5185\uff0c\u672a\u5b9e\u65bd\u8be5\u89c4\u5b9a\u800c\u5c06\u6c38\u4e45\u57fa\u672c\u519c\u7530\u4ee5\u5916\u7684\u519c\u7528\u5730\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u6309\u571f\u5730\u5229\u7528\u5e74\u5ea6\u8ba1\u5212\u5206\u6279\u6b21\u6309\u7167\u56fd\u52a1\u9662\u89c4\u5b9a\u7531\u539f\u5ba1\u6279\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u7684\u673a\u5173\u5355\u4f4d\u6216\u8005\u5176\u6388\u6743\u7684\u673a\u5173\u5ba1\u6279\u3002\u5728\u5df2\u6279\u51c6\u7684\u519c\u7528\u5730\u8f6c\u7528\u8303\u56f4\u5185\uff0c\u5177\u4f53\u5efa\u8bbe\u9879\u76ee\u7528\u5730\u53ef\u4ee5\u7531\u5e02\u3001\u53bf\u4eba\u6c11\u653f\u5e9c\u6279\u51c6\u3002", null);
        this.AddRoleDesc(document, "\u7b2c\u56db\u5341\u516d\u6761 \u5f81\u6536\u4e0b\u5217\u571f\u5730\u7684\uff0c\u7531\u56fd\u52a1\u9662\u6279\u51c6\uff1a", null);
        this.AddRoleDesc(document, "\uff08\u4e00\uff09\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff1b", null);
        this.AddRoleDesc(document, "\uff08\u4e8c\uff09\u6c38\u4e45\u57fa\u672c\u519c\u7530\u4ee5\u5916\u7684\u8015\u5730\u8d85\u8fc7\u4e09\u5341\u4e94\u516c\u9877\u7684\uff1b", null);
        this.AddRoleDesc(document, "\uff08\u4e09\uff09\u5176\u4ed6\u571f\u5730\u8d85\u8fc7\u4e03\u5341\u516c\u9877\u7684\u3002", null);
        this.AddRoleDesc(document, "\u5f81\u6536\u524d\u6b3e\u89c4\u5b9a\u4ee5\u5916\u7684\u571f\u5730\u7684\uff0c\u7531\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u5ba1\u6279\u3002", null);
        this.AddRoleDesc(document, "\u5f81\u6536\u519c\u7528\u5730\u7684\uff0c\u5e94\u5f53\u4f9d\u7167\u672c\u6cd5\u7b2c\u56db\u5341\u56db\u6761\u7684\u89c4\u5b9a\u5148\u884c\u529e\u7406\u519c\u7528\u5730\u8f6c\u7528\u5ba1\u6279\u3002\u5176\u4e2d\uff0c\u7ecf\u56fd\u52a1\u9662\u6279\u51c6\u519c\u7528\u5730\u8f6c\u7528\u7684\uff0c\u540c\u65f6\u529e\u7406\u5f81\u5730\u5ba1\u6279\u624b\u7eed\uff0c\u4e0d\u518d\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\uff1b\u7ecf\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u5728\u5f81\u5730\u6279\u51c6\u6743\u9650\u5185\u6279\u51c6\u519c\u7528\u5730\u8f6c\u7528\u7684\uff0c\u540c\u65f6\u529e\u7406\u5f81\u5730\u5ba1\u6279\u624b\u7eed\uff0c\u4e0d\u518d\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\uff0c\u8d85\u8fc7\u5f81\u5730\u6279\u51c6\u6743\u9650\u7684\uff0c\u5e94\u5f53\u4f9d\u7167\u672c\u6761\u7b2c\u4e00\u6b3e\u7684\u89c4\u5b9a\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\u3002", null);
        Paragraph zrbhqPg = new Paragraph("(\u56db)\u81ea\u7136\u4fdd\u62a4\u5730\u60c5\u51b5\u5206\u6790", this.sectionFont);
        zrbhqPg.setExtraParagraphSpace(30.0f);
        zrbhqPg.setSpacingBefore(this.pgSpace);
        zrbhqPg.setLeading(this.lineSpace);
        document.add((Element)zrbhqPg);
        String zrbhqDesc = "";
        if (info.zrbhqArea > 0.0) {
            result.passZrbhq = EnumAnalyzeResult.NoPass;
            if (info.zrbhqArea < info.area) {
                result.passZrbhq = EnumAnalyzeResult.PartPass;
            }
            zrbhqDesc = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\uff0c\u5171 " + this.Round(info.zrbhqArea, 2) + "\u4ea9";
        } else {
            result.passZrbhq = EnumAnalyzeResult.AllPass;
            zrbhqDesc = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\u3002";
        }
        Paragraph zrbhqInfo = new Paragraph(zrbhqDesc, this.normalFont);
        zrbhqInfo.setFirstLineIndent(this.firstLineIndent);
        zrbhqInfo.setExtraParagraphSpace(30.0f);
        zrbhqInfo.setSpacingBefore(this.pgSpace);
        zrbhqInfo.setLeading(this.lineSpace);
        document.add((Element)zrbhqInfo);
        if (info.zrbhqImg != null) {
            String desc = "\u81ea\u7136\u4fdd\u62a4\u5730\uff1a" + this.Round(info.zrbhqArea, 2) + "\u4ea9\uff0c\u975e\u81ea\u7136\u4fdd\u62a4\u5730\uff1a" + this.Round(info.area - info.zrbhqArea, 2) + "\u4ea9";
            this.AddImg(document, "\u81ea\u7136\u4fdd\u62a4\u7528\u5730", info.zrbhqImg, desc);
        }
        this.AddRoleDesc(document, "\u300a\u81ea\u7136\u4fdd\u62a4\u533a\u571f\u5730\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c\u5341\u4e94\u6761 \u81ea\u7136\u4fdd\u62a4\u533a\u5185\u571f\u5730\u7684\u4f7f\u7528\uff0c\u4e0d\u5f97\u8fdd\u53cd\u6709\u5173\u73af\u5883\u548c\u8d44\u6e90\u4fdd\u62a4\u6cd5\u5f8b\u7684\u89c4\u5b9a\u3002", "\u653f\u7b56\u89e3\u8bfb");
        this.AddRoleDesc(document, "\u4f9d\u6cd5\u4f7f\u7528\u81ea\u7136\u4fdd\u62a4\u533a\u5185\u571f\u5730\u7684\u5355\u4f4d\u548c\u4e2a\u4eba\u5fc5\u987b\u4e25\u683c\u6309\u7167\u571f\u5730\u767b\u8bb0\u548c\u571f\u5730\u8bc1\u4e66\u89c4\u5b9a\u7684\u7528\u9014\u4f7f\u7528\u571f\u5730\uff0c\u5e76\u4e25\u683c\u9075\u5b88\u6709\u5173\u6cd5\u5f8b\u7684\u89c4\u5b9a\u3002\u6539\u53d8\u7528\u9014\u65f6\uff0c\u9700\u4e8b\u5148\u5f81\u6c42\u73af\u5883\u4fdd\u62a4\u53ca\u6709\u5173\u81ea\u7136\u4fdd\u62a4\u533a\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u7684\u610f\u89c1\uff0c\u7531\u53bf\u7ea7\u4ee5\u4e0a\u4eba\u6c11\u653f\u5e9c\u571f\u5730\u7ba1\u7406\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u5ba1\u67e5\uff0c\u62a5\u53bf\u7ea7\u4ee5\u4e0a\u4eba\u6c11\u653f\u5e9c\u6279\u51c6\u3002", null);
    }

    private void LegalAnalysisLawless(Document document, LawlessInfo info, ResultInfo result) throws DocumentException {
        Paragraph chapter2Pg = new Paragraph("\u4e8c\u3001\u5408\u6cd5\u6027\u5206\u6790", this.chapterFont);
        chapter2Pg.setExtraParagraphSpace(30.0f);
        chapter2Pg.setSpacingBefore(this.pgSpace);
        chapter2Pg.setLeading(this.lineSpace);
        document.add((Element)chapter2Pg);
        Paragraph jbntPg = new Paragraph("(\u4e00)\u6c38\u4e45\u57fa\u672c\u519c\u7530\u60c5\u51b5\u5206\u6790", this.sectionFont);
        jbntPg.setExtraParagraphSpace(30.0f);
        jbntPg.setSpacingBefore(this.pgSpace);
        jbntPg.setLeading(this.lineSpace);
        document.add((Element)jbntPg);
        String jbntResult = "";
        if (info.jbntArea > 0.0) {
            result.passJbnt = EnumAnalyzeResult.NoPass;
            if (info.jbntArea < info.area) {
                result.passJbnt = EnumAnalyzeResult.PartPass;
            }
            jbntResult = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u5171" + this.Round(info.jbntArea, 2) + "\u4ea9\u3002";
        } else {
            result.passJbnt = EnumAnalyzeResult.AllPass;
            jbntResult = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u4e0d\u6d89\u53ca\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3002";
        }
        Paragraph jbntInfo = new Paragraph(jbntResult, this.normalFont);
        jbntInfo.setFirstLineIndent(this.firstLineIndent);
        jbntInfo.setExtraParagraphSpace(30.0f);
        jbntInfo.setSpacingBefore(this.pgSpace);
        jbntInfo.setLeading(this.lineSpace);
        document.add((Element)jbntInfo);
        if (info.jbntImg != null) {
            String desc = "\u57fa\u672c\u519c\u7530\uff1a" + this.Round(info.jbntArea, 2) + "\u4ea9\uff0c\u975e\u57fa\u672c\u519c\u7530\uff1a" + this.Round(info.area - info.jbntArea, 2) + "\u4ea9";
            this.AddImg(document, "\u6c38\u4e45\u57fa\u672c\u519c\u7530", info.jbntImg, desc);
        }
        this.AddRoleDesc(document, "\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u4e09\u5341\u4e94\u6761  \u57fa\u672c\u519c\u7530\u7ecf\u4f9d\u6cd5\u5212\u5b9a\u540e\uff0c\u4efb\u4f55\u5355\u4f4d\u548c\u4e2a\u4eba\u4e0d\u5f97\u64c5\u81ea\u5360\u7528\u6216\u8005\u6539\u53d8\u5176\u7528\u9014\u3002\u56fd\u5bb6\u80fd\u6e90\u3001\u4ea4\u901a\u3001\u6c34\u5229\u3001\u519b\u4e8b\u8bbe\u65bd\u7b49\u91cd\u70b9\u5efa\u8bbe\u9879\u76ee\u9009\u5740\u786e\u5b9e\u96be\u4ee5\u907f\u8ba9\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff0c\u6d89\u53ca\u519c\u7528\u5730\u8f6c\u7528\u6216\u8005\u571f\u5730\u5f81\u6536\u7684\uff0c\u5fc5\u987b\u7ecf\u56fd\u52a1\u9662\u6279\u51c6\u3002", "\u653f\u7b56\u89e3\u8bfb");
        Paragraph tdghPg = new Paragraph("(\u4e8c)\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u60c5\u51b5\u5206\u6790", this.sectionFont);
        tdghPg.setExtraParagraphSpace(30.0f);
        tdghPg.setSpacingBefore(this.pgSpace);
        tdghPg.setLeading(this.lineSpace);
        document.add((Element)tdghPg);
        String tdghDesc = "";
        String tdghResult = "";
        double cantJsArea = 0.0;
        if (info.tdghInfos != null) {
            int count = 0;
            int leng = info.tdghInfos.size();
            for (TdghInfo item : info.tdghInfos) {
                tdghDesc = tdghDesc + item.jsmc + "(" + item.jsbm + ")-" + this.Round(item.area, 2);
                if (++count < leng) {
                    tdghDesc = tdghDesc + "/";
                }
                if ("040".equals(item.jsbm)) {
                    cantJsArea += item.area;
                }
                if (!"030".equals(item.jsbm)) continue;
                cantJsArea += item.area;
            }
        }
        if (cantJsArea > 0.0) {
            result.passTdgh = EnumAnalyzeResult.NoPass;
            tdghResult = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3002";
        } else {
            result.passTdgh = EnumAnalyzeResult.AllPass;
            tdghResult = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3002";
        }
        Paragraph tdghInfo = new Paragraph(tdghResult, this.normalFont);
        tdghInfo.setFirstLineIndent(this.firstLineIndent);
        tdghInfo.setExtraParagraphSpace(30.0f);
        tdghInfo.setSpacingBefore(this.pgSpace);
        tdghInfo.setLeading(this.lineSpace);
        document.add((Element)tdghInfo);
        if (info.tdghImg != null) {
            this.AddImg(document, "\u571f\u5730\u89c4\u5212", info.tdghImg, tdghDesc);
        }
        this.AddRoleDesc(document, "\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u4e8c\u5341\u4e94\u6761 \u7ecf\u6279\u51c6\u7684\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u7684\u4fee\u6539\uff0c\u987b\u7ecf\u539f\u5ba1\u6279\u673a\u5173\u6279\u51c6\uff1b\u672a\u7ecf\u6279\u51c6\uff0c\u4e0d\u5f97\u6539\u53d8\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u786e\u5b9a\u7684\u571f\u5730\u7528\u9014\u3002", "\u653f\u7b56\u89e3\u8bfb");
        Paragraph spbaPg = new Paragraph("(\u4e09)\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u60c5\u51b5\u5206\u6790", this.sectionFont);
        spbaPg.setExtraParagraphSpace(30.0f);
        spbaPg.setSpacingBefore(this.pgSpace);
        spbaPg.setLeading(this.lineSpace);
        document.add((Element)spbaPg);
        String spbaResult = "";
        double spbaArea = 0.0;
        if (info.spbaInfos != null && info.spbaInfos.size() > 0) {
            String license = "";
            int count = 0;
            for (SpbaInfo sp : info.spbaInfos) {
                spbaArea += sp.area;
                license = license + sp.license;
                if (++count >= info.spbaInfos.size()) continue;
                license = license + "\u3001";
            }
            result.passSpba = EnumAnalyzeResult.NoPass;
            if (spbaArea > 0.0) {
                if (spbaArea < info.area) {
                    result.passSpba = EnumAnalyzeResult.PartPass;
                    spbaResult = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u6709\u90e8\u5206\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
                } else {
                    result.passSpba = EnumAnalyzeResult.AllPass;
                    spbaResult = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u6709\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
                }
                if (license != null && !license.isEmpty()) {
                    spbaResult = spbaResult + "\u5907\u6848\u53f7\u4e3a\uff1a" + license;
                }
            } else {
                result.passSpba = EnumAnalyzeResult.NoPass;
                spbaResult = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u65e0\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
            }
        } else {
            result.passSpba = EnumAnalyzeResult.NoPass;
            spbaResult = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u65e0\u5ba1\u6279\u5907\u6848\u4fe1\u606f\u3002";
        }
        Paragraph spbaInfo = new Paragraph(spbaResult, this.normalFont);
        spbaInfo.setFirstLineIndent(this.firstLineIndent);
        spbaInfo.setExtraParagraphSpace(30.0f);
        spbaInfo.setSpacingBefore(this.pgSpace);
        spbaInfo.setLeading(this.lineSpace);
        document.add((Element)spbaInfo);
        if (info.spbaImg != null) {
            String desc = "\u6709\u5ba1\u6279\uff1a" + this.Round(spbaArea, 2) + "\u4ea9\uff0c\u65e0\u5ba1\u6279\uff1a" + this.Round(info.area - spbaArea, 2) + "\u4ea9";
            this.AddImg(document, "\u7528\u5730\u5ba1\u6279", info.spbaImg, desc);
        }
        this.AddRoleDesc(document, "\u300a\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u571f\u5730\u7ba1\u7406\u6cd5\u300b\u7b2c\u56db\u5341\u56db\u6761 \u5efa\u8bbe\u5360\u571f\u5730\uff0c\u6d89\u53ca\u519c\u7528\u5730\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u5e94\u5f53\u529e\u7406\u519c\u7528\u5730\u8f6c\u7528\u5ba1\u6279\u624b\u7eed\u3002", "\u653f\u7b56\u89e3\u8bfb");
        this.AddRoleDesc(document, "\u6c38\u4e45\u57fa\u672c\u519c\u7530\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u7531\u56fd\u52a1\u9662\u5ba1\u6279\u3002", null);
        this.AddRoleDesc(document, "\u5728\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u786e\u5b9a\u7684\u57ce\u5e02\u548c\u6751\u5e84\u3001\u96c6\u9547\u5efa\u8bbe\u7528\u5730\u89c4\u6a21\u8303\u56f4\u5185\uff0c\u672a\u5b9e\u65bd\u8be5\u89c4\u5b9a\u800c\u5c06\u6c38\u4e45\u57fa\u672c\u519c\u7530\u4ee5\u5916\u7684\u519c\u7528\u5730\u8f6c\u4e3a\u5efa\u8bbe\u7528\u5730\u7684\uff0c\u6309\u571f\u5730\u5229\u7528\u5e74\u5ea6\u8ba1\u5212\u5206\u6279\u6b21\u6309\u7167\u56fd\u52a1\u9662\u89c4\u5b9a\u7531\u539f\u5ba1\u6279\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u7684\u673a\u5173\u5355\u4f4d\u6216\u8005\u5176\u6388\u6743\u7684\u673a\u5173\u5ba1\u6279\u3002\u5728\u5df2\u6279\u51c6\u7684\u519c\u7528\u5730\u8f6c\u7528\u8303\u56f4\u5185\uff0c\u5177\u4f53\u5efa\u8bbe\u9879\u76ee\u7528\u5730\u53ef\u4ee5\u7531\u5e02\u3001\u53bf\u4eba\u6c11\u653f\u5e9c\u6279\u51c6\u3002", null);
        this.AddRoleDesc(document, "\u7b2c\u56db\u5341\u516d\u6761 \u5f81\u6536\u4e0b\u5217\u571f\u5730\u7684\uff0c\u7531\u56fd\u52a1\u9662\u6279\u51c6\uff1a", null);
        this.AddRoleDesc(document, "\uff08\u4e00\uff09\u6c38\u4e45\u57fa\u672c\u519c\u7530\uff1b", null);
        this.AddRoleDesc(document, "\uff08\u4e8c\uff09\u6c38\u4e45\u57fa\u672c\u519c\u7530\u4ee5\u5916\u7684\u8015\u5730\u8d85\u8fc7\u4e09\u5341\u4e94\u516c\u9877\u7684\uff1b", null);
        this.AddRoleDesc(document, "\uff08\u4e09\uff09\u5176\u4ed6\u571f\u5730\u8d85\u8fc7\u4e03\u5341\u516c\u9877\u7684\u3002", null);
        this.AddRoleDesc(document, "\u5f81\u6536\u524d\u6b3e\u89c4\u5b9a\u4ee5\u5916\u7684\u571f\u5730\u7684\uff0c\u7531\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u5ba1\u6279\u3002", null);
        this.AddRoleDesc(document, "\u5f81\u6536\u519c\u7528\u5730\u7684\uff0c\u5e94\u5f53\u4f9d\u7167\u672c\u6cd5\u7b2c\u56db\u5341\u56db\u6761\u7684\u89c4\u5b9a\u5148\u884c\u529e\u7406\u519c\u7528\u5730\u8f6c\u7528\u5ba1\u6279\u3002\u5176\u4e2d\uff0c\u7ecf\u56fd\u52a1\u9662\u6279\u51c6\u519c\u7528\u5730\u8f6c\u7528\u7684\uff0c\u540c\u65f6\u529e\u7406\u5f81\u5730\u5ba1\u6279\u624b\u7eed\uff0c\u4e0d\u518d\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\uff1b\u7ecf\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u5728\u5f81\u5730\u6279\u51c6\u6743\u9650\u5185\u6279\u51c6\u519c\u7528\u5730\u8f6c\u7528\u7684\uff0c\u540c\u65f6\u529e\u7406\u5f81\u5730\u5ba1\u6279\u624b\u7eed\uff0c\u4e0d\u518d\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\uff0c\u8d85\u8fc7\u5f81\u5730\u6279\u51c6\u6743\u9650\u7684\uff0c\u5e94\u5f53\u4f9d\u7167\u672c\u6761\u7b2c\u4e00\u6b3e\u7684\u89c4\u5b9a\u53e6\u884c\u529e\u7406\u5f81\u5730\u5ba1\u6279\u3002", null);
        Paragraph zrbhqPg = new Paragraph("(\u56db)\u81ea\u7136\u4fdd\u62a4\u5730\u60c5\u51b5\u5206\u6790", this.sectionFont);
        zrbhqPg.setExtraParagraphSpace(30.0f);
        zrbhqPg.setSpacingBefore(this.pgSpace);
        zrbhqPg.setLeading(this.lineSpace);
        document.add((Element)zrbhqPg);
        String zrbhqDesc = "";
        if (info.zrbhqArea > 0.0) {
            result.passZrbhq = EnumAnalyzeResult.NoPass;
            if (info.zrbhqArea < info.area) {
                result.passZrbhq = EnumAnalyzeResult.PartPass;
            }
            zrbhqDesc = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\uff0c\u5171 " + this.Round(info.zrbhqArea, 2) + "\u4ea9";
        } else {
            result.passZrbhq = EnumAnalyzeResult.AllPass;
            zrbhqDesc = "\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591\u4e0d\u6d89\u53ca\u81ea\u7136\u4fdd\u62a4\u5730\u3002";
        }
        Paragraph zrbhqInfo = new Paragraph(zrbhqDesc, this.normalFont);
        zrbhqInfo.setFirstLineIndent(this.firstLineIndent);
        zrbhqInfo.setExtraParagraphSpace(30.0f);
        zrbhqInfo.setSpacingBefore(this.pgSpace);
        zrbhqInfo.setLeading(this.lineSpace);
        document.add((Element)zrbhqInfo);
        if (info.zrbhqImg != null) {
            String desc = "\u81ea\u7136\u4fdd\u62a4\u5730\uff1a" + this.Round(info.zrbhqArea, 2) + "\u4ea9\uff0c\u975e\u81ea\u7136\u4fdd\u62a4\u5730\uff1a" + this.Round(info.area - info.zrbhqArea, 2) + "\u4ea9";
            this.AddImg(document, "\u81ea\u7136\u4fdd\u62a4\u7528\u5730", info.zrbhqImg, desc);
        }
        this.AddRoleDesc(document, "\u300a\u81ea\u7136\u4fdd\u62a4\u533a\u571f\u5730\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c\u5341\u4e94\u6761 \u81ea\u7136\u4fdd\u62a4\u533a\u5185\u571f\u5730\u7684\u4f7f\u7528\uff0c\u4e0d\u5f97\u8fdd\u53cd\u6709\u5173\u73af\u5883\u548c\u8d44\u6e90\u4fdd\u62a4\u6cd5\u5f8b\u7684\u89c4\u5b9a\u3002", "\u653f\u7b56\u89e3\u8bfb");
        this.AddRoleDesc(document, "\u4f9d\u6cd5\u4f7f\u7528\u81ea\u7136\u4fdd\u62a4\u533a\u5185\u571f\u5730\u7684\u5355\u4f4d\u548c\u4e2a\u4eba\u5fc5\u987b\u4e25\u683c\u6309\u7167\u571f\u5730\u767b\u8bb0\u548c\u571f\u5730\u8bc1\u4e66\u89c4\u5b9a\u7684\u7528\u9014\u4f7f\u7528\u571f\u5730\uff0c\u5e76\u4e25\u683c\u9075\u5b88\u6709\u5173\u6cd5\u5f8b\u7684\u89c4\u5b9a\u3002\u6539\u53d8\u7528\u9014\u65f6\uff0c\u9700\u4e8b\u5148\u5f81\u6c42\u73af\u5883\u4fdd\u62a4\u53ca\u6709\u5173\u81ea\u7136\u4fdd\u62a4\u533a\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u7684\u610f\u89c1\uff0c\u7531\u53bf\u7ea7\u4ee5\u4e0a\u4eba\u6c11\u653f\u5e9c\u571f\u5730\u7ba1\u7406\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u5ba1\u67e5\uff0c\u62a5\u53bf\u7ea7\u4ee5\u4e0a\u4eba\u6c11\u653f\u5e9c\u6279\u51c6\u3002", null);
    }

    private void BzInfo(Document document) throws DocumentException {
        String content = "\u8bf4\u660e\uff1a\u7531\u4e8e\u6211\u4eec\u4e0d\u638c\u63e1\u73af\u8bc4\u4fe1\u606f\u548c\u57ce\u4e61\u89c4\u5212\u6570\u636e\u7b49\u76f8\u5173\u7ba1\u7406\u6570\u636e\uff0c\u4e91\u5206\u6790\u62a5\u544a\u4e0d\u6d89\u53ca\u73af\u8bc4\u548c\u57ce\u4e61\u89c4\u5212\u7b26\u5408\u6027\u7b49\u5206\u6790\u5185\u5bb9\u3002";
        Paragraph contentPg = new Paragraph(content, this.redFont);
        contentPg.setFirstLineIndent(this.firstLineIndent);
        contentPg.setExtraParagraphSpace(30.0f);
        contentPg.setSpacingBefore(this.pgSpace);
        contentPg.setLeading(this.lineSpace);
        document.add((Element)contentPg);
    }

    private void SuitableAnalysis(Document document, ProjectInfo info, ResultInfo result, boolean px) throws DocumentException {
        Paragraph chapter3Pg = new Paragraph("\u4e09\u3001\u9002\u5b9c\u6027\u5206\u6790", this.chapterFont);
        chapter3Pg.setExtraParagraphSpace(30.0f);
        chapter3Pg.setSpacingBefore(this.pgSpace);
        chapter3Pg.setLeading(this.lineSpace);
        document.add((Element)chapter3Pg);
        Paragraph jzdjPg = new Paragraph("(\u4e00)\u5f81\u5730\u533a\u7247\u5730\u4ef7\u5206\u6790", this.sectionFont);
        jzdjPg.setExtraParagraphSpace(30.0f);
        jzdjPg.setSpacingBefore(this.pgSpace);
        jzdjPg.setLeading(this.lineSpace);
        document.add((Element)jzdjPg);
        String jzdjResult = "";
        jzdjResult = info.landPrice > 0.0 ? "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5f81\u5730\u533a\u7247\u5730\u4ef7\u4e3a\uff1a" + this.Round(info.landPrice, 2) + "\u5143/\u4ea9" : "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5f81\u5730\u533a\u7247\u5730\u4ef7\u672a\u77e5 ";
        Paragraph jzdjInfo = new Paragraph(jzdjResult, this.normalFont);
        jzdjInfo.setFirstLineIndent(this.firstLineIndent);
        jzdjInfo.setExtraParagraphSpace(30.0f);
        jzdjInfo.setSpacingBefore(this.pgSpace);
        jzdjInfo.setLeading(this.lineSpace);
        document.add((Element)jzdjInfo);
        if (info.landPriceImg != null) {
            this.AddImg(document, "\u5f81\u5730\u533a\u7247\u5730\u4ef7", info.landPriceImg, this.Round(info.landPrice, 2) + "\u5143/\u4ea9");
        }
        this.AddRoleDesc(document, "\u300a\u81ea\u7136\u4fdd\u62a4\u533a\u571f\u5730\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c\u56db\u5341\u516b\u6761\u7b2c\u4e09\u6b3e  \u5f81\u6536\u519c\u7528\u5730\u7684\u571f\u5730\u8865\u507f\u8d39\u3001\u5b89\u7f6e\u8865\u52a9\u8d39\u6807\u51c6\u7531\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u901a\u8fc7\u5236\u5b9a\u516c\u5e03\u533a\u7247\u7efc\u5408\u5730\u4ef7\u786e\u5b9a\u3002\u5236\u5b9a\u533a\u7247\u7efc\u5408\u5730\u4ef7\u5e94\u5f53\u7efc\u5408\u8003\u8651\u571f\u5730\u539f\u7528\u9014\u3001\u571f\u5730\u8d44\u6e90\u6761\u4ef6\u3001\u571f\u5730\u4ea7\u503c\u3001\u571f\u5730\u533a\u4f4d\u3001\u571f\u5730\u4f9b\u6c42\u5173\u7cfb\u3001\u4eba\u53e3\u4ee5\u53ca\u7ecf\u6d4e\u793e\u4f1a\u53d1\u5c55\u6c34\u5e73\u7b49\u56e0\u7d20\uff0c\u5e76\u81f3\u5c11\u6bcf\u4e09\u5e74\u8c03\u6574\u6216\u8005\u91cd\u65b0\u516c\u5e03\u4e00\u6b21\u3002", "\u653f\u7b56\u89e3\u8bfb");
        Paragraph dzzhPg = new Paragraph("(\u4e8c)\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u5206\u6790", this.sectionFont);
        dzzhPg.setExtraParagraphSpace(30.0f);
        dzzhPg.setSpacingBefore(this.pgSpace);
        dzzhPg.setLeading(this.lineSpace);
        document.add((Element)dzzhPg);
        String dzzhResult = "";
        double dzfxArea = 0.0;
        String dzfxDesc = "";
        if (info.dzfxInfos != null && info.dzfxInfos.size() > 0) {
            int count = 0;
            for (DzfxInfo dzfx : info.dzfxInfos) {
                dzfxArea += dzfx.area;
                dzfxDesc = dzfxDesc + dzfx.level + this.Round(dzfx.area, 2) + "\u4ea9";
                if (++count >= info.dzfxInfos.size()) continue;
                dzfxDesc = dzfxDesc + "/";
            }
        }
        if (dzfxArea > 0.0) {
            result.passDzfx = EnumAnalyzeResult.NoPass;
            if (dzfxArea < info.area) {
                result.passDzfx = EnumAnalyzeResult.PartPass;
            }
            dzzhResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3002";
        } else {
            result.passDzfx = EnumAnalyzeResult.AllPass;
            dzzhResult = info.provinceCode != null && info.provinceCode.startsWith("22") ? "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3002" : "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u60c5\u51b5\u4e0d\u8be6\uff08\u65e0\u8be5\u533a\u57df\u5730\u8d28\u707e\u5bb3\u6570\u636e\uff09\u3002";
        }
        Paragraph dzzhInfo = new Paragraph(dzzhResult, this.normalFont);
        dzzhInfo.setFirstLineIndent(this.firstLineIndent);
        dzzhInfo.setExtraParagraphSpace(30.0f);
        dzzhInfo.setSpacingBefore(this.pgSpace);
        dzzhInfo.setLeading(this.lineSpace);
        document.add((Element)dzzhInfo);
        if (info.dzfxImg != null) {
            this.AddImg(document, "\u5730\u8d28\u707e\u5bb3\u9690\u60a3", info.dzfxImg, dzfxDesc);
        }
        this.AddRoleDesc(document, "\u300a\u5730\u8d28\u707e\u5bb3\u9632\u6cbb\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c25\u6761\u660e\u786e\u89c4\u5b9a\uff1a\u201c\u57ce\u5e02\u5efa\u8bbe\u6709\u53ef\u80fd\u5bfc\u81f4\u5730\u8d28\u707e\u5bb3\u53d1\u751f\u7684\u5de5\u7a0b\u9879\u76ee\u5efa\u8bbe\u548c\u5730\u8d28\u707e\u5bb3\u6613\u53d1\u533a\u5185\u8fdb\u884c\u7684\u5de5\u7a0b\u5efa\u8bbe\u5728\u7533\u8bf7\u5efa\u8bbe\u7528\u5730\u4e4b\u524d\u5fc5\u987b\u8fdb\u884c\u5730\u8d28\u707e\u5bb3\u98ce\u9669\u6027\u8bc4\u4f30\uff0c\u8bc4\u4f30\u7ed3\u679c\u7531\u7701\u7ea7\u4ee5\u4e0a\u5730\u8d28\u77ff\u4ea7\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u8ba4\u5b9a\u3002\u4e0d\u7b26\u5408\u6761\u4ef6\u7684\uff0c\u571f\u5730\u884c\u653f\u4e3b\u7ba1\u90e8\u95e8\u4e0d\u4e88\u529e\u7406\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u201d\u3002", "\u653f\u7b56\u89e3\u8bfb");
        Paragraph stydPg = new Paragraph("(\u4e09)\u751f\u6001\u7528\u5730\u5206\u6790", this.sectionFont);
        stydPg.setExtraParagraphSpace(30.0f);
        stydPg.setSpacingBefore(this.pgSpace);
        stydPg.setLeading(this.lineSpace);
        document.add((Element)stydPg);
        String stydResult = "";
        if (info.sdArea > 0.0) {
            result.passSd = EnumAnalyzeResult.NoPass;
            if (info.sdArea < info.area) {
                result.passSd = EnumAnalyzeResult.PartPass;
            }
            stydResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5360\u7528\u6e7f\u5730\uff0c\u5171" + this.Round(info.sdArea, 2) + "\u4ea9";
        } else {
            result.passSd = EnumAnalyzeResult.AllPass;
            stydResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u5360\u7528\u6e7f\u5730\u3002";
        }
        Paragraph stydInfo = new Paragraph(stydResult, this.normalFont);
        stydInfo.setFirstLineIndent(this.firstLineIndent);
        stydInfo.setExtraParagraphSpace(30.0f);
        stydInfo.setSpacingBefore(this.pgSpace);
        stydInfo.setLeading(this.lineSpace);
        document.add((Element)stydInfo);
        if (info.sdImg != null) {
            this.AddImg(document, "\u751f\u6001\u7528\u5730", info.sdImg, "\u751f\u6001\u7528\u5730\u9762\u79ef\uff1a" + this.Round(info.sdArea, 2) + "\u4ea9");
        }
        this.AddRoleDesc(document, "\u300a\u6e7f\u5730\u4fdd\u62a4\u7ba1\u7406\u89c4\u5b9a\u300b\u7b2c\u5341\u516b\u6761 \u56e0\u5de5\u7a0b\u5efa\u8bbe\u7b49\u9020\u6210\u56fd\u9645\u91cd\u8981\u6e7f\u5730\u751f\u6001\u7279\u5f81\u9000\u5316\u751a\u81f3\u6d88\u5931\u7684\uff0c\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u6797\u4e1a\u4e3b\u7ba1\u90e8\u95e8\u5e94\u5f53\u4f1a\u540c\u540c\u7ea7\u4eba\u6c11\u653f\u5e9c\u6709\u5173\u90e8\u95e8\u7763\u4fc3\u3001\u6307\u5bfc\u9879\u76ee\u5efa\u8bbe\u5355\u4f4d\u9650\u671f\u6062\u590d\uff0c\u5e76\u5411\u540c\u7ea7\u4eba\u6c11\u653f\u5e9c\u548c\u56fd\u5bb6\u6797\u4e1a\u5c40\u62a5\u544a\uff1b\u5bf9\u903e\u671f\u4e0d\u4e88\u6062\u590d\u6216\u8005\u786e\u5b9e\u65e0\u6cd5\u6062\u590d\u7684\uff0c\u7531\u56fd\u5bb6\u6797\u4e1a\u5c40\u4f1a\u5546\u6240\u5728\u5730\u7701\u3001\u81ea\u6cbb\u533a\u3001\u76f4\u8f96\u5e02\u4eba\u6c11\u653f\u5e9c\u548c\u56fd\u52a1\u9662\u6709\u5173\u90e8\u95e8\u540e\uff0c\u6309\u7167\u6709\u5173\u89c4\u5b9a\u5904\u7406\u3002", "\u653f\u7b56\u89e3\u8bfb");
        this.AddRoleDesc(document, "\u300a\u6e7f\u5730\u4fdd\u62a4\u7ba1\u7406\u89c4\u5b9a\u300b\u7b2c\u4e09\u5341\u6761\u5efa\u8bbe\u9879\u76ee\u5e94\u5f53\u4e0d\u5360\u6216\u8005\u5c11\u5360\u6e7f\u5730\uff0c\u7ecf\u6279\u51c6\u786e\u9700\u5f81\u6536\u3001\u5360\u7528\u6e7f\u5730\u5e76\u8f6c\u4e3a\u5176\u4ed6\u7528\u9014\u7684\uff0c\u7528\u5730\u5355\u4f4d\u5e94\u5f53\u6309\u7167\u201c\u5148\u8865\u540e\u5360\u3001\u5360\u8865\u5e73\u8861\u201d\u7684\u539f\u5219\uff0c\u4f9d\u6cd5\u529e\u7406\u76f8\u5173\u624b\u7eed\u3002", null);
        this.AddRoleDesc(document, "\u4e34\u65f6\u5360\u7528\u6e7f\u5730\u7684\uff0c\u671f\u9650\u4e0d\u5f97\u8d85\u8fc72\u5e74\uff1b\u4e34\u65f6\u5360\u7528\u671f\u9650\u5c4a\u6ee1\uff0c\u5360\u7528\u5355\u4f4d\u5e94\u5f53\u5bf9\u6240\u5360\u6e7f\u5730\u9650\u671f\u8fdb\u884c\u751f\u6001\u4fee\u590d\u3002", null);
        boolean hasGradeInfo = false;
        if (info.gradeInfos != null && info.gradeInfos.size() > 0) {
            hasGradeInfo = true;
            Paragraph zbphPg = new Paragraph("(\u56db)\u5360\u8865\u5e73\u8861\u60c5\u51b5\u5206\u6790", this.sectionFont);
            zbphPg.setExtraParagraphSpace(30.0f);
            zbphPg.setSpacingBefore(this.pgSpace);
            zbphPg.setLeading(this.lineSpace);
            document.add((Element)zbphPg);
            String zbphResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a";
            String first = "";
            double area = 0.0;
            String second = "";
            HashMap<String, Double> map = new HashMap<String, Double>();
            for (LandUseGrade g : info.gradeInfos) {
                if (map.containsKey(g.field2)) {
                    double gradeArea = (Double)map.get(g.field2) + g.area;
                    map.put(g.field2, gradeArea);
                } else {
                    map.put(g.field2, g.area);
                }
                if (!first.equalsIgnoreCase(g.field1)) {
                    if (second != null && !second.isEmpty()) {
                        zbphResult = zbphResult + "\u5360" + first + this.Round(area, 2) + "\u4ea9\uff0c";
                        second = second.substring(0, second.length() - 1);
                        zbphResult = zbphResult + second + "\uff1b";
                    }
                    area = 0.0;
                    second = "";
                    first = g.field1;
                }
                area += g.area;
                if (g.field2 == null) {
                    second = second + "\u8015\u5730\u7b49\u522b\u672a\u77e5" + this.Round(g.area, 2) + "\u4ea9,";
                    continue;
                }
                second = second + "\u8015\u5730\u7b49\u522b\u4e3a" + g.field2 + "\u7b49" + this.Round(g.area, 2) + "\u4ea9\uff0c";
            }
            if (second != null && !second.isEmpty()) {
                zbphResult = zbphResult + "\u5360" + first + this.Round(area, 2) + "\u4ea9\uff0c";
                second = second.substring(0, second.length() - 1);
                zbphResult = zbphResult + second + "\u3002";
            }
            Paragraph zbphInfo = new Paragraph(zbphResult, this.normalFont);
            zbphInfo.setFirstLineIndent(this.firstLineIndent);
            zbphInfo.setExtraParagraphSpace(30.0f);
            zbphInfo.setSpacingBefore(this.pgSpace);
            zbphInfo.setLeading(this.lineSpace);
            document.add((Element)zbphInfo);
            if (info.gradeImg != null) {
                String desc = "";
                for (Map.Entry m : map.entrySet()) {
                    Object obj = m.getKey();
                    String key = "";
                    if (obj == null) {
                        key = "\u672a\u77e5";
                    } else {
                        key = obj.toString();
                        key = key + "\u7b49";
                    }
                    desc = desc + key + this.Round((Double)m.getValue(), 2) + "\u4ea9/";
                }
                desc = desc.substring(0, desc.length() - 1);
                this.AddImg(document, "\u8015\u5730\u7b49\u522b", info.gradeImg, desc);
            }
            this.AddRoleDesc(document, "\u300a\u5173\u4e8e\u8865\u8db3\u8015\u5730\u6570\u91cf\u4e0e\u63d0\u5347\u8015\u5730\u8d28\u91cf\u76f8\u7ed3\u5408\u843d\u5b9e\u5360\u8865\u5e73\u8861\u7684\u6307\u5bfc\u610f\u89c1\u300b\u63d0\u51fa\uff0c\u8865\u6539\u7ed3\u5408\u3001\u63d0\u8d28\u6539\u9020\u5fc5\u987b\u575a\u6301\u653f\u5e9c\u4e3b\u5bfc\u3001\u56e0\u5730\u5236\u5b9c\u3001\u7ef4\u62a4\u519c\u6c11\u6743\u76ca\u548c\u5ba1\u614e\u7a33\u59a5\u63a8\u8fdb\u7684\u539f\u5219\u3002", "\u653f\u7b56\u89e3\u8bfb");
            this.AddRoleDesc(document, "\u300a\u6307\u5bfc\u610f\u89c1\u300b\u660e\u786e\u4e86\u8865\u6539\u7ed3\u5408\u7684\u9002\u7528\u8303\u56f4\uff0c\u5373\u5bf9\u4e8e\u5355\u72ec\u9009\u5740\u5efa\u8bbe\u9879\u76ee\u53d7\u8d44\u6e90\u6761\u4ef6\u9650\u5236\uff0c\u65e0\u6cd5\u843d\u5b9e\u5360\u4f18\u8865\u4f18\u3001\u5360\u6c34\u7530\u8865\u6c34\u7530\u7684\uff0c\u53ef\u901a\u8fc7\u8865\u6539\u7ed3\u5408\u843d\u5b9e\uff1b\u5404\u7c7b\u57ce\u5e02\u5efa\u8bbe\u6d89\u53ca\u5360\u7528\u8015\u5730\u7684\uff0c\u4ecd\u575a\u6301\u5148\u8865\u540e\u5360\u548c\u76f4\u63a5\u8865\u5145\u4f18\u8d28\u8015\u5730\uff0c\u843d\u5b9e\u5360\u4f18\u8865\u4f18\u3001\u5360\u6c34\u7530\u8865\u6c34\u7530\u3002", null);
        }
        if (px) {
            String xh = hasGradeInfo ? "\u4e94" : "\u56db";
            Paragraph sthxPg = new Paragraph("(" + xh + ")\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf", this.sectionFont);
            sthxPg.setExtraParagraphSpace(30.0f);
            sthxPg.setSpacingBefore(this.pgSpace);
            sthxPg.setLeading(this.lineSpace);
            document.add((Element)sthxPg);
            String sthxResult = "";
            if (info.px_stbhhx_area > 0.0) {
                result.passPxSthx = EnumAnalyzeResult.NoPass;
                if (info.px_stbhhx_area < info.area) {
                    result.passPxSthx = EnumAnalyzeResult.PartPass;
                }
                sthxResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\uff0c\u5171" + this.Round(info.px_stbhhx_area, 2) + "\u4ea9";
            } else {
                result.passPxSthx = EnumAnalyzeResult.AllPass;
                sthxResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3002";
            }
            Paragraph sthxInfo = new Paragraph(sthxResult, this.normalFont);
            sthxInfo.setFirstLineIndent(this.firstLineIndent);
            sthxInfo.setExtraParagraphSpace(30.0f);
            sthxInfo.setSpacingBefore(this.pgSpace);
            sthxInfo.setLeading(this.lineSpace);
            document.add((Element)sthxInfo);
            if (info.px_stbhhx_Img != null) {
                this.AddImg(document, "\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf", info.px_stbhhx_Img, "\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u9762\u79ef\uff1a" + this.Round(info.px_stbhhx_area, 2) + "\u4ea9");
            }
            this.AddRoleDesc(document, "\u300a\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c\u4e94\u6761\u3010\u7ba1\u7406\u539f\u5219\u3011\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u539f\u5219\u4e0a\u6309\u7981\u6b62\u5f00\u53d1\u533a\u57df\u7684\u8981\u6c42\u8fdb\u884c\u7ba1\u7406\u3002\u9075\u5faa\u751f\u6001\u4f18\u5148\u3001\u4e25\u683c\u7ba1\u63a7\u3001\u5956\u60e9\u5e76\u91cd\u539f\u5219\uff0c\u4e25\u7981\u4e0d\u7b26\u5408\u4e3b\u9898\u529f\u80fd\u5b9a\u4f4d\u7684\u5404\u7c7b\u5f00\u53d1\u6d3b\u52a8\u3002\u6839\u636e\u4e3b\u5bfc\u751f\u6001\u529f\u80fd\u5b9a\u4f4d\uff0c\u5b9e\u65f6\u5dee\u522b\u5316\u7ba1\u7406\uff0c\u786e\u4fdd\u751f\u6001\u7ea2\u7ebf\u751f\u6001\u529f\u80fd\u4e0d\u964d\u4f4e\u3001\u9762\u79ef\u4e0d\u51cf\u5c11\u3001\u6027\u8d28\u4e0d\u6539\u53d8\u3002", "\u653f\u7b56\u89e3\u8bfb");
            xh = hasGradeInfo ? "\u516d" : "\u4e94";
            Paragraph gylPg = new Paragraph("(" + xh + ")\u516c\u76ca\u6797\u5206\u6790", this.sectionFont);
            gylPg.setExtraParagraphSpace(30.0f);
            gylPg.setSpacingBefore(this.pgSpace);
            gylPg.setLeading(this.lineSpace);
            document.add((Element)gylPg);
            String gylResult = "";
            if (info.px_gyl_area > 0.0) {
                result.passPxGyl = EnumAnalyzeResult.NoPass;
                if (info.px_gyl_area < info.area) {
                    result.passPxGyl = EnumAnalyzeResult.PartPass;
                }
                gylResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u5360\u7528\u516c\u76ca\u6797\uff0c\u5171" + this.Round(info.px_gyl_area, 2) + "\u4ea9";
            } else {
                result.passPxGyl = EnumAnalyzeResult.AllPass;
                gylResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u4e0d\u5360\u7528\u516c\u76ca\u6797\u3002";
            }
            Paragraph gylInfo = new Paragraph(gylResult, this.normalFont);
            gylInfo.setFirstLineIndent(this.firstLineIndent);
            gylInfo.setExtraParagraphSpace(30.0f);
            gylInfo.setSpacingBefore(this.pgSpace);
            gylInfo.setLeading(this.lineSpace);
            document.add((Element)gylInfo);
            if (info.px_gyl_img != null) {
                this.AddImg(document, "\u516c\u76ca\u6797", info.px_gyl_img, "\u516c\u76ca\u6797\u9762\u79ef\uff1a" + this.Round(info.px_gyl_area, 2) + "\u4ea9");
            }
            this.AddRoleDesc(document, "\u300a\u56fd\u5bb6\u7ea7\u516c\u76ca\u6797\u7ba1\u7406\u529e\u6cd5\u300b\u7b2c\u516b\u6761 \u56fd\u5bb6\u7ea7\u516c\u76ca\u6797\u4e0d\u5f97\u968f\u610f\u8c03\u6574\u3002\u786e\u9700\u8c03\u6574\u7684\uff0c\u5fc5\u987b\u6309\u7167\u300a\u56fd\u5bb6\u7ea7\u516c\u76ca\u6797\u533a\u5212\u754c\u5b9a\u529e\u6cd5\u300b\u89c4\u5b9a\u7a0b\u5e8f\u6267\u884c\u3002", "\u653f\u7b56\u89e3\u8bfb");
            this.AddRoleDesc(document, "\u7b2c\u5341\u4e00\u6761 \u7981\u6b62\u5728\u56fd\u5bb6\u7ea7\u516c\u76ca\u6797\u5730\u5f00\u57a6\u3001\u91c7\u77f3\u3001\u91c7\u6c99\u3001\u53d6\u571f\uff0c\u4e25\u683c\u63a7\u5236\u52d8\u67e5\u3001\u5f00\u91c7\u77ff\u85cf\u548c\u5de5\u7a0b\u5efa\u8bbe\u5f81\u6536\u3001\u5f81\u7528\u3001\u5360\u7528\u56fd\u5bb6\u7ea7\u516c\u76ca\u6797\u5730\u3002\u9664\u56fd\u52a1\u9662\u6709\u5173\u90e8\u95e8\u548c\u7701\u7ea7\u4eba\u6c11\u653f\u5e9c\u6279\u51c6\u7684\u57fa\u7840\u8bbe\u65bd\u5efa\u8bbe\u9879\u76ee\u5916\uff0c\u4e0d\u5f97\u5f81\u6536\u3001\u5f81\u7528\u3001\u5360\u7528\u4e00\u7ea7\u56fd\u5bb6\u7ea7\u516c\u76ca\u6797\u5730\u3002", null);
            this.AddRoleDesc(document, "\u7ecf\u6279\u51c6\u5f81\u6536\u3001\u5f81\u7528\u3001\u5360\u7528\u7684\u56fd\u5bb6\u7ea7\u516c\u76ca\u6797\u5730\uff0c\u7531\u56fd\u5bb6\u6797\u4e1a\u5c40\u8fdb\u884c\u5ba1\u6838\u6c47\u603b\u5e76\u76f8\u5e94\u6838\u51cf\u56fd\u5bb6\u7ea7\u516c\u76ca\u6797\u603b\u91cf\uff0c\u8d22\u653f\u90e8\u6839\u636e\u56fd\u5bb6\u6797\u4e1a\u5c40\u5ba1\u6838\u7ed3\u679c\u76f8\u5e94\u6838\u51cf\u4e0b\u4e00\u5e74\u5ea6\u4e2d\u592e\u8d22\u653f\u68ee\u6797\u751f\u6001\u6548\u76ca\u8865\u507f\u57fa\u91d1\u3002", null);
            xh = hasGradeInfo ? "\u4e03" : "\u516d";
            Paragraph pdPg = new Paragraph("(" + xh + ")\u5761\u5ea6\u56fe\u5206\u6790", this.sectionFont);
            pdPg.setExtraParagraphSpace(30.0f);
            pdPg.setSpacingBefore(this.pgSpace);
            pdPg.setLeading(this.lineSpace);
            document.add((Element)pdPg);
            String pdDesc = "";
            String pdResult = "";
            double cantJsArea = 0.0;
            if (info.px_pd != null) {
                int count = 0;
                int leng = info.px_pd.size();
                for (Map.Entry item : info.px_pd.entrySet()) {
                    pdDesc = pdDesc + item.getKey() + "(\u7ea7)-" + this.Round((Double)item.getValue(), 2) + "\u4ea9";
                    if (++count < leng) {
                        pdDesc = pdDesc + "/";
                    }
                    if (!"5".equals(item.getKey())) continue;
                    cantJsArea += ((Double)item.getValue()).doubleValue();
                }
            }
            if (cantJsArea > 0.0) {
                result.passPxPd = EnumAnalyzeResult.NoPass;
                pdResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u6d89\u53ca5\u7ea7\u5761\u5ea6\u3002";
            } else {
                result.passPxPd = EnumAnalyzeResult.AllPass;
                pdResult = "\u62df\u5efa\u8bbe\u9879\u76ee\u533a\u672a\u6d89\u53ca5\u7ea7\u5761\u5ea6\u3002";
            }
            Paragraph pdInfo = new Paragraph(pdResult, this.normalFont);
            pdInfo.setFirstLineIndent(this.firstLineIndent);
            pdInfo.setExtraParagraphSpace(30.0f);
            pdInfo.setSpacingBefore(this.pgSpace);
            pdInfo.setLeading(this.lineSpace);
            document.add((Element)pdInfo);
            if (info.px_pd_img != null) {
                this.AddImg(document, "\u5761\u5ea6\u5206\u6790", info.px_pd_img, pdDesc);
            }
            this.AddRoleDesc(document, "\u6839\u636e\u840d\u4e61\u5730\u5f62\u548c\u73af\u5883\u56e0\u7d20\uff0c\u5761\u5ea6\u4e3a5\u7ea7\u65f6\u4e0d\u5141\u8bb8\u571f\u5730\u5f00\u53d1\u3002", "\u653f\u7b56\u89e3\u8bfb");
        }
    }

    private void SummarizeAnalysis(Document document, ProjectInfo info, ResultInfo result, boolean px) throws DocumentException {
        boolean legal;
        Paragraph chapter4Pg = new Paragraph("\u56db\u3001\u603b\u4f53\u5206\u6790", this.chapterFont);
        chapter4Pg.setExtraParagraphSpace(30.0f);
        chapter4Pg.setSpacingBefore(this.pgSpace);
        chapter4Pg.setLeading(this.lineSpace);
        document.add((Element)chapter4Pg);
        String content = "\u6839\u636e\u5df2\u6709\u6570\u636e\u5206\u6790\u7ed3\u679c\uff0c\u62df\u5efa\u8bbe\u9879\u76ee\u533a";
        if (!px) {
            boolean allPass;
            legal = result.passJbnt == EnumAnalyzeResult.AllPass && result.passTdgh == EnumAnalyzeResult.AllPass && result.passSpba == EnumAnalyzeResult.AllPass && result.passZrbhq == EnumAnalyzeResult.AllPass;
            boolean suitable = result.passDzfx == EnumAnalyzeResult.AllPass && result.passSd == EnumAnalyzeResult.AllPass;
            boolean unlegal = result.passJbnt == EnumAnalyzeResult.NoPass || result.passTdgh == EnumAnalyzeResult.NoPass || result.passSpba == EnumAnalyzeResult.NoPass || result.passZrbhq == EnumAnalyzeResult.NoPass;
            boolean unsuitable = result.passDzfx == EnumAnalyzeResult.NoPass || result.passSd == EnumAnalyzeResult.NoPass;
            boolean bl = allPass = legal && suitable;
            if (allPass) {
                content = content + "\u5408\u6cd5\u3001\u9002\u5b9c\u3002";
                content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                content = content + "\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                content = content + "\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                content = content + "\u4e0d\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                content = content + "\u4e0d\u5360\u7528\u6e7f\u5730\u3002";
            } else if (unlegal) {
                content = content + "\u4e0d\u5408\u6cd5\u3001\u4e0d\u9002\u5b9c\u3002";
                switch (result.passJbnt) {
                    case NoPass: {
                        content = content + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                    }
                }
                switch (result.passTdgh) {
                    case NoPass: {
                        content = content + "\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                    }
                }
                switch (result.passSpba) {
                    case NoPass: {
                        content = content + "\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                    }
                }
                switch (result.passZrbhq) {
                    case NoPass: {
                        content = content + "\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                    }
                }
                switch (result.passDzfx) {
                    case NoPass: {
                        content = content + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                    }
                }
                switch (result.passSd) {
                    case NoPass: {
                        content = content + "\u5360\u7528\u6e7f\u5730\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u6e7f\u5730\u3001";
                    }
                }
                content = content.substring(0, content.length() - 1) + "\u3002";
            } else if (unsuitable) {
                content = content + "\u4e0d\u9002\u5b9c\u3002";
                switch (result.passDzfx) {
                    case NoPass: {
                        content = content + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                    }
                }
                switch (result.passSd) {
                    case NoPass: {
                        content = content + "\u5360\u7528\u6e7f\u5730\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u6e7f\u5730\u3001";
                    }
                }
                content = content.substring(0, content.length() - 1) + "\u3002";
            } else {
                boolean partlegal = false;
                boolean partsuitable = false;
                String tmp = "";
                if (result.passJbnt == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                    partlegal = true;
                }
                if (result.passTdgh == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                    partlegal = true;
                }
                if (result.passSpba == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                    partlegal = true;
                }
                if (result.passZrbhq == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                    partlegal = true;
                }
                if (result.passDzfx == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                    partsuitable = true;
                }
                if (result.passSd == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u5360\u7528\u6e7f\u5730\u3001";
                    partsuitable = true;
                }
                tmp = tmp.substring(0, tmp.length() - 1) + "\u3002";
                if (partlegal && partsuitable) {
                    content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u3001\u4e0d\u9002\u5b9c\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
                } else if (partlegal) {
                    content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
                } else if (partsuitable) {
                    content = content + "\u5b58\u5728\u4e0d\u9002\u5b9c\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
                }
                content = content + tmp;
            }
        } else {
            boolean allPass;
            legal = result.passJbnt == EnumAnalyzeResult.AllPass && result.passTdgh == EnumAnalyzeResult.AllPass && result.passSpba == EnumAnalyzeResult.AllPass && result.passZrbhq == EnumAnalyzeResult.AllPass;
            boolean suitable = result.passDzfx == EnumAnalyzeResult.AllPass && result.passSd == EnumAnalyzeResult.AllPass && result.passPxSthx == EnumAnalyzeResult.AllPass && result.passPxGyl == EnumAnalyzeResult.AllPass && result.passPxPd == EnumAnalyzeResult.AllPass;
            boolean unlegal = result.passJbnt == EnumAnalyzeResult.NoPass || result.passTdgh == EnumAnalyzeResult.NoPass || result.passSpba == EnumAnalyzeResult.NoPass || result.passZrbhq == EnumAnalyzeResult.NoPass;
            boolean unsuitable = result.passDzfx == EnumAnalyzeResult.NoPass || result.passSd == EnumAnalyzeResult.NoPass || result.passPxSthx == EnumAnalyzeResult.NoPass || result.passPxGyl == EnumAnalyzeResult.NoPass || result.passPxPd == EnumAnalyzeResult.NoPass;
            boolean bl = allPass = legal && suitable;
            if (allPass) {
                content = content + "\u5408\u6cd5\u3001\u9002\u5b9c\u3002";
                content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                content = content + "\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                content = content + "\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                content = content + "\u4e0d\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                content = content + "\u4e0d\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                content = content + "\u4e0d\u5360\u7528\u6e7f\u5730\u3001";
                content = content + "\u4e0d\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3001";
                content = content + "\u4e0d\u5360\u7528\u516c\u76ca\u6797\u3001";
                content = content + "\u4e0d\u6d89\u53ca5\u7ea7\u5761\u5ea6\u3002";
            } else if (unlegal) {
                content = content + "\u4e0d\u5408\u6cd5\u3001\u4e0d\u9002\u5b9c\u3002";
                switch (result.passJbnt) {
                    case NoPass: {
                        content = content + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                    }
                }
                switch (result.passTdgh) {
                    case NoPass: {
                        content = content + "\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                    }
                }
                switch (result.passSpba) {
                    case NoPass: {
                        content = content + "\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                    }
                }
                switch (result.passZrbhq) {
                    case NoPass: {
                        content = content + "\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                    }
                }
                switch (result.passDzfx) {
                    case NoPass: {
                        content = content + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                    }
                }
                switch (result.passSd) {
                    case NoPass: {
                        content = content + "\u5360\u7528\u6e7f\u5730\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u6e7f\u5730\u3001";
                    }
                }
                switch (result.passPxSthx) {
                    case NoPass: {
                        content = content + "\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3001";
                    }
                }
                switch (result.passPxGyl) {
                    case NoPass: {
                        content = content + "\u5360\u7528\u516c\u76ca\u6797\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u516c\u76ca\u6797\u3001";
                    }
                }
                switch (result.passPxPd) {
                    case NoPass: {
                        content = content + "\u6d89\u53ca5\u7ea7\u5761\u5ea6\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca5\u7ea7\u5761\u5ea6\u3001";
                    }
                }
                content = content.substring(0, content.length() - 1) + "\u3002";
            } else if (unsuitable) {
                content = content + "\u4e0d\u9002\u5b9c\u3002";
                switch (result.passDzfx) {
                    case NoPass: {
                        content = content + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                    }
                }
                switch (result.passSd) {
                    case NoPass: {
                        content = content + "\u5360\u7528\u6e7f\u5730\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u6e7f\u5730\u3001";
                    }
                }
                switch (result.passPxSthx) {
                    case NoPass: {
                        content = content + "\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3001";
                    }
                }
                switch (result.passPxGyl) {
                    case NoPass: {
                        content = content + "\u5360\u7528\u516c\u76ca\u6797\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u5360\u7528\u516c\u76ca\u6797\u3001";
                    }
                }
                switch (result.passPxPd) {
                    case NoPass: {
                        content = content + "\u6d89\u53ca5\u7ea7\u5761\u5ea6\u3001";
                        break;
                    }
                    case PartPass: {
                        content = content + "\u90e8\u5206\u533a\u57df\u6d89\u53ca5\u7ea7\u5761\u5ea6\u3001";
                    }
                }
                content = content.substring(0, content.length() - 1) + "\u3002";
            } else {
                boolean partlegal = false;
                boolean partsuitable = false;
                String tmp = "";
                if (result.passJbnt == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u6d89\u53ca\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
                    partlegal = true;
                }
                if (result.passTdgh == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u4e0d\u7b26\u5408\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
                    partlegal = true;
                }
                if (result.passSpba == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                    partlegal = true;
                }
                if (result.passZrbhq == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u6d89\u53ca\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\u3001";
                    partlegal = true;
                }
                if (result.passDzfx == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u5b58\u5728\u5730\u8d28\u707e\u5bb3\u9690\u60a3\u3001";
                    partsuitable = true;
                }
                if (result.passSd == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u5360\u7528\u6e7f\u5730\u3001";
                    partsuitable = true;
                }
                if (result.passPxSthx == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u5360\u7528\u751f\u6001\u4fdd\u62a4\u7ea2\u7ebf\u3001";
                    partsuitable = true;
                }
                if (result.passPxGyl == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u5360\u7528\u516c\u76ca\u6797\u3001";
                    partsuitable = true;
                }
                if (result.passPxPd == EnumAnalyzeResult.PartPass) {
                    tmp = tmp + "\u6d89\u53ca5\u7ea7\u5761\u5ea6\u3001";
                    partsuitable = true;
                }
                tmp = tmp.substring(0, tmp.length() - 1) + "\u3002";
                if (partlegal && partsuitable) {
                    content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u3001\u4e0d\u9002\u5b9c\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
                } else if (partlegal) {
                    content = content + "\u5b58\u5728\u4e0d\u7b26\u5408\u6cd5\u5f8b\u6cd5\u89c4\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
                } else if (partsuitable) {
                    content = content + "\u5b58\u5728\u4e0d\u9002\u5b9c\u7684\u60c5\u51b5\u3002\u6bd4\u5982\u90e8\u5206\u5730\u533a";
                }
                content = content + tmp;
            }
        }
        Paragraph contentPg = new Paragraph(content, this.normalFont);
        contentPg.setFirstLineIndent(this.firstLineIndent);
        contentPg.setExtraParagraphSpace(30.0f);
        contentPg.setSpacingBefore(this.pgSpace);
        contentPg.setLeading(this.lineSpace);
        document.add((Element)contentPg);
    }

    private void SummarizeAnalysisLawless(Document document, LawlessInfo info, ResultInfo result) throws DocumentException {
        Paragraph chapter4Pg = new Paragraph("\u56db\u3001\u603b\u4f53\u5206\u6790", this.chapterFont);
        chapter4Pg.setExtraParagraphSpace(30.0f);
        chapter4Pg.setSpacingBefore(this.pgSpace);
        chapter4Pg.setLeading(this.lineSpace);
        document.add((Element)chapter4Pg);
        boolean legal = result.passJbnt == EnumAnalyzeResult.AllPass && result.passTdgh == EnumAnalyzeResult.AllPass && result.passSpba == EnumAnalyzeResult.AllPass && result.passZrbhq == EnumAnalyzeResult.AllPass;
        String content = "\u6839\u636e\u5df2\u6709\u6570\u636e\u5206\u6790\u7ed3\u679c\uff0c\u8be5\u9065\u611f\u76d1\u6d4b\u56fe\u6591";
        content = content + (legal ? "\u5c5e\u4e8e\u5408\u6cd5\u5efa\u8bbe\u7528\u5730" : "\u5c5e\u4e8e\u8fdd\u6cd5\u5efa\u8bbe\u7528\u5730");
        content = content + "\uff0c";
        content = content + (result.passJbnt != EnumAnalyzeResult.AllPass ? "\u6d89\u53ca" : "\u4e0d\u6d89\u53ca") + "\u5360\u7528\u6c38\u4e45\u57fa\u672c\u519c\u7530\u3001";
        content = content + (result.passTdgh != EnumAnalyzeResult.AllPass ? "\u4e0d\u7b26\u5408" : "\u7b26\u5408") + "\u571f\u5730\u5229\u7528\u603b\u4f53\u89c4\u5212\u3001";
        switch (result.passSpba) {
            case AllPass: {
                content = content + "\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                break;
            }
            case PartPass: {
                content = content + "\u90e8\u5206\u533a\u57df\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
                break;
            }
            case NoPass: {
                content = content + "\u6ca1\u6709\u5408\u6cd5\u5efa\u8bbe\u7528\u5730\u5ba1\u6279\u624b\u7eed\u3001";
            }
        }
        content = content + (result.passZrbhq != EnumAnalyzeResult.AllPass ? "\u6d89\u53ca" : "\u4e0d\u6d89\u53ca") + "\u5360\u7528\u81ea\u7136\u4fdd\u62a4\u5730\uff0c";
        content = !legal ? content + "\u5efa\u8bae\u53d8\u66f4\u4e3a\u4e34\u65f6\u7528\u5730\u6216\u8bbe\u65bd\u519c\u7528\u5730\u3002" : content.substring(0, content.length() - 1) + "\u3002";
        Paragraph contentPg = new Paragraph(content, this.normalFont);
        contentPg.setFirstLineIndent(this.firstLineIndent);
        contentPg.setExtraParagraphSpace(30.0f);
        contentPg.setSpacingBefore(this.pgSpace);
        contentPg.setLeading(this.lineSpace);
        document.add((Element)contentPg);
    }

    private void AddBaseImg(Document document, ProjectInfo info) throws DocumentException {
        int col = 2;
        if (info.narrow) {
            col = 1;
            PdfPTable t1 = new PdfPTable(col);
            t1.setSpacingBefore(this.pgSpace);
            t1.setSpacingAfter(this.pgSpace);
            t1.setWidthPercentage(80.0f);
            PdfPTable t2 = new PdfPTable(col);
            t2.setSpacingBefore(this.pgSpace);
            t2.setSpacingAfter(this.pgSpace);
            t2.setWidthPercentage(80.0f);
            PdfPCell c1 = null;
            c1 = new PdfPCell(new Phrase("\u9879\u76ee\u533a\u4f4d\u7f6e", this.normalFont));
            c1.setVerticalAlignment(1);
            c1.setHorizontalAlignment(1);
            c1.setPaddingTop(5.0f);
            c1.setPaddingBottom(5.0f);
            PdfPCell c2 = null;
            c2 = new PdfPCell(new Phrase("\u571f\u5730\u5229\u7528\u73b0\u72b6\u56fe", this.normalFont));
            c2.setVerticalAlignment(1);
            c2.setHorizontalAlignment(1);
            c2.setPaddingTop(5.0f);
            c2.setPaddingBottom(5.0f);
            PdfPCell cimg1 = null;
            float width = 250.0f;
            float heigth = 250.0f;
            if (info.ownershipImg != null) {
                heigth = info.ownershipImg.getHeight() / (info.ownershipImg.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.ownershipImg.scaleToFit(width, heigth);
                cimg1 = new PdfPCell(info.ownershipImg);
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            } else {
                cimg1 = new PdfPCell();
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            }
            PdfPCell cimg2 = null;
            if (info.landtypeImg != null) {
                heigth = info.landtypeImg.getHeight() / (info.landtypeImg.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.landtypeImg.scaleToFit(width, heigth);
                cimg2 = new PdfPCell(info.landtypeImg);
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            } else {
                cimg2 = new PdfPCell();
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            }
            PdfPCell meta1 = null;
            meta1 = new PdfPCell(new Phrase(info.ownershipImgMeta, this.roleFont));
            meta1.setVerticalAlignment(1);
            meta1.setHorizontalAlignment(1);
            meta1.setPaddingTop(5.0f);
            meta1.setPaddingBottom(5.0f);
            PdfPCell meta2 = null;
            meta2 = new PdfPCell(new Phrase(info.landtypeImgMeta, this.roleFont));
            meta2.setVerticalAlignment(1);
            meta2.setHorizontalAlignment(1);
            meta2.setPaddingTop(5.0f);
            meta2.setPaddingBottom(5.0f);
            if (info.ownershipImg != null) {
                t1.addCell(c1);
                t1.addCell(cimg1);
                t1.addCell(meta1);
            }
            if (info.landtypeImg != null) {
                t2.addCell(c2);
                t2.addCell(cimg2);
                t2.addCell(meta2);
            }
            if (info.photo1 != null || info.photo2 != null) {
                PdfPCell photo1 = new PdfPCell(new Phrase("\u5b9e\u5730\u7167\u72471", this.normalFont));
                photo1.setVerticalAlignment(1);
                photo1.setHorizontalAlignment(1);
                photo1.setPaddingTop(5.0f);
                photo1.setPaddingBottom(5.0f);
                PdfPCell photo2 = new PdfPCell(new Phrase("\u5b9e\u5730\u7167\u72472", this.normalFont));
                photo2.setVerticalAlignment(1);
                photo2.setHorizontalAlignment(1);
                photo2.setPaddingTop(5.0f);
                photo2.setPaddingBottom(5.0f);
                PdfPCell cp1 = null;
                if (info.photo1 != null) {
                    Image img1 = Image.getInstance((Image)info.photo1);
                    heigth = img1.getHeight() / (img1.getWidth() / width);
                    img1.scaleToFit(width, heigth);
                    cp1 = new PdfPCell(img1);
                } else {
                    cp1 = new PdfPCell();
                }
                cp1.setVerticalAlignment(1);
                cp1.setHorizontalAlignment(1);
                cp1.setPaddingTop(5.0f);
                cp1.setPaddingBottom(5.0f);
                cp1.setPaddingLeft(5.0f);
                cp1.setPaddingRight(5.0f);
                PdfPCell cp2 = null;
                if (info.photo2 != null) {
                    Image img2 = Image.getInstance((Image)info.photo2);
                    heigth = img2.getHeight() / (img2.getWidth() / width);
                    img2.scaleToFit(width, heigth);
                    cp2 = new PdfPCell(img2);
                } else {
                    cp2 = new PdfPCell();
                }
                cp2.setVerticalAlignment(1);
                cp2.setHorizontalAlignment(1);
                cp2.setPaddingTop(5.0f);
                cp2.setPaddingBottom(5.0f);
                cp2.setPaddingLeft(5.0f);
                cp2.setPaddingRight(5.0f);
                PdfPCell pmeta1 = new PdfPCell(new Phrase(info.photoMeta1, this.normalFont));
                pmeta1.setVerticalAlignment(1);
                pmeta1.setHorizontalAlignment(1);
                pmeta1.setPaddingTop(5.0f);
                pmeta1.setPaddingBottom(5.0f);
                PdfPCell pmeta2 = new PdfPCell(new Phrase(info.photoMeta2, this.normalFont));
                pmeta2.setVerticalAlignment(1);
                pmeta2.setHorizontalAlignment(1);
                pmeta2.setPaddingTop(5.0f);
                pmeta2.setPaddingBottom(5.0f);
                t2.addCell(photo1);
                t2.addCell(photo2);
                t2.addCell(cp1);
                t2.addCell(cp2);
                t2.addCell(pmeta1);
                t2.addCell(pmeta2);
            }
            document.add((Element)t1);
            document.newPage();
            document.add((Element)t2);
        } else {
            PdfPTable t = new PdfPTable(col);
            t.setSpacingBefore(this.pgSpace);
            t.setSpacingAfter(this.pgSpace);
            t.setWidthPercentage(100.0f);
            PdfPCell c1 = null;
            c1 = new PdfPCell(new Phrase("\u9879\u76ee\u533a\u4f4d\u7f6e", this.normalFont));
            c1.setVerticalAlignment(1);
            c1.setHorizontalAlignment(1);
            c1.setPaddingTop(5.0f);
            c1.setPaddingBottom(5.0f);
            PdfPCell c2 = null;
            c2 = new PdfPCell(new Phrase("\u571f\u5730\u5229\u7528\u73b0\u72b6\u56fe", this.normalFont));
            c2.setVerticalAlignment(1);
            c2.setHorizontalAlignment(1);
            c2.setPaddingTop(5.0f);
            c2.setPaddingBottom(5.0f);
            PdfPCell cimg1 = null;
            float width = 250.0f;
            float heigth = 250.0f;
            if (info.ownershipImg != null) {
                heigth = info.ownershipImg.getHeight() / (info.ownershipImg.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.ownershipImg.scaleToFit(width, heigth);
                cimg1 = new PdfPCell(info.ownershipImg);
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            } else {
                cimg1 = new PdfPCell();
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            }
            PdfPCell cimg2 = null;
            if (info.landtypeImg != null) {
                heigth = info.landtypeImg.getHeight() / (info.landtypeImg.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.landtypeImg.scaleToFit(width, heigth);
                cimg2 = new PdfPCell(info.landtypeImg);
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            } else {
                cimg2 = new PdfPCell();
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            }
            PdfPCell meta1 = null;
            meta1 = new PdfPCell(new Phrase(info.ownershipImgMeta, this.roleFont));
            meta1.setVerticalAlignment(1);
            meta1.setHorizontalAlignment(1);
            meta1.setPaddingTop(5.0f);
            meta1.setPaddingBottom(5.0f);
            PdfPCell meta2 = null;
            meta2 = new PdfPCell(new Phrase(info.landtypeImgMeta, this.roleFont));
            meta2.setVerticalAlignment(1);
            meta2.setHorizontalAlignment(1);
            meta2.setPaddingTop(5.0f);
            meta2.setPaddingBottom(5.0f);
            t.addCell(c1);
            t.addCell(c2);
            t.addCell(cimg1);
            t.addCell(cimg2);
            t.addCell(meta1);
            t.addCell(meta2);
            if (info.photo1 != null || info.photo2 != null) {
                PdfPCell photo1 = new PdfPCell(new Phrase("\u5b9e\u5730\u7167\u72471", this.normalFont));
                photo1.setVerticalAlignment(1);
                photo1.setHorizontalAlignment(1);
                photo1.setPaddingTop(5.0f);
                photo1.setPaddingBottom(5.0f);
                PdfPCell photo2 = new PdfPCell(new Phrase("\u5b9e\u5730\u7167\u72472", this.normalFont));
                photo2.setVerticalAlignment(1);
                photo2.setHorizontalAlignment(1);
                photo2.setPaddingTop(5.0f);
                photo2.setPaddingBottom(5.0f);
                PdfPCell cp1 = null;
                if (info.photo1 != null) {
                    Image img1 = Image.getInstance((Image)info.photo1);
                    heigth = img1.getHeight() / (img1.getWidth() / width);
                    img1.scaleToFit(width, heigth);
                    cp1 = new PdfPCell(img1);
                } else {
                    cp1 = new PdfPCell();
                }
                cp1.setVerticalAlignment(1);
                cp1.setHorizontalAlignment(1);
                cp1.setPaddingTop(5.0f);
                cp1.setPaddingBottom(5.0f);
                cp1.setPaddingLeft(5.0f);
                cp1.setPaddingRight(5.0f);
                PdfPCell cp2 = null;
                if (info.photo2 != null) {
                    Image img2 = Image.getInstance((Image)info.photo2);
                    heigth = img2.getHeight() / (img2.getWidth() / width);
                    img2.scaleToFit(width, heigth);
                    cp2 = new PdfPCell(img2);
                } else {
                    cp2 = new PdfPCell();
                }
                cp2.setVerticalAlignment(1);
                cp2.setHorizontalAlignment(1);
                cp2.setPaddingTop(5.0f);
                cp2.setPaddingBottom(5.0f);
                cp2.setPaddingLeft(5.0f);
                cp2.setPaddingRight(5.0f);
                PdfPCell pmeta1 = new PdfPCell(new Phrase(info.photoMeta1, this.normalFont));
                pmeta1.setVerticalAlignment(1);
                pmeta1.setHorizontalAlignment(1);
                pmeta1.setPaddingTop(5.0f);
                pmeta1.setPaddingBottom(5.0f);
                PdfPCell pmeta2 = new PdfPCell(new Phrase(info.photoMeta2, this.normalFont));
                pmeta2.setVerticalAlignment(1);
                pmeta2.setHorizontalAlignment(1);
                pmeta2.setPaddingTop(5.0f);
                pmeta2.setPaddingBottom(5.0f);
                t.addCell(photo1);
                t.addCell(photo2);
                t.addCell(cp1);
                t.addCell(cp2);
                t.addCell(pmeta1);
                t.addCell(pmeta2);
            }
            document.add((Element)t);
        }
    }

    private void AddBaseImgLawless(Document document, LawlessInfo info) throws DocumentException {
        if (info.ownershipImg != null) {
            this.AddImg(document, "\u4f4d\u7f6e\u56fe", info.ownershipImg, info.ownershipImgMeta);
        }
    }

    private void AddBaseImgLawless2(Document document, LawlessInfo info) throws DocumentException {
        int col = 2;
        if (info.narrow) {
            col = 1;
            PdfPTable t1 = new PdfPTable(col);
            t1.setSpacingBefore(this.pgSpace);
            t1.setSpacingAfter(this.pgSpace);
            t1.setWidthPercentage(80.0f);
            PdfPTable t2 = new PdfPTable(col);
            t2.setSpacingBefore(this.pgSpace);
            t2.setSpacingAfter(this.pgSpace);
            t2.setWidthPercentage(80.0f);
            PdfPCell c1 = null;
            c1 = new PdfPCell(new Phrase("\u9879\u76ee\u533a\u4f4d\u7f6e", this.normalFont));
            c1.setVerticalAlignment(1);
            c1.setHorizontalAlignment(1);
            c1.setPaddingTop(5.0f);
            c1.setPaddingBottom(5.0f);
            PdfPCell c2 = null;
            c2 = new PdfPCell(new Phrase("\u571f\u5730\u5229\u7528\u73b0\u72b6\u56fe", this.normalFont));
            c2.setVerticalAlignment(1);
            c2.setHorizontalAlignment(1);
            c2.setPaddingTop(5.0f);
            c2.setPaddingBottom(5.0f);
            PdfPCell cimg1 = null;
            float width = 250.0f;
            float heigth = 250.0f;
            if (info.ownershipImg != null) {
                heigth = info.ownershipImg.getHeight() / (info.ownershipImg.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.ownershipImg.scaleToFit(width, heigth);
                cimg1 = new PdfPCell(info.ownershipImg);
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            } else {
                cimg1 = new PdfPCell();
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            }
            PdfPCell cimg2 = null;
            if (info.landtypeImg != null) {
                heigth = info.landtypeImg.getHeight() / (info.landtypeImg.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.landtypeImg.scaleToFit(width, heigth);
                cimg2 = new PdfPCell(info.landtypeImg);
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            } else {
                cimg2 = new PdfPCell();
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            }
            PdfPCell meta1 = null;
            meta1 = new PdfPCell(new Phrase(info.ownershipImgMeta, this.roleFont));
            meta1.setVerticalAlignment(1);
            meta1.setHorizontalAlignment(1);
            meta1.setPaddingTop(5.0f);
            meta1.setPaddingBottom(5.0f);
            PdfPCell meta2 = null;
            meta2 = new PdfPCell(new Phrase(info.landtypeImgMeta, this.roleFont));
            meta2.setVerticalAlignment(1);
            meta2.setHorizontalAlignment(1);
            meta2.setPaddingTop(5.0f);
            meta2.setPaddingBottom(5.0f);
            if (info.ownershipImg != null) {
                t1.addCell(c1);
                t1.addCell(cimg1);
                t1.addCell(meta1);
            }
            if (info.landtypeImg != null) {
                t2.addCell(c2);
                t2.addCell(cimg2);
                t2.addCell(meta2);
            }
            if (info.photo1 != null || info.photo2 != null) {
                PdfPCell photo1 = new PdfPCell(new Phrase("\u5b9e\u5730\u7167\u72471", this.normalFont));
                photo1.setVerticalAlignment(1);
                photo1.setHorizontalAlignment(1);
                photo1.setPaddingTop(5.0f);
                photo1.setPaddingBottom(5.0f);
                PdfPCell photo2 = new PdfPCell(new Phrase("\u5b9e\u5730\u7167\u72472", this.normalFont));
                photo2.setVerticalAlignment(1);
                photo2.setHorizontalAlignment(1);
                photo2.setPaddingTop(5.0f);
                photo2.setPaddingBottom(5.0f);
                PdfPCell cp1 = null;
                if (info.photo1 != null) {
                    Image img1 = Image.getInstance((Image)info.photo1);
                    heigth = img1.getHeight() / (img1.getWidth() / width);
                    img1.scaleToFit(width, heigth);
                    cp1 = new PdfPCell(img1);
                } else {
                    cp1 = new PdfPCell();
                }
                cp1.setVerticalAlignment(1);
                cp1.setHorizontalAlignment(1);
                cp1.setPaddingTop(5.0f);
                cp1.setPaddingBottom(5.0f);
                cp1.setPaddingLeft(5.0f);
                cp1.setPaddingRight(5.0f);
                PdfPCell cp2 = null;
                if (info.photo2 != null) {
                    Image img2 = Image.getInstance((Image)info.photo2);
                    heigth = img2.getHeight() / (img2.getWidth() / width);
                    img2.scaleToFit(width, heigth);
                    cp2 = new PdfPCell(img2);
                } else {
                    cp2 = new PdfPCell();
                }
                cp2.setVerticalAlignment(1);
                cp2.setHorizontalAlignment(1);
                cp2.setPaddingTop(5.0f);
                cp2.setPaddingBottom(5.0f);
                cp2.setPaddingLeft(5.0f);
                cp2.setPaddingRight(5.0f);
                PdfPCell pmeta1 = new PdfPCell(new Phrase(info.photoMeta1, this.normalFont));
                pmeta1.setVerticalAlignment(1);
                pmeta1.setHorizontalAlignment(1);
                pmeta1.setPaddingTop(5.0f);
                pmeta1.setPaddingBottom(5.0f);
                PdfPCell pmeta2 = new PdfPCell(new Phrase(info.photoMeta2, this.normalFont));
                pmeta2.setVerticalAlignment(1);
                pmeta2.setHorizontalAlignment(1);
                pmeta2.setPaddingTop(5.0f);
                pmeta2.setPaddingBottom(5.0f);
                t2.addCell(photo1);
                t2.addCell(photo2);
                t2.addCell(cp1);
                t2.addCell(cp2);
                t2.addCell(pmeta1);
                t2.addCell(pmeta2);
            }
            document.add((Element)t1);
            document.newPage();
            document.add((Element)t2);
        } else {
            PdfPTable t = new PdfPTable(col);
            t.setSpacingBefore(this.pgSpace);
            t.setSpacingAfter(this.pgSpace);
            t.setWidthPercentage(100.0f);
            PdfPCell c1 = null;
            c1 = new PdfPCell(new Phrase("\u9879\u76ee\u533a\u4f4d\u7f6e", this.normalFont));
            c1.setVerticalAlignment(1);
            c1.setHorizontalAlignment(1);
            c1.setPaddingTop(5.0f);
            c1.setPaddingBottom(5.0f);
            PdfPCell c2 = null;
            c2 = new PdfPCell(new Phrase("\u571f\u5730\u5229\u7528\u73b0\u72b6\u56fe", this.normalFont));
            c2.setVerticalAlignment(1);
            c2.setHorizontalAlignment(1);
            c2.setPaddingTop(5.0f);
            c2.setPaddingBottom(5.0f);
            PdfPCell cimg1 = null;
            float width = 250.0f;
            float heigth = 250.0f;
            if (info.ownershipImg != null) {
                heigth = info.ownershipImg.getHeight() / (info.ownershipImg.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.ownershipImg.scaleToFit(width, heigth);
                cimg1 = new PdfPCell(info.ownershipImg);
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            } else {
                cimg1 = new PdfPCell();
                cimg1.setVerticalAlignment(1);
                cimg1.setHorizontalAlignment(1);
                cimg1.setPaddingTop(5.0f);
                cimg1.setPaddingBottom(5.0f);
                cimg1.setPaddingLeft(5.0f);
                cimg1.setPaddingRight(5.0f);
            }
            PdfPCell cimg2 = null;
            if (info.landtypeImg != null) {
                heigth = info.landtypeImg.getHeight() / (info.landtypeImg.getWidth() / width);
                System.out.println("width:" + width);
                System.out.println("heigth:" + heigth);
                info.landtypeImg.scaleToFit(width, heigth);
                cimg2 = new PdfPCell(info.landtypeImg);
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            } else {
                cimg2 = new PdfPCell();
                cimg2.setVerticalAlignment(1);
                cimg2.setHorizontalAlignment(1);
                cimg2.setPaddingTop(5.0f);
                cimg2.setPaddingBottom(5.0f);
                cimg2.setPaddingLeft(5.0f);
                cimg2.setPaddingRight(5.0f);
            }
            PdfPCell meta1 = null;
            meta1 = new PdfPCell(new Phrase(info.ownershipImgMeta, this.roleFont));
            meta1.setVerticalAlignment(1);
            meta1.setHorizontalAlignment(1);
            meta1.setPaddingTop(5.0f);
            meta1.setPaddingBottom(5.0f);
            PdfPCell meta2 = null;
            meta2 = new PdfPCell(new Phrase(info.landtypeImgMeta, this.roleFont));
            meta2.setVerticalAlignment(1);
            meta2.setHorizontalAlignment(1);
            meta2.setPaddingTop(5.0f);
            meta2.setPaddingBottom(5.0f);
            t.addCell(c1);
            t.addCell(c2);
            t.addCell(cimg1);
            t.addCell(cimg2);
            t.addCell(meta1);
            t.addCell(meta2);
            if (info.photo1 != null || info.photo2 != null) {
                PdfPCell photo1 = new PdfPCell(new Phrase("\u5b9e\u5730\u7167\u72471", this.normalFont));
                photo1.setVerticalAlignment(1);
                photo1.setHorizontalAlignment(1);
                photo1.setPaddingTop(5.0f);
                photo1.setPaddingBottom(5.0f);
                PdfPCell photo2 = new PdfPCell(new Phrase("\u5b9e\u5730\u7167\u72472", this.normalFont));
                photo2.setVerticalAlignment(1);
                photo2.setHorizontalAlignment(1);
                photo2.setPaddingTop(5.0f);
                photo2.setPaddingBottom(5.0f);
                PdfPCell cp1 = null;
                if (info.photo1 != null) {
                    Image img1 = Image.getInstance((Image)info.photo1);
                    heigth = img1.getHeight() / (img1.getWidth() / width);
                    img1.scaleToFit(width, heigth);
                    cp1 = new PdfPCell(img1);
                } else {
                    cp1 = new PdfPCell();
                }
                cp1.setVerticalAlignment(1);
                cp1.setHorizontalAlignment(1);
                cp1.setPaddingTop(5.0f);
                cp1.setPaddingBottom(5.0f);
                cp1.setPaddingLeft(5.0f);
                cp1.setPaddingRight(5.0f);
                PdfPCell cp2 = null;
                if (info.photo2 != null) {
                    Image img2 = Image.getInstance((Image)info.photo2);
                    heigth = img2.getHeight() / (img2.getWidth() / width);
                    img2.scaleToFit(width, heigth);
                    cp2 = new PdfPCell(img2);
                } else {
                    cp2 = new PdfPCell();
                }
                cp2.setVerticalAlignment(1);
                cp2.setHorizontalAlignment(1);
                cp2.setPaddingTop(5.0f);
                cp2.setPaddingBottom(5.0f);
                cp2.setPaddingLeft(5.0f);
                cp2.setPaddingRight(5.0f);
                PdfPCell pmeta1 = new PdfPCell(new Phrase(info.photoMeta1, this.normalFont));
                pmeta1.setVerticalAlignment(1);
                pmeta1.setHorizontalAlignment(1);
                pmeta1.setPaddingTop(5.0f);
                pmeta1.setPaddingBottom(5.0f);
                PdfPCell pmeta2 = new PdfPCell(new Phrase(info.photoMeta2, this.normalFont));
                pmeta2.setVerticalAlignment(1);
                pmeta2.setHorizontalAlignment(1);
                pmeta2.setPaddingTop(5.0f);
                pmeta2.setPaddingBottom(5.0f);
                t.addCell(photo1);
                t.addCell(photo2);
                t.addCell(cp1);
                t.addCell(cp2);
                t.addCell(pmeta1);
                t.addCell(pmeta2);
            }
            document.add((Element)t);
        }
    }

    private void AddImg(Document document, String title, Image img, String desc) throws DocumentException {
        PdfPTable t = new PdfPTable(1);
        t.setKeepTogether(true);
        t.setSpacingBefore(this.pgSpace);
        t.setSpacingAfter(this.pgSpace);
        t.setWidthPercentage(80.0f);
        PdfPCell titleCell = new PdfPCell(new Phrase(title, this.normalFont));
        titleCell.setVerticalAlignment(1);
        titleCell.setHorizontalAlignment(1);
        titleCell.setPaddingTop(5.0f);
        titleCell.setPaddingBottom(5.0f);
        t.addCell(titleCell);
        float width = 250.0f;
        float heigth = img.getHeight() / (img.getWidth() / width);
        img.scaleToFit(width, heigth);
        PdfPCell cimg1 = new PdfPCell(img);
        cimg1.setVerticalAlignment(1);
        cimg1.setHorizontalAlignment(1);
        cimg1.setPaddingTop(5.0f);
        cimg1.setPaddingBottom(5.0f);
        cimg1.setPaddingLeft(5.0f);
        cimg1.setPaddingRight(5.0f);
        t.addCell(cimg1);
        PdfPCell descCell = new PdfPCell(new Phrase(desc, this.roleFont));
        descCell.setVerticalAlignment(1);
        descCell.setHorizontalAlignment(1);
        descCell.setPaddingTop(5.0f);
        descCell.setPaddingBottom(5.0f);
        t.addCell(descCell);
        document.add((Element)t);
    }

    private void AddImg2(Document document, String title, Image img, String desc, boolean first, boolean last) throws DocumentException {
        PdfPTable t = new PdfPTable(1);
        t.setKeepTogether(true);
        if (first) {
            t.setSpacingBefore(this.pgSpace);
        } else if (last) {
            t.setSpacingAfter(this.pgSpace);
        }
        t.setWidthPercentage(75.0f);
        PdfPCell titleCell = new PdfPCell(new Phrase(title, this.normalFont));
        titleCell.setVerticalAlignment(1);
        titleCell.setHorizontalAlignment(1);
        titleCell.setPaddingTop(5.0f);
        titleCell.setPaddingBottom(5.0f);
        t.addCell(titleCell);
        float width = 200.0f;
        float heigth = img.getHeight() / (img.getWidth() / width);
        img.scaleToFit(width, heigth);
        PdfPCell cimg1 = new PdfPCell(img);
        cimg1.setVerticalAlignment(1);
        cimg1.setHorizontalAlignment(1);
        cimg1.setPaddingTop(5.0f);
        cimg1.setPaddingBottom(5.0f);
        cimg1.setPaddingLeft(5.0f);
        cimg1.setPaddingRight(5.0f);
        t.addCell(cimg1);
        PdfPCell descCell = new PdfPCell(new Phrase(desc, this.roleFont));
        descCell.setVerticalAlignment(1);
        descCell.setHorizontalAlignment(1);
        descCell.setPaddingTop(5.0f);
        descCell.setPaddingBottom(5.0f);
        t.addCell(descCell);
        document.add((Element)t);
    }

    private void AddRoleDesc(Document document, String desc, String role) throws DocumentException {
        float spaceBefore = 0.0f;
        if (role != null && !role.isEmpty()) {
            String roleInfo = role + "\uff1a";
            Paragraph rolePg = new Paragraph(roleInfo, this.roleFont);
            rolePg.setFirstLineIndent(this.firstLineIndent);
            rolePg.setExtraParagraphSpace(30.0f);
            rolePg.setSpacingBefore(7.0f);
            rolePg.setLeading(this.lineSpace);
            document.add((Element)rolePg);
            spaceBefore = 5.0f;
        }
        Paragraph descPg = new Paragraph(desc, this.roleFont);
        descPg.setFirstLineIndent(this.firstLineIndent);
        descPg.setExtraParagraphSpace(30.0f);
        descPg.setSpacingBefore(spaceBefore);
        descPg.setLeading(this.lineSpace);
        document.add((Element)descPg);
    }

    private void AddSign(Document document, ProjectInfo info) throws DocumentException {
        String sign = "\u62a5\u544a\u4eba\uff1a " + info.userName;
        Paragraph signPg = new Paragraph(sign, this.normalFont);
        signPg.setAlignment(0);
        if (info.narrow) {
            signPg.setFirstLineIndent(200.0f);
        } else {
            signPg.setFirstLineIndent(300.0f);
        }
        signPg.setExtraParagraphSpace(30.0f);
        signPg.setSpacingBefore(24.0f);
        signPg.setLeading(22.0f);
        document.add((Element)signPg);
        String timeStr = "\u65f6  \u95f4\uff1a " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        Paragraph timePg = new Paragraph(timeStr, this.normalFont);
        timePg.setAlignment(0);
        if (info.narrow) {
            timePg.setFirstLineIndent(200.0f);
        } else {
            timePg.setFirstLineIndent(300.0f);
        }
        timePg.setExtraParagraphSpace(30.0f);
        timePg.setSpacingBefore(24.0f);
        timePg.setLeading(22.0f);
        document.add((Element)timePg);
    }

    private void AddSign(Document document, LawlessInfo info) throws DocumentException {
        String sign = "\u62a5\u544a\u4eba\uff1a " + info.userName;
        Paragraph signPg = new Paragraph(sign, this.normalFont);
        signPg.setAlignment(0);
        if (info.narrow) {
            signPg.setFirstLineIndent(200.0f);
        } else {
            signPg.setFirstLineIndent(300.0f);
        }
        signPg.setExtraParagraphSpace(30.0f);
        signPg.setSpacingBefore(24.0f);
        signPg.setLeading(22.0f);
        document.add((Element)signPg);
        String timeStr = "\u65f6  \u95f4\uff1a " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        Paragraph timePg = new Paragraph(timeStr, this.normalFont);
        timePg.setAlignment(0);
        if (info.narrow) {
            timePg.setFirstLineIndent(200.0f);
        } else {
            timePg.setFirstLineIndent(300.0f);
        }
        timePg.setExtraParagraphSpace(30.0f);
        timePg.setSpacingBefore(24.0f);
        timePg.setLeading(22.0f);
        document.add((Element)timePg);
    }

    private void AddSign(Document document, YnbhInfo info) throws DocumentException {
        String sign = "\u62a5\u544a\u4eba\uff1a " + info.userName;
        Paragraph signPg = new Paragraph(sign, this.normalFont);
        signPg.setAlignment(0);
        if (info.narrow) {
            signPg.setFirstLineIndent(200.0f);
        } else {
            signPg.setFirstLineIndent(300.0f);
        }
        signPg.setExtraParagraphSpace(30.0f);
        signPg.setSpacingBefore(24.0f);
        signPg.setLeading(22.0f);
        document.add((Element)signPg);
        String timeStr = "\u65f6  \u95f4\uff1a " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        Paragraph timePg = new Paragraph(timeStr, this.normalFont);
        timePg.setAlignment(0);
        if (info.narrow) {
            timePg.setFirstLineIndent(200.0f);
        } else {
            timePg.setFirstLineIndent(300.0f);
        }
        timePg.setExtraParagraphSpace(30.0f);
        timePg.setSpacingBefore(24.0f);
        timePg.setLeading(22.0f);
        document.add((Element)timePg);
    }

    private String GetDirction(double azid) {
        String direction = "";
        if (azid > 0.0 && azid < 90.0) {
            direction = "\u4e1c\u504f\u5317";
        } else if (azid == 90.0) {
            direction = "\u6b63\u4e1c";
        } else if (azid > 90.0 && azid < 180.0) {
            direction = "\u4e1c\u504f\u5357";
        } else if (azid == 180.0) {
            direction = "\u6b63\u5357";
        } else if (azid > 180.0 && azid < 270.0) {
            direction = "\u897f\u504f\u5357";
        } else if (azid == 270.0) {
            direction = "\u6b63\u897f";
        } else if (azid > 270.0 && azid < 360.0) {
            direction = "\u897f\u504f\u5317";
        } else if (azid == 360.0) {
            direction = "\u6b63\u5317";
        }
        return direction;
    }
}

