/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq.impl;

import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskGroupRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.repository.task.TskRightAreaRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskGroup;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskAssignRecord;
import com.geoway.landteam.customtask.task.entity.TskRightArea;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.task.entity.UserBiz2;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.pub.entity.TaskBizProject;
import com.geoway.landteam.landcloud.model.pub.entity.TbBizProjectHistory;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectHistoryRepository;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectRepository;
import com.geoway.landteam.landcloud.servface.datacq.BackDataService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportTxtService;
import com.geoway.landteam.landcloud.service.thirddata.utils.MaterializedViewUtils;
import com.geoway.landteam.landcloud.service.thirddata.utils.ProjectStatus;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class BackDataServiceImpl
implements BackDataService {
    @Value(value="${project.submitDir}")
    protected String submitDir;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    private TskTaskBizRepository taskBizRepository;
    @Autowired
    private TbtskObjectinfoRepository objectinfoRepository;
    @Autowired
    private TbBizProjectRepository projectRepository;
    @Autowired
    private TbtskFieldsRepository fieldsRepository;
    @Autowired
    private TbtskGroupRepository groupRepository;
    @Autowired
    private AppMediaRepository appMediaRepository;
    @Autowired
    private UserBiz2Repository userBiz2Repository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TskRightAreaRepository TskRightAreaRepository;
    @Autowired
    private TbBizProjectHistoryRepository projectHistoryRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    private TskAssignRecordRepository assignRecordRepository;
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private ExportTxtService exportTxtService;
    private GiLoger logger = GwLoger.getLoger(BackDataServiceImpl.class);

    @Transactional
    public TskTaskBiz reviewProject(String bizId, String message, String checkId, String checkStatus) throws Exception {
        TskTaskBiz oldBiz = (TskTaskBiz)this.taskBizRepository.gwSearchByPK((Serializable)((Object)bizId));
        TbtskObjectinfo oldTableInfo = (TbtskObjectinfo)this.objectinfoRepository.gwSearchByPK((Serializable)((Object)oldBiz.getTableId()));
        if (oldBiz == null) {
            this.logger.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u9879\u76ee,bizId:" + bizId, new Object[0]);
            throw new Exception("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u9879\u76ee");
        }
        if (ProjectStatus.status1.equals(checkStatus)) {
            this.taskResouceService.saveCheckMessage(message, bizId);
            return null;
        }
        if (ProjectStatus.status2.equals(checkStatus)) {
            this.taskResouceService.saveCheckMessage(message, bizId);
            return null;
        }
        if (ProjectStatus.status3.equals(checkStatus)) {
            if (null != oldBiz.getIsDel() && 1 == oldBiz.getIsDel()) {
                return null;
            }
            oldBiz.setIsDel(Integer.valueOf(1));
            this.taskBizRepository.save((Object)oldBiz);
            this.exportTxtService.deleteTask(bizId, null, Boolean.valueOf(false));
            Map<String, String> dataMap = this.copyData(oldTableInfo.getfTablename());
            String newTableName = dataMap.get("tableName");
            TbtskObjectinfo newTable = this.copyObjectInfo(oldTableInfo, newTableName);
            TskTaskBiz newBiz = this.copyNewTaskBiz(oldBiz, newTable.getfId());
            TaskBizProject oldProject = this.projectRepository.findOneByTableid(oldTableInfo.getfId());
            TaskBizProject newProject = this.copyProject(checkId, newBiz.getId(), newTable.getfId(), checkStatus, oldProject);
            this.copyHistoryProject(newProject.getId(), oldProject);
            List fieldList = this.fieldsRepository.getTbtskFieldsByTableid(oldTableInfo.getfId());
            Map<String, String> fieldMap = this.copyFields(fieldList, newTable);
            this.copyGroup(oldTableInfo.getfTablename(), fieldMap, newTableName);
            this.copyMedia(dataMap);
            this.copyUserBiz(oldBiz.getId(), newBiz.getId());
            this.copyArea(oldBiz.getId(), newBiz.getId());
            this.copyStatistics(oldProject.getId(), newProject.getId(), newTable.getfId(), newTable.getfTablename());
            this.copyAssign(oldBiz.getId(), dataMap);
            MaterializedViewUtils.setJdbcTemplate(this.jdbcTemplate);
            MaterializedViewUtils.createOrReplaceBHJBNTTB2ConflicCheckView();
            this.projectRepository.delete((Object)oldProject);
            String url = this.createDB(newTable, newBiz);
            newBiz.setStructDbUrl(url);
            this.taskBizRepository.save((Object)newBiz);
            return newBiz;
        }
        return null;
    }

    @Transactional
    public void reviewProjectLan(String bizId, String message) {
        TskTaskBiz oldBiz = (TskTaskBiz)this.taskBizRepository.gwSearchByPK((Serializable)((Object)bizId));
        TaskBizProject oldProject = this.projectRepository.findOneByTableid(oldBiz.getTableId());
        this.copyHistoryProject(UUID.randomUUID().toString(), oldProject);
        this.taskResouceService.saveCheckMessage(message, oldBiz.getId());
    }

    private TskTaskBiz copyNewTaskBiz(TskTaskBiz biz, String tableId) {
        TskTaskBiz newbiz = new TskTaskBiz();
        BeanUtils.copyProperties((Object)biz, (Object)newbiz);
        newbiz.setTableId(tableId);
        newbiz.setId(UUID.randomUUID().toString());
        newbiz.setIsDel(null);
        this.taskBizRepository.save((Object)newbiz);
        return newbiz;
    }

    private Map<String, String> copyData(String oldTableName) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        String sxff = sdf.format(new Date());
        String[] tableNames = oldTableName.split("_");
        String newTableName = "";
        for (int i = 0; i < tableNames.length; ++i) {
            newTableName = i != tableNames.length - 1 ? newTableName + tableNames[i] + "_" : newTableName + sxff;
        }
        String createTable = "select * into " + newTableName + " from " + oldTableName;
        this.jdbcTemplate.execute(createTable);
        String idSql = "select f_id from " + newTableName;
        List idList = this.jdbcTemplate.queryForList(idSql);
        HashMap<String, String> result = new HashMap<String, String>();
        String updateIdSql = "";
        for (int i = 0; i < idList.size(); ++i) {
            String oldId = ((Map)idList.get(i)).get("f_id").toString();
            String newId = UUID.randomUUID().toString();
            updateIdSql = updateIdSql + "update " + newTableName + " set f_id = '" + newId + "' where f_id = '" + oldId + "';";
            result.put(oldId, newId);
        }
        this.jdbcTemplate.execute(updateIdSql);
        result.put("tableName", newTableName);
        return result;
    }

    private TbtskObjectinfo copyObjectInfo(TbtskObjectinfo old, String tableName) {
        TbtskObjectinfo data = new TbtskObjectinfo();
        BeanUtils.copyProperties((Object)old, (Object)data);
        String id = UUID.randomUUID().toString();
        data.setfId(id);
        data.setfTablename(tableName);
        this.objectinfoRepository.save((Object)data);
        return data;
    }

    public TbBizProjectHistory copyHistoryProject(String newProjectId, TaskBizProject oldProject) {
        TbBizProjectHistory data = new TbBizProjectHistory();
        BeanUtils.copyProperties((Object)oldProject, (Object)data);
        data.setNewid(newProjectId);
        this.projectHistoryRepository.save((Object)data);
        return data;
    }

    public TaskBizProject copyProject(TaskBizProject oldProject) {
        TaskBizProject data = new TaskBizProject();
        BeanUtils.copyProperties((Object)oldProject, (Object)data);
        data.setId(UUID.randomUUID().toString());
        this.projectRepository.save((Object)data);
        return data;
    }

    private TaskBizProject copyProject(String checkId, String newBizId, String newTableId, String checkStatus, TaskBizProject old) {
        TaskBizProject data = new TaskBizProject();
        BeanUtils.copyProperties((Object)old, (Object)data);
        String newId = UUID.randomUUID().toString();
        data.setId(newId);
        data.setSubmitStatus("0");
        data.setCheckId(checkId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        data.setCheckTime(sdf.format(new Date()));
        data.setCheckStatus(checkStatus);
        data.setTableid(newTableId);
        data.setBizId(newBizId);
        this.projectRepository.save((Object)data);
        return data;
    }

    public void backLan(String oldBizId, String newBizId, String newProjectId) {
        TbBizProjectHistory projectHistory;
        TskTaskBiz biz = (TskTaskBiz)this.taskBizRepository.gwSearchByPK((Serializable)((Object)oldBizId));
        if (null != biz) {
            biz.setIsDel(Integer.valueOf(1));
            this.taskBizRepository.save((Object)biz);
        }
        if ((projectHistory = this.projectHistoryRepository.findByBiz(oldBizId)) != null) {
            projectHistory.setNewid(newProjectId);
            this.projectHistoryRepository.save((Object)projectHistory);
            String sql = "delete from tbtsk_task_ntzy_project where f_id in (select f_id from tbtsk_task_ntzy_project_history where f_biz_id = '" + oldBizId + "')";
            this.jdbcTemplate.execute(sql);
        }
    }

    public void backLanThread(String oldBizId, String newBizId, String newProjectId) {
    }

    private Map<String, String> copyFields(List<TbtskFields> fieldList, TbtskObjectinfo newTable) {
        ArrayList<TbtskFields> newList = new ArrayList<TbtskFields>();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (int i = 0; i < fieldList.size(); ++i) {
            TbtskFields data = new TbtskFields();
            BeanUtils.copyProperties((Object)fieldList.get(i), (Object)data);
            data.setfId(UUID.randomUUID().toString());
            data.setfTableid(newTable.getfId());
            data.setfTablename(newTable.getfTablename());
            newList.add(data);
            fieldMap.put(fieldList.get(i).getfId(), data.getfId());
        }
        if (newList.size() > 0) {
            this.fieldsRepository.gwAccessSelective(newList);
        }
        return fieldMap;
    }

    private void copyUserBiz(String oldBizId, String newBizId) {
        List oldList = this.userBiz2Repository.findByBizId(oldBizId);
        ArrayList<UserBiz2> newList = new ArrayList<UserBiz2>();
        for (int i = 0; i < oldList.size(); ++i) {
            UserBiz2 data = new UserBiz2();
            BeanUtils.copyProperties(oldList.get(i), (Object)data);
            data.setId(UUID.randomUUID().toString());
            data.setBizId(newBizId);
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.userBiz2Repository.gwAccessSelective(newList);
        }
    }

    private void copyGroup(String oldTableName, Map<String, String> fieldMap, String newTableName) {
        List groupList = this.groupRepository.findByFTablename(oldTableName);
        ArrayList<TbtskGroup> newList = new ArrayList<TbtskGroup>();
        for (int i = 0; i < groupList.size(); ++i) {
            TbtskGroup data = new TbtskGroup();
            BeanUtils.copyProperties(groupList.get(i), (Object)data);
            String newFieldId = fieldMap.get(((TbtskGroup)groupList.get(i)).getfFieldid());
            data.setfId(UUID.randomUUID().toString());
            data.setfTablename(newTableName);
            data.setfFieldid(newFieldId);
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.groupRepository.gwAccessSelective(newList);
        }
    }

    private void copyMedia(Map<String, String> dataMap) {
        ArrayList<String> dataIdList = new ArrayList<String>();
        for (String key : dataMap.keySet()) {
            dataIdList.add(key);
        }
        List mediaList = this.appMediaRepository.queryByGalleryids(dataIdList);
        ArrayList<AppMedia> newList = new ArrayList<AppMedia>();
        for (int i = 0; i < mediaList.size(); ++i) {
            AppMedia data = new AppMedia();
            BeanUtils.copyProperties(mediaList.get(i), (Object)data);
            data.setId(UUID.randomUUID().toString());
            data.setGalleryid(dataMap.get(((AppMedia)mediaList.get(i)).getGalleryid()));
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.appMediaRepository.gwAccessSelective(newList);
        }
    }

    private void copyArea(String oldBizId, String newBizId) {
        List oldList = this.TskRightAreaRepository.findByTaskId(oldBizId);
        ArrayList<TskRightArea> newList = new ArrayList<TskRightArea>();
        for (int i = 0; i < oldList.size(); ++i) {
            TskRightArea data = new TskRightArea();
            BeanUtils.copyProperties(oldList.get(i), (Object)data);
            data.setId(UUID.randomUUID().toString());
            data.setTaskId(newBizId);
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.TskRightAreaRepository.gwAccessSelective(newList);
        }
    }

    public void copyStatistics(String oldProjectId, String newProjectId, String newTableid, String newTableName) {
    }

    private void copyAssign(String oldBizid, Map<String, String> dataMap) {
        ArrayList<String> dataIdList = new ArrayList<String>();
        for (String key : dataMap.keySet()) {
            dataIdList.add(key);
        }
        List list = this.assignRecordRepository.findByTaskIdAndDataIds(oldBizid, dataIdList);
        ArrayList<TskAssignRecord> newList = new ArrayList<TskAssignRecord>();
        for (int i = 0; i < list.size(); ++i) {
            TskAssignRecord data = new TskAssignRecord();
            BeanUtils.copyProperties(list.get(i), (Object)data);
            data.setId(UUID.randomUUID().toString());
            data.setDataId(dataMap.get(((TskAssignRecord)list.get(i)).getDataId()));
            newList.add(data);
        }
        if (newList.size() > 0) {
            this.assignRecordRepository.gwAccessSelective(newList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTxtData(List<String> result) throws Exception {
        boolean flag = false;
        String fileName = result.get(0);
        BufferedWriter out = null;
        try {
            if (result != null) {
                if (!result.isEmpty()) {
                    String relFilePath;
                    File file;
                    fileName = fileName + "_" + System.currentTimeMillis() + ".txt";
                    File pathFile = new File(this.submitDir);
                    if (!pathFile.exists()) {
                        pathFile.mkdirs();
                    }
                    if (!(file = new File(relFilePath = this.submitDir + File.separator + fileName)).exists()) {
                        file.createNewFile();
                    }
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "GBK"));
                    for (String info : result) {
                        out.write(info);
                        out.newLine();
                    }
                    flag = true;
                    return flag;
                }
            }
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return flag;
        }
    }

    private String createDB(TbtskObjectinfo newTable, TskTaskBiz newBiz) {
        TskTaskBiz task = new TskTaskBiz();
        TbtskObjectinfo table = new TbtskObjectinfo();
        BeanUtils.copyProperties((Object)newBiz, (Object)task);
        BeanUtils.copyProperties((Object)newTable, (Object)table);
        Connection conn = null;
        Statement statement = null;
        String dbUrl = "";
        try {
            String fileName = UUID.randomUUID().toString() + ".db";
            String filePath = this.uploadDir + File.separator + fileName;
            SqlliteConnTool tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            if (table.getfTableversion() != null && table.getfTableversion() == 1) {
                TaskDBUtils.createInfo((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement, null);
                TaskDBUtils.createTable((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement);
            } else {
                TaskDBUtils.createInfo((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement, null);
                TaskDBUtils.createTable((TskTaskBizService)this.tskTaskBizService, (TbtskObjectinfo)table, (TskTaskBiz)task, (Statement)statement);
            }
            tool.closeAll(conn, statement, null);
            Long date = System.currentTimeMillis();
            String key = String.format("taskManagerDB/%s/%s.db", newBiz.getUserId(), date.toString());
            dbUrl = this.ossOperatorService.sendObject2Oss(key, new File(filePath));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dbUrl;
    }
}

