/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq.impl;

import com.geoway.landteam.cloudquery.model.pub.entity.CloudQuery;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.core.model.pub.dto.CloudQueryParam;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.BysxzService;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class BysxzServiceImpl
implements BysxzService {
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private CloudQueryRepository cloudQueryCQRepository;

    public List<Map<String, Object>> getBysxzData(String requestid) {
        String namespace = ApiNameType.bysxzImport[0];
        String apiname = ApiNameType.bysxzImport[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        String tableName = table.getfTablename();
        String fid = this.getTbidByrequestid(requestid);
        if ("".equals(fid)) {
            return null;
        }
        String sql = "select f_xmmz, f_sqlx , f_lxr from " + tableName + " where f_id = '" + fid + "'";
        return this.jdbcTemplate.queryForList(sql);
    }

    private String getTbidByrequestid(String requestid) {
        List data = this.cloudQueryCQRepository.getByRequestId(requestid);
        if (null == data || data.isEmpty()) {
            return "";
        }
        for (int i = 0; i < data.size(); ++i) {
            if (0 != ((CloudQuery)data.get(i)).getMark()) continue;
            CloudQueryParam queryParam = (CloudQueryParam)new Gson().fromJson(((CloudQuery)data.get(i)).getParam(), CloudQueryParam.class);
            return queryParam.getTbid();
        }
        return "";
    }
}

