/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq.impl;

import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.OutworkProofService;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class OutworkProofServiceImpl
implements OutworkProofService {
    @Value(value="${project.applicationType}")
    protected String applicationType;
    @Value(value="${project.mediaUrlPrefix}")
    protected String mediaUrlPrefix;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    LandUserRepository landUserDao;
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private AppMediaService mediaService;

    public List<AppMedia> getMediaList(String galleryId) {
        List appMedias = this.appMediaDao.queryByGid(galleryId);
        List result = this.mediaService.getAppMedia(appMedias);
        return result;
    }

    public List<AppMedia> getMediaList(String galleryId, String bizid) {
        List appMedias = this.appMediaDao.queryByGalleryidAndBizid(galleryId, bizid);
        List result = this.mediaService.getAppMedia(appMedias);
        return result;
    }

    public List<AppMedia> getMediaList(List<String> galleryIds) {
        List appMedias = this.appMediaDao.queryByGalleryids(galleryIds);
        List result = this.mediaService.getAppMedia(appMedias);
        return result;
    }

    public List<AppMedia> getMediaByBound(String wkt, Integer buffer) throws Exception {
        Geometry bound = WKTUtil.wktToGeom((String)wkt);
        if (null != buffer) {
            Double distance = (double)(buffer * 180) / Math.PI / 6371000.0;
            bound = bound.buffer(distance.doubleValue());
        }
        List appMedias = this.appMediaDao.queryByWkt(WKTUtil.geomToWkt((Geometry)bound));
        List result = this.mediaService.getAppMedia(appMedias);
        return result;
    }
}

