/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datacq.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.common.dto.BaseResponse;
import com.geoway.landteam.landcloud.common.util.PhoneNumberUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionTown;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.model.pub.constants.ApiDataType;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.model.pub.entity.TaskBizProject;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskAutoimportRel;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectRepository;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.repository.pub.TbtskAutoimportRelRepository;
import com.geoway.landteam.landcloud.servface.datacq.BackDataService;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportTxtService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportZbphDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ExportDataUtils;
import com.geoway.landteam.landcloud.service.thirddata.utils.BysxzUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.EsriGeoJsonUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ExportFileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.GeoUtils;
import com.geoway.landteam.landcloud.service.thirddata.utils.ProjectStatus;
import com.geoway.landteam.landcloud.service.thirddata.utils.ZipUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.multipart.MultipartFile;

@Service
public class TaskResouceServiceImpl
implements TaskResouceService {
    private GiLoger logger = GwLoger.getLoger(TaskResouceServiceImpl.class);
    @Value(value="${project.tempDir}")
    private String tempDir;
    @Value(value="${project.import.media}")
    private String mediaDir;
    @Value(value="${project.import.resultsDir}")
    private String resultsDir;
    @Value(value="${project.applicationType}")
    private String applicationType;
    @Value(value="${uis.LandPlatform.useridPrefix:}")
    private Long useridPrefix;
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${project.submitDir}")
    protected String submitDir;
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TbtskFieldsService tbtskFieldsService;
    @Autowired
    private AppMediaRepository appMediaDao;
    @Autowired
    private TskTaskBizRepository bizDao;
    @Autowired
    private ExportDataService exportDataService;
    @Autowired
    private ExportTxtService exportTxtService;
    @Autowired
    private TbtskAutoimportRelRepository tbtskAutoimportRelDao;
    @Autowired
    private DataBizService dataBizService;
    @Autowired
    private TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    private RegionRepository regionRepository;
    @Autowired
    private LandUserRepository userRepository;
    @Autowired
    private TbBizProjectRepository projectRepository;
    @Autowired
    private BackDataService backDataService;
    @Autowired
    private ExportZbphDataService zbphDataService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    private LogService logService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private TbtskObjectinfoRepository tbObjectinfoRepository;
    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    RegionService regionService;

    public BaseResponse getResult(String namespace, String apiname, String bjbh) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            List dataList;
            TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
            if (applicationApi == null) {
                return BaseResponse.buildFailuaResponse((String)"\u63a5\u53e3\u5b58\u5728");
            }
            TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
            String tableName = table.getfTablename();
            String[] bjbhArray = bjbh.split(",");
            String inString = "";
            for (int i = 0; i < bjbhArray.length; ++i) {
                inString = i == bjbhArray.length - 1 ? inString + "'" + bjbhArray[i] + "'" : inString + "'" + bjbhArray[i] + "',";
            }
            String sql = "select *,ST_AsGeoJSON(f_shape) as f_geojson from " + tableName + " where f_bjbh in (" + inString + ")";
            if (StringUtils.isNotEmpty((CharSequence)applicationApi.getSqlfilterstr())) {
                sql = sql + " and " + applicationApi.getSqlfilterstr();
            }
            if ((dataList = this.jdbcTemplate.queryForList(sql)).isEmpty()) {
                baseResponse.setData((Object)("\u672a\u627e\u5230\u62a5\u5efa\u7f16\u53f7\u4e3a" + bjbh + "\u7684\u6570\u636e"));
                return baseResponse;
            }
            JSONArray result = new JSONArray();
            for (int i = 0; i < dataList.size(); ++i) {
                Map data = (Map)dataList.get(i);
                JSONObject geojson = this.createGeojson(applicationApi.getTableid(), data);
                JSONObject obj = new JSONObject();
                obj.put("bjbh", data.get("f_bjbh"));
                obj.put("feature", (Object)geojson);
                result.add((Object)obj);
            }
            baseResponse.setData((Object)result);
            return baseResponse;
        }
        catch (Exception e) {
            return BaseObjectResponse.buildFailuaResponse((Exception)e);
        }
    }

    @Transactional
    public void saveTransaction(JSONObject obj, String usetype) throws Exception {
        String wyid = obj.getString("wyid");
        String ywlx = obj.getString("ywlx");
        String xmbh = obj.getString("xmbh");
        String spzt = obj.getString("spzt");
        String bslx = obj.getString("bslx");
        String wyuserid = obj.getString("sendto");
        String sfzjbnt = obj.getString("sfzjbnt");
        if ("5".equals(spzt)) {
            if (StringUtils.isEmpty((CharSequence)sfzjbnt) || "0".equals(sfzjbnt)) {
                TaskBizProject project = this.projectRepository.findByXmbh(xmbh);
                if (project == null) {
                    return;
                }
                this.backDataService.copyHistoryProject(project.getId(), project);
                this.projectRepository.delete((Object)project);
            } else {
                TaskBizProject project = this.projectRepository.findOneByBizId(obj.getString("wyid"));
                if (null == project) {
                    throw new Exception("\u672a\u627e\u5230\u8981\u5220\u9664\u9879\u76ee");
                }
                project.setCheckStatus("5");
                this.tskTaskBizService.delByTaskId(project.getBizId());
                this.projectRepository.save((Object)project);
            }
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)wyuserid)) {
            if ("1".equals(sfzjbnt)) {
                this.updateProject(obj);
            } else {
                this.updateCqData(obj);
            }
            this.assign(obj);
        } else if (ProjectStatus.status4.equals(spzt)) {
            if (!StringUtils.isEmpty((CharSequence)sfzjbnt) && "1".equals(sfzjbnt) && !StringUtils.isEmpty((CharSequence)wyid)) {
                this.updateProject(obj);
            } else {
                this.updateCqData(obj);
            }
            this.exportTxtService.updateJbnt(obj.toString(), InterfaceType.sendUpdateSsnyd);
        } else if (!StringUtils.isEmpty((CharSequence)sfzjbnt) && "1".equals(sfzjbnt) && !StringUtils.isEmpty((CharSequence)wyid)) {
            if (ProjectStatus.status3.equals(obj.getString("spzt"))) {
                this.exportTxtService.reviewProjectLan(wyid, obj.toString(), xmbh, spzt);
                this.backDataService.reviewProjectLan(wyid, obj.toString());
            } else {
                this.updateProject(obj);
            }
        } else {
            this.updateCqData(obj);
        }
        if ("0".equalsIgnoreCase(ywlx) || "2".equalsIgnoreCase(ywlx) || "4".equalsIgnoreCase(ywlx)) {
            final Thread thread = new Thread(() -> {
                try {
                    Thread.sleep(5000L);
                    TaskBizProject pro = this.getProjectByXmbh(xmbh);
                    String newId = pro.getId();
                    this.logService.saveLog(LogType.saveCqData, "\u66f4\u65b0\u4e2d\u95f4\u5e93\uff1axmbh:" + xmbh + "; bslx:" + bslx + "; spzt:" + spzt + "; newid:" + newId + "; type:" + ywlx);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logService.saveLog(LogType.saveCqData, "\u4e2d\u95f4\u5e93\u66f4\u65b0\u5931\u8d25\uff1a" + xmbh + ";message:" + e.getMessage());
                }
            });
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    TaskResouceServiceImpl.this.threadPoolTaskExecutor.execute((Runnable)thread);
                }
            });
        }
    }

    public String createResultDataFile(String namespace, String apiname, String bjbhs) throws IOException {
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            return null;
        }
        String tempPath = this.tempDir + File.separator + namespace;
        File file = new File(tempPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        String tableName = table.getfTablename();
        String[] bjbhArray = bjbhs.split(",");
        String inbjbhs = "";
        for (int i = 0; i < bjbhArray.length; ++i) {
            String pdfPath;
            File pdfFile;
            inbjbhs = inbjbhs + "'" + bjbhArray[i] + "'";
            if (i != bjbhArray.length - 1) {
                inbjbhs = inbjbhs + ",";
            }
            File tempFile = new File(tempPath + File.separator + bjbhArray[i]);
            if (!file.exists()) {
                tempFile.mkdirs();
            }
            if (!(pdfFile = new File(pdfPath = this.resultsDir + File.separator + bjbhArray[i] + ".pdf")).exists()) continue;
            String newPdfPath = tempPath + File.separator + bjbhArray[i] + File.separator + bjbhArray[i] + ".pdf";
            FileUtil.copyFile(pdfPath, newPdfPath);
        }
        String sql = "select f_id, f_bjbh from " + tableName + " where f_bjbh in (" + inbjbhs + ");";
        List list = this.jdbcTemplate.queryForList(sql);
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Map temp = (Map)list.get(i);
            String f_id = (String)temp.get("f_id");
            String f_bjbh = (String)temp.get("f_bjbh");
            map.put(f_id, f_bjbh);
            idList.add(f_id);
        }
        List mediaList = this.appMediaDao.queryByGalleryids(idList);
        for (int i = 0; i < mediaList.size(); ++i) {
            AppMedia media = (AppMedia)mediaList.get(i);
            String mediaPath = media.getServerpath();
            String time = media.getTime();
            String galleryid = media.getGalleryid();
            Integer type = media.getType();
            String bjbh = (String)map.get(galleryid);
            String mediaFile = this.mediaDir + File.separator + mediaPath;
            String newPath = tempPath + File.separator + bjbh + File.separator + time;
            if (type == 1) {
                newPath = newPath + ".jpg";
            } else if (type == 2) {
                newPath = newPath + ".mp4";
            } else if (type == 3) {
                newPath = newPath + ".mp3";
            } else if (type == 4) {
                newPath = newPath + ".osgb";
            }
            FileUtil.copyFile(mediaFile, newPath);
        }
        ZipUtils utils = new ZipUtils();
        utils.doZip(tempPath);
        String zipPath = this.tempDir + File.separator + "bysxz.zip";
        ExportFileUtil.deleteFileAndDir(new File(tempPath));
        return zipPath;
    }

    public void importBysxzData(String json) throws Exception {
        JSONObject object;
        String namespace = ApiNameType.bysxzImport[0];
        String apiname = ApiNameType.bysxzImport[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054\u914d\u7f6e\u5931\u8d25");
        }
        if (json.contains("\\")) {
            json = json.replace("\\", "");
        }
        if (!PhoneNumberUtil.isMobile((String)(object = JSON.parseObject((String)json)).getString("gtdydh"))) {
            throw new Exception("\u624b\u673a\u53f7\u4e0d\u5408\u6cd5");
        }
        String fid = this.saveData(object, applicationApi, ApiDataType.Bysxz);
        String ids = "";
        if (!"".equals(fid)) {
            ids = fid;
        }
        if (!"".equals(ids)) {
            this.exportData(applicationApi, ids);
        }
    }

    public String importReportData(String json) throws Exception {
        String namespace = ApiNameType.report[0];
        String apiname = ApiNameType.report[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054\u914d\u7f6e\u5931\u8d25");
        }
        JSONObject object = JSONArray.parseObject((String)json);
        return this.saveData(object, applicationApi, ApiDataType.report);
    }

    public List<Map> selectReportByIDs(List<String> ids) throws Exception {
        String namespace = ApiNameType.report[0];
        String apiname = ApiNameType.report[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054\u914d\u7f6e\u5931\u8d25");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbObjectinfoRepository.getObjectByTableId(applicationApi.getTableid());
        if (tbtskObjectinfo == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054table\u5931\u8d25");
        }
        ArrayList<Map> result = new ArrayList();
        String idStr = "";
        for (int i = 0; i < ids.size(); ++i) {
            idStr = ids.size() == i + 1 ? idStr + "'" + ids.get(i) + "'" : idStr + "'" + ids.get(i) + "',";
        }
        String sqlStr = "SELECT r.f_id,r.f_status,r.f_createtime,r.f_committime,array_to_string(array_agg(u.f_rname),',') as usrs  from (SELECT tb.f_id, tar.f_assignto,tb.f_status,tb.f_createtime,tb.f_committime from " + tbtskObjectinfo.getfTablename() + " as tb ,tbtsk_assign_record AS tar WHERE (tb.f_id in ( " + idStr + " )) AND tar.f_dataid = tb.f_id) AS r LEFT JOIN tbsys_user as u on  cast(u.f_userid as VARCHAR) = r.f_assignto GROUP BY r.f_id,r.f_status,r.f_createtime,r.f_committime";
        result = this.dataBizService.queryDataBySql(sqlStr);
        return result;
    }

    public Map getReportByID(String id) throws Exception {
        String namespace = ApiNameType.report[0];
        String apiname = ApiNameType.report[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054\u914d\u7f6e\u5931\u8d25");
        }
        TbtskObjectinfo tbtskObjectinfo = this.tbObjectinfoRepository.getObjectByTableId(applicationApi.getTableid());
        if (tbtskObjectinfo == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054table\u5931\u8d25");
        }
        Map result = this.dataBizService.selectByID(tbtskObjectinfo.getfTablename(), applicationApi.getPrimary(), "'" + id + "'");
        return result;
    }

    public void updateCqData(JSONObject obj) throws Exception {
        String newProjectId;
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.datasync[0], ApiNameType.datasync[1]);
        if (applicationApi == null) {
            throw new Exception("\u8be5\u63a5\u53e3\u4e0d\u53ef\u4f7f\u7528");
        }
        String tablename = applicationApi.getTableid();
        Map<String, String> fieldsMap = this.getFiledMap(tablename);
        String data = obj.getString("data");
        JSONObject dataObject = JSONObject.parseObject((String)data);
        dataObject.keySet().forEach(key -> obj.put(key, dataObject.get(key)));
        String xmbh = obj.getString("xmbh");
        String submission = obj.getString("bslx");
        HashMap<String, Object> result = new HashMap<String, Object>();
        fieldsMap.keySet().forEach(key -> {
            Object value = obj.get(fieldsMap.get(key));
            if (value != null) {
                result.put((String)key, value);
            }
        });
        result.put("f_data", data);
        boolean flag = true;
        if (obj.containsKey((Object)"space") && !StringUtils.isEmpty((CharSequence)obj.getString("space"))) {
            this.processGeodata(obj, result);
            flag = false;
        }
        TaskBizProject oldProject = this.projectRepository.findByXmbh(xmbh);
        String lastProjectId = newProjectId = UUID.randomUUID().toString();
        if (null != oldProject && !submission.equals(oldProject.getSubmission())) {
            this.backDataService.copyHistoryProject(newProjectId, oldProject);
            result.put("f_id", newProjectId);
            if (flag) {
                // empty if block
            }
            this.dataBizService.insertData(tablename, result, "f_shape");
            this.projectRepository.delete((Object)oldProject);
        } else if (null == oldProject) {
            result.put("f_id", newProjectId);
            this.dataBizService.insertData(tablename, result, "f_shape");
        } else {
            lastProjectId = oldProject.getId();
            this.dataBizService.updateData(tablename, result, "f_xmbh='" + obj.getString("xmbh") + "'");
        }
    }

    private void processGeodata(JSONObject obj, Map<String, Object> result) throws Exception {
        JSONArray array = obj.getJSONArray("space");
        for (int i = 0; i < array.size(); ++i) {
            String space = array.getJSONObject(i).getString("json");
            Geometry geometry = GeoUtils.geojson2Geom(space);
            String bound = geometry.toText();
            String wkt = WKTUtil.geomToWkt((Geometry)geometry);
            if ("xmfw".equals(array.getJSONObject(i).getString("fwlx")) || "xmqydgdzb".equals(array.getJSONObject(i).getString("fwlx"))) {
                result.put("f_shape", wkt);
                result.put("f_boundary", bound);
                continue;
            }
            if ("lsydfw".equals(array.getJSONObject(i).getString("fwlx"))) {
                result.put("f_red_line_shape", wkt);
                result.put("f_red_line_boundary", bound);
                continue;
            }
            if ("phgdgzczb".equals(array.getJSONObject(i).getString("fwlx"))) {
                result.put("f_destory_gzc_shape", wkt);
                result.put("f_destory_gzc_boundary", bound);
                continue;
            }
            if (!"phjbntdkgdzb".equals(array.getJSONObject(i).getString("fwlx"))) continue;
            result.put("f_destory_jbnt_shape", wkt);
            result.put("f_destory_jbnt_boundary", bound);
        }
    }

    private JSONObject createGeojson(String tableid, Map<String, Object> data) {
        String geojson = (String)data.get("f_geojson");
        JSONObject result = new JSONObject();
        JSONObject obj = JSONObject.parseObject((String)geojson);
        result.put("geometry", (Object)obj);
        JSONObject properties = new JSONObject();
        List fieldList = this.tbtskFieldsService.getAllFieldsByTableID(tableid);
        for (int i = 0; i < fieldList.size(); ++i) {
            TbtskFields field = (TbtskFields)fieldList.get(i);
            if (field.getfFieldInnerOuterSys() >= 4) continue;
            String fieldName = field.getfFieldname();
            properties.put(fieldName, data.get(fieldName));
        }
        String submitUser = this.getSubmitUser((String)data.get("f_id"));
        properties.put("f_submitUser", (Object)submitUser);
        result.put("properties", (Object)properties);
        result.put("type", (Object)"Feature");
        return result;
    }

    private String getSubmitUser(String dataid) {
        String sql = "select f_rname from tbsys_user where f_userid = (select cast(f_assignto as INTEGER) from tbtsk_assign_record where f_dataid = '" + dataid + "'  and f_status = '1' limit 1)";
        try {
            Map map = this.jdbcTemplate.queryForMap(sql);
            return (String)map.get("f_rname");
        }
        catch (Exception e) {
            return "";
        }
    }

    public String saveData(JSONObject object, TbtskApplicationApi applicationApi, Integer datatype) throws Exception {
        Geometry geometry;
        String tableid = applicationApi.getTableid();
        Map<String, String> mapping = this.getFiledMap(tableid);
        TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        List allFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(applicationApi.getTableid());
        String primary = applicationApi.getPrimary();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map data = null;
        if (!StringUtils.isEmpty((CharSequence)primary)) {
            String[] primarys = primary.split(",");
            String sql = "select * from " + table.getfTablename() + " where 1=1 ";
            for (int i = 0; i < primarys.length; ++i) {
                sql = sql + " and " + primarys[i] + " = '" + object.getString(mapping.get(primarys[i])) + "'";
            }
            List list = this.jdbcTemplate.queryForList(sql);
            if (list != null && !list.isEmpty()) {
                data = (Map)list.get(0);
            }
        }
        String f_id = "";
        this.insertData(object, mapping, allFields, map, data);
        if (data == null) {
            f_id = map.containsKey("tbid") && map.get("tbid") != null && !StringUtils.isEmpty((CharSequence)map.get("tbid").toString()) ? map.get("tbid").toString() : (map.containsKey("f_id") && map.get("f_id") != null && !StringUtils.isEmpty((CharSequence)map.get("f_id").toString()) ? map.get("f_id").toString() : UUID.randomUUID().toString());
        } else {
            f_id = (String)data.get("f_id");
            if (object.containsKey((Object)"sendto") && !StringUtils.isEmpty((CharSequence)object.getString("sendto")) && mapping.containsKey("f_sendto")) {
                map.put("f_sendto", object.getString("sendto"));
            }
        }
        Region region = null;
        if (ApiDataType.Bysxz == datatype) {
            if (object.containsKey((Object)"cunName") && !StringUtils.isEmpty((CharSequence)object.getString("cunName"))) {
                region = this.getRegionByName(object.getString("cunName"));
            }
            map.put("f_userid", applicationApi.getSqlfilterstr());
        } else if (ApiDataType.SSNYD == datatype) {
            region = this.getRegionByName(object.getString("qxmc"));
            JSONArray array = object.getJSONArray("space");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject temp = array.getJSONObject(i);
                String type = temp.getString("fwlx");
                if (!"xmfw".equals(type) && !"xmqydgdzb".equals(type)) continue;
                String space = array.getJSONObject(i).getString("json");
                Geometry geometry2 = GeoUtils.geojson2Geom(space);
                String wkt = WKTUtil.geomToWkt((Geometry)geometry2);
                map.put("f_shape", wkt);
                map.put("f_shape1", wkt);
                Point point = geometry2.getCentroid();
                map.put("f_lat", point.getY());
                map.put("f_lon", point.getX());
            }
        } else if (ApiDataType.Jcjg == datatype) {
            region = this.getRegionByName(object.getString("qxmc"));
            map.put("f_shape", object.getString("shape"));
            map.put("f_shape1", object.getString("shape"));
            geometry = WKTUtil.wktToGeom((String)object.getString("shape").replace("SRID=4490;", ""));
            Point point = geometry.getCentroid();
            map.put("f_lat", point.getY());
            map.put("f_lon", point.getX());
            map.put("f_sendto", object.get((Object)"sendto"));
            map.put("f_status", object.get((Object)"status"));
            map.put("f_xhzg", object.get((Object)"ghzt"));
        } else if (ApiDataType.Phjg == datatype) {
            region = StringUtils.isNotBlank((CharSequence)object.getString("xzqdm")) ? this.getRegionByCode(object.getString("xzqdm")) : this.getRegionByName(object.getString("xzqmc"));
            map.put("f_shape", object.getString("shape"));
            map.put("f_shape1", object.getString("shape"));
            geometry = WKTUtil.wktToGeom((String)object.getString("shape").replace("SRID=4490;", ""));
            Point point = geometry.getCentroid();
            map.put("f_lat", point.getY());
            map.put("f_lon", point.getX());
        } else if (ApiDataType.Xzgd == datatype) {
            this.saveXzgdGeometry(object, map, "coord1", "f_shape");
            this.saveXzgdGeometry(object, map, "coord2", "f_shape2");
            this.saveXzgdMessage(map);
            this.zbphDataService.exportZbphData(map);
        } else if (ApiDataType.Gtzz == datatype) {
            // empty if block
        }
        if (null == region && !StringUtils.isEmpty((CharSequence)object.getString("f_shape"))) {
            geometry = WKTUtil.wktToGeom((String)object.getString("f_shape").replace("SRID=4490;", ""));
            String xzqdmsys = this.getXzqdmSys(geometry);
            map.put("f_xzqdmsys", xzqdmsys);
            if (!StringUtils.isEmpty((CharSequence)xzqdmsys)) {
                region = this.regionRepository.queryRegionByCode(xzqdmsys.substring(0, 6));
                map.put("f_xzqmc1", region.getName());
                map.put("f_xzqdm", region.getCode());
            }
        } else if (null != region) {
            map.put("f_xzqmc1", region.getName());
            if (ApiDataType.Jcjg == datatype || ApiDataType.Bysxz == datatype) {
                map.put("f_xzqmc", region.getName());
            }
            map.put("f_xzqdm", region.getCode());
            map.put("f_xzqdmsys", region.getCode() + "000000");
        }
        if (data == null) {
            map.put("f_id", f_id);
            map.put("f_status", "1");
            map.put("f_createtime", System.currentTimeMillis() + "");
            this.dataBizService.insertDataByTimeStamp(table.getfTablename(), map, "f_shape");
        } else {
            String where = "";
            if (!StringUtils.isEmpty((CharSequence)primary)) {
                String[] primarys = primary.split(",");
                where = " 1=1 ";
                for (int i = 0; i < primarys.length; ++i) {
                    where = where + " and " + primarys[i] + " = '" + object.getString(mapping.get(primarys[i])) + "'";
                }
            }
            this.dataBizService.updateData(table.getfTablename(), map, where);
        }
        return f_id;
    }

    private Region getRegionByCode(String xzqdm) {
        return this.regionRepository.queryRegionByCode(xzqdm);
    }

    public void saveCheckMessage(String message, String bizid) {
        JSONObject object = JSONObject.parseObject((String)message);
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.datasync[0], ApiNameType.datasync[1]);
        String tablename = applicationApi.getTableid();
        String f_submission = object.getString("bslx");
        String f_check_status = object.getString("spzt");
        String xmbh = object.getString("xmbh");
        String messages = object.getString("message");
        JSONObject data = object.getJSONObject("data");
        data.put("ywid", (Object)object.getString("ywid"));
        String update = "update " + tablename + " set ";
        update = update + "f_data = '" + data.toString() + "',";
        update = update + "f_check_message = '" + messages + "',";
        if (!StringUtils.isEmpty((CharSequence)f_submission)) {
            update = update + "f_submission = '" + f_submission + "',";
        }
        update = update + "f_check_status = '" + f_check_status + "',";
        update = update + "f_xmbh = '" + xmbh + "'";
        final String finalUpdate = update = update + " where f_biz_id = '" + bizid + "'";
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                TaskResouceServiceImpl.this.jdbcTemplate.execute(finalUpdate);
            }
        });
    }

    private void insertData(JSONObject object, Map<String, String> mapping, List<TbtskFields> allFields, HashMap<String, Object> map, Map data) throws Exception {
        ArrayList list = new ArrayList();
        allFields.forEach(e -> list.add(e.getfFieldname()));
        for (TbtskFields field : allFields) {
            String str;
            String fieldName = field.getfFieldname();
            String fieldType = field.getfFieldtype();
            Integer outWork = field.getfIsOutwork();
            String type = TskTaskBizDBUtil.getDBType((String)fieldType);
            Integer nullable = null == outWork ? field.getfNullable() : Integer.valueOf(outWork == 1 ? 1 : field.getfNullable());
            Integer order = field.getfOrder();
            if (mapping.containsKey(fieldName) && StringUtils.isNotEmpty((CharSequence)(str = mapping.get(fieldName)))) {
                BysxzUtil.addDatatoMap(map, type, str, fieldName, nullable, order, object);
                continue;
            }
            if (data != null || "f_index".equalsIgnoreCase(fieldName) || fieldName.equals("f_lat") || fieldName.equals("f_lon")) continue;
            String value = field.getfDefaultvalue();
            if (type.equals(TskTaskBizDBUtil.getDBType((String)"5"))) {
                value = null;
            }
            map.put(fieldName, value);
            BysxzUtil.addDatatoMap(map, type, fieldName, fieldName, nullable, order, object);
        }
    }

    private Region getRegionByName(String name) {
        List regionList;
        if (name.startsWith("\u91cd\u5e86\u5e02")) {
            name = name.split("\u91cd\u5e86\u5e02")[1];
        }
        if ((regionList = this.regionRepository.queryByName((name = name.substring(0, 2)) + "%")).isEmpty()) {
            return null;
        }
        return (Region)regionList.get(0);
    }

    public void assign(JSONObject obj) throws Exception {
        String namespace = ApiNameType.assgin[0];
        String apiname = ApiNameType.assgin[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("\u8be5\u63a5\u53e3\u4e0d\u53ef\u4f7f\u7528");
        }
        String tableid = applicationApi.getTableid();
        Map<String, String> mapping = this.getFiledMap(tableid);
        TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        List allFields = this.tbtskFieldsRepository.getTbtskFieldsByTableid(applicationApi.getTableid());
        String primary = applicationApi.getPrimary();
        String ids = "";
        JSONObject dataObject = obj.getJSONObject("data");
        Long userid = obj.getLong("sendto");
        LandUser user = this.userRepository.queryUserById(userid = Long.valueOf(userid + this.useridPrefix));
        if (user == null) {
            throw new Exception("\u6ca1\u6709\u7528\u6237id\u4e3a" + userid + "\u7684\u7528\u6237\u4fe1\u606f");
        }
        String hasDataSql = "select f_id from " + table.getfTablename() + " where " + primary + "='" + obj.getString(mapping.get(primary)) + "'";
        List hasDataList = this.jdbcTemplate.queryForList(hasDataSql);
        if (!hasDataList.isEmpty()) {
            // empty if block
        }
        String xmbh = obj.getString("xmbh");
        dataObject.put("ywid", (Object)obj.getString("ywid"));
        dataObject.put("xmbh", (Object)xmbh);
        dataObject.put("bslx", (Object)obj.getString("bslx"));
        dataObject.put("spzt", (Object)obj.getString("spzt"));
        List<Object> geoList = new ArrayList();
        geoList = obj.containsKey((Object)"space") && !StringUtils.isEmpty((CharSequence)obj.getString("space")) ? this.getGeo(obj) : this.getGeoByTabele(xmbh);
        for (int i = 0; i < geoList.size(); ++i) {
            Geometry geo = (Geometry)geoList.get(i);
            String fid = this.saveBzyjbntData(dataObject, applicationApi, allFields, table, mapping, geo);
            if (i != 0) {
                ids = ids + ",";
            }
            ids = ids + fid;
        }
        if (!"".equals(ids)) {
            this.exportData(applicationApi, ids);
        }
    }

    @Transactional
    public void updateProject(JSONObject obj) throws Exception {
        String bizId;
        TaskBizProject oldProject;
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.datasync[0], ApiNameType.datasync[1]);
        if (applicationApi == null) {
            throw new Exception("\u8be5\u63a5\u53e3\u4e0d\u53ef\u4f7f\u7528");
        }
        String submission = obj.getString("bslx");
        if (!submission.equals((oldProject = this.projectRepository.findOneByBizId(bizId = obj.getString("wyid"))).getSubmission())) {
            this.updateProject(oldProject, obj);
            this.exportTxtService.updateJbnt(obj.toString(), InterfaceType.sendUpdateJbnt);
        } else {
            this.saveCheckMessage(obj.toString(), obj.getString("wyid"));
            String spzt = obj.getString("spzt");
            if (!spzt.equals(oldProject.getCheckStatus()) && !ProjectStatus.status4.equals(spzt) && this.applicationType.equals("lan")) {
                this.exportTxtService.updateJbnt(obj.toString(), InterfaceType.sendUpdateJbnt);
            }
        }
    }

    @Transactional
    public void updateProject(TaskBizProject oldProject, JSONObject obj) throws Exception {
        if (null == oldProject) {
            oldProject = this.projectRepository.findOneByBizId(obj.getString("wyid"));
        }
        if (null == oldProject) {
            return;
        }
        TaskBizProject newProject = this.backDataService.copyProject(oldProject);
        this.backDataService.copyHistoryProject(newProject.getId(), oldProject);
        TbtskObjectinfo objectinfo = this.tbtskObjectinfoService.getObjectbyID(newProject.getTableid());
        this.backDataService.copyStatistics(oldProject.getId(), newProject.getId(), newProject.getTableid(), objectinfo.getfTablename());
        this.projectRepository.delete((Object)oldProject);
        this.saveCheckMessage(obj.toString(), obj.getString("wyid"));
    }

    public boolean hasComplete(String xmbh) {
        String namespace = ApiNameType.assgin[0];
        String apiname = ApiNameType.assgin[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        String tableName = table.getfTablename();
        String sql = "select * from " + tableName + " where f_status != '4' and f_xmbh = '" + xmbh + "'";
        List data = this.jdbcTemplate.queryForList(sql);
        return data.isEmpty();
    }

    public String getLatestYwid(String tableName, String xmbh) throws Exception {
        String sql = "select f_ywid from " + tableName + " where f_xmbh = '" + xmbh + "' order by f_createtime desc limit 1";
        List list = this.jdbcTemplate.queryForList(sql);
        if (null == list || list.isEmpty()) {
            return "";
        }
        return (String)((Map)list.get(0)).get("f_ywid");
    }

    public void updatePrjectYtgzc(String xmbh, String xmmc, String bslx, String space) throws Exception {
        TaskBizProject oldProject = this.projectRepository.findByXmbh(xmbh);
        if (null == oldProject) {
            throw new Exception("\u65e0\u6cd5\u83b7\u53d6xmbh\u4e3a" + xmbh + "\u7684\u9879\u76ee");
        }
        TaskBizProject newProject = this.backDataService.copyProject(oldProject);
        this.backDataService.copyHistoryProject(newProject.getId(), oldProject);
        newProject.setXmbh(xmbh);
        newProject.setName(xmmc);
        newProject.setSubmission(bslx);
        Geometry geometry = GeoUtils.geojson2Geom4490(space);
        newProject.setShape(geometry);
        newProject.setBoundary(geometry.toText());
        this.projectRepository.save((Object)newProject);
    }

    public void importXzgdData(String json) throws Exception {
        String namespace = ApiNameType.xzgdImportData[0];
        String apiname = ApiNameType.xzgdImportData[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        if (applicationApi == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054\u914d\u7f6e\u5931\u8d25");
        }
        if (json.contains("\\")) {
            json = json.replace("\\\\", "");
        }
        JSONArray array = JSONArray.parseArray((String)json, (Feature[])new Feature[0]);
        for (int j = 0; j < array.size(); ++j) {
            JSONObject object = array.getJSONObject(j);
            this.saveData(object, applicationApi, ApiDataType.Xzgd);
            try {
                this.zbphDataService.exportZbphData((Map)object);
                continue;
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51fa\u5230\u5360\u8865\u5e73\u8861\u5931\u8d25", new Object[0]);
            }
        }
    }

    private List<Geometry> getGeo(JSONObject object) throws Exception {
        JSONArray array = object.getJSONArray("space");
        for (int i = 0; i < array.size(); ++i) {
            JSONObject temp = array.getJSONObject(i);
            String type = temp.getString("fwlx");
            if (!"xmfw".equals(type) && !"xmqydgdzb".equals(type)) continue;
            String space = array.getJSONObject(i).getString("json");
            List<Geometry> geometry = GeoUtils.geojson2Geoms(space);
            return geometry;
        }
        return null;
    }

    private List<Geometry> getGeoByTabele(String xmbh) throws Exception {
        TaskBizProject project = this.projectRepository.findByXmbh(xmbh);
        if (null == project || null == project.getShape()) {
            throw new Exception("space\u4e3a\u7a7a\u65f6\uff0c\u65e0\u6cd5\u83b7\u53d6\u5230xmbh\u4e3a" + xmbh + "\u7684\u9879\u76ee\u8fb9\u754c");
        }
        Geometry geometry = project.getShape();
        if (null == geometry) {
            throw new Exception("");
        }
        Integer length = geometry.getNumGeometries();
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        if (length == 0) {
            result.add(geometry);
        } else {
            for (int i = 0; i < length; ++i) {
                result.add(geometry.getGeometryN(i));
            }
        }
        return result;
    }

    public String saveBzyjbntData(JSONObject object, TbtskApplicationApi applicationApi, List<TbtskFields> allFields, TbtskObjectinfo table, Map<String, String> mapping, Geometry geo) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.insertData(object, mapping, allFields, map, null);
        String f_id = UUID.randomUUID().toString();
        Region region = this.getRegionByName(object.getString("qxmc"));
        String wkt = WKTUtil.geomToWkt((Geometry)geo);
        map.put("f_shape", wkt);
        map.put("f_shape1", wkt);
        Point point = geo.getCentroid();
        map.put("f_lat", point.getY());
        map.put("f_lon", point.getX());
        if (null != region) {
            map.put("f_xzqmc1", region.getName());
            map.put("f_xzqdm", region.getCode());
            map.put("f_xzqdmsys", region.getCode() + "000000");
        }
        map.put("f_id", f_id);
        map.put("f_status", "1");
        map.put("f_createtime", System.currentTimeMillis() + "");
        map.put("f_userid", applicationApi.getSqlfilterstr());
        this.dataBizService.insertData(table.getfTablename(), map, "f_shape");
        return f_id;
    }

    public Map<String, String> getFiledMap(String tableid) throws Exception {
        return this.getFiledMap(tableid, null);
    }

    public Map<String, String> getFiledMap(String tableid, String tag) throws Exception {
        if (StringUtils.isEmpty((CharSequence)tag)) {
            tag = "0";
        }
        List fields = this.tbtskAutoimportRelDao.getImportTableFields(tableid, tag);
        HashMap<String, String> fieldsMap = new HashMap<String, String>();
        if (fields.size() > 0) {
            for (TbtskAutoimportRel value : fields) {
                fieldsMap.put(value.getFieldname(), value.getImFieldname());
            }
        } else {
            throw new Exception("\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
        }
        return fieldsMap;
    }

    public TaskBizProject getProjectByXmbh(String xmbh) {
        TaskBizProject project = this.projectRepository.findByXmbh(xmbh);
        return project;
    }

    public void receive(String data, Integer type, MultipartFile[] files) throws Exception {
        JSONObject object = JSONObject.parseObject((String)data);
        object.put("geoway_type", (Object)type);
        if (files.length > 0) {
            this.saveFile(object, type, files);
        }
        if (type == LogType.kfly_gdxx || type == LogType.kfly_jsydghxkz_zjl || type == LogType.zngl_swltsksjk) {
            this.saveData(object, type, files);
        }
        if (type == LogType.kfly_jsydghxkz || type == LogType.kfly_jsydghxkz_szjtl || type == LogType.kfly_jgghhsqrs) {
            this.sendData(object, type, files);
        }
    }

    private void saveXzgdGeometry(JSONObject object, HashMap<String, Object> map, String objKey, String mapKey) {
        try {
            if (object.containsKey((Object)objKey) && !StringUtils.isEmpty((CharSequence)object.getString(objKey)) && !"null".equals(object.getString(objKey))) {
                String geojosn = object.getJSONObject(objKey).getJSONObject("result").toString();
                Geometry geometry = GeoUtils.geojson2Geom(EsriGeoJsonUtil.esri2geo(geojosn));
                map.put(mapKey, geometry);
            } else {
                map.put(mapKey, null);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            map.put(mapKey, null);
        }
    }

    private void saveXzgdMessage(HashMap<String, Object> map) {
        BigDecimal f_hjxzstmj = new BigDecimal(0);
        if (map.get("f_kzstmj") != null && !StringUtils.isEmpty((CharSequence)map.get("f_kzstmj").toString())) {
            f_hjxzstmj = f_hjxzstmj.add(new BigDecimal(map.get("f_kzstmj").toString()));
        }
        if (map.get("f_hgsmj") != null && !StringUtils.isEmpty((CharSequence)map.get("f_hgsmj").toString())) {
            f_hjxzstmj = f_hjxzstmj.add(new BigDecimal(map.get("f_hgsmj").toString()));
        }
        BigDecimal f_hjxzlscn = new BigDecimal(0);
        if (map.get("f_xzgdlscn") != null && !StringUtils.isEmpty((CharSequence)map.get("f_xzgdlscn").toString())) {
            f_hjxzlscn = f_hjxzlscn.add(new BigDecimal(map.get("f_xzgdlscn").toString()));
        }
        if (map.get("f_tzgzlscn") != null && !StringUtils.isEmpty((CharSequence)map.get("f_tzgzlscn").toString())) {
            f_hjxzlscn = f_hjxzlscn.add(new BigDecimal(map.get("f_tzgzlscn").toString()));
        }
        map.put("f_hjxzstmj", f_hjxzstmj);
        map.put("f_hjxzlscn", f_hjxzlscn);
    }

    private void saveData(JSONObject object, Integer type, MultipartFile[] files) throws Exception {
        TbtskApplicationApi applicationApi = null;
        if (type == LogType.kfly_gdxx) {
            applicationApi = this.tbtskApplicationApiDao.queryApplicationApi("phjg", "kfly_gdxx");
            Geometry geometry = GeoUtils.geojson2Geom(EsriGeoJsonUtil.esri2geo(object.getString("\u4f9b\u5730\u8303\u56f4")));
            object.put("f_shape", (Object)geometry.toText());
            this.saveData(object, applicationApi, null);
        } else if (type == LogType.kfly_jsydghxkz_zjl) {
            applicationApi = this.tbtskApplicationApiDao.queryApplicationApi("phjg", "kfly_jsydghxkz_zjl");
            JSONArray array = object.getJSONObject("\u603b\u5e73\u9762\u56fe\u5efa\u7b51\u8f6e\u5ed3").getJSONArray("features");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                String geometryStr = obj.getString("geometry");
                String attributeStr = obj.getString("attributes");
                JSONObject geometryJson = JSONObject.parseObject((String)geometryStr);
                JSONObject attributes = JSONObject.parseObject((String)attributeStr);
                attributes.put("\u6807\u8bc6\u7801", (Object)obj.getString("unique"));
                obj.put("geometry", (Object)geometryJson);
                obj.put("attributes", (Object)attributes);
                JSONObject esriGeojson = new JSONObject();
                esriGeojson.put("geometryType", (Object)object.getString("geometryType"));
                JSONArray feature = new JSONArray();
                feature.add((Object)obj);
                esriGeojson.put("features", (Object)feature);
                Geometry geometry = GeoUtils.geojson2Geom(EsriGeoJsonUtil.esri2geo(esriGeojson.toJSONString()));
                JSONObject copyobj = JSONObject.parseObject((String)object.toString());
                copyobj.remove((Object)"\u603b\u5e73\u9762\u56fe\u5efa\u7b51\u8f6e\u5ed3");
                for (String key : attributes.keySet()) {
                    copyobj.put(key, attributes.get((Object)key));
                }
                copyobj.put("f_shape", (Object)geometry.toText());
                this.saveData(copyobj, applicationApi, null);
            }
        } else if (type == LogType.zngl_swltsksjk) {
            JSONArray array = object.getJSONArray("data");
            applicationApi = this.tbtskApplicationApiDao.queryApplicationApi("zngl", "zngl_swltsksjk");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = this.getData(array.getJSONObject(i));
                String f_id = this.saveData(obj, applicationApi, null);
                idSet.add(f_id);
            }
            this.exportData(applicationApi, StringUtils.join(idSet, (String)","));
        }
    }

    private void exportData(TbtskApplicationApi applicationApi, String ids) throws Exception {
        TskTaskBiz task = this.bizDao.getByTableId(applicationApi.getTableid());
        this.exportDataService.export(task.getId(), ids, Boolean.valueOf(false), Boolean.valueOf(false), null, "wydc", null);
    }

    private JSONObject getData(JSONObject geojson) throws Exception {
        JSONObject result = new JSONObject();
        JSONObject properties = geojson.getJSONObject("properties");
        for (String key : properties.keySet()) {
            result.put(key, properties.get((Object)key));
        }
        Geometry geometry = GeoUtils.geojson2Geom(geojson.toJSONString());
        result.put("f_shape", (Object)geometry.toText());
        return result;
    }

    private void sendData(JSONObject dataObj, Integer type, MultipartFile[] files) throws Exception {
        String safeFileName = "" + System.currentTimeMillis();
        String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
        ArrayList<String> txtData = new ArrayList<String>();
        txtData.add(dataObj.toString());
        this.exportTxtService.writeTxtData(txtData, fileNameNoSuffix, false, "data");
        if (files.length > 0 && null != dataObj.getJSONArray("geoway_filename")) {
            JSONArray objArray = dataObj.getJSONArray("geoway_filename");
            for (int i = 0; i < objArray.size(); ++i) {
                String fromPath = this.mediaDir + File.separator + "other" + File.separator + type + File.separator + objArray.getString(i);
                String toPath = fileNameNoSuffix + File.separator + objArray.getString(i);
                FileUtils.copyFile((File)new File(fromPath), (File)new File(toPath));
            }
        }
        ZipUtils utils = new ZipUtils();
        utils.doZip(fileNameNoSuffix);
        ExportDataUtils.copyFileToSubmit(safeFileName + ".zip", this.uploadDir, this.submitDir);
        ExportFileUtil.deleteFileAndDir(new File(fileNameNoSuffix));
        File zipFile = new File(fileNameNoSuffix + ".zip");
        String identity = "";
        if (type == LogType.kfly_jsydghxkz || type == LogType.kfly_jsydghxkz_szjtl || type == LogType.kfly_jgghhsqrs) {
            identity = "jaPhjg";
        }
        this.fileTransferService.sendFile(fileNameNoSuffix + ".zip", identity);
        zipFile.delete();
    }

    private void saveFile(JSONObject data, Integer type, MultipartFile[] files) throws IOException {
        JSONArray filePathArray = new JSONArray();
        for (MultipartFile file : files) {
            String filename = file.getOriginalFilename();
            String path = this.mediaDir + File.separator + "other" + File.separator + type;
            File dir = new File(path);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            Long time = System.currentTimeMillis();
            String newFile = time + "_" + filename;
            path = path + File.separator + newFile;
            File outFile = new File(path);
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)outFile);
            filePathArray.add((Object)newFile);
        }
        data.put("geoway_filename", (Object)filePathArray);
    }

    private String getXzqdmSys(Geometry geo) {
        String xzqdmsys = "";
        RegionVillage regionVillage = this.regionService.queryRegionVillageByCoor(geo);
        if (regionVillage != null) {
            xzqdmsys = regionVillage.getCode();
        } else {
            RegionTown regionTown = this.regionService.queryRegionTownCotain(geo);
            if (regionTown != null) {
                xzqdmsys = regionTown.getCode() + "000";
            } else {
                try {
                    String wkt = WKTUtil.geomToWkt((Geometry)geo);
                    RegionDetail region = this.regionService.queryRegionByGeom(wkt, 4490, 3);
                    if (null == region) {
                        throw new Exception("\u6570\u636e\u9519\u8bef\uff0c\u6570\u636e\u4e2d\u5fc3\u70b9\u4e0d\u5728\u672c\u7701\u8303\u56f4");
                    }
                    xzqdmsys = region.getCode() + "000000";
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return xzqdmsys;
    }
}

