/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.inherit;

import com.geoway.landteam.landcloud.dao.atlas.CloudCalculationTaskDao;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalculationTask;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.CloudCalculationTaskService;
import com.geoway.landteam.landcloud.service.datatransfer.inherit.FileResolver2;
import com.geoway.landteam.landcloud.service.datatransfer.inherit.ZipFileResolver;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="fileresolver_calc")
public class CalcFileResolver
extends ZipFileResolver {
    @Autowired
    CloudCalculationTaskDao cloudCalculationTaskDao;
    @Autowired
    CloudCalculationTaskService cloudCalculationTaskService;
    @Value(value="${project.applicationType}")
    protected String applicationType;

    @Override
    protected String getScopedExtension() {
        return "calc";
    }

    @Override
    protected void process(String path) throws Exception {
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        ArrayList files = new ArrayList();
        File[] temp = dir.listFiles(f -> f.getName().endsWith(".db"));
        Collections.addAll(files, temp);
        temp = dir.listFiles(f -> f.getName().endsWith(".zip"));
        Collections.addAll(files, temp);
        for (File file : files) {
            String fullname = file.getAbsolutePath();
            String suffix = FilenameUtils.getExtension((String)fullname);
            if (StringUtils.isBlank((CharSequence)suffix)) continue;
            FileResolver2 fileResolver = this.getScopedResolver(suffix);
            fileResolver.resolve(fullname);
        }
        if (dir.exists()) {
            FileUtil.deleteFileAndDir(dir);
        }
        String taskid = FilenameUtils.getBaseName((String)FilenameUtils.getFullPathNoEndSeparator((String)path));
        if ("lan".equals(this.applicationType)) {
            Integer status = CloudCalculationTask.STATUS_PUSH | CloudCalculationTask.STATUS_LAN_RECEIVED;
            this.cloudCalculationTaskDao.updataStatusByTaskid(taskid, status.intValue());
        } else {
            this.cloudCalculationTaskService.addStatusByTaskid(taskid, CloudCalculationTask.STATUS_RETURNED | CloudCalculationTask.STATUS_RETURN);
        }
    }
}

