/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.inherit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalcuationDef;
import com.geoway.landteam.landcloud.model.atlas.entity.CloudCalculationTask;
import com.geoway.landteam.landcloud.repository.atlas.CloudCalculationDefRepository;
import com.geoway.landteam.landcloud.repository.atlas.CloudCalculationTaskRepository;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.Datasource;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.DatasourceFactory;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.impl.DatasourceHdfs;
import com.geoway.landteam.landcloud.service.customtask.atlas.service.impl.HdfsHandleImpl;
import com.geoway.landteam.landcloud.service.datatransfer.inherit.ZipDbFileResolver;
import com.geoway.landteam.landcloud.service.formatConversion.utils.ShapeOprate;
import com.geoway.landteam.landcloud.service.thirddata.utils.GeoUtils;
import com.geoway.landteam.landcloud.service.util.FileUtil;
import com.geoway.landteam.landcloud.service.util.ZipUtils;
import com.geoway.landteam.landcloud.service.util.hdfs.HdfsPool.Hdfs;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.store.ContentFeatureSource;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service(value="fileresolver_calc.zip")
public class CalcZipFileResolver
extends ZipDbFileResolver {
    private int SHAPE_NUM_LIMIT = 5000;
    @Autowired
    CloudCalculationDefRepository cloudCalculationDefRepository;
    @Autowired
    CloudCalculationTaskRepository cloudCalculationTaskRepository;
    @Autowired
    DatasourceFactory datasourceFactory;
    @Autowired
    private DefaultOssOperatorService stsService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private HdfsHandleImpl hdfsHandler;
    @Value(value="${project.applicationType}")
    protected String applicationType;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolve(String filepath) throws Exception {
        String taskid = "";
        if ("lan".equals(this.applicationType)) {
            taskid = FilenameUtils.getBaseName((String)filepath);
            String unzipPath = FilenameUtils.getFullPath((String)filepath);
            ZipUtils.unZip(new File(filepath), unzipPath);
            JSONObject datasource = Optional.of(taskid).map(arg_0 -> ((CloudCalculationDefRepository)this.cloudCalculationDefRepository).queryByTask(arg_0)).map(CloudCalcuationDef::getInputDataSource).map(JSON::parseObject).orElseThrow(() -> new RuntimeException());
            String type = datasource.getString("type");
            String source = datasource.getString("dataSource");
            String dbuser = datasource.getString("dbuser");
            String password = datasource.getString("dbpassword");
            if ("hdfs".equalsIgnoreCase(type)) {
                String hdfsPath = datasource.getString("path");
                String srcPath = unzipPath + taskid;
                DatasourceHdfs ds = (DatasourceHdfs)this.datasourceFactory.getDatasource(type);
                Hdfs hdfs = null;
                try {
                    hdfs = ds.getDaoObject(source, dbuser, password);
                    this.hdfsHandler.uploadshp(hdfs, "LOCAL", taskid, srcPath, hdfsPath, "0", "0");
                }
                finally {
                    if (hdfs != null) {
                        ds.returnDaoObject(source, hdfs);
                    }
                }
            } else {
                Datasource ds = this.datasourceFactory.getDatasource(type);
                if (!ds.testConnection(source, dbuser, password)) {
                    throw new RuntimeException("\u8f93\u5165\u6570\u636e\u6e90\u8fde\u63a5\u5931\u8d25");
                }
                List<Geometry> geometrylist = this.parseGeometry(filepath);
                String tablename = datasource.getString("tablename");
                ds.startConnectionPool(source, dbuser, password);
                JdbcTemplate inputTemplate = (JdbcTemplate)ds.getDaoObject(source, dbuser, password);
                for (Geometry geometry : geometrylist) {
                    String geomStr = String.format("st_geomfromtext('%s',%s)", geometry.toString(), 4490);
                    Long oid = System.currentTimeMillis() % Integer.MAX_VALUE;
                    String sql = String.format("insert into %s (objectid,shape,taskid) values(%s,%s,'%s')", tablename, oid, geomStr, taskid);
                    inputTemplate.update(sql);
                }
            }
            FileUtil.deleteFileAndDir(new File(unzipPath));
        } else {
            taskid = FilenameUtils.getBaseName((String)FilenameUtils.getFullPathNoEndSeparator((String)filepath));
            List tasks = Optional.of(taskid).map(arg_0 -> ((CloudCalculationTaskRepository)this.cloudCalculationTaskRepository).queryByTaskid(arg_0)).orElseThrow(RuntimeException::new);
            String taskname = ((CloudCalculationTask)tasks.get(0)).getName();
            if (StringUtils.isBlank((CharSequence)taskname)) {
                throw new RuntimeException("Empty Tasak Name!");
            }
            String sendObjName = "calc/" + taskname + ".zip";
            String url = this.stsService.sendObject2Oss(sendObjName, filepath);
            tasks.stream().forEach(task -> {
                String resultStr = task.getResult();
                JSONObject result = StringUtils.isBlank((CharSequence)resultStr) ? new JSONObject() : JSONObject.parseObject((String)resultStr);
                result.put("shape", (Object)url);
                task.setResult(result.toJSONString());
            });
            this.cloudCalculationTaskRepository.saveAll((Iterable)tasks);
        }
    }

    private List<Geometry> parseGeometry(String filepath) throws Exception {
        List<Geometry> geoms = null;
        ArrayList<Geometry> result = new ArrayList<Geometry>();
        String zipDirFileName = FilenameUtils.removeExtension((String)filepath);
        List<String> shpFileList = FileUtil.findFiles(zipDirFileName, "*.shp");
        ShapefileDataStore shpDataStore = new ShapefileDataStore(new File(shpFileList.get(0)).toURI().toURL());
        ContentFeatureSource featureSource = shpDataStore.getFeatureSource(shpDataStore.getTypeNames()[0]);
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        String wkt = sourceCRS.toWKT();
        ShapeOprate shapeOprate = new ShapeOprate();
        if (shpFileList != null && shpFileList.size() > 0) {
            geoms = shapeOprate.readShp(shpFileList.get(0));
        }
        int count = 0;
        GeometryFactory factory = new GeometryFactory();
        List<Object> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < geoms.size(); ++i) {
            if (count < this.SHAPE_NUM_LIMIT) {
                polygons = this.getPolygon(polygons, geoms.get(i), false, wkt);
                ++count;
                continue;
            }
            MultiPolygon multipolygon = factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
            result.add((Geometry)multipolygon);
            polygons = new ArrayList();
            count = 0;
        }
        if (count > 0) {
            MultiPolygon multipolygon = factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
            result.add((Geometry)multipolygon);
        }
        return result;
    }

    private List<Polygon> getPolygon(List<Polygon> polygons, Geometry geometry, boolean transform, String crsSourceWkt) throws Exception {
        if ("MultiPolygon".equals(geometry.getGeometryType()) && geometry.getNumGeometries() > 0) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                polygons = this.getPolygon(polygons, geometry.getGeometryN(i), transform, crsSourceWkt);
            }
        } else if ("Polygon".equals(geometry.getGeometryType())) {
            if (transform) {
                polygons.add((Polygon)GeoUtils.geoTransform(geometry, crsSourceWkt, "EPSG:4490"));
            } else {
                polygons.add((Polygon)geometry);
            }
        }
        return polygons;
    }
}

