/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.inherit;

import com.geoway.landteam.landcloud.service.datatransfer.inherit.FileResolver2;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;

@Component
public class FileResolverProvider2 {
    @Resource
    private Map<String, FileResolver2> FILE_RESOLVER_MAP;

    public final FileResolver2 getHandler(String suffix) {
        return Optional.ofNullable(suffix).map("fileresolver_"::concat).map(String::toLowerCase).map(this.FILE_RESOLVER_MAP::get).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u8be5\u7c7b\u578b\u6587\u4ef6\u89e3\u6790\u5668"));
    }

    public final boolean hasHandler(String suffix) {
        return Optional.ofNullable(suffix).map("fileresolver_"::concat).map(String::toLowerCase).map(this.FILE_RESOLVER_MAP::get).isPresent();
    }

    public final void handle(String path) throws Exception {
        String suffix = FilenameUtils.getExtension((String)path);
        this.getHandler(suffix).resolve(path);
    }

    public final void handle(String path, String resolver) throws Exception {
        this.getHandler(resolver).resolve(path);
    }
}

