/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.inherit;

import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.service.datatransfer.inherit.AbstractScopedFileResolver;
import com.geoway.landteam.landcloud.service.datatransfer.inherit.FileResolver2;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ZipUtils;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="fileresolver_zip")
public class ZipFileResolver
extends AbstractScopedFileResolver {
    private final String[] identitys = new String[]{"wydc", "zbph", "phjg", "dcxs"};

    @Override
    protected String getScopedExtension() {
        return "zip";
    }

    @Override
    public void resolve(String path) throws Exception {
        String fileNameWithoutExtension = FilenameUtils.getBaseName((String)path);
        String filePath = FilenameUtils.getFullPathNoEndSeparator((String)path);
        String decompressedPath = filePath + File.separator + fileNameWithoutExtension + File.separator;
        ZipUtils utils = new ZipUtils();
        utils.decompressZip(path, decompressedPath);
        this.process(decompressedPath);
        this.deleteFiles(decompressedPath);
    }

    protected void process(String path) throws Exception {
        List<String> dbFileList = FileUtil.findFiles(path, "meta.db");
        if (!dbFileList.isEmpty()) {
            String dbPath = dbFileList.get(0);
            FileResolver2 fileResolver = this.getScopedResolver("db");
            fileResolver.resolve(dbPath);
        }
        FileResolver2 mediaResolver = this.getScopedResolver("media");
        mediaResolver.resolve(path);
        FileResolver2 pdfResolver = this.getScopedResolver("pdf");
        pdfResolver.resolve(path);
        List<String> txtList = FileUtil.findDirectorys(path, "*txt");
        if (!txtList.isEmpty()) {
            String backLan = "";
            for (int i = 0; i < txtList.size(); ++i) {
                if (InterfaceType.backLan.equals(txtList.get(i))) {
                    backLan = txtList.get(i);
                    continue;
                }
                this.fileResolverProvider2.getHandler("txt").resolve(txtList.get(i));
            }
            if (!StringUtils.isEmpty((CharSequence)backLan)) {
                this.fileResolverProvider2.getHandler("txt").resolve(backLan);
            }
        }
    }

    private void deleteFiles(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            FileUtil.deleteFileAndDir(file);
        } else {
            file.delete();
        }
    }
}

