/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.customtask.dao.pub.TbExchangeFieldRelDao;
import com.geoway.landteam.customtask.pub.entity.PwInfo;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldFormater;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.repository.pub.PwInfoRepository;
import com.geoway.landteam.customtask.repository.pub.TbExchangeFieldFormatterRepository;
import com.geoway.landteam.customtask.repository.task.TbtskApproveRecordRepository;
import com.geoway.landteam.customtask.repository.task.TbtskRejectRecordRepository;
import com.geoway.landteam.customtask.service.review.TbtskFlowServiceImpl;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.model.datacq.dto.DataField;
import com.geoway.landteam.landcloud.servface.customtask.task.ObjectTableNameService;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import com.geoway.landteam.patrolclue.mapper.cluelibrary.JcClueImportRecordMapper;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractWpzfDbResolver
implements DbResolver {
    private GiLoger loger = GwLoger.getLoger(AbstractWpzfDbResolver.class);
    protected JdbcTemplate jdbcTemplate;
    protected TbExchangeFieldRelDao exchangeFieldRelDao;
    protected ObjectTableNameService objectTableNameService;
    protected TbExchangeFieldRelDao tbExchangeFieldRelDao;
    protected SysConfigService sysConfigService;
    protected TbtskApproveRecordRepository approveRecordRepository;
    protected TbtskRejectRecordRepository rejectRecordRepository;
    protected JcClueImportRecordMapper jcClueImportRecordMapper;
    protected JcClueImportRecordService jcClueImportRecordService;
    protected RedisTemplate redisTemplate;
    protected PwInfoRepository pwInfoRepository;
    protected TbtskFlowServiceImpl tbtskFlowService;
    protected TbExchangeFieldFormatterRepository formatterRepository;

    @Autowired
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Autowired
    public void setExchangeFieldRelDao(TbExchangeFieldRelDao exchangeFieldRelDao) {
        this.exchangeFieldRelDao = exchangeFieldRelDao;
    }

    @Autowired
    public void setObjectTableNameService(ObjectTableNameService objectTableNameService) {
        this.objectTableNameService = objectTableNameService;
    }

    @Autowired
    public void setTbExchangeFieldRelDao(TbExchangeFieldRelDao tbExchangeFieldRelDao) {
        this.tbExchangeFieldRelDao = tbExchangeFieldRelDao;
    }

    @Autowired
    public void setSysConfigService(SysConfigService sysConfigService) {
        this.sysConfigService = sysConfigService;
    }

    @Autowired
    public void setApproveRecordRepository(TbtskApproveRecordRepository approveRecordRepository) {
        this.approveRecordRepository = approveRecordRepository;
    }

    @Autowired
    public void setJcClueImportRecordMapper(JcClueImportRecordMapper jcClueImportRecordMapper) {
        this.jcClueImportRecordMapper = jcClueImportRecordMapper;
    }

    @Autowired
    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Autowired
    public void setJcClueImportRecordService(JcClueImportRecordService jcClueImportRecordService) {
        this.jcClueImportRecordService = jcClueImportRecordService;
    }

    @Autowired
    public void setPwInfoRepository(PwInfoRepository pwInfoRepository) {
        this.pwInfoRepository = pwInfoRepository;
    }

    @Autowired
    public void setTbtskFlowService(TbtskFlowServiceImpl tbtskFlowService) {
        this.tbtskFlowService = tbtskFlowService;
    }

    @Autowired
    public void setFormatterRepository(TbExchangeFieldFormatterRepository formatterRepository) {
        this.formatterRepository = formatterRepository;
    }

    @Autowired
    public void setRejectRecordRepository(TbtskRejectRecordRepository rejectRecordRepository) {
        this.rejectRecordRepository = rejectRecordRepository;
    }

    protected void updateSystemInfo(SqlliteConnTool connTool, ExchangeParam param, boolean isChild) throws Exception {
    }

    protected void insertTable(SqlliteConnTool connTool, String fromTable, String primary, String configid, Integer objectype) throws Exception {
        this.insertTable(connTool, fromTable, primary, configid, objectype, false);
    }

    protected void insertTable(SqlliteConnTool connTool, String fromTable, String primary, String configid, Integer objtype, boolean ischild) throws Exception {
        if (!this.hasTable(connTool, fromTable)) {
            this.loger.warn("#### SQLLITE ERROR ### DB \u7f3a\u5c11\u8868\uff1a" + fromTable + "!!!!", new Object[0]);
            throw new RuntimeException("#### SQLLITE ERROR #### DB \u7f3a\u5c11\u8868\uff1a" + fromTable + "!!!!");
        }
        if (this.hasRelConfig(configid)) {
            ExchangeParam param = new ExchangeParam(this.jdbcTemplate, this.exchangeFieldRelDao, this.objectTableNameService);
            param.init(fromTable, primary, configid, objtype);
            this.insertTmpl(connTool, param, ischild);
        }
    }

    protected void insertTmpl(SqlliteConnTool connTool, ExchangeParam param, boolean ischild) throws SQLException {
        String fromTable = param.getFromTable();
        String primary = param.getPrimary();
        String myPrimary = param.getPgPrimary();
        String toTbale = param.getToTable();
        if (ischild) {
            toTbale = param.getToChildTable();
        }
        List<DataField> fieldsList = param.getFields();
        String sql = "select * from " + fromTable;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        ArrayList<String> idList = new ArrayList<String>();
        while (rs.next()) {
            String idvalue = rs.getString(primary);
            idList.add(idvalue);
        }
        if (idList.isEmpty()) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        String idsql = String.format("select %s from %s where %s in ('%s')", myPrimary, toTbale, myPrimary, StringUtils.join(idList, (String)"','"));
        List hasIdList = this.jdbcTemplate.queryForList(idsql);
        for (int i = 0; i < hasIdList.size(); ++i) {
            idSet.add(((Map)hasIdList.get(i)).get(myPrimary).toString());
        }
        boolean hasfid = false;
        String insert = "INSERT INTO " + toTbale + " (";
        for (int i = 0; i < fieldsList.size(); ++i) {
            String field = fieldsList.get(i).getfFieldname();
            if ("f_id".equals(field)) {
                hasfid = true;
            }
            insert = insert + "\"" + field + "\"";
            if (i >= fieldsList.size() - 1) continue;
            insert = insert + ",";
        }
        if (!hasfid) {
            insert = insert + ",f_id";
        }
        insert = insert + ")";
        String sql2 = "select * from " + fromTable;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        while (rs2.next()) {
            try {
                String id = rs2.getString(primary);
                if (idSet.contains(id)) {
                    String updateSql = "UPDATE " + toTbale + " SET ";
                    updateSql = updateSql + this.getInsertSql(rs2, fieldsList, 1);
                    updateSql = updateSql + " WHERE " + myPrimary + " ='" + id + "'";
                    this.jdbcTemplate.update(updateSql);
                    continue;
                }
                String insertSql = insert + " VALUES (";
                insertSql = insertSql + this.getInsertSql(rs2, fieldsList, 0);
                if (!hasfid) {
                    String uuid = UUID.randomUUID().toString();
                    insertSql = insertSql + ",'" + uuid + "'";
                }
                insertSql = insertSql + ")";
                this.jdbcTemplate.update(insertSql);
            }
            catch (Exception e) {
                this.loger.error((Throwable)e);
            }
        }
    }

    protected void insertPwinfo(SqlliteConnTool connTool, String tablename) throws SQLException {
        String sql = "select * from " + tablename;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        while (rs.next()) {
            PwInfo pwInfo = new PwInfo();
            String id = UUID.randomUUID().toString();
            pwInfo.setId(id);
            String tbbsm = rs.getString("tbbsm");
            pwInfo.setTbbsm(tbbsm);
            String dktbbsm = rs.getString("dktbbsm");
            pwInfo.setDktbbsm(dktbbsm);
            String pwtbbsm = rs.getString("pwtbbsm");
            pwInfo.setPwtbbsm(pwtbbsm);
            String dkbh = rs.getString("dkbh");
            pwInfo.setDkbh(dkbh);
            String pzwh = rs.getString("pzwh");
            pwInfo.setPzwh(pzwh);
            String sfzypzwhmj = rs.getString("sfzypzwhmj");
            pwInfo.setSfzypzwhmj(sfzypzwhmj);
            String pzwhlx = rs.getString("pzwhlx");
            pwInfo.setPzwhlx(pzwhlx);
            String pzjg = rs.getString("pzjg");
            pwInfo.setPzjg(pzjg);
            String pzjgjb = rs.getString("pzjgjb");
            pwInfo.setPzjgjb(pzjgjb);
            String pzsj = rs.getString("pzsj");
            pwInfo.setPzsj(pzsj);
            String pzmj = rs.getString("pzmj");
            pwInfo.setPzmj(pzmj);
            String pznydmj = rs.getString("pznydmj");
            pwInfo.setPznydmj(pznydmj);
            String pzgdmj = rs.getString("pzgdmj");
            pwInfo.setPzgdmj(pzgdmj);
            String pzyjjbntmj = rs.getString("pzyjjbntmj");
            pwInfo.setPzyjjbntmj(pzyjjbntmj);
            String pdyjfile = rs.getString("pdyjfile");
            pwInfo.setPdyjfile(pdyjfile);
            String pdyjsm = rs.getString("pdyjsm");
            pwInfo.setPdyjsm(pdyjsm);
            String pzwhlxtwo = rs.getString("pzwhlxtwo");
            pwInfo.setPzwhlxtwo(pzwhlxtwo);
            String pwly = rs.getString("pwly");
            pwInfo.setPwly(pwly);
            String dz = rs.getString("dz");
            pwInfo.setDz(dz);
            String xz = rs.getString("xz");
            pwInfo.setXz(xz);
            String nz = rs.getString("nz");
            pwInfo.setNz(nz);
            String bz = rs.getString("bz");
            pwInfo.setBz(bz);
            String reltbbsm = rs.getString("reltbbsm");
            pwInfo.setReltbbsm(reltbbsm);
            String yxqz = rs.getString("yxqz");
            pwInfo.setYxqz(yxqz);
            String pwlb = rs.getString("pwlb");
            pwInfo.setPwlb(pwlb);
            String reason = rs.getString("reason");
            pwInfo.setReason(reason);
            String xmmc = rs.getString("xmmc");
            pwInfo.setXmmc(xmmc);
            String md5 = rs.getString("md5");
            pwInfo.setMd5(md5);
            String pzjsydmj = rs.getString("pzjsydmj");
            pwInfo.setPzjsydmj(pzjsydmj);
            String pzwlymj = rs.getString("pzwlymj");
            pwInfo.setPzwlymj(pzwlymj);
            String pwmdbfile = rs.getString("pwmdbfile");
            pwInfo.setPwmdbfile(pwmdbfile);
            String type = "";
            if ("dktb_pwinfo".equals(tablename)) {
                type = "1";
            } else if ("wtcz_pwinfo".equals(tablename)) {
                type = "2";
            }
            pwInfo.setType(type);
            this.pwInfoRepository.save((Object)pwInfo);
        }
    }

    private boolean hasRelConfig(String configid) {
        return this.tbExchangeFieldRelDao.countConfig(configid) > 0;
    }

    private boolean hasTable(SqlliteConnTool connTool, String tableName) throws Exception {
        String sql = "SELECT COUNT(*) FROM sqlite_master WHERE type='table' AND name='" + tableName + "';";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        rs.next();
        int count = rs.getInt(1);
        return count > 0;
    }

    protected String getInsertSql(ResultSet rs, List<DataField> fieldsList, Integer type) throws SQLException {
        String result = "";
        for (int i = 0; i < fieldsList.size(); ++i) {
            DataField field = fieldsList.get(i);
            if (type == 1) {
                result = result + "\"" + field.getfFieldname() + "\"=";
            }
            result = result + this.getInsertValue(rs, field);
            if (i >= fieldsList.size() - 1) continue;
            result = result + ",";
        }
        return result;
    }

    protected String getInsertValue(ResultSet rs, DataField field) throws SQLException {
        if ("varchar".equals(field.getfFieldtype()) || "text".equals(field.getfFieldtype()) || "json".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfRelFieldName())) {
                return "null";
            }
            String value = rs.getString(field.getfRelFieldName());
            value = value.replace("'", "''");
            TbExchangeFieldFormater formater = field.getFormater();
            if (formater != null && "string".equals(formater.getType())) {
                value = formater.fomat(value);
            }
            return " '" + value + "'";
        }
        if ("int2".equals(field.getfFieldtype()) || "int4".equals(field.getfFieldtype()) || "int8".equals(field.getfFieldtype()) || "decimal".equals(field.getfFieldtype()) || "numeric".equals(field.getfFieldtype()) || "float8".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfRelFieldName())) {
                return "null";
            }
            String temp = rs.getString(field.getfRelFieldName());
            if (StringUtils.isBlank((CharSequence)temp)) {
                temp = "0";
            } else {
                try {
                    temp = String.valueOf(Double.valueOf(temp));
                }
                catch (Exception e) {
                    temp = "-1";
                }
            }
            return temp;
        }
        if ("geometry".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfRelFieldName())) {
                return "null";
            }
            String wkt = rs.getString(field.getfRelFieldName());
            return "st_geomfromtext('" + rs.getString(field.getfRelFieldName()) + "')";
        }
        if ("date".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfRelFieldName())) {
                return "null";
            }
            String value = rs.getString(field.getfRelFieldName());
            TbExchangeFieldFormater formater = field.getFormater();
            if (formater != null && "string".equals(formater.getType())) {
                value = formater.fomat(value);
            }
            return "to_date('" + value + "','yyyy-MM-dd hh24:mi:ss')";
        }
        if ("timestamp".equals(field.getfFieldtype())) {
            if (null == rs.getString(field.getfRelFieldName())) {
                return "null";
            }
            String value = rs.getString(field.getfRelFieldName());
            TbExchangeFieldFormater formater = field.getFormater();
            if (formater != null && "string".equals(formater.getType())) {
                value = formater.fomat(value);
            }
            return "to_timestamp('" + value + "','yyyy-MM-dd hh24:mi:ss')";
        }
        if ("null".equals(field.getfFieldtype())) {
            return "null";
        }
        return " '" + rs.getString(field.getfRelFieldName()) + "'";
    }

    protected class ExchangeParam {
        private String fromTable;
        private String toTable;
        private String toChildTable;
        private String primary;
        private String pgPrimary;
        private List<DataField> fields;
        private String objectid;
        private JdbcTemplate jdbcTemplate;
        protected TbExchangeFieldRelDao exchangeFieldRelDao;
        private ObjectTableNameService objectTableNameService;

        public ExchangeParam(@NotNull JdbcTemplate jdbcTemplate, @NotNull TbExchangeFieldRelDao exchangeFieldRelDao, ObjectTableNameService objectTableNameService) {
            this.jdbcTemplate = jdbcTemplate;
            this.exchangeFieldRelDao = exchangeFieldRelDao;
            this.objectTableNameService = objectTableNameService;
        }

        public void init(String fromTable, String primary, String configid, Integer objType) {
            String pgPrimary;
            this.fromTable = fromTable;
            this.primary = primary;
            List relList = AbstractWpzfDbResolver.this.tbExchangeFieldRelDao.getRelListByConfigid(configid);
            String objectid = ((TbExchangeFieldRel)relList.stream().findFirst().orElseThrow(() -> new RuntimeException("\u7f3a\u5c11\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e"))).getObjectid();
            String toTable = this.objectTableNameService.getTablename(objectid, objType);
            String childTable = this.objectTableNameService.getChildTablename(objectid, objType);
            this.toTable = toTable;
            this.pgPrimary = pgPrimary = relList.stream().filter(e -> primary.equals(e.getOutFieldName())).map(TbExchangeFieldRel::getInFieldName).findFirst().orElseThrow(() -> new RuntimeException("\u65e0\u6548\u7684\u4e3b\u952e\u914d\u7f6e"));
            this.objectid = objectid;
            this.fields = this.getFieldsByTable(toTable, relList);
            this.toChildTable = childTable;
        }

        private List<DataField> getFieldsByTable(String tablename, List<TbExchangeFieldRel> relList) {
            List fields = relList.stream().map(TbExchangeFieldRel::getInFieldName).collect(Collectors.toList());
            ArrayList<DataField> result = new ArrayList<DataField>();
            tablename = tablename.substring(tablename.lastIndexOf(".") + 1);
            List<Map<String, Object>> fieldList = this.getFields(tablename);
            for (int i = 0; i < fieldList.size(); ++i) {
                Map<String, Object> obj = fieldList.get(i);
                String fieldName = obj.get("attname").toString();
                if (!fields.contains(fieldName)) continue;
                String pgType = obj.get("typname").toString();
                DataField temp = new DataField();
                temp.setfFieldname(fieldName);
                temp.setfFieldtype(pgType);
                Optional<TbExchangeFieldRel> fieldRel = relList.stream().filter(rel -> fieldName.equals(rel.getInFieldName())).findFirst();
                String relName = fieldRel.orElseThrow(RuntimeException::new).getOutFieldName();
                temp.setfRelFieldName(relName);
                TbExchangeFieldFormater formater = fieldRel.map(TbExchangeFieldRel::getFormaterId).map(arg_0 -> ((TbExchangeFieldFormatterRepository)AbstractWpzfDbResolver.this.formatterRepository).findById(arg_0)).map(e -> e.orElse(null)).orElse(null);
                temp.setfRelFieldName(relName);
                temp.setFormater(formater);
                result.add(temp);
            }
            return result;
        }

        private List<Map<String, Object>> getFields(String tableName) {
            String attributeSql = "select t1.*,t2.typname from (select atttypid,attname from pg_attribute where attrelid = (select oid from pg_class where relname = '" + tableName + "') and attname like 'f_%' ) t1 left join pg_type t2 on t1.atttypid = t2.oid;";
            return this.jdbcTemplate.queryForList(attributeSql);
        }

        public String getFromTable() {
            return this.fromTable;
        }

        public void setFromTable(String fromTable) {
            this.fromTable = fromTable;
        }

        public String getToTable() {
            return this.toTable;
        }

        public void setToTable(String toTable) {
            this.toTable = toTable;
        }

        public String getPrimary() {
            return this.primary;
        }

        public void setPrimary(String primary) {
            this.primary = primary;
        }

        public String getPgPrimary() {
            return this.pgPrimary;
        }

        public void setPgPrimary(String pgPrimary) {
            this.pgPrimary = pgPrimary;
        }

        public List<DataField> getFields() {
            return this.fields;
        }

        public void setFields(List<DataField> fields) {
            this.fields = fields;
        }

        public String getObjectid() {
            return this.objectid;
        }

        public void setObjectid(String objectid) {
            this.objectid = objectid;
        }

        public String getToChildTable() {
            return this.toChildTable;
        }

        public void setToChildTable(String toChildTable) {
            this.toChildTable = toChildTable;
        }
    }
}

