/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.customtask.dao.pub.TbExchangeFieldRelDao;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.model.datatransfer.AttachFileParam;
import com.geoway.landteam.landcloud.servface.customtask.task.ObjectTableNameService;
import com.geoway.landteam.landcloud.servface.datatransfer.DirectoryResolver;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;

public abstract class AbstractWpzfDirectoryResolver
implements DirectoryResolver {
    private GiLoger loger = GwLoger.getLoger(AbstractWpzfDirectoryResolver.class);
    protected TbExchangeFieldRelDao tbExchangeFieldRelDao;
    protected JdbcTemplate jdbcTemplate;
    protected AppMediaRepository appMediaRepository;
    protected static Map<String, Integer> SUFFIX_TYPE_MAP = new HashMap<String, Integer>(){
        {
            this.put("jpg", 1);
            this.put("png", 1);
            this.put("mp4", 2);
            this.put("mp3", 3);
            this.put("osgb", 4);
            this.put("pdf", 5);
            this.put("txt", 6);
            this.put("doc", 7);
            this.put("docx", 7);
            this.put("xls", 8);
            this.put("xlsx", 8);
            this.put("ppt", 9);
            this.put("pptx", 9);
            this.put("zip", 10);
        }
    };
    protected SysConfigService sysConfigService;
    protected ObjectTableNameService objectTableNameService;
    protected DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    public void setTbExchangeFieldRelDao(TbExchangeFieldRelDao tbExchangeFieldRelDao) {
        this.tbExchangeFieldRelDao = tbExchangeFieldRelDao;
    }

    @Autowired
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Autowired
    public void setAppMediaRepository(AppMediaRepository appMediaRepository) {
        this.appMediaRepository = appMediaRepository;
    }

    @Autowired
    public void setSysConfigService(SysConfigService sysConfigService) {
        this.sysConfigService = sysConfigService;
    }

    @Autowired
    public void setObjectTableNameService(ObjectTableNameService objectTableNameService) {
        this.objectTableNameService = objectTableNameService;
    }

    @Autowired
    public void setDefaultOssOperatorService(DefaultOssOperatorService defaultOssOperatorService) {
        this.defaultOssOperatorService = defaultOssOperatorService;
    }

    protected String getPrefix(AttachFileParam param) {
        return param.getCode().toLowerCase();
    }

    protected abstract String getConfigKey(AttachFileParam var1);

    protected abstract String getAttachTableName(AttachFileParam var1);

    protected abstract String queryFileInfoSql(AttachFileParam var1, String var2);

    protected abstract void customedMediaField(AppMedia var1, ResultSet var2) throws Exception;

    public void resolve(File directory, AttachFileParam param) throws Exception {
        File[] files;
        for (File file : files = directory.listFiles()) {
            this.uploadAttach(file, param);
        }
    }

    protected Integer getMedaiType(String filename) {
        String extension = FilenameUtils.getExtension((String)filename);
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            return SUFFIX_TYPE_MAP.get(extension);
        }
        return -1;
    }

    protected void uploadAttach(File file, AttachFileParam param) throws Exception {
        TbExchangeFieldRel rel = this.tbExchangeFieldRelDao.getConfig(this.getPrefix(param) + "." + this.getConfigKey(param));
        Integer objectType = rel.getObjectType();
        String objectId = rel.getObjectid();
        String tablename = this.objectTableNameService.getTablename(objectId, objectType);
        SqlliteConnTool connTool = param.getConnTool();
        String filename = file.getName();
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        String sql = this.queryFileInfoSql(param, filename);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        if (rs.next()) {
            String md5;
            String tbbsm = rs.getString("tbbsm");
            String primary = "f_dkbsm";
            if ("ba006".equals(this.getPrefix(param))) {
                primary = "f_tbbsm";
            }
            String idSql = String.format("select f_id from %s where %s = '%s'", tablename, primary, tbbsm);
            String idSqlChild = String.format("select f_id from %s where %s = '%s'", tablename + "_child", primary, tbbsm);
            String id = Optional.of(idSql).map(arg_0 -> ((JdbcTemplate)this.jdbcTemplate).queryForList(arg_0)).filter(e -> !e.isEmpty()).map(e -> (Map)e.get(0)).map(e -> (String)e.get("f_id")).orElseGet(() -> Optional.of(idSqlChild).map(arg_0 -> ((JdbcTemplate)this.jdbcTemplate).queryForList(arg_0)).filter(e -> !e.isEmpty()).map(e -> (Map)e.get(0)).map(e -> (String)e.get("f_id")).orElseThrow(() -> new RuntimeException("\u672a\u627e\u5230\u56fe\u6591")));
            int contMd5 = this.appMediaRepository.countBySm3(objectId, id, md5 = Md5Util.calFileMd5((File)file));
            if (contMd5 == 0) {
                AppMedia media = new AppMedia();
                media.setBizId(objectId);
                media.setId(UUID.randomUUID().toString());
                media.setGalleryid(id);
                media.setTypetype(Integer.valueOf(0));
                media.setFromSource("JAIMPORT");
                media.setSm3(md5);
                media.setTableName(tablename);
                media.setMediasize(Double.valueOf(file.length()));
                String extension = FilenameUtils.getExtension((String)filename);
                Integer type = SUFFIX_TYPE_MAP.get(extension);
                media.setType(type);
                String remoteUrl = "media/101/" + media.getBizId() + "/" + System.currentTimeMillis() + "/" + type + "/" + filename;
                String url = this.defaultOssOperatorService.sendObject2Oss(remoteUrl, file);
                media.setServerpath(url);
                String timeStr = rs.getString("createtime");
                try {
                    Date createtime = sdf.parse(timeStr);
                    media.setCreateTime(String.valueOf(createtime.getTime()));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.customedMediaField(media, rs);
                this.appMediaRepository.save((Object)media);
            }
        }
    }
}

