/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.servface.datatransfer.DbResolver;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class DbResolverProvider {
    @Resource
    private Map<String, DbResolver> DB_RESOLVER_MAP;

    public final DbResolver getHandler(String code) throws Exception {
        return Optional.ofNullable(code).map("dbresolver_"::concat).map(String::toLowerCase).map(this.DB_RESOLVER_MAP::get).orElseThrow(() -> new Exception("\u672a\u627e\u5230\u8be5\u7c7b\u578bDB\u89e3\u6790\u5668"));
    }

    public final boolean hasHandler(String code) {
        return Optional.ofNullable(code).map("dbresolver_"::concat).map(String::toLowerCase).map(this.DB_RESOLVER_MAP::get).isPresent();
    }

    public final void handle(SqlliteConnTool connTool, String code) throws Exception {
        this.getHandler(code).resolve(connTool);
    }

    public final void handle(String path, String code) throws Exception {
        SqlliteConnTool connTool = new SqlliteConnTool(path);
        this.getHandler(code).resolve(connTool);
    }

    public final void handle(File dbFile, String code) throws Exception {
        SqlliteConnTool connTool = new SqlliteConnTool(dbFile.getAbsolutePath());
        this.getHandler(code).resolve(connTool);
    }
}

