/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.model.datatransfer.AttachFileParam;
import com.geoway.landteam.landcloud.servface.datatransfer.DirectoryResolver;
import java.io.File;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;

@Component
public class DirectoryResolverProvider {
    @Resource
    private Map<String, DirectoryResolver> DIR_RESOLVER_MAP;

    public final DirectoryResolver getHandler(String code) throws Exception {
        return Optional.ofNullable(code).map("directoryresolver_"::concat).map(String::toLowerCase).map(this.DIR_RESOLVER_MAP::get).orElseThrow(() -> new Exception("\u672a\u627e\u5230\u8be5\u7c7b\u578bDB\u89e3\u6790\u5668"));
    }

    public final boolean hasHandler(String code) {
        return Optional.ofNullable(code).map("directoryresolver_"::concat).map(String::toLowerCase).map(this.DIR_RESOLVER_MAP::get).isPresent();
    }

    public final void handle(String path, AttachFileParam param, String code) throws Exception {
        File dir = new File(path);
        if (dir.isDirectory()) {
            this.getHandler(code).resolve(dir, param);
        }
    }

    public final void handle(File directory, AttachFileParam param, String code) throws Exception {
        if (directory.isDirectory()) {
            this.getHandler(code).resolve(directory, param);
        }
    }

    public final void handle(File directory, AttachFileParam param) throws Exception {
        String code = directory.getName();
        this.handle(directory, param, code);
    }

    public final void handle(String path, AttachFileParam param) throws Exception {
        path = FilenameUtils.getPathNoEndSeparator((String)path);
        String code = FilenameUtils.getName((String)path);
        this.handle(path, param, code);
    }
}

