/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQuery;
import com.geoway.landteam.cloudquery.servface.pub.CloudQueryService;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.servface.taskTranslate.TaskBusiCodeApater2_0Service;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportTxtService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.datacq.CloudAnalyzeCQBysxzService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ExportDataUtils;
import com.geoway.landteam.landcloud.service.thirddata.utils.ExportFileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ZipUtils;
import com.google.common.base.Preconditions;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExportDataServiceImpl
implements ExportDataService {
    private GiLoger logger = GwLoger.getLoger(ExportDataServiceImpl.class);
    @Value(value="${project.uploadDir}")
    protected String uploadDir;
    @Value(value="${project.submitDir}")
    protected String submitDir;
    @Value(value="${cloudService.url}")
    private String cloudQueryUrl;
    @Value(value="${project.applicationType}")
    private String applicationType;
    private final String template = "dailytaskmeta-submit.db";
    @Autowired
    private TskTaskBizService tskTaskBizService;
    @Autowired
    private TbtskFieldsService tbtskFieldsService;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    private LandUserRepository landUserDao;
    @Autowired
    private CloudQueryService cloudQueryDao;
    @Autowired
    private ExportTxtService exportTxtService;
    @Autowired
    private FileTransferService fileTransferService;
    @Resource(name="CloudAnalyzeCQBysxzService")
    private CloudAnalyzeCQBysxzService analyzeCQService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    TaskBusiCodeApater2_0Service taskBusiCodeApater2_0Service;
    private ExecutorService executor = Executors.newCachedThreadPool();

    public void export(String taskId, String ids, Boolean isAppSubmit, Boolean isSubmit, String userId, String identity, String userIds) throws Exception {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId can not be null ");
        TskTaskBiz tskTaskBiz = null;
        TbtskObjectinfo tbtskObjectinfo = null;
        List sourceFields = null;
        SysConfig disabelTransferConfig = this.sysConfigService.findOne("transfer.disable");
        boolean disabelTransfer = disabelTransferConfig == null || StringUtils.isBlank((CharSequence)disabelTransferConfig.getValue()) ? false : "true".equals(disabelTransferConfig.getValue().toLowerCase());
        File zipFile = null;
        try {
            tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
            if (tskTaskBiz != null && StringUtils.isNotBlank((CharSequence)tskTaskBiz.getTableId())) {
                tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            if (tbtskObjectinfo != null && StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfTablename())) {
                sourceFields = this.tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
            }
            String safeFileName = "" + System.currentTimeMillis();
            String fileNameNoSuffix = this.uploadDir + File.separator + safeFileName;
            if (sourceFields != null && sourceFields.size() > 0) {
                this.createExportData(fileNameNoSuffix, tbtskObjectinfo, tskTaskBiz, sourceFields, ids, isAppSubmit, userId, userIds);
                if (isSubmit.booleanValue()) {
                    this.createSubmitTxt(fileNameNoSuffix, tskTaskBiz.getId());
                    if (!"lan".equals(this.applicationType)) {
                        this.createBackTxt(fileNameNoSuffix, tskTaskBiz.getId());
                    }
                }
                ZipUtils utils = new ZipUtils();
                utils.doZip(fileNameNoSuffix);
                ExportFileUtil.deleteFileAndDir(new File(fileNameNoSuffix));
                zipFile = new File(fileNameNoSuffix + ".zip");
                if (!disabelTransfer) {
                    this.fileTransferService.sendFile(fileNameNoSuffix + ".zip", identity);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            e.printStackTrace();
            throw e;
        }
        finally {
            if (!disabelTransfer && zipFile != null) {
                zipFile.delete();
            }
        }
    }

    public void createDownloadDataAsync(final String taskId, final String ids, final Boolean isAppSubmit, final Boolean isSubmit, final String userId, final String identity, final String userIds) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ExportDataServiceImpl.this.createDownloadData(taskId, ids, isAppSubmit, isSubmit, userId, identity, userIds);
            }
        });
        this.executor.execute(thread);
    }

    public void createDownloadData(String taskId, String ids, Boolean isAppSubmit, Boolean isSubmit, String userId, String identity, String userIds) {
        Preconditions.checkNotNull((Object)taskId, (Object)"taskId can not be null ");
        TskTaskBiz tskTaskBiz = null;
        TbtskObjectinfo tbtskObjectinfo = null;
        List sourceFields = null;
        DataDownloadRecord dataDownloadRecord = this.dataDownloadRecordService.buildDataDownloadRecordBaseInfo(taskId, null, Long.parseLong(userId));
        this.dataDownloadRecordService.save(dataDownloadRecord);
        try {
            tskTaskBiz = this.tskTaskBizService.findByTaskId(taskId);
            dataDownloadRecord.setName(tskTaskBiz.getName());
            if (tskTaskBiz != null && StringUtils.isNotBlank((CharSequence)tskTaskBiz.getTableId())) {
                tbtskObjectinfo = this.tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            if (tbtskObjectinfo != null && StringUtils.isNotBlank((CharSequence)tbtskObjectinfo.getfTablename())) {
                sourceFields = this.tbtskFieldsService.getAllFieldsByTables(tbtskObjectinfo.getfTablename());
            }
            String safeFileName = "" + System.currentTimeMillis();
            String fileNameNoSuffix = this.uploadDir + File.separator + (tskTaskBiz.getName() + "_" + safeFileName);
            if (sourceFields != null && sourceFields.size() > 0) {
                this.createExportData(fileNameNoSuffix, tbtskObjectinfo, tskTaskBiz, sourceFields, ids, isAppSubmit, userId, userIds);
                if (isSubmit.booleanValue()) {
                    this.createSubmitTxt(fileNameNoSuffix, tskTaskBiz.getId());
                    if (!"lan".equals(this.applicationType)) {
                        this.createBackTxt(fileNameNoSuffix, tskTaskBiz.getId());
                    }
                }
                ZipUtils utils = new ZipUtils();
                utils.doZip(fileNameNoSuffix);
                ExportFileUtil.deleteFileAndDir(new File(fileNameNoSuffix));
                File zipFile = new File(fileNameNoSuffix + ".zip");
                dataDownloadRecord.setUrl(zipFile.getAbsolutePath());
                dataDownloadRecord.setTbCount(tskTaskBiz.getAllCount());
                dataDownloadRecord.setEndTime(new Date());
                dataDownloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                this.dataDownloadRecordService.save(dataDownloadRecord);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
            e.printStackTrace();
            dataDownloadRecord.setEndTime(new Date());
            dataDownloadRecord.setErrorMsg(e.getMessage());
            dataDownloadRecord.setState(DataDownloadStateEnum.FAILED);
            this.dataDownloadRecordService.save(dataDownloadRecord);
        }
    }

    public void createInterfaceData(JSONObject requestBody, String url, String type, String loginUrl, String identity) throws Exception {
        Preconditions.checkNotNull((Object)url, (Object)"url can not be null ");
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("requestBody", (Object)requestBody);
            jsonObject.put("url", (Object)url);
            jsonObject.put("loginUrl", (Object)loginUrl);
            jsonObject.put("type", (Object)type);
            String fileName = new SimpleDateFormat("yyyyMMddHHmmssS").format(new Date());
            File file = new File(System.getProperty("java.io.tmpdir") + fileName + ".ex");
            String param = jsonObject.toJSONString();
            FileUtils.writeStringToFile((File)file, (String)param, (String)"GBK");
            this.fileTransferService.sendFile(file, identity);
            file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void appSubmit(String bizId, String tableName, MultipartFile[] files, String userId, String identity) {
        try {
            if (files.length < 1) {
                this.logger.error("app\u4e0a\u4ea4\u4efb\u52a1\u6570\u636e\u540c\u6b65\u5931\u8d25\uff0c\u65e0\u6cd5\u83b7\u53d6db\u6587\u4ef6", new Object[0]);
                throw new Exception("\u65e0\u6cd5\u83b7\u53d6db\u6587\u4ef6");
            }
            MultipartFile fileOfDB = files[0];
            File tempUploadFile = this.buildTempUploadFile(UUID.randomUUID().toString());
            FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
            SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
            Connection connection = connPool.getConnection();
            Statement statement = connection.createStatement();
            ResultSet rs = null;
            String sql = "SELECT DISTINCT f_id from " + tableName;
            rs = statement.executeQuery(sql);
            ArrayList<String> idList = new ArrayList<String>();
            while (rs.next()) {
                String f_id = rs.getString("f_id");
                idList.add(f_id);
            }
            connPool.closeAll(connection, statement, rs);
            tempUploadFile.delete();
            this.export(bizId, String.join((CharSequence)",", idList), true, false, userId, identity, null);
        }
        catch (Exception e) {
            this.logger.fatal("app\u4e0a\u4ea4\u4efb\u52a1\u6570\u636e\u540c\u6b65\u5931\u8d25" + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
    }

    public void sendBYSXZData(String taskid, String ids) throws Exception {
        this.export(taskid, ids, false, false, null, "wydc", null);
    }

    public String getAppSubmitIds(String tableName, MultipartFile[] files) throws SQLException, IOException {
        MultipartFile fileOfDB = files[0];
        File tempUploadFile = this.buildTempUploadFile(UUID.randomUUID().toString());
        FileUtils.copyInputStreamToFile((InputStream)fileOfDB.getInputStream(), (File)tempUploadFile);
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        String sql = "SELECT DISTINCT f_id from " + tableName;
        rs = statement.executeQuery(sql);
        ArrayList<String> idList = new ArrayList<String>();
        while (rs.next()) {
            String f_id = rs.getString("f_id");
            idList.add(f_id);
        }
        connPool.closeAll(connection, statement, rs);
        tempUploadFile.delete();
        return String.join((CharSequence)",", idList);
    }

    public void createExportData(String resultDbFileDir, TbtskObjectinfo tbtskObjectinfo, TskTaskBiz tskTaskBiz, List<TbtskFields> fieldsList, String ids, Boolean isAppSubmit, String userId, String userIds) throws Exception {
        this.logger.info("\u65e5\u5e38\u4efb\u52a1\u4e0b\u8f7d \u5f00\u59cb\u5bfc\u51fa\u6570\u636e ", new Object[0]);
        SqlliteConnTool connTool = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            String databaseFile = ExportDataUtils.copyDataBaseFile(resultDbFileDir, this.template, null);
            connTool = new SqlliteConnTool(databaseFile);
            conn = connTool.getConnection();
            conn.setAutoCommit(false);
            this.createExportData(resultDbFileDir, conn, ps, tbtskObjectinfo, tskTaskBiz, fieldsList, ids, isAppSubmit, userId, userIds);
            ExportDataUtils.closeConn(connTool, conn, ps);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                this.logger.error((Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                ExportDataUtils.closeConn(connTool, conn, ps);
                throw throwable;
            }
        }
        ExportDataUtils.closeConn(connTool, conn, ps);
    }

    public void createExportData(String DbFileDir, String taskId, String ids) throws Exception {
        TskTaskBiz tskTaskBiz = Optional.ofNullable(taskId).map(arg_0 -> ((TskTaskBizService)this.tskTaskBizService).findByTaskId(arg_0)).orElseThrow(() -> new RuntimeException("\u65e0\u6548\u7684bizId"));
        TbtskObjectinfo objectinfo = Optional.ofNullable(tskTaskBiz.getTableId()).map(arg_0 -> ((TbtskObjectinfoService)this.tbtskObjectinfoService).getObjectbyID(arg_0)).orElseThrow(RuntimeException::new);
        List fields = Optional.ofNullable(objectinfo.getfTablename()).map(arg_0 -> ((TbtskFieldsService)this.tbtskFieldsService).getAllFieldsByTables(arg_0)).orElseThrow(() -> new RuntimeException("\u5b57\u6bb5\u914d\u7f6e\u9519\u8bef"));
        this.createExportData(DbFileDir, objectinfo, tskTaskBiz, fields, ids, false, null, null);
    }

    private void createExportData(String resultDbFileDir, Connection conn, PreparedStatement pre, TbtskObjectinfo tbtskObjectinfo, TskTaskBiz tskTaskBiz, List<TbtskFields> fieldsList, String ids, Boolean isAppSubmit, String userId, String userIds) throws Exception {
        String childrenIds;
        List childList;
        this.logger.info("\u5f00\u59cb\u5199\u5165Tbtsk_task_biz", new Object[0]);
        String busiCode = this.taskBusiCodeApater2_0Service.getBusiCode(tskTaskBiz);
        this.insertBizData(conn, pre, tskTaskBiz.getId());
        TbtskObjectinfo childInfo = null;
        if (tskTaskBiz.getPmEnable() == 1 && !(childList = this.tbtskObjectinfoService.getObjectByParentObjId(tbtskObjectinfo.getfId())).isEmpty()) {
            childInfo = (TbtskObjectinfo)childList.get(0);
        }
        if (isAppSubmit.booleanValue()) {
            this.logger.info("\u5f00\u59cb\u5199\u5165tb_app_media", new Object[0]);
            this.insertAppMedia(conn, pre, tbtskObjectinfo.getfTablename(), resultDbFileDir, ids);
            this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_assign_record", new Object[0]);
            this.insertAssign(conn, pre, tskTaskBiz.getId(), ids);
            if ("BYSXZ".equals(busiCode)) {
                this.insertBysxz(conn, pre, tbtskObjectinfo.getfTablename(), resultDbFileDir, ids, userId);
            }
        } else if (null == ids || StringUtils.isEmpty((CharSequence)ids)) {
            this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_objectinfo", new Object[0]);
            this.insertObjectInfo(conn, pre, tbtskObjectinfo.getfId());
            if (null != childInfo) {
                this.insertObjectInfo(conn, pre, childInfo.getfId());
            }
            this.logger.info("\u5f00\u59cb\u5199\u5165tb_app_media", new Object[0]);
            this.insertAppMedia(conn, pre, tbtskObjectinfo.getfTablename(), resultDbFileDir, null);
            this.logger.info("\u5f00\u59cb\u5199\u5165tbsys_user_biz2", new Object[0]);
            this.insertUserBiz(conn, pre, tskTaskBiz.getId());
            this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_group", new Object[0]);
            this.insertGroup(conn, pre, tbtskObjectinfo.getfTablename());
            this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_assign_record", new Object[0]);
            this.insertAssign(conn, pre, tskTaskBiz.getId(), null);
            this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_task_ntzy_project", new Object[0]);
            this.insertProjectInfoData(conn, pre, tbtskObjectinfo.getfId());
            this.logger.info("\u5f00\u59cb\u5438\u5165check\u8868", new Object[0]);
            this.insertCheckData(conn, pre, fieldsList);
            this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_task_project_ntzy_statistics", new Object[0]);
            this.insertStatistics(conn, pre, tbtskObjectinfo.getfId());
        } else if ("BYSXZ".equals(busiCode) || "GDBH_SPBA".equals(busiCode) || "GDBH_JCJG".equals(busiCode) || "PHJG".equals(busiCode) || "CGJC_JDJC".equals(busiCode) || "GDBH_JCPH".equals(busiCode)) {
            this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_objectinfo", new Object[0]);
            this.insertObjectInfo(conn, pre, tbtskObjectinfo.getfId());
            this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_group", new Object[0]);
            this.insertGroup(conn, pre, tbtskObjectinfo.getfTablename());
            if (null != childInfo) {
                this.insertObjectInfo(conn, pre, childInfo.getfId());
            }
            if ("GDBH_JCJG".equals(busiCode) || "CGJC_JDJC".equals(busiCode)) {
                this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_task_ntzy_project", new Object[0]);
                this.insertProjectInfoData(conn, pre, tbtskObjectinfo.getfId());
                this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_task_project_ntzy_statistics", new Object[0]);
                this.insertStatistics(conn, pre, tbtskObjectinfo.getfId());
                this.logger.info("\u5f00\u59cb\u5199\u5165tbsys_user_biz2", new Object[0]);
                this.insertUserBiz(conn, pre, tskTaskBiz.getId());
            }
        }
        this.logger.info("\u5f00\u59cb\u5199\u5165\u6570\u636e\u8868", new Object[0]);
        this.insertTableData(conn, pre, fieldsList, ids, userIds);
        this.logger.info("\u5f00\u59cb\u5199\u5165tbtsk_fields", new Object[0]);
        this.insertFields(conn, pre, tbtskObjectinfo.getfId());
        if (childInfo != null && !StringUtils.isEmpty((CharSequence)(childrenIds = this.getChildrenIds(tbtskObjectinfo, childInfo, ids)))) {
            List childFiledList = this.tbtskFieldsService.getAllFieldsByTables(childInfo.getfTablename());
            this.insertTableData(conn, pre, childFiledList, childrenIds, null);
            this.insertFields(conn, pre, childInfo.getfId());
            this.insertGroup(conn, pre, childInfo.getfTablename());
            if (!"lan".equals(this.applicationType)) {
                this.insertAppMedia(conn, pre, childInfo.getfTablename(), resultDbFileDir, childrenIds);
            }
        }
    }

    private void insertObjectInfo(Connection connection, PreparedStatement pre, String tableId) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_objectinfo"));
        String insertSql = "INSERT INTO 'tbtsk_objectinfo' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "SELECT * from tbtsk_objectinfo t where t.f_id = '" + tableId + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private void insertTableData(Connection connection, PreparedStatement pre, List<TbtskFields> fieldsList, String ids, String userIds) throws Exception {
        String tableName = fieldsList.get(0).getfTablename();
        String create = "CREATE TABLE '" + tableName + "' (";
        String insert = "INSERT INTO '" + tableName + "' (";
        String insertEnd = " VALUES (";
        boolean flag = true;
        for (int i = 0; i < fieldsList.size(); ++i) {
            String field = fieldsList.get(i).getfFieldname();
            create = create + "'" + field + "'" + this.getTypeSql(fieldsList.get(i));
            insert = insert + "'" + field + "'";
            insertEnd = insertEnd + "?";
            if (i != fieldsList.size() - 1) {
                create = create + ",";
                insert = insert + ",";
                insertEnd = insertEnd + ",";
            }
            if (!field.equals("f_sendto")) continue;
            flag = false;
        }
        if (flag && !StringUtils.isEmpty((CharSequence)userIds)) {
            create = create + ",'f_sendto' text";
            insert = insert + ",'f_sendto'";
            insertEnd = insertEnd + ",?";
        }
        create = create + ")";
        insert = insert + ")";
        insertEnd = insertEnd + ")";
        insert = insert + insertEnd;
        pre = connection.prepareStatement(create);
        pre.execute();
        String sql1 = "select * from " + tableName;
        if (null != ids && !StringUtils.isEmpty((CharSequence)ids)) {
            sql1 = sql1 + " WHERE f_id in (";
            sql1 = sql1 + this.getInSql(ids);
            sql1 = sql1 + ")";
        }
        List mapList = this.jdbcTemplate.queryForList(sql1);
        pre = connection.prepareStatement(insert);
        for (int i = 0; i < mapList.size(); ++i) {
            Map map = (Map)mapList.get(i);
            for (int j = 0; j < fieldsList.size(); ++j) {
                this.setTableData(pre, fieldsList.get(j), map, j + 1);
            }
            if (!StringUtils.isEmpty((CharSequence)userIds)) {
                pre.setString(fieldsList.size() + 1, userIds);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    private void insertCheckData(Connection connection, PreparedStatement pre, List<TbtskFields> fieldsList) throws Exception {
        String tableName = fieldsList.get(0).getfTablename();
        String checkName = tableName + "_check";
        boolean hasTable = this.isTableExist(checkName);
        if (!hasTable) {
            return;
        }
        ArrayList<String> fieldCheck = new ArrayList<String>();
        fieldCheck.add("f_id");
        fieldCheck.add("f_pid");
        fieldCheck.add("f_createtime");
        fieldCheck.add("f_userid");
        fieldCheck.add("f_username");
        fieldCheck.add("f_checktime");
        fieldCheck.add("f_sign");
        String create = "CREATE TABLE '" + checkName + "' ('f_id' varchar(100),'f_pid' varchar(100),'f_createtime' varchar(100),'f_userid' varchar(100),'f_username' varchar(100),'f_checktime' varchar(100),'f_sign' text";
        String insert = "INSERT INTO '" + checkName + "' ('f_id','f_pid','f_createtime','f_userid','f_username','f_checktime','f_sign'";
        String insertEnd = " VALUES (?,?,?,?,?,?,?";
        String[] existsArr = new String[]{"f_id", "f_pid", "f_createtime", "f_userid", "f_username", "f_checktime", "f_sign"};
        for (int i = 0; i < fieldsList.size(); ++i) {
            if (fieldsList.get(i).getfIsOutwork() != null && 1 != fieldsList.get(i).getfIsOutwork()) continue;
            String field = fieldsList.get(i).getfFieldname();
            boolean flag = Arrays.asList(existsArr).contains(field);
            if (flag) continue;
            fieldCheck.add(field);
            create = create + ",'" + field + "'" + this.getTypeSql(fieldsList.get(i));
            insert = insert + ",'" + field + "'";
            insertEnd = insertEnd + ",?";
        }
        create = create + ")";
        insert = insert + ")";
        insertEnd = insertEnd + ")";
        insert = insert + insertEnd;
        pre = connection.prepareStatement(create);
        pre.execute();
        String sql1 = "select * from " + checkName + " ;";
        List mapList = this.jdbcTemplate.queryForList(sql1);
        pre = connection.prepareStatement(insert);
        for (int i = 0; i < mapList.size(); ++i) {
            Map map = (Map)mapList.get(i);
            for (int j = 0; j < fieldCheck.size(); ++j) {
                this.setTableData2(pre, fieldCheck, map, j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    private void insertStatistics(Connection connection, PreparedStatement pre, String tableId) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_task_project_ntzy_statistic"));
        String insertSql = "INSERT INTO 'tbtsk_task_project_ntzy_statistic' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "SELECT * from tbtsk_task_project_ntzy_statistic t where t.f_tableid = '" + tableId + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private boolean isTableExist(String tableName) {
        String sql;
        Map map;
        if (tableName.contains(".")) {
            String[] split = tableName.split("\\.");
            tableName = split[1];
        }
        return 0 != Integer.valueOf((map = this.jdbcTemplate.queryForMap(sql = "select count(*) as f_count from pg_class where relname = '" + tableName + "'")).get("f_count").toString());
    }

    private String getTypeSql(TbtskFields fields) {
        if ("varchar".equals(fields.getfFieldtype())) {
            return " varchar(" + fields.getfLength() + ")";
        }
        if ("text".equals(fields.getfFieldtype())) {
            return " text";
        }
        if ("geometry".equals(fields.getfFieldtype())) {
            return " text";
        }
        return " varchar(100)";
    }

    private void setTableData(PreparedStatement pre, TbtskFields fields, Map<String, Object> map, int index) throws SQLException {
        if (null == map.get(fields.getfFieldname())) {
            pre.setString(index, null);
        } else {
            pre.setString(index, map.get(fields.getfFieldname()).toString());
        }
    }

    private void setTableData2(PreparedStatement pre, List<String> fields, Map<String, Object> map, int index) throws SQLException {
        if (null == map.get(fields.get(index - 1))) {
            pre.setString(index, null);
        } else {
            pre.setString(index, map.get(fields.get(index - 1)).toString());
        }
    }

    private void insertAppMedia(Connection connection, PreparedStatement pre, String tableName, String resultDbFileDir, String ids) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tb_app_media"));
        String insertSql = "INSERT INTO 'tb_app_media' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tb_app_media t where t.f_galleryid in (select f_id from " + tableName;
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            String idsql = this.getInSql(ids);
            dataSql = dataSql + " WHERE f_id in (" + idsql + ")";
        }
        dataSql = dataSql + ");";
        pre = connection.prepareStatement(insertSql);
        List mapList = this.jdbcTemplate.queryForList(dataSql);
        if (mapList.size() == 0) {
            return;
        }
        for (int i = 0; i < mapList.size(); ++i) {
            Map map = (Map)mapList.get(i);
            this.insertMedias(map, resultDbFileDir);
            for (int j = 0; j < fieldArray.length; ++j) {
                ExportDataUtils.setStringData(pre, map, fieldArray[j], j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    private void insertUserBiz(Connection connection, PreparedStatement pre, String bizid) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tbsys_user_biz2"));
        String insertSql = "INSERT INTO 'tbsys_user_biz2' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbsys_user_biz2 t where t.f_bizid = '" + bizid + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private void insertFields(Connection connection, PreparedStatement pre, String tableId) throws SQLException {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_fields"));
        String insertSql = "INSERT INTO 'tbtsk_fields' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbtsk_fields t where t.f_tableid = '" + tableId + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private void insertGroup(Connection connection, PreparedStatement pre, String tablename) throws SQLException {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_group"));
        String insertSql = "INSERT INTO 'tbtsk_group' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbtsk_group t where t.f_tablename = '" + tablename + "'";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private void insertAssign(Connection connection, PreparedStatement pre, String taskId, String ids) throws SQLException {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_assign_record"));
        String insertSql = "INSERT INTO 'tbtsk_assign_record' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbtsk_assign_record t WHERE t.f_taskid = '" + taskId + "'";
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            String idsql = this.getInSql(ids);
            dataSql = dataSql + " and f_dataid in (" + idsql + ")";
        }
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private void insertProjectInfoData(Connection connection, PreparedStatement pre, String tableId) throws Exception {
        String[] fieldArray = this.getFieldArray(this.getFields("tbtsk_task_ntzy_project"));
        String insertSql = "INSERT INTO 'tbtsk_task_ntzy_project' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from tbtsk_task_ntzy_project where f_tableid = '" + tableId + "';";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private void insertMedias(Map<String, Object> map, String resultDbFileDir) {
        if (null == map.get("f_serverpath") || StringUtils.isEmpty((CharSequence)map.get("f_serverpath").toString())) {
            return;
        }
        String serverPath = map.get("f_serverpath").toString();
        if (serverPath.toLowerCase().startsWith("http://")) {
            int pathIndex = serverPath.indexOf("/", 7);
            serverPath = serverPath.substring(pathIndex + 1);
        }
        String[] paths = serverPath.split("/");
        String mediaPath = resultDbFileDir;
        for (int i = 0; i < paths.length - 1; ++i) {
            mediaPath = mediaPath + File.separator + paths[i];
        }
        String url = "";
        url = null == map.get("f_downloadurl") || StringUtils.isEmpty((CharSequence)map.get("f_downloadurl").toString()) ? map.get("f_serverpath").toString() : map.get("f_downloadurl").toString();
        String mediaName = paths[paths.length - 1];
        try {
            if (StringUtils.isNotBlank((CharSequence)url)) {
                if (url.startsWith("https://pan.jfunbox.com")) {
                    FileUtils.copyURLToFile((URL)new URL(url), (File)new File(mediaPath, mediaName));
                } else {
                    url = this.temporarySignedUrlService.getTemporarySignedUrl("", url, null);
                    FileUtils.copyURLToFile((URL)new URL(url), (File)new File(mediaPath, mediaName));
                }
            }
        }
        catch (IOException e) {
            this.logger.error((Throwable)e);
            e.printStackTrace();
        }
    }

    private void insertTeml(Connection connection, PreparedStatement pre, String insertSql, String dataSql, String[] fieldArray) throws SQLException {
        pre = connection.prepareStatement(insertSql);
        List mapList = this.jdbcTemplate.queryForList(dataSql);
        for (int i = 0; i < mapList.size(); ++i) {
            Map map = (Map)mapList.get(i);
            for (int j = 0; j < fieldArray.length; ++j) {
                ExportDataUtils.setStringData(pre, map, fieldArray[j], j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        connection.commit();
        pre.close();
    }

    private void setNumberData(PreparedStatement pre, Object obj, int index) throws SQLException {
        if (null == obj) {
            pre.setString(index, null);
        } else {
            pre.setString(index, (String)obj);
        }
    }

    private File buildTempUploadFile(String userid) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("task-%s-%s-%s.db", userid, sdf.format(new Date()), UUID.randomUUID().toString());
        return new File(this.uploadDir, fileName);
    }

    private void createSubmitTxt(String path, String bizId) throws Exception {
        ArrayList<String> data = new ArrayList<String>();
        data.add("submitProject");
        data.add(bizId);
        this.exportTxtService.writeTxtData(data, path, false);
    }

    private void insertBysxz(Connection connection, PreparedStatement pre, String tableName, String resultDbFileDir, String ids, String userId) throws Exception {
        String inString = this.getInSql(ids);
        String requestSql = "select f_requestid, f_bjbh from " + tableName + " where f_id in (" + inString + ");";
        List dataList = this.jdbcTemplate.queryForList(requestSql);
        ArrayList<String> requestList = new ArrayList<String>();
        HashMap<String, String> requestMap = new HashMap<String, String>();
        for (int i = 0; i < dataList.size(); ++i) {
            Map obj = (Map)dataList.get(i);
            String requestId = (String)obj.get("f_requestid");
            if (StringUtils.isEmpty((CharSequence)requestId)) continue;
            requestMap.put(requestId, (String)obj.get("f_bjbh"));
            requestList.add(requestId);
        }
        List cloudQueryList = this.cloudQueryDao.getByRequestIdAndMark(requestList);
        if (cloudQueryList.isEmpty()) {
            return;
        }
        LandUser user = this.landUserDao.queryUserById(Long.valueOf(userId));
        for (int i = 0; i < cloudQueryList.size(); ++i) {
            CloudQuery obj = (CloudQuery)cloudQueryList.get(i);
            String requestId = obj.getRequestId();
            String tag = obj.getTag();
            if (!"\u6751\u9547\u9009\u5740".equals(tag) || null == obj.getResult()) continue;
            String fileName = (String)requestMap.get(requestId) + ".pdf";
            File file = new File(resultDbFileDir, fileName);
            break;
        }
    }

    private void createBackTxt(String path, String bizId) throws Exception {
        String sql1 = "select f_id from tbtsk_task_ntzy_project where f_biz_id = '" + bizId + "';";
        List data1 = this.jdbcTemplate.queryForList(sql1);
        if (data1.isEmpty()) {
            return;
        }
        String newProjectId = (String)((Map)data1.get(0)).get("f_id");
        String sql = "select f_id from tbtsk_task_biz_history where f_newid = '" + bizId + "';";
        List data = this.jdbcTemplate.queryForList(sql);
        if (data.isEmpty()) {
            return;
        }
        String oldBizId = (String)((Map)data.get(0)).get("f_id");
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(InterfaceType.backLan);
        JSONObject object = new JSONObject();
        object.put("oldBizId", (Object)oldBizId);
        object.put("newBizId", (Object)bizId);
        object.put("newProjectId", (Object)newProjectId);
        resultList.add(object.toJSONString());
        this.exportTxtService.writeTxtData(resultList, path, false);
    }

    private List<Map<String, Object>> getFields(String tableName) {
        if (tableName.contains(".")) {
            String[] split = tableName.split("\\.");
            tableName = split[1];
        }
        String attributeSql = "select atttypid,attname from pg_attribute where attrelid = (select oid from pg_class where relname = '" + tableName + "') and attname like 'f_%' ORDER BY atttypid;";
        return this.jdbcTemplate.queryForList(attributeSql);
    }

    private String[] getFieldArray(List<Map<String, Object>> data) {
        String[] result = new String[data.size()];
        for (int i = 0; i < data.size(); ++i) {
            Map<String, Object> map = data.get(i);
            result[i] = map.get("attname").toString();
        }
        return result;
    }

    private void insertBizData(Connection connection, PreparedStatement pre, String id) throws Exception {
        String tablename = "tbtsk_task_biz";
        String[] fieldArray = this.getFieldArray(this.getFields(tablename));
        String insertSql = "INSERT INTO '" + tablename + "' (" + ExportDataUtils.getInsertFields(fieldArray) + ") ";
        insertSql = insertSql + " VALUES (" + ExportDataUtils.getQuestionMark(fieldArray) + ")";
        String dataSql = "select * from " + tablename + " t where t.f_id = '" + id + "'";
        this.insertTeml(connection, pre, insertSql, dataSql, fieldArray);
    }

    private String getInSql(String ids) {
        String[] idArray = ids.split(",");
        String idsql = "";
        for (int i = 0; i < idArray.length; ++i) {
            idsql = idsql + "'" + idArray[i] + "'";
            if (i == idArray.length - 1) continue;
            idsql = idsql + ",";
        }
        return idsql;
    }

    private String getChildrenIds(TbtskObjectinfo parent, TbtskObjectinfo child, String ids) {
        String relfield = child.getRelfield();
        if (StringUtils.isEmpty((CharSequence)relfield)) {
            return "";
        }
        JSONObject relJson = JSONObject.parseObject((String)relfield);
        String parentFiled = relJson.getString("parentFieldName");
        String childFiled = relJson.getString("fieldName");
        String sql = "select f_id from " + child.getfTablename() + " where " + childFiled + " in (select " + parentFiled + " from " + parent.getfTablename() + " where f_id in (" + this.getInSql(ids) + "));";
        String result = "";
        List dataList = this.jdbcTemplate.queryForList(sql);
        for (int i = 0; i < dataList.size(); ++i) {
            result = result + ((Map)dataList.get(i)).get("f_id");
            if (i == dataList.size() - 1) continue;
            result = result + ",";
        }
        return result;
    }
}

