/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.ParamType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.UpdateType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.ValueType;
import com.geoway.landteam.landcloud.model.datatransfer.dto.DataOperate;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportJsonService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExportJsonServiceImpl
implements ExportJsonService {
    private static GiLoger logger = GwLoger.getLoger(ExportJsonServiceImpl.class);
    @Value(value="${project.submitDir}")
    protected String submitDir;
    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    private TskTaskBizService tskTaskBizService;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private TbtskFieldsService tbtskFieldsService;

    public void deleteTaskData(String dataIds, String taskId) throws IOException {
        TskTaskBiz biz = this.tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo objectinfo = this.tbtskObjectinfoService.getObjectbyID(biz.getTableId());
        String tableName = objectinfo.getfTablename();
        String[] idArray = dataIds.split(",");
        JSONArray resultArray = new JSONArray();
        for (int i = 0; i < idArray.length; ++i) {
            JSONObject object = new JSONObject();
            object.put("type", (Object)UpdateType.DEL);
            object.put("table", (Object)tableName);
            object.put("data", (Object)new JSONArray());
            JSONArray paramArray = new JSONArray();
            JSONObject paramObject = this.createParamObject("f_id", idArray[i], ValueType.TYPE_STRING, ParamType.TYPE_EQ);
            paramArray.add((Object)paramObject);
            object.put("param", (Object)paramArray);
            resultArray.add((Object)object);
        }
        this.writeJson(resultArray.toString(), InterfaceType.deleteTaskData);
    }

    public void editTskTaskBiz(TskTaskBiz taskBiz) throws IOException {
        JSONArray resultArray = new JSONArray();
        JSONObject object = new JSONObject();
        object.put("type", (Object)UpdateType.UPDATE);
        object.put("table", (Object)"tbtsk_task_biz");
        JSONArray dataArray = new JSONArray();
        if (StringUtils.isNotBlank((CharSequence)taskBiz.getName())) {
            dataArray.add((Object)this.createDataObject("f_name", taskBiz.getName(), ValueType.TYPE_STRING));
        }
        if (StringUtils.isNotBlank((CharSequence)taskBiz.getDesc())) {
            dataArray.add((Object)this.createDataObject("f_desc", taskBiz.getDesc(), ValueType.TYPE_STRING));
        }
        if (taskBiz.getStartTime() != null) {
            dataArray.add((Object)this.createDataObject("f_starttime", taskBiz.getStartTime(), ValueType.TYPE_DATE));
        }
        if (taskBiz.getEndTime() != null) {
            dataArray.add((Object)this.createDataObject("f_endtime", taskBiz.getEndTime(), ValueType.TYPE_DATE));
        }
        if (StringUtils.isNotBlank((CharSequence)taskBiz.getAllowEdit())) {
            dataArray.add((Object)this.createDataObject("f_allownedit", taskBiz.getAllowEdit(), ValueType.TYPE_STRING));
        }
        if (StringUtils.isNotBlank((CharSequence)taskBiz.getAllowNew())) {
            dataArray.add((Object)this.createDataObject("f_allownew", taskBiz.getAllowNew(), ValueType.TYPE_STRING));
        }
        if (StringUtils.isNotBlank((CharSequence)taskBiz.getNeedSign())) {
            dataArray.add((Object)this.createDataObject("f_needsign", taskBiz.getNeedSign(), ValueType.TYPE_STRING));
        }
        if (taskBiz.getIsTmpl() != null) {
            dataArray.add((Object)this.createDataObject("f_istmpl", taskBiz.getIsTmpl(), ValueType.TYPE_INT));
        }
        object.put("data", (Object)dataArray);
        JSONArray paramArray = new JSONArray();
        paramArray.add((Object)this.createParamObject("f_id", taskBiz.getId(), ValueType.TYPE_STRING, ParamType.TYPE_EQ));
        object.put("param", (Object)paramArray);
        resultArray.add((Object)object);
        this.writeJson(resultArray.toString(), "editTskTaskBiz");
    }

    public void checkTaskData(Map<String, Object> data, String bizId, String dataId, String type, Long userId, String tableName) throws IOException {
        JSONArray resultArray = new JSONArray();
        JSONObject assignObject = new JSONObject();
        assignObject.put("type", (Object)UpdateType.UPDATE);
        assignObject.put("table", (Object)"tbtsk_assign_record");
        JSONArray assignDataArray = new JSONArray();
        JSONObject assignDataObject = this.createDataObject("f_status", "1", ValueType.TYPE_INT);
        assignDataArray.add((Object)assignDataObject);
        assignObject.put("data", (Object)assignDataArray);
        JSONArray paramArray = new JSONArray();
        JSONObject paramObject1 = this.createParamObject("f_dataid", dataId, ValueType.TYPE_STRING, ParamType.TYPE_EQ);
        JSONObject paramObject2 = this.createParamObject("f_assignto", userId, ValueType.TYPE_STRING, ParamType.TYPE_EQ);
        paramArray.add((Object)paramObject1);
        paramArray.add((Object)paramObject2);
        assignObject.put("param", (Object)paramArray);
        resultArray.add((Object)assignObject);
        JSONObject tableObject = new JSONObject();
        tableObject.put("type", (Object)UpdateType.UPDATE);
        tableObject.put("table", (Object)tableName);
        List fieldsList = this.tbtskFieldsService.getAllFieldsByTables(tableName);
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        for (int i = 0; i < fieldsList.size(); ++i) {
            fieldMap.put(((TbtskFields)fieldsList.get(i)).getfFieldname(), ((TbtskFields)fieldsList.get(i)).getfFieldtype());
        }
        JSONArray tableDataArray = new JSONArray();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String fieldType = (String)fieldMap.get(entry.getKey());
            if (StringUtils.isEmpty((CharSequence)fieldType)) continue;
            JSONObject tempObject = this.createDataObject(entry.getKey(), entry.getValue(), ValueType.getType((String)fieldType));
            tableDataArray.add((Object)tempObject);
        }
        tableObject.put("data", (Object)tableDataArray);
        JSONArray paramTableArray = new JSONArray();
        JSONObject paramObject3 = this.createParamObject("f_id", dataId, ValueType.TYPE_STRING, ParamType.TYPE_EQ);
        paramTableArray.add((Object)paramObject3);
        tableObject.put("param", (Object)paramTableArray);
        resultArray.add((Object)tableObject);
        this.writeJson(resultArray.toString(), "checkTaskData");
    }

    public void updateTbData(String tablename, List<DataOperate> data, List<DataOperate> where) throws IOException {
        JSONArray resultArray = new JSONArray();
        JSONObject updateObj = new JSONObject();
        updateObj.put("type", (Object)UpdateType.UPDATE);
        updateObj.put("table", (Object)tablename);
        JSONArray assignDataArray = new JSONArray();
        data.forEach(item -> {
            JSONObject object = this.createDataObject(item.getField(), item.getValue(), item.getValueType());
            assignDataArray.add((Object)object);
        });
        updateObj.put("data", (Object)assignDataArray);
        JSONArray paramArray = new JSONArray();
        where.forEach(item -> {
            JSONObject object = this.createParamObject(item.getField(), item.getValue(), item.getValueType(), item.getParamType());
            paramArray.add((Object)object);
        });
        updateObj.put("param", (Object)paramArray);
        resultArray.add((Object)updateObj);
        this.writeJson(resultArray.toString(), InterfaceType.updateTbData);
    }

    public void submitTask(List<String> ids, String tablename) throws IOException {
        ArrayList<DataOperate> data = new ArrayList<DataOperate>();
        DataOperate item = new DataOperate("f_status", "4", ValueType.TYPE_INT);
        data.add(item);
        ArrayList<DataOperate> where = new ArrayList<DataOperate>();
        DataOperate item3 = new DataOperate("f_id", StringUtils.join(ids, (String)","), ValueType.TYPE_STRING, ParamType.TYPE_IN);
        where.add(item3);
        this.updateTbData(tablename, data, where);
        ArrayList<DataOperate> data2 = new ArrayList<DataOperate>();
        DataOperate item2 = new DataOperate("f_status", "1", ValueType.TYPE_STRING);
        data2.add(item2);
        ArrayList<DataOperate> where2 = new ArrayList<DataOperate>();
        DataOperate item4 = new DataOperate("f_id", StringUtils.join(ids, (String)","), ValueType.TYPE_STRING, ParamType.TYPE_IN);
        where2.add(item4);
        this.updateTbData("tbtsk_assign_record", data2, where2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJson(String json, String type) throws IOException {
        String fileName = type + "_" + System.currentTimeMillis();
        String path = this.submitDir + File.separator + fileName + ".json";
        File file = new File(path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file.createNewFile();
        BufferedWriter out = new BufferedWriter(new FileWriter(file));
        try {
            out.write(json);
            out.flush();
        }
        finally {
            out.close();
            this.fileTransferService.sendFile(path);
            file.delete();
        }
    }

    private JSONObject createDataObject(String key, Object value, Integer valueType) {
        JSONObject object = new JSONObject();
        object.put("key", (Object)key);
        object.put("value", value);
        object.put("valueType", (Object)valueType);
        return object;
    }

    private JSONObject createParamObject(String key, Object value, Integer valueType, Integer paramType) {
        JSONObject object = new JSONObject();
        object.put("key", (Object)key);
        object.put("value", value);
        object.put("valueType", (Object)valueType);
        object.put("paramType", (Object)paramType);
        return object;
    }
}

