/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.model.pub.entity.TaskBizProject;
import com.geoway.landteam.landcloud.model.pub.entity.TbBizProjectHistory;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectHistoryRepository;
import com.geoway.landteam.landcloud.repository.pub.TbBizProjectRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.ExportTxtService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ExportTxtServiceImpl
implements ExportTxtService {
    @Value(value="${project.submitDir}")
    protected String submitDir;
    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    private TbBizProjectRepository projectDao;
    @Autowired
    private TbBizProjectHistoryRepository projectHistoryDao;

    public void reviewProjectLan(String bizId, String message, String checkId, String checkStatus) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(InterfaceType.backProject);
        JSONObject object = new JSONObject();
        object.put("bizId", (Object)bizId);
        object.put("message", JSONObject.parse((String)message, (Feature[])new Feature[0]));
        object.put("checkId", (Object)checkId);
        object.put("checkStatus", (Object)checkStatus);
        resultList.add(object.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    public void deleteTask(String taskId, Long userId, Boolean sync) throws Exception {
        String newId;
        TbBizProjectHistory history;
        TaskBizProject newProject;
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(InterfaceType.deleteTask);
        JSONObject object = new JSONObject();
        object.put("taskId", (Object)taskId);
        object.put("userId", (Object)userId);
        object.put("sync", (Object)sync);
        if (sync.booleanValue() && (newProject = this.projectDao.findOneByBizId(taskId)) != null && "3".equals(newProject.getCheckStatus()) && (history = this.projectHistoryDao.findByNewId(newId = newProject.getId())) != null) {
            object.put("wyid", (Object)history.getBizId());
        }
        resultList.add(object.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    public void sendTask(JSONObject data, Boolean isWhole) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        if (isWhole.booleanValue()) {
            resultList.add("sendTaskWhole");
        } else {
            resultList.add("sendTask");
        }
        resultList.add(data.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    public void updateJbnt(String json, String interfaceName) throws Exception {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(interfaceName);
        JSONObject object = new JSONObject();
        object.put("message", JSONObject.parse((String)json, (Feature[])new Feature[0]));
        resultList.add(object.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    public void backItem(String bizId, String tbids, String reason) throws Exception {
        JSONObject object = new JSONObject();
        object.put("bizId", (Object)bizId);
        object.put("tbids", (Object)tbids);
        object.put("reason", (Object)reason);
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(InterfaceType.backItem);
        object.put("message", (Object)object);
        resultList.add(object.toJSONString());
        this.writeTxtData(resultList, this.submitDir, true);
    }

    public boolean writeTxtData(List<String> result, String path, boolean send) throws Exception {
        String fileName = result.get(0);
        return this.writeTxtData(result, path, send, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeTxtData(List<String> result, String path, boolean send, String fileName) throws Exception {
        boolean flag = false;
        BufferedWriter out = null;
        File file = null;
        long timeName = System.currentTimeMillis();
        try {
            if (result != null) {
                if (!result.isEmpty()) {
                    String relFilePath;
                    fileName = fileName + "_" + timeName + ".txt";
                    File pathFile = new File(path);
                    if (!pathFile.exists()) {
                        pathFile.mkdirs();
                    }
                    if (!(file = new File(relFilePath = path + File.separator + fileName)).exists()) {
                        file.createNewFile();
                    }
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                    for (String info : result) {
                        out.write(info);
                        out.newLine();
                    }
                    flag = true;
                    return flag;
                }
            }
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (send && null != file) {
                    this.fileTransferService.sendFile(file.getPath());
                }
            }
            return flag;
        }
    }
}

