/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.service.util.Zip4jUtils;
import com.geoway.landteam.customtask.util.DateUtils;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.pub.entity.OptLog;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.model.datacq.entity.ConfigFiletransfer;
import com.geoway.landteam.landcloud.model.datacq.entity.TbtskQueryInfo;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.repository.datacq.ConfigFiletransferRepository;
import com.geoway.landteam.landcloud.repository.datacq.TbtskQueryInfoRepository;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ExportFileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.SignUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.SmbUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class FileTransferServiceImpl
implements FileTransferService {
    private GiLoger logger = GwLoger.getLoger(FileTransferServiceImpl.class);
    @Value(value="${FileTransfer.url}")
    private String url;
    @Value(value="${project.filetrans:}")
    private String filetransPath;
    @Value(value="${FileTransfer.shareUrl:}")
    private String shareUrl;
    private final String configkey = "filetransferConfig";
    private final String mapkey = "filetransferConfigMap";
    private final String mapProgress = "filetransferProgress";
    private final String inProgress = "filetransferInProgress";
    private boolean isStart = false;
    @Value(value="${project.import.exchange}")
    protected String dataFolder;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private TbtskQueryInfoRepository tbtskQueryInfoRepository;
    @Autowired
    private ConfigFiletransferRepository filetransferRepository;
    @Autowired
    private LogService logService;
    @Autowired
    private SysConfigService sysConfigService;
    protected JSONObject config;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFile(File file, String identity) throws Exception {
        if (this.config == null) {
            this.config = Optional.of("transfer.config").map(arg_0 -> ((SysConfigService)this.sysConfigService).findToJson(arg_0)).orElseGet(JSONObject::new);
        }
        String url = this.config.getString("url");
        String app = this.config.getString("app");
        String module = this.config.getString("module");
        String filePath = file.getAbsolutePath();
        String path = FilenameUtils.getFullPathNoEndSeparator((String)filePath);
        String baseName = FilenameUtils.getBaseName((String)filePath);
        String filename = FilenameUtils.getName((String)filePath);
        String tempPath = path + File.separator + baseName;
        FileUtil.creatDirectoryIfNotExist((String)tempPath);
        File tempFile = new File(tempPath + File.separator + filename);
        file.renameTo(tempFile);
        File mate = new File(tempPath + File.separator + baseName + ".meta");
        JSONObject mateinfo = new JSONObject();
        mateinfo.put("identity", (Object)identity);
        mateinfo.put("filename", (Object)baseName);
        mateinfo.put("time", (Object)new Date().toString());
        mate.createNewFile();
        try (BufferedWriter out = new BufferedWriter(new FileWriter(mate));){
            out.write(mateinfo.toJSONString());
            out.flush();
        }
        Zip4jUtils.zip((String)tempPath, null, (boolean)false, null);
        File zip = new File(tempPath + ".zip");
        ExportFileUtil.deleteFileAndDir(new File(tempPath));
        HttpUtil.sendRrquestByFile(app, module, zip, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFile() {
        if (this.isStart) {
            return;
        }
        if (this.isInProgress().booleanValue()) {
            return;
        }
        try {
            JSONArray fileArray = this.getFileList();
            if (null == fileArray || fileArray.size() == 0) {
                return;
            }
            this.logger.debug("\u83b7\u53d6\u6587\u4ef6\uff1a" + fileArray.toString(), new Object[0]);
            for (int i = 0; i < fileArray.size(); ++i) {
                JSONObject object = fileArray.getJSONObject(i);
                String fileId = object.getString("FileId");
                if (this.hasDownload(fileId).booleanValue()) continue;
                String IdentityID = object.getString("IdentityID");
                String fileName = object.getString("FileName");
                String SystemId = object.getString("SystemId");
                this.logger.debug("\u83b7\u53d6\u6587\u4ef6\uff1a" + IdentityID + "   " + fileId + "   " + fileName + "\n", new Object[0]);
                String path = this.saveFile(fileName, fileId, IdentityID, SystemId);
                this.saveLdlife(path, IdentityID, fileId);
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        finally {
            this.isStart = false;
            this.removeProgress();
        }
    }

    public void sendFile(String filePath) throws UnsupportedEncodingException {
    }

    public void sendFile(String filePath, String identity) throws Exception {
        if (StringUtils.isEmpty((Object)identity)) {
            identity = "wydc";
        }
        File file = new File(filePath);
        this.sendFile(file, identity);
    }

    public void deleteFiletrans(String fileName) {
        String filePath = this.filetransPath + File.separator + fileName;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
    }

    public void removeProgress() {
        if (this.redisTemplate.hasKey((Object)this.mapProgress).booleanValue()) {
            this.redisTemplate.delete((Object)this.mapProgress);
        }
    }

    private JSONArray getFileList() {
        List<ConfigFiletransfer> configList = this.getConfig();
        JSONArray result = new JSONArray();
        for (int i = 0; i < configList.size(); ++i) {
            ConfigFiletransfer config = configList.get(i);
            String systemId = config.getSystemid();
            String identitys = config.getIdentitys();
            JSONArray array = this.getFileList(systemId);
            if (array.isEmpty()) continue;
            for (int j = 0; j < array.size(); ++j) {
                JSONObject object = array.getJSONObject(j);
                String IdentityID = object.getString("IdentityID");
                if (identitys.indexOf(IdentityID) <= -1) continue;
                object.put("SystemId", (Object)systemId);
                result.add((Object)object);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONArray getFileList(String systemId) {
        CloseableHttpClient client = null;
        try {
            String getUrl = this.url + "/getfileinfo?SystemId=" + systemId + "&IsReady=true";
            HttpGet get = new HttpGet(getUrl);
            client = HttpClients.createDefault();
            CloseableHttpResponse response = null;
            response = client.execute((HttpUriRequest)get);
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"utf-8");
            JSONObject resultObject = JSONObject.parseObject((String)result);
            if (!"200".equals(resultObject.getString("code"))) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray jSONArray = JSONArray.parseArray((String)resultObject.get((Object)"data").toString(), (Feature[])new Feature[0]);
            return jSONArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Throwable)e);
            JSONArray jSONArray = null;
            return jSONArray;
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveFile(String fileName, String fileId, String IdentityID, String SystemId) throws IOException {
        String savePath;
        File file;
        Boolean fileExisted = false;
        File filePath = new File(this.dataFolder + File.separator + IdentityID);
        if (!filePath.exists()) {
            filePath.mkdirs();
        }
        if (!(file = new File(savePath = this.dataFolder + File.separator + IdentityID + File.separator + fileName)).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        InputStream is = null;
        FilterInputStream dataInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            String getFileUrl = this.url + "/receive?SystemId=" + SystemId + "&IdentityID=" + IdentityID + "&FileId=" + fileId;
            String signUrl = this.getSignUrl(getFileUrl, this.getConfigByIdentity(IdentityID));
            URL url = new URL(signUrl);
            is = url.openStream();
            dataInputStream = new DataInputStream(is);
            fileOutputStream = new FileOutputStream(file);
            byte[] chs = new byte[1024];
            int len = 0;
            while ((len = ((DataInputStream)dataInputStream).read(chs)) != -1) {
                fileOutputStream.write(chs, 0, len);
            }
        }
        finally {
            try {
                fileOutputStream.close();
                dataInputStream.close();
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtils.isEmpty((Object)this.shareUrl)) {
            String smbPath = this.shareUrl + "/data/" + IdentityID + "/" + fileName;
            SmbUtil.putFile(savePath, smbPath);
            return smbPath;
        }
        return savePath;
    }

    private String sendPost(String strUrl, Map<String, String> parameters, File file) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpPost post = new HttpPost(strUrl);
        long time = 0L;
        OptLog log = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (file.length() > 10000000L) {
            time = System.currentTimeMillis();
            JSONObject object = new JSONObject();
            object.put("file", (Object)file.getName());
            object.put("fileLength", (Object)(file.length() / 1000L / 1000L + "M"));
            object.put("starttime", (Object)sdf.format(new Date()));
            log = this.logService.saveLog(LogType.startFileTranfer, object.toString());
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (file.exists()) {
            builder.addBinaryBody("Content", file);
        }
        for (String key : parameters.keySet()) {
            builder.addTextBody(key, parameters.get(key));
        }
        HttpEntity entity = builder.build();
        post.setEntity(entity);
        post.setHeader("Url", this.url.split("/api")[0]);
        try {
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                if (file.length() > 10000000L) {
                    long time2 = System.currentTimeMillis();
                    JSONObject object = JSONObject.parseObject((String)log.getData());
                    object.put("endtime", (Object)sdf.format(new Date()));
                    object.put("time", (Object)((time2 - time) / 1000L + "s"));
                    log.setData(object.toString());
                    log.setOptType(LogType.endFileTranfer);
                    this.logService.saveLog(log);
                }
                return result;
            }
            this.logger.fatal("\u4f20\u8f93\u51fa\u9519" + response.getStatusLine().toString(), new Object[0]);
        }
        catch (ClientProtocolException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String sendPost2(String strUrl, Map<String, String> parameters, File file) {
        RestTemplate rest = new RestTemplate();
        FileSystemResource resource = new FileSystemResource(file);
        LinkedMultiValueMap param = new LinkedMultiValueMap();
        param.add((Object)"Content", (Object)resource);
        for (String key : parameters.keySet()) {
            param.add((Object)key, (Object)parameters.get(key));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(new MediaType(MediaType.MULTIPART_FORM_DATA, Charset.forName("utf-8")));
        org.springframework.http.HttpEntity requestEntity = new org.springframework.http.HttpEntity((Object)param, (MultiValueMap)headers);
        String string = (String)rest.postForObject(strUrl, (Object)requestEntity, String.class, new Object[0]);
        return string;
    }

    private String getSignUrl(String url, ConfigFiletransfer filetransfer) {
        Date date = new Date();
        long time = date.getTime();
        url = url.contains("?") ? url + "&" : url + "?";
        url = url + "appkey=" + filetransfer.getAppkey() + "&timestamp=" + String.valueOf(time);
        String sign = SignUtil.getSign(url, filetransfer.getAppsecret());
        url = url + "&sign=" + sign;
        return url;
    }

    public String getSignUrl(String appkey, String secret, Long time) {
        String url = this.url + "/send";
        url = url.contains("?") ? url + "&" : url + "?";
        url = url + "appkey=" + appkey + "&timestamp=" + String.valueOf(time);
        String sign = SignUtil.getSign(url, secret);
        url = url + "&sign=" + sign;
        return url;
    }

    private void getSignParam(String url, ConfigFiletransfer filetransfer, Map<String, String> parameters) {
        Date date = new Date();
        long time = date.getTime();
        url = url.contains("?") ? url + "&" : url + "?";
        url = url + "appkey=" + filetransfer.getAppkey() + "&timestamp=" + String.valueOf(time);
        String sign = SignUtil.getSign(url, filetransfer.getAppsecret());
        parameters.put("appkey", filetransfer.getAppkey());
        parameters.put("timestamp", String.valueOf(time));
        parameters.put("sign", sign);
    }

    private void saveLdlife(String path, String IdentityID, String id) {
        if (StringUtils.isEmpty((Object)path)) {
            return;
        }
        TbtskQueryInfo info = new TbtskQueryInfo();
        info.setId(id);
        info.setPath(path);
        info.setState(Integer.valueOf(0));
        info.setLevel(Integer.valueOf(0));
        info.setTime(DateUtils.getSysTime().toString());
        info.setRepeat(Integer.valueOf(0));
        info.setType(IdentityID);
        this.tbtskQueryInfoRepository.save((Object)info);
    }

    private List<ConfigFiletransfer> getConfig() {
        if (this.redisTemplate.hasKey((Object)this.configkey).booleanValue()) {
            return (List)this.redisTemplate.opsForValue().get((Object)this.configkey);
        }
        List list = this.filetransferRepository.getConfig();
        this.redisTemplate.opsForValue().set((Object)this.configkey, (Object)list, 1L, TimeUnit.DAYS);
        return list;
    }

    private ConfigFiletransfer getConfigByIdentity(String identity) {
        if (this.redisTemplate.hasKey((Object)this.mapkey).booleanValue()) {
            Map map = (Map)this.redisTemplate.opsForValue().get((Object)this.mapkey);
            if (!map.containsKey(identity)) {
                this.saveConfig(map, identity);
            }
            return (ConfigFiletransfer)map.get(identity);
        }
        HashMap<String, ConfigFiletransfer> map = new HashMap<String, ConfigFiletransfer>();
        this.saveConfig(map, identity);
        return (ConfigFiletransfer)map.get(identity);
    }

    private void saveConfig(Map<String, ConfigFiletransfer> map, String identity) {
        ConfigFiletransfer obj = this.filetransferRepository.getConfigByType(identity);
        map.put(identity, obj);
        this.redisTemplate.opsForValue().set((Object)this.mapkey, map, 1L, TimeUnit.DAYS);
    }

    private Boolean isInProgress() {
        if (this.redisTemplate.hasKey((Object)this.mapProgress).booleanValue()) {
            return true;
        }
        this.redisTemplate.opsForValue().set((Object)this.mapProgress, (Object)true, 1L, TimeUnit.DAYS);
        return false;
    }

    private void copyToFiletrans(File file) throws IOException {
        String fileName = file.getName();
        FileUtil.copyFile((String)file.getPath(), (String)(this.filetransPath + File.separator + fileName), (StandardCopyOption[])new StandardCopyOption[0]);
    }

    public Boolean isInProgress(String fileid) {
        if (this.redisTemplate.hasKey((Object)this.inProgress).booleanValue()) {
            Set set = (Set)this.redisTemplate.opsForValue().get((Object)this.inProgress);
            if (!set.contains(fileid)) {
                set.add(fileid);
                this.redisTemplate.opsForValue().set((Object)this.inProgress, (Object)set, 1L, TimeUnit.DAYS);
                return false;
            }
            return true;
        }
        HashSet<String> set = new HashSet<String>();
        set.add(fileid);
        this.redisTemplate.opsForValue().set((Object)this.inProgress, set, 1L, TimeUnit.DAYS);
        return false;
    }

    public void removeProgress(String fileid) {
        if (this.redisTemplate.hasKey((Object)this.inProgress).booleanValue()) {
            Set set = (Set)this.redisTemplate.opsForValue().get((Object)this.inProgress);
            set.remove(fileid);
            this.redisTemplate.opsForValue().set((Object)this.inProgress, (Object)set, 1L, TimeUnit.DAYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFileInfo(String id, ConfigFiletransfer filetransfer) {
        CloseableHttpClient client = null;
        try {
            String baseurl = this.url + "/deleteByInfo?id=" + id;
            String getUrl = this.getSignUrl(baseurl, filetransfer);
            HttpGet get = new HttpGet(getUrl);
            client = HttpClients.createDefault();
            CloseableHttpResponse response = null;
            response = client.execute((HttpUriRequest)get);
            String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"utf-8");
            JSONObject resultObject = JSONObject.parseObject((String)result);
            if (!"200".equals(resultObject.getString("code"))) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Boolean isProcessFinished(List<TbtskQueryInfo> queryInfos) {
        Assert.notNull(queryInfos, (String)"empty queryInfos");
        for (TbtskQueryInfo queryInfo : queryInfos) {
            Set set;
            String key = queryInfo.getId();
            if (!this.redisTemplate.hasKey((Object)this.inProgress).booleanValue() || !(set = (Set)this.redisTemplate.opsForValue().get((Object)this.inProgress)).contains(key)) continue;
            return false;
        }
        return true;
    }

    private Boolean hasDownload(String fileId) {
        TbtskQueryInfo info = (TbtskQueryInfo)this.tbtskQueryInfoRepository.gwSearchByPK((Serializable)((Object)fileId));
        if (null != info) {
            return true;
        }
        return false;
    }
}

