/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.model.pub.dto.FtApplicationDto;
import com.geoway.landteam.landcloud.model.pub.entity.FtApplicationToSystem;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationToBusinessRepository;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationToSystemRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.FtAppToSystemService;
import com.gexin.fastjson.JSON;
import java.sql.Timestamp;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class FtAppToSystemServiceImpl
implements FtAppToSystemService {
    @Autowired
    private FtApplicationToSystemRepository ftApplicationToSystemRepository;
    @Autowired
    private FtApplicationToBusinessRepository ftApplicationToBusinessRepository;

    public String addEntity(FtApplicationDto dto, Long userId) {
        String id = UUID.randomUUID().toString();
        FtApplicationToSystem ftApplication = new FtApplicationToSystem();
        ftApplication.setAppkey(dto.getAppkey());
        ftApplication.setSystemid(dto.getSystemid());
        ftApplication.setDescription(dto.getDescription());
        ftApplication.setRegistrant(userId);
        ftApplication.setRegistertime(new Timestamp(System.currentTimeMillis()));
        ftApplication.setState(Integer.valueOf(1));
        ftApplication.setIp("::1");
        ftApplication.setIp_state(Integer.valueOf(1));
        this.ftApplicationToSystemRepository.save((Object)ftApplication);
        return id;
    }

    public List<FtApplicationToSystem> findAll() {
        return this.ftApplicationToSystemRepository.findAll();
    }

    public Page<FtApplicationToSystem> findPageList(String filterParam, String sortParam, int start, int limit) {
        Page results = this.ftApplicationToSystemRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public FtApplicationToSystem findByName(String name) {
        return this.ftApplicationToSystemRepository.findByDescription(name);
    }

    public void updateEntity(FtApplicationDto dto) {
        FtApplicationToSystem ftApplication = (FtApplicationToSystem)JSONObject.parseObject((String)JSON.toJSONString((Object)dto), FtApplicationToSystem.class);
        this.ftApplicationToSystemRepository.save((Object)ftApplication);
    }

    public void delete(FtApplicationToSystem entity) {
        List entities = this.ftApplicationToBusinessRepository.findBySystemid(entity.getSystemid());
        if (null != entities && entities.size() > 0) {
            this.ftApplicationToBusinessRepository.deleteBySystemId(entity.getSystemid());
        }
        this.ftApplicationToSystemRepository.delete((Object)entity);
    }
}

