/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.model.pub.dto.FtApplicationDto;
import com.geoway.landteam.landcloud.model.pub.entity.FtApplication;
import com.geoway.landteam.landcloud.model.pub.entity.FtApplicationToSystem;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationRepository;
import com.geoway.landteam.landcloud.repository.pub.FtApplicationToSystemRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.FtAppToSystemService;
import com.geoway.landteam.landcloud.servface.datatransfer.FtApplicationService;
import com.gexin.fastjson.JSON;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class FtApplicationServiceImpl
implements FtApplicationService {
    @Value(value="${forwarded.url:}")
    protected String netUrl;
    @Autowired
    private FtApplicationRepository ftApplicationRepository;
    @Autowired
    private FtApplicationToSystemRepository ftApplicationToSystemRepository;
    @Autowired
    private FtAppToSystemService ftAppToSystemService;

    public String addEntity(FtApplicationDto dto, Long userId) {
        String appkey = UUID.randomUUID().toString();
        String appsecret = UUID.randomUUID().toString();
        FtApplication ftApplication = new FtApplication();
        ftApplication.setAppkey(appkey);
        ftApplication.setAppsecret(appsecret);
        ftApplication.setSystemname(dto.getSystemname());
        ftApplication.setDescription(dto.getDescription());
        ftApplication.setDepartment(dto.getDepartment());
        ftApplication.setRegistrant(userId);
        ftApplication.setRegistertime(new Timestamp(System.currentTimeMillis()));
        if (null == dto.getState()) {
            dto.setState(Integer.valueOf(1));
        }
        ftApplication.setState(dto.getState());
        this.ftApplicationRepository.save((Object)ftApplication);
        return appkey;
    }

    public List<FtApplication> findAll() {
        return this.ftApplicationRepository.findAll();
    }

    public Page<FtApplication> findPageList(String filterParam, String sortParam, int start, int limit) {
        Page results = this.ftApplicationRepository.findAll((Specification)new QuerySpecification(filterParam), (Pageable)PageRequest.of((int)start, (int)limit, (Sort)QueryParamUtil.parseSortParams((String)sortParam)));
        return results;
    }

    public void updateEntity(FtApplicationDto dto) {
        FtApplication ftApplication = (FtApplication)JSONObject.parseObject((String)JSON.toJSONString((Object)dto), FtApplication.class);
        this.ftApplicationRepository.save((Object)ftApplication);
    }

    public void delete(FtApplication entity) {
        List entities = this.ftApplicationToSystemRepository.findByAppkey(entity.getAppkey());
        if (null != entities && entities.size() > 0) {
            for (FtApplicationToSystem temp : entities) {
                this.ftAppToSystemService.delete(temp);
            }
        }
        this.ftApplicationRepository.delete((Object)entity);
    }

    public String forwarded(String param) throws IOException {
        StringEntity httpEntity = new StringEntity(param, ContentType.create((String)"application/x-www-form-urlencoded", (String)"utf-8"));
        HttpPost post = new HttpPost(this.netUrl);
        post.setEntity((HttpEntity)httpEntity);
        post.setHeader("Authorization", "Basic YWRtaW46Z2Vvc2VydmVy");
        String result = null;
        return result;
    }

    public String dealData(JSONObject jsonObject) {
        Map header = null;
        String param = null;
        if (jsonObject.containsKey((Object)"headers") && !StringUtils.isBlank((CharSequence)jsonObject.getString("headers"))) {
            header = (Map)JSONObject.parseObject((String)jsonObject.getString("headers"), Map.class);
        }
        JSONObject object = jsonObject.getJSONObject("requestbody");
        String url = jsonObject.getString("url");
        if (null == object || object.size() <= 0) {
            if (url.contains("&")) {
                url = url.replaceAll("&", "#");
                url = url.replaceAll(" ", "A1B2C3D4E5");
            }
            param = "&url=" + url;
        } else {
            String requestbody = object.toJSONString();
            param = header == null || header.size() <= 0 ? "&url=" + url + "&requestbody=" + requestbody : "&url=" + url + "&requestbody=" + requestbody + "&headers=" + JSONArray.toJSONString((Object)header);
        }
        if (!StringUtils.isBlank((CharSequence)jsonObject.getString("type"))) {
            param = param + "&type=" + jsonObject.getString("type");
        }
        return param;
    }
}

