/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.model.datacq.entity.TbtskQueryInfo;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.repository.datacq.TbtskQueryInfoRepository;
import com.geoway.landteam.landcloud.servface.datatransfer.FileTransferService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportDataService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportDbService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportDcxsService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportExService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportJsonService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportTxtService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportZbphDataService;
import com.geoway.landteam.landcloud.service.thirddata.utils.FileUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.SmbUtil;
import com.geoway.landteam.landcloud.service.thirddata.utils.ZipUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ImportDataServiceImpl
implements ImportDataService {
    @Value(value="${project.import.exchange}")
    protected String dataFolder;
    @Value(value="${project.import.media}")
    protected String mediaFolder;
    @Value(value="${project.import.bysxz}")
    protected String pdfFolder;
    @Value(value="${project.minioModel:}")
    protected String minioModel;
    private int status = 0;
    @Autowired
    private ImportZbphDataService zbphDataService;
    @Autowired
    TbtskQueryInfoRepository queryInfoDao;
    @Autowired
    private FileTransferService fileTransferService;
    @Autowired
    private ImportDbService dbService;
    @Autowired
    private ImportTxtService txtService;
    @Autowired
    private ImportDcxsService dcxsService;
    @Autowired
    private ImportJsonService jsonService;
    @Autowired
    private ImportExService importExService;
    private GiLoger logger = GwLoger.getLoger(ImportDataServiceImpl.class);
    private final String[] identitys = new String[]{"wydc", "zbph", "phjg", "dcxs"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            if (this.status == 1) {
                return;
            }
            this.status = 1;
            List list = this.queryInfoDao.queryListByList(Integer.valueOf(0), new ArrayList<String>(Arrays.asList(this.identitys)));
            for (int i = 0; i < list.size(); ++i) {
                TbtskQueryInfo info = (TbtskQueryInfo)list.get(i);
                String objIdentity = info.getType();
                if (this.fileTransferService.isInProgress(info.getId()).booleanValue()) continue;
                info.setState(Integer.valueOf(1));
                this.queryInfoDao.saveAndFlush((Object)info);
                try {
                    String filePath = info.getPath();
                    if (filePath.startsWith("smb://")) {
                        String toPath = this.dataFolder + File.separator + objIdentity;
                        filePath = SmbUtil.getFile(filePath, toPath);
                    }
                    File file = new File(filePath);
                    this.progress(objIdentity, file);
                    info.setState(Integer.valueOf(2));
                    this.queryInfoDao.saveAndFlush((Object)info);
                    file.delete();
                    continue;
                }
                catch (Exception e) {
                    info.setState(Integer.valueOf(3));
                    info.setError(ExceptionUtils.getStackTrace((Throwable)e));
                    this.queryInfoDao.saveAndFlush((Object)info);
                    continue;
                }
                finally {
                    this.fileTransferService.removeProgress(info.getId());
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
        finally {
            this.status = 0;
        }
    }

    public void progress(String objIdentity, File tempFile) throws Exception {
        String allFileName = tempFile.getName();
        String fileName = allFileName.split("\\.")[0];
        String filePath = tempFile.getPath();
        if (allFileName.indexOf(".zip") != -1) {
            ZipUtils utils = new ZipUtils();
            utils.decompressZip(filePath, tempFile.getPath().split(".zip")[0] + File.separator);
            String processFile = this.dataFolder + File.separator + objIdentity + File.separator + fileName;
            if (this.identitys[0].equals(objIdentity) || this.identitys[2].equals(objIdentity)) {
                this.importData(processFile);
            }
            this.deleteFiles(tempFile.getPath().split(".zip")[0] + File.separator);
        } else if (allFileName.indexOf(".txt") != -1) {
            this.txtService.readTxt(filePath);
        } else if (allFileName.indexOf(".json") != -1) {
            this.jsonService.readJson(filePath);
        } else if (allFileName.indexOf(".db") != -1) {
            if (this.identitys[1].equals(objIdentity)) {
                this.zbphDataService.importZbphDb(filePath);
            } else if (this.identitys[3].equals(objIdentity)) {
                // empty if block
            }
        } else if (allFileName.indexOf(".ex") != -1) {
            this.importExService.importData(filePath);
        } else {
            this.logger.error("\u65e0\u6cd5\u89e3\u6790\u6587\u4ef6\u7c7b\u578b\u2014\u2014" + allFileName, new Object[0]);
        }
    }

    private void deleteFiles(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            FileUtil.deleteFileAndDir(file);
        } else {
            file.delete();
        }
    }

    public void importData(String path) throws Exception {
        List<String> txtList;
        List<String> pdfFileList;
        List<String> mediaFileList;
        List<String> dbFileList = FileUtil.findFiles(path, "meta.db");
        if (!dbFileList.isEmpty()) {
            String dbPath = dbFileList.get(0);
            this.dbService.importToDb(dbPath);
        }
        if (!(mediaFileList = FileUtil.findDirectorys(path, "media")).isEmpty()) {
            this.saveMedia(mediaFileList.get(0));
        }
        if (!(pdfFileList = FileUtil.findFiles(path, "*.pdf")).isEmpty()) {
            this.savePdf(pdfFileList);
        }
        if (!(txtList = FileUtil.findDirectorys(path, "*txt")).isEmpty()) {
            String backLan = "";
            for (int i = 0; i < txtList.size(); ++i) {
                if (InterfaceType.backLan.equals(txtList.get(i))) {
                    backLan = txtList.get(i);
                    continue;
                }
                this.txtService.readTxt(txtList.get(i));
            }
            if (!StringUtils.isEmpty((CharSequence)backLan)) {
                this.txtService.readTxt(backLan);
            }
        }
    }

    private String getDataPath(String path) {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        return pathRoot + "data" + File.separator + path;
    }

    private String getMediaPath(String path) {
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
        String pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
        return pathRoot + path;
    }

    private void saveMedia(String mediaPath) throws Exception {
        File tempFolder = new File(mediaPath);
        List<File> mediaList = this.getMediaFile(tempFolder);
        String newMediaPath = this.mediaFolder + File.separator + "media";
        for (int i = 0; i < mediaList.size(); ++i) {
            File mediaFile;
            String relativePath;
            String tempPath = mediaList.get(i).getPath();
            String[] tempPaths = tempPath.split("media");
            if ("true".equals(this.minioModel)) {
                relativePath = "media/" + tempPaths[tempPaths.length - 1];
                this.logger.error(relativePath + "   " + tempPath, new Object[0]);
                this.logger.error("\u7ed3\u675f", new Object[0]);
                continue;
            }
            relativePath = tempPaths[tempPaths.length - 1];
            String[] paths = relativePath.split("\\\\");
            String father = newMediaPath;
            for (int j = 0; j < paths.length - 1; ++j) {
                father = father + File.separator + paths[j];
            }
            File fatherFile = new File(father);
            if (!fatherFile.exists()) {
                fatherFile.mkdirs();
            }
            if ((mediaFile = new File(father = father + File.separator + paths[paths.length - 1])).exists()) {
                mediaFile.delete();
            }
            File tempFile = new File(tempPath);
            tempFile.renameTo(mediaFile);
        }
    }

    private List<File> getMediaFile(File file) {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] children = file.listFiles();
        for (int i = 0; i < children.length; ++i) {
            File temp = children[i];
            if (temp.isDirectory()) {
                fileList.addAll(this.getMediaFile(temp));
                continue;
            }
            fileList.add(temp);
        }
        return fileList;
    }

    private void savePdf(List<String> pdfList) throws IOException {
        for (int i = 0; i < pdfList.size(); ++i) {
            File temp = new File(pdfList.get(i));
            FileUtil.copyFile(pdfList.get(i), this.pdfFolder + File.separator + temp.getName());
        }
    }
}

