/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportDcxsService;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.TableDataDto;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ImportDcxsServiceImpl
implements ImportDcxsService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importDcxsDB(String file) throws Exception {
        SqlliteConnTool connTool = null;
        try {
            connTool = new SqlliteConnTool(file);
            Map<String, List> structure = this.readSqliteStructure(connTool);
            List<TableDataDto> list = this.readSqliteTable(structure, connTool);
        }
        finally {
            connTool.Dispose();
        }
    }

    private List<TableDataDto> readSqliteTable(Map<String, List> structure, SqlliteConnTool connTool) throws Exception {
        ArrayList<TableDataDto> tableDataDtos = new ArrayList<TableDataDto>();
        String sql4 = "SELECT %s FROM %s";
        for (Map.Entry<String, List> next : structure.entrySet()) {
            String tablename = next.getKey();
            List value = next.getValue();
            TableDataDto tableDataDto = new TableDataDto();
            String sql5 = String.format(sql4, StringUtils.join((Iterable)value, (String)","), tablename);
            ResultSetInfo resultSetInfo = connTool.doQuery(sql5);
            ResultSet resultSet = resultSetInfo.getResultSet();
            while (resultSet.next()) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                for (Object field : value) {
                    temp.put(field.toString(), resultSet.getObject(field.toString()));
                }
                tableDataDto.getList().add(temp);
            }
            tableDataDto.setTablename(tablename);
            tableDataDtos.add(tableDataDto);
        }
        return tableDataDtos;
    }

    private Map<String, List> readSqliteStructure(SqlliteConnTool connTool) throws Exception {
        HashMap<String, List> structure = new HashMap<String, List>();
        String sql1 = "SELECT name FROM sqlite_master WHERE type = 'table';";
        String sql2 = "pragma table_info ('%s');";
        ArrayList tables = connTool.getTables();
        for (String table : tables) {
            String sql3 = String.format(sql2, table);
            ResultSetInfo resultSetInfo = connTool.doQuery(sql3);
            ResultSet resultSet = resultSetInfo.getResultSet();
            ArrayList<String> fields = new ArrayList<String>();
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                fields.add(name);
            }
        }
        return structure;
    }
}

