/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.model.datatransfer.dto.EntriesParameter;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportExService;
import com.geoway.landteam.landcloud.service.thirddata.utils.HttpUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.io.File;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.springframework.stereotype.Service;

@Service
public class ImportExServiceImpl
implements ImportExService {
    private GiLoger logger = GwLoger.getLoger(ImportExServiceImpl.class);

    public void importData(String filePath) throws Exception {
        String charset = FileUtils.readFileToString((File)new File(filePath), (String)"GBK");
        EntriesParameter content = (EntriesParameter)JSONObject.parseObject((String)charset, EntriesParameter.class);
        String loginUrl = content.getLoginUrl();
        CloseableHttpClient httpClient = HttpUtil.buildHttpClient(false);
        HttpGet httpGet = new HttpGet(loginUrl);
        HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        httpGet.releaseConnection();
        String value = null;
        String cookie = "";
        String data = null;
        Header[] headers = response.getHeaders("Set-Cookie");
        for (int i = 0; i < headers.length; ++i) {
            value = headers[i].getValue();
            cookie = cookie + value + ";";
        }
        if (content.getType().equals("get")) {
            HttpGet method = new HttpGet(content.getUrl());
            method.setHeader("Cookie", cookie);
            HttpResponse response1 = httpClient.execute((HttpUriRequest)method);
            data = EntityUtils.toString((HttpEntity)response1.getEntity());
            method.releaseConnection();
        } else if (content.getType().equals("jsonpost")) {
            HttpPost method = new HttpPost(content.getUrl());
            method.setHeader("Cookie", cookie);
            if (StringUtils.isNotBlank((CharSequence)content.getRequestbody())) {
                StringEntity entity = new StringEntity(content.getRequestbody(), "UTF-8");
                entity.setContentEncoding("UTF-8");
                entity.setContentType("application/json;charset=utf-8");
                method.setEntity((HttpEntity)entity);
            }
            HttpResponse response1 = httpClient.execute((HttpUriRequest)method);
            data = EntityUtils.toString((HttpEntity)response1.getEntity());
            method.releaseConnection();
        } else {
            String param = "";
            JSONObject jsonObject = JSONObject.parseObject((String)content.getRequestbody());
            if (null != jsonObject && !jsonObject.isEmpty()) {
                for (Map.Entry entry : jsonObject.entrySet()) {
                    param = param + "&" + entry.getKey() + "=" + entry.getValue();
                }
            }
            StringEntity httpEntity = new StringEntity(param, ContentType.create((String)"application/x-www-form-urlencoded", (String)"utf-8"));
            HttpPost post = new HttpPost(content.getUrl());
            post.setEntity((HttpEntity)httpEntity);
            post.setHeader("Authorization", "Basic YWRtaW46Z2Vvc2VydmVy");
            post.addHeader("Cookie", cookie);
            data = HttpUtil.executeRequest((HttpRequestBase)post, null);
        }
        if (StringUtils.isBlank((CharSequence)data)) {
            this.logger.error("\u63a5\u53e3\u53c2\u6570\u8fd4\u56de\u9519\u8bef", new Object[0]);
        } else {
            this.logger.info("\u8fd4\u56de\u6570\u636e:" + data, new Object[0]);
        }
    }
}

