/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.landcloud.model.datatransfer.constants.ParamType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.UpdateType;
import com.geoway.landteam.landcloud.model.datatransfer.constants.ValueType;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportJsonService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ImportDataUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class ImportJsonServiceImpl
implements ImportJsonService {
    private GiLoger logger = GwLoger.getLoger(ImportJsonServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public void readJson(String filePath) throws Exception {
        List<String> jsonList = ImportDataUtils.readTxtFile(filePath);
        JSONArray array = JSONArray.parseArray((String)jsonList.get(0), (Feature[])new Feature[0]);
        if (this.containsSqlInjection(array.toString())) {
            this.logger.error("\u53d1\u73b0\u6709sql\u6ce8\u5165\u95ee\u9898" + array.toString(), new Object[0]);
            return;
        }
        for (int i = 0; i < array.size(); ++i) {
            Integer valueType;
            Object value;
            String key;
            JSONObject dataObject;
            ArrayList<Object> params = new ArrayList<Object>();
            JSONObject object = array.getJSONObject(i);
            String tableName = object.getString("table");
            JSONArray dataArray = object.getJSONArray("data");
            JSONArray paramArray = object.getJSONArray("param");
            Integer type = object.getInteger("type");
            String sql = "";
            if (UpdateType.ADD == type) {
                sql = sql + "INSERT INTO " + tableName + " VALUES(";
            } else if (UpdateType.DEL == type) {
                sql = sql + "DELETE FROM " + tableName;
            } else if (UpdateType.UPDATE == type) {
                sql = sql + "UPDATE " + tableName + " SET ";
            }
            for (int j = 0; j < dataArray.size(); ++j) {
                dataObject = dataArray.getJSONObject(j);
                key = dataObject.getString("key");
                value = dataObject.getString("value");
                valueType = dataObject.getInteger("valueType");
                sql = 1 == type ? sql + " ? " : sql + key + " = ? ";
                if (j != dataArray.size() - 1) {
                    sql = sql + " , ";
                }
                params.add(this.getInsertValue2(valueType, value));
            }
            if (1 == type) {
                sql = sql + ")";
            }
            sql = sql + " WHERE 1=1 ";
            if (null != paramArray && paramArray.size() != 0) {
                for (int m = 0; m < paramArray.size(); ++m) {
                    dataObject = paramArray.getJSONObject(m);
                    key = dataObject.getString("key");
                    value = dataObject.get((Object)"value");
                    valueType = dataObject.getInteger("valueType");
                    Integer paramType = dataObject.getInteger("paramType");
                    if (ParamType.TYPE_IN == paramType) {
                        sql = sql + " and " + key + " in (" + this.getINsql((String)value) + ")";
                        continue;
                    }
                    sql = sql + " and " + key + this.getOperation(paramType) + "?";
                    params.add(this.getInsertValue2(valueType, value));
                }
            }
            this.jdbcTemplate.update(sql, params.toArray());
        }
    }

    private Object getInsertValue2(Integer type, Object value) {
        if (ValueType.TYPE_STRING == type) {
            if (null == value || "null".equals(value)) {
                return null;
            }
            return value.toString();
        }
        if (ValueType.TYPE_INT == type) {
            if (null == value || "null".equals(value)) {
                return null;
            }
            return ImportDataUtils.toInteger(value);
        }
        if (ValueType.TYPE_GEOMETRY == type) {
            if (null == value || "null".equals(value)) {
                return null;
            }
            return ImportDataUtils.toGeometry(value);
        }
        if (ValueType.TYPE_DATE == type) {
            if (null == value || "null".equals(value)) {
                return null;
            }
            return ImportDataUtils.toDate(value);
        }
        if (ValueType.TYPE_TIMESTAMP == type) {
            if (null == value || "null".equals(value)) {
                return null;
            }
            return ImportDataUtils.toTimestamp(value);
        }
        if (ValueType.TYPE_NUMBER == type) {
            if (null == value || "null".equals(value)) {
                return null;
            }
            return ImportDataUtils.toDouble(value);
        }
        if (ValueType.TYPE_LONG == type) {
            if (null == value || "null".equals(value)) {
                return null;
            }
            return ImportDataUtils.toLong(value);
        }
        return value;
    }

    private String getOperation(Integer paramType) {
        if (ParamType.TYPE_EQ == paramType) {
            return " = ";
        }
        if (ParamType.TYPE_NE == paramType) {
            return " != ";
        }
        if (ParamType.TYPE_LT == paramType) {
            return " < ";
        }
        if (ParamType.TYPE_LE == paramType) {
            return " <= ";
        }
        if (ParamType.TYPE_GT == paramType) {
            return " > ";
        }
        if (ParamType.TYPE_GE == paramType) {
            return " >= ";
        }
        if (ParamType.TYPE_IN == paramType) {
            return " in ";
        }
        return " = ";
    }

    private String getINsql(String data) {
        String[] array = data.split(",");
        String result = "";
        for (int i = 0; i < array.length; ++i) {
            result = result + "'" + array[i] + "'";
            if (i == array.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public boolean containsSqlInjection(Object obj) {
        Pattern pattern = Pattern.compile("\\b(and|exec|insert|select|drop|grant|alter|delete|update|count|chr|mid|master|truncate|char|declare|or)\\b|(\\*|;|\\+|')");
        Matcher matcher = pattern.matcher(obj.toString().toLowerCase());
        return matcher.find();
    }
}

