/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.http.HttpUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportMessageService;
import com.geoway.landteam.landcloud.service.thirddata.utils.SendMessage;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geojson.geom.GeometryJSON;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ImportMessageServiceImpl
implements ImportMessageService {
    @Value(value="${project.minioModel:}")
    protected String minioModel;
    @Value(value="${project.mediaUrlPrefix}")
    protected String mediaUrlPrefix;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TskTaskBizRepository bizDao;
    @Autowired
    private DataBizService dataBizService;
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private LogService logService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    @Autowired
    private TbtskObjectinfoRepository tbtskObjectinfoDao;

    public void sendMessage(SqlliteConnTool connTool) throws Exception {
        String sql3 = "select * from tbtsk_task_biz";
        ResultSetInfo result3 = connTool.doQuery(sql3);
        ResultSet rs3 = result3.getResultSet();
        while (rs3.next()) {
            String f_busicode = rs3.getString("f_busicode");
            if ("BYSXZ".equals(f_busicode)) {
                this.sendBysxzMessage(connTool);
                break;
            }
            if ("GDBH_SPBA".equals(f_busicode)) {
                this.sendSpbaMessage(connTool);
            } else if ("GDBH_JCJG".equals(f_busicode)) {
                this.saveJcjgMessage(connTool);
            } else if ("PHJG".equals(f_busicode)) {
                this.savePhjgMessage(connTool);
            }
            this.sendUniversalMessage(connTool);
        }
    }

    private void sendBysxzMessage(SqlliteConnTool connTool) throws Exception {
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String f_tablename = "";
        if (rs.next()) {
            f_tablename = rs.getString("f_tablename");
        }
        String sql2 = "select * from " + f_tablename;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        rs2.next();
        JSONObject geojson = this.createGeojson(rs2);
        JSONObject obj = new JSONObject();
        obj.put("bjbh", (Object)rs2.getString("f_bjbh"));
        obj.put("feature", (Object)geojson);
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(ApiNameType.bysxzSendMessage[0], ApiNameType.bysxzSendMessage[1]);
        JSONObject config = JSONObject.parseObject((String)applicationApi.getSqlfilterstr());
        String url = config.getString("url");
        Thread thread = new Thread(() -> {
            String sendResult = SendMessage.SendXxzxMessage(config.getString("appId"), config.getString("template"), obj.toString(), url);
            this.logService.saveLog(LogType.sendBysxzMessage, sendResult);
        });
        this.threadPoolTaskExecutor.execute((Runnable)thread);
    }

    private void sendSpbaMessage(SqlliteConnTool connTool) throws Exception {
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String f_tablename = "";
        if (rs.next()) {
            f_tablename = rs.getString("f_tablename");
        }
        String sql2 = "select * from " + f_tablename;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        ArrayList<String> xmbhList = new ArrayList<String>();
        while (rs2.next()) {
            xmbhList.add(rs2.getString("f_xmbh"));
        }
        if (!xmbhList.isEmpty()) {
            for (int i = 0; i < xmbhList.size(); ++i) {
                String xmbh = (String)xmbhList.get(i);
                if (!StringUtils.isEmpty((CharSequence)xmbh) && !this.taskResouceService.hasComplete(xmbh)) continue;
            }
        }
    }

    private void saveJcjgMessage(SqlliteConnTool connTool) throws Exception {
        String zgBizId;
        List apiList;
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String f_tableid = "";
        String f_tablename = "";
        if (rs.next()) {
            f_tableid = rs.getString("f_tableid");
            f_tablename = rs.getString("f_tablename");
        }
        Boolean jgtask = !(apiList = this.tbtskApplicationApiDao.queryByTableid(f_tableid)).isEmpty();
        TbtskApplicationApi api = null;
        String projecttype = "1";
        if (jgtask.booleanValue() && (api = (TbtskApplicationApi)apiList.get(0)).getApiname().equals(ApiNameType.assginLsyd[1])) {
            projecttype = "2";
        }
        String sql2 = "select * from " + f_tablename;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        String spotIds = "";
        while (rs2.next()) {
            String f_id = rs2.getString("f_id");
            spotIds = spotIds + f_id + ",";
            if (!jgtask.booleanValue()) continue;
        }
        String bizSql = "select * from tbtsk_task_biz";
        ResultSetInfo bizResult = connTool.doQuery(bizSql);
        ResultSet bizRs = bizResult.getResultSet();
        String bizid = "";
        while (bizRs.next()) {
            bizid = bizRs.getString("f_id");
        }
        TbtskApplicationApi zgApi = this.tbtskApplicationApiDao.queryApplicationApi("JCJG", "gdzyjczg");
        String string = zgBizId = zgApi != null ? zgApi.getTableid() : "";
        if (!zgBizId.equals(bizid) && !jgtask.booleanValue()) {
            this.dataBizService.updateBySql(f_tablename, "f_gzzt = '2'", "f_id in ('" + spotIds.replaceAll(",", "','") + "')");
        }
    }

    private void savePhjgMessage(SqlliteConnTool connTool) throws SQLException {
        List apiList;
        String sql = "select * from tbtsk_fields";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String f_tableid = "";
        String f_tablename = "";
        if (rs.next()) {
            f_tableid = rs.getString("f_tableid");
            f_tablename = rs.getString("f_tablename");
        }
        if ((apiList = this.tbtskApplicationApiDao.queryByTableid(f_tableid)).isEmpty()) {
            return;
        }
        TbtskApplicationApi api = (TbtskApplicationApi)apiList.get(0);
        TskTaskBiz tbTaskBiz = this.bizDao.findByTableId(api.getTableid());
        String sql2 = "select * from " + f_tablename;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        ArrayList<String> tbIds = new ArrayList<String>();
        while (rs2.next()) {
            String f_id = rs2.getString("f_id");
            tbIds.add(f_id);
        }
    }

    private JSONObject createGeojson(ResultSet rs2) throws Exception {
        JSONObject result = new JSONObject();
        Geometry geometry = WKTUtil.wktToGeom((String)rs2.getString("f_shape").replace("SRID=4490;", ""));
        StringWriter writer = new StringWriter();
        GeometryJSON g = new GeometryJSON();
        g.write(geometry, (Object)writer);
        String obj = writer.toString();
        result.put("geometry", JSONObject.parse((String)obj, (Feature[])new Feature[0]));
        JSONObject properties = new JSONObject();
        String[] array = new String[]{"f_tbmc", "f_tbbh", "f_tbmj", "f_xzqdm", "f_xzqmc", "f_czmz", "f_bjbh", "f_xmmz", "f_xmfzr", "f_bjsj", "f_njsgm", "f_nydmj", "f_sqlx", "f_lxr", "f_lxrdh", "f_sfzhm", "f_ydhxsfqd", "f_bz", "f_xzqmc1", "f_committime"};
        for (int i = 0; i < array.length; ++i) {
            properties.put(array[i], (Object)rs2.getString(array[i]));
        }
        String submitUser = this.getSubmitUser(rs2.getString("f_sendto"));
        properties.put("f_submitUser", (Object)submitUser);
        result.put("properties", (Object)properties);
        result.put("type", (Object)"Feature");
        return result;
    }

    private String getSubmitUser(String phone) {
        if (StringUtils.isEmpty((CharSequence)phone)) {
            return "";
        }
        String sql = "select f_rname from tbsys_user where f_phonemobile = '" + phone + "' limit 1";
        try {
            Map map = this.jdbcTemplate.queryForMap(sql);
            return (String)map.get("f_rname");
        }
        catch (Exception e) {
            return "";
        }
    }

    private boolean sendUniversalMessage(SqlliteConnTool connTool) throws Exception {
        List apiList;
        String sql = "select * from tbtsk_task_biz";
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        String parentTableid = "";
        while (rs.next()) {
            parentTableid = rs.getString("f_tableid");
        }
        if (StringUtils.isEmpty((CharSequence)parentTableid)) {
            return false;
        }
        TbtskObjectinfo parentInfo = (TbtskObjectinfo)this.tbtskObjectinfoDao.gwSearchByPK((Serializable)((Object)parentTableid));
        if (null == parentInfo) {
            return false;
        }
        String parentTablename = parentInfo.getfTablename();
        String childTableid = "";
        String childTablename = "";
        List childList = this.tbtskObjectinfoDao.queryAllByParentId(parentTableid);
        if (!childList.isEmpty()) {
            childTableid = ((TbtskObjectinfo)childList.get(0)).getfId();
            childTablename = ((TbtskObjectinfo)childList.get(0)).getfTablename();
        }
        if ((apiList = this.tbtskApplicationApiDao.queryByTableOrAssign(parentTableid)).isEmpty()) {
            return false;
        }
        TbtskApplicationApi api = (TbtskApplicationApi)apiList.get(0);
        String send = api.getSend();
        if (StringUtils.isEmpty((CharSequence)send)) {
            return false;
        }
        JSONObject sendConfig = JSONObject.parseObject((String)send);
        String configTableId = api.getTableid();
        Map<String, String> parentMapping = this.getFieldMapping(configTableId);
        if (null == parentMapping) {
            return false;
        }
        JSONArray sendArray = this.sendData(connTool, parentTablename, childTableid, childTablename, parentMapping, sendConfig);
        for (int i = 0; i < sendArray.size(); ++i) {
            JSONObject sendObj = sendArray.getJSONObject(i);
            this.sendMessageByConfig(sendConfig, sendObj);
        }
        return true;
    }

    private Map<String, String> getFieldMapping(String tableid) {
        Map mapping = null;
        try {
            mapping = this.taskResouceService.getFiledMap(tableid, "1");
        }
        catch (Exception e) {
            return null;
        }
        return mapping;
    }

    private JSONArray sendData(SqlliteConnTool connTool, String parentTablename, String childTableid, String childTablename, Map<String, String> fieldMapping, JSONObject sendConfig) throws SQLException {
        JSONArray resultArray = new JSONArray();
        String sql = "select * from " + parentTablename;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        while (rs.next()) {
            JSONObject obj = this.getSendData(connTool, rs, fieldMapping, sendConfig);
            if (StringUtils.isEmpty((CharSequence)childTableid)) {
                TbtskApplicationApi api;
                String configTableId;
                Map<String, String> childMapping;
                List apiList = this.tbtskApplicationApiDao.queryByTableOrAssign(childTableid);
                if (apiList.isEmpty() || null == (childMapping = this.getFieldMapping(configTableId = (api = (TbtskApplicationApi)apiList.get(0)).getTableid()))) continue;
                JSONArray childObj = this.sendData(connTool, childTablename, null, null, childMapping, sendConfig);
                obj.put("children", (Object)childObj);
            }
            resultArray.add((Object)obj);
        }
        return resultArray;
    }

    private JSONObject getSendData(SqlliteConnTool connTool, ResultSet rs, Map<String, String> fieldMapping, JSONObject sendConfig) throws SQLException {
        String shpType;
        JSONObject result = new JSONObject();
        for (Map.Entry<String, String> entry : fieldMapping.entrySet()) {
            result.put(entry.getValue(), (Object)rs.getString(entry.getKey()));
        }
        if (sendConfig.containsKey((Object)"hasShp") && sendConfig.getBoolean("hasShp").booleanValue() && "wkt".equals(shpType = sendConfig.getString("shpType"))) {
            result.put("shape", (Object)rs.getString("f_shape"));
        }
        if (sendConfig.containsKey((Object)"hasMedia") && sendConfig.getBoolean("hasMedia").booleanValue()) {
            String f_id = rs.getString("f_id");
            JSONArray mediaArray = this.getMediaArray(connTool, f_id, sendConfig);
            result.put("media", (Object)mediaArray);
        }
        return result;
    }

    private JSONArray getMediaArray(SqlliteConnTool connTool, String f_id, JSONObject sendConfig) throws SQLException {
        JSONArray result = new JSONArray();
        String mediaSql = "select * from tb_app_media where f_galleryid = '" + f_id + "'";
        ResultSetInfo medisInfo = connTool.doQuery(mediaSql);
        ResultSet rsMedia = medisInfo.getResultSet();
        String[] fields = sendConfig.getString("mediaFields").split(",");
        while (rsMedia.next()) {
            JSONObject obj = new JSONObject();
            for (int i = 0; i < fields.length; ++i) {
                String fieldname = fields[i];
                if ("f_serverpath".equals(fieldname)) {
                    String path = rsMedia.getString(fieldname);
                    String[] pathArray = path.split("media");
                    String resultPath = "";
                    if (pathArray.length != 2) {
                        resultPath = path;
                    } else if (!"true".equals(this.minioModel)) {
                        resultPath = this.mediaUrlPrefix + "/media" + pathArray[1];
                    }
                    obj.put("serverpath", (Object)resultPath);
                    continue;
                }
                obj.put(fieldname.split("f_")[1], (Object)rsMedia.getString(fieldname));
            }
            result.add((Object)obj);
        }
        return result;
    }

    public void sendMessageByConfig(JSONObject sendConfig, JSONObject sendObj) {
        JSONObject logData = new JSONObject();
        String url = sendConfig.getString("sendurl");
        String type = sendConfig.getString("sendtype");
        logData.put("send", (Object)sendObj);
        if ("post".equals(type)) {
            String result = null;
            try {
                result = HttpUtil.JsonPostInvoke((String)url, (String)sendObj.toJSONString());
            }
            catch (Exception e) {
                result = e.getMessage();
            }
            logData.put("result", (Object)result);
        }
        this.logService.saveLog(LogType.send_message, logData.toString());
    }
}

