/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.model.datatransfer.constants.InterfaceType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.servface.datacq.BackDataService;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportTxtService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ImportDataUtils;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImportTxtServiceImpl
implements ImportTxtService {
    private GiLoger logger = GwLoger.getLoger(ImportTxtServiceImpl.class);
    @Value(value="${project.applicationType}")
    protected String applicationType;
    @Autowired
    private BackDataService backDataService;
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private TskTaskBizService tskTaskBizService;
    @Autowired
    private LogService logService;

    public void readTxt(String filePath) throws Exception {
        List<String> messageList = ImportDataUtils.readTxtFile(filePath);
        if (messageList.isEmpty()) {
            return;
        }
        String interfaceName = messageList.get(0);
        if (InterfaceType.backProject.equals(interfaceName)) {
            this.logger.info("\u5904\u7406backProject\u63a5\u53e3", new Object[0]);
            this.reviewProjectLan(messageList);
        } else if (InterfaceType.deleteTask.equals(interfaceName)) {
            this.logger.info("\u5904\u7406deleteTask\u63a5\u53e3", new Object[0]);
            this.deleteByTaskId(messageList);
        } else if ("sendTaskWhole".equals(interfaceName)) {
            this.logger.info("\u5904\u7406sendTaskWhole\u63a5\u53e3", new Object[0]);
            this.assignTask(messageList, true);
        } else if ("sendTask".equals(interfaceName)) {
            this.logger.info("\u5904\u7406sendTask\u63a5\u53e3", new Object[0]);
            this.assignTask(messageList, false);
        } else if (InterfaceType.submitProject.equals(interfaceName)) {
            this.logger.info("\u5904\u7406submitProject\u63a5\u53e3", new Object[0]);
        } else if (InterfaceType.backLan.equals(interfaceName)) {
            this.logger.info("\u5904\u7406backLan\u63a5\u53e3", new Object[0]);
            this.backLan(messageList);
        } else if (InterfaceType.sendUpdateJbnt.equals(interfaceName)) {
            this.logger.info("\u5904\u7406sendUpdateJbnt\u63a5\u53e3", new Object[0]);
            this.sendUpdateJbnt(messageList);
        } else if (InterfaceType.sendSsnydResult.equals(interfaceName)) {
            this.logger.info("\u5904\u7406sendSsnydResult\u63a5\u53e3", new Object[0]);
            this.sendSsnydResult(messageList);
        } else if (InterfaceType.sendUpdateSsnyd.equals(interfaceName)) {
            this.sendUpdateSsnyd(messageList);
        } else if (InterfaceType.backItem.equals(interfaceName)) {
            this.backItem(messageList);
        }
    }

    @Transactional
    public void reviewProjectLan(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("\u9879\u76ee\u5ba1\u6838\u63a5\u53e3\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", new Object[0]);
        } else if ("lan".equals(this.applicationType)) {
            this.logger.error("\u8c03\u7528\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd9\u91cc\u662f\u5916\u7f51\u5904\u7406\u63a5\u53e3", new Object[0]);
        }
        JSONObject object = JSONObject.parseObject((String)messageList.get(1));
        String bizId = object.getString("bizId");
        String message = object.getString("message");
        String checkId = object.getString("checkId");
        String checkStatus = object.getString("checkStatus");
        TskTaskBiz newbiz = this.backDataService.reviewProject(bizId, message, checkId, checkStatus);
        if (null != newbiz) {
            this.taskResouceService.saveCheckMessage(message, newbiz.getId());
        }
    }

    private void deleteByTaskId(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("\u4efb\u52a1\u4e0b\u53d1\u63a5\u53e3\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", new Object[0]);
        }
        JSONObject object = JSONObject.parseObject((String)messageList.get(1));
        String taskId = object.getString("taskId");
        Long userId = object.getLong("userId");
        Boolean sync = object.getBoolean("sync");
        String wyid = object.getString("wyid");
        if (!"lan".equals(this.applicationType) || sync == null || !sync.booleanValue() || StringUtils.isEmpty((CharSequence)wyid)) {
            this.tskTaskBizService.delByTaskId(taskId);
        }
    }

    private void assignTask(List<String> messageList, Boolean isWhole) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("\u4efb\u52a1\u4e0b\u53d1\u63a5\u53e3\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", new Object[0]);
        }
        JSONObject object = JSONObject.parseObject((String)messageList.get(1));
        Long userId = object.getLong("userId");
    }

    private void backLan(List<String> messageList) {
        if (messageList.size() < 2) {
            this.logger.error("\u5185\u7f51\u56de\u9000\u63a5\u53e3\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", new Object[0]);
        }
        JSONObject object = JSONObject.parseObject((String)messageList.get(1));
        String oldBizId = object.getString("oldBizId");
        String newBizId = object.getString("newBizId");
        String newProjectId = object.getString("newProjectId");
        this.logService.saveLog(LogType.backLan, object.toString());
        this.backDataService.backLanThread(oldBizId, newBizId, newProjectId);
    }

    private void sendUpdateJbnt(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("\u5916\u7f51\u66f4\u65b0\u6570\u636e\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", new Object[0]);
        }
        JSONObject object = JSONObject.parseObject((String)messageList.get(1));
        String message = object.getString("message");
        JSONObject obj = JSONObject.parseObject((String)message);
        this.taskResouceService.updateProject(null, obj);
    }

    private void sendSsnydResult(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("\u5916\u7f51\u66f4\u65b0\u6570\u636e\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", new Object[0]);
        }
        JSONObject object = JSONObject.parseObject((String)messageList.get(1));
        String message = object.getString("message");
        JSONObject obj = JSONObject.parseObject((String)message);
    }

    private void sendUpdateSsnyd(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("\u5916\u7f51\u66f4\u65b0\u6570\u636e\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", new Object[0]);
        }
        JSONObject object = JSONObject.parseObject((String)messageList.get(1));
        String message = object.getString("message");
        JSONObject obj = JSONObject.parseObject((String)message);
    }

    private void backItem(List<String> messageList) throws Exception {
        if (messageList.size() < 2) {
            this.logger.error("\u5916\u7f51\u66f4\u65b0\u6570\u636e\u53c2\u6570\u83b7\u53d6\u5f02\u5e38", new Object[0]);
        }
        JSONObject object = JSONObject.parseObject((String)messageList.get(1));
        String message = object.getString("message");
        JSONObject obj = JSONObject.parseObject((String)message);
        String bizId = obj.getString("bizId");
        String tbids = obj.getString("tbids");
        String reason = obj.getString("reason");
    }
}

