/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.model.pub.constants.ApiDataType;
import com.geoway.landteam.landcloud.model.pub.constants.ApiNameType;
import com.geoway.landteam.landcloud.model.pub.constants.LogType;
import com.geoway.landteam.landcloud.model.pub.entity.TbtskApplicationApi;
import com.geoway.landteam.landcloud.repository.pub.TbtskApplicationApiRepository;
import com.geoway.landteam.landcloud.servface.datacq.LogService;
import com.geoway.landteam.landcloud.servface.datacq.TaskResouceService;
import com.geoway.landteam.landcloud.servface.datatransfer.ImportZbphDataService;
import com.geoway.landteam.landcloud.service.thirddata.utils.SendMessage;
import java.sql.ResultSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class ImportZbphDataServiceImpl
implements ImportZbphDataService {
    @Autowired
    private TbtskApplicationApiRepository tbtskApplicationApiDao;
    @Autowired
    private TaskResouceService taskResouceService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    private LogService logService;
    @Autowired
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;

    public void importZbphDb(String file) throws Exception {
        SqlliteConnTool connTool = null;
        try {
            connTool = new SqlliteConnTool(file);
            this.insertJbxx(connTool);
            this.insertJyxq(connTool);
            this.insertZbsy(connTool);
        }
        finally {
            connTool.Dispose();
        }
    }

    private void insertJbxx(SqlliteConnTool connTool) throws Exception {
        String namespace = ApiNameType.zbphImportData1[0];
        String apiname = ApiNameType.zbphImportData1[1];
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        String tableName = "ZBPH_XMJBXX";
        JSONArray array = this.saveZbphData(connTool, applicationApi, tableName);
        JSONObject config = JSONObject.parseObject((String)applicationApi.getSqlfilterstr());
        Thread thread = new Thread(() -> {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject obj = array.getJSONObject(i);
                String sendResult = SendMessage.SendXxzxMessage(config.getString("appId"), config.getString("template"), obj.toString(), config.getString("url"));
                this.logService.saveLog(LogType.sendXzgdMessage, sendResult);
            }
        });
        this.threadPoolTaskExecutor.execute((Runnable)thread);
    }

    private void insertJyxq(SqlliteConnTool connTool) throws Exception {
        String namespace = ApiNameType.zbphImportData2[0];
        String apiname = ApiNameType.zbphImportData2[1];
        String tableName = "ZBPH_JYXQB";
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        this.saveZbphData(connTool, applicationApi, tableName);
    }

    private void insertZbsy(SqlliteConnTool connTool) throws Exception {
        String namespace = ApiNameType.zbphImportData3[0];
        String apiname = ApiNameType.zbphImportData3[1];
        String tableName = "ZBPH_SYZB";
        TbtskApplicationApi applicationApi = this.tbtskApplicationApiDao.queryApplicationApi(namespace, apiname);
        this.truncateTable(applicationApi);
        this.saveZbphData(connTool, applicationApi, tableName);
    }

    private void truncateTable(TbtskApplicationApi applicationApi) {
        TbtskObjectinfo table = this.tbtskObjectinfoService.getObjectByTableId(applicationApi.getTableid());
        String tableName = table.getfTablename();
        String sql = "TRUNCATE " + tableName;
        this.jdbcTemplate.execute(sql);
    }

    private JSONArray saveZbphData(SqlliteConnTool connTool, TbtskApplicationApi applicationApi, String tableName) throws Exception {
        if (applicationApi == null) {
            throw new Exception("\u83b7\u53d6\u5173\u8054\u914d\u7f6e\u5931\u8d25");
        }
        String tableid = applicationApi.getTableid();
        Map mapping = this.taskResouceService.getFiledMap(tableid);
        String sql2 = "select * from " + tableName;
        ResultSetInfo result2 = connTool.doQuery(sql2);
        ResultSet rs2 = result2.getResultSet();
        JSONArray result = new JSONArray();
        while (rs2.next()) {
            JSONObject object = new JSONObject();
            for (Map.Entry entry : mapping.entrySet()) {
                object.put((String)entry.getValue(), rs2.getObject((String)entry.getValue()));
            }
            this.taskResouceService.saveData(object, applicationApi, ApiDataType.Zbph);
            result.add((Object)object);
        }
        return result;
    }
}

