/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.task.entity.TbtskApproveRecord;
import com.geoway.landteam.customtask.task.entity.TbtskRejectRecord;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.AbstractWpzfDbResolver;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="dbresolver_ba003")
public class WpzfApproveDbResolver
extends AbstractWpzfDbResolver {
    private GiLoger logger = GwLoger.getLoger(WpzfApproveDbResolver.class);

    protected String getConfigPrefix() {
        return "ba003";
    }

    public void resolve(SqlliteConnTool connTool) throws Exception {
        String tbbhSql = "select tbbh from dkinfo";
        ResultSetInfo gzlyResult = connTool.doQuery(tbbhSql);
        ResultSet tbbhRs = gzlyResult.getResultSet();
        tbbhRs.next();
        String tbbh = tbbhRs.getString("tbbh");
        if (!StringUtils.isNotBlank((CharSequence)tbbh)) {
            throw new RuntimeException("\u7f3a\u5c11\u56fe\u6591\u7f16\u53f7");
        }
        tbbh = tbbh.trim();
        String regx = "-\\d+$";
        Pattern pattern = Pattern.compile(regx);
        Matcher matcher = pattern.matcher(tbbh);
        boolean isChild = matcher.find();
        this.insertTable(connTool, "dkinfo", "tbbh", this.getConfigPrefix() + ".dkinfo", 2, isChild);
        this.insertTable(connTool, "dktb_hccg", "tbbsm", this.getConfigPrefix() + ".dktb_hccg", 2, isChild);
        try {
            this.insertTable(connTool, "xzdc_hccg", "tbbsm", this.getConfigPrefix() + ".xzdc_hccg", 2, isChild);
        }
        catch (Exception e) {
            this.logger.warn("SKIP INVALID TABLE", new Object[0]);
        }
        AbstractWpzfDbResolver.ExchangeParam param = new AbstractWpzfDbResolver.ExchangeParam(this.jdbcTemplate, this.exchangeFieldRelDao, this.objectTableNameService);
        param.init("dkinfo", "tbbsm", this.getConfigPrefix() + ".dktb_hccg", 2);
        this.updateSystemInfo(connTool, param, isChild);
        try {
            this.insertApproveRecord(connTool, "dktb_audit", this.getConfigPrefix() + ".audit", isChild);
            this.insertApproveRecord(connTool, "xzdc_audit", this.getConfigPrefix() + ".audit", isChild);
        }
        catch (Exception e) {
            this.logger.warn("\u5ba1\u6838\u4fe1\u606f\u63d2\u5165\u5931\u8d25", new Object[0]);
        }
        try {
            this.insertPwinfo(connTool, "dktb_pwinfo");
        }
        catch (Exception e) {
            this.logger.warn("\u6279\u6587\u63d2\u5165\u5931\u8d25", new Object[0]);
        }
    }

    protected void insertApproveRecord(SqlliteConnTool connTool, String tablename, String config, boolean isChild) throws Exception {
        Integer option;
        String sql = "select * from " + tablename;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        ArrayList<JSONObject> aduitList = new ArrayList<JSONObject>();
        String tbbsm = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            String bsm = rs.getString("tbbsm");
            tbbsm = rs.getString("tbbsm");
            String shr = rs.getString("shr");
            String shlx = rs.getString("shlx");
            String shsj = rs.getString("shsj");
            String shyj = rs.getString("shyj");
            Integer node = rs.getInt("nodeid");
            JSONObject aduitRecord = new JSONObject();
            aduitRecord.put("tbbsm", (Object)bsm);
            aduitRecord.put("shr", (Object)shr);
            aduitRecord.put("shlx", (Object)shlx);
            aduitRecord.put("shyj", (Object)shyj);
            Date date = sdf.parse(shsj);
            aduitRecord.put("shsj", (Object)date);
            aduitRecord.put("nodeid", (Object)node);
            aduitList.add(aduitRecord);
        }
        if (aduitList.isEmpty()) {
            return;
        }
        TbExchangeFieldRel rel = this.tbExchangeFieldRelDao.getConfig(config);
        String taskid = rel.getObjectid();
        String toTable = this.objectTableNameService.getTablename(taskid, Integer.valueOf(2));
        String childTable = this.objectTableNameService.getChildTablename(taskid, Integer.valueOf(2));
        String tbidSql = "";
        tbidSql = !isChild ? String.format("select f_id from %s where f_dkbsm = '%s'", toTable, tbbsm) : String.format("select f_id from %s where f_dkbsm = '%s'", childTable, tbbsm);
        String tbid = Optional.ofNullable(tbidSql).map(arg_0 -> ((JdbcTemplate)this.jdbcTemplate).queryForList(arg_0)).filter(e -> !e.isEmpty()).map(e -> (Map)e.get(0)).map(e -> (String)e.get("f_id")).orElseThrow(RuntimeException::new);
        TbtskApproveRecord lastRecord = this.saveAduitRecords(aduitList = aduitList.stream().sorted(Comparator.comparingDouble(e -> ((Date)e.getOrDefault((Object)"shsj", (Object)new Date(0L))).getTime())).collect(Collectors.toList()), sdf, taskid, tbid);
        if (lastRecord != null && (option = lastRecord.getOption()) == 1) {
            String updateSql = "";
            updateSql = !isChild ? String.format("UPDATE %s SET  f_review_stage = 95 ,f_status = 10 WHERE f_id ='%s'", toTable, tbid) : String.format("UPDATE %s SET  f_review_stage = 95 ,f_status = 10 WHERE f_id ='%s'", childTable, tbid);
            this.jdbcTemplate.update(updateSql);
        }
    }

    private TbtskApproveRecord saveAduitRecords(List<JSONObject> aduitList, SimpleDateFormat sdf, String taskid, String tbid) {
        ArrayList<TbtskApproveRecord> approveRecords = new ArrayList<TbtskApproveRecord>();
        TbtskApproveRecord lastRecord = null;
        int revokecount = 0;
        for (JSONObject aduit : aduitList) {
            TbtskApproveRecord record;
            int countApproved;
            Date shsj = aduit.getDate("shsj");
            Date toleStasrt = DateUtils.addSeconds((Date)shsj, (int)-1);
            Date toleEnd = DateUtils.addSeconds((Date)shsj, (int)1);
            String shlx = aduit.getString("shlx");
            int revokeFlag = "\u9000\u56de\u4fee\u6539".equals(shlx) ? 2 : 1;
            int node = aduit.getIntValue("nodeid");
            if (revokeFlag == 2) {
                ++revokecount;
                countApproved = this.rejectRecordRepository.countByTaskidAndTbidAndTimerange(taskid, tbid, sdf.format(toleStasrt), sdf.format(toleEnd));
                if (countApproved >= 1) continue;
                record = new TbtskRejectRecord();
                record.setId(UUID.randomUUID().toString());
                record.setTaskid(taskid);
                record.setTbid(tbid);
                record.setRejectTime(shsj);
                record.setUserName(aduit.getString("shr"));
                if (node == 1) {
                    record.setSourceStage(Integer.valueOf(93));
                    record.setStepName("\u53bf\u7ea7\u5ba1\u6838");
                    record.setTargetStage(Integer.valueOf(90));
                } else {
                    record.setSourceStage(Integer.valueOf(95));
                    record.setStepName("\u5e02\u7ea7\u5ba1\u6838");
                    record.setTargetStage(Integer.valueOf(93));
                }
                record.setRemark(aduit.getString("shyj"));
                this.rejectRecordRepository.save((Object)record);
                continue;
            }
            countApproved = this.approveRecordRepository.countByTaskidAndTbidAndTimerange(taskid, tbid, sdf.format(toleStasrt), sdf.format(toleEnd));
            if (countApproved >= 1) continue;
            record = new TbtskApproveRecord();
            record.setId(UUID.randomUUID().toString());
            record.setTaskid(taskid);
            record.setTbid(tbid);
            record.setApproveTime(shsj);
            record.setApproveUser(aduit.getString("shr"));
            if (node == 1) {
                record.setStepindex(Integer.valueOf(0));
                record.setStepname("\u53bf\u7ea7\u5ba1\u6838");
                record.setNextstep(Integer.valueOf(1));
            } else {
                record.setStepindex(Integer.valueOf(1));
                record.setStepname("\u5e02\u7ea7\u5ba1\u6838");
                record.setNextstep(Integer.valueOf(2));
            }
            record.setStatus(Integer.valueOf(1));
            record.setOption(Integer.valueOf(revokeFlag));
            record.setRemark(aduit.getString("shyj"));
            record.setIsRevoked(Integer.valueOf(revokecount));
            record.setRejectCount(Integer.valueOf(revokecount));
            approveRecords.add(record);
            lastRecord = record;
        }
        this.approveRecordRepository.saveAll(approveRecords);
        return lastRecord;
    }

    @Override
    public void updateSystemInfo(SqlliteConnTool connTool, AbstractWpzfDbResolver.ExchangeParam param, boolean isChild) throws SQLException {
        String fromTable = param.getFromTable();
        String primary = param.getPrimary();
        String myPrimary = param.getPgPrimary();
        String toTbale = isChild ? param.getToChildTable() : param.getToTable();
        String sql = String.format("select %s from %s", primary, fromTable);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        ArrayList<String> idList = new ArrayList<String>();
        while (rs.next()) {
            String idvalue = rs.getString(primary);
            idList.add(idvalue);
        }
        if (idList.isEmpty()) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        String idsql = String.format("select %s from %s where %s in ('%s')", myPrimary, toTbale, myPrimary, StringUtils.join(idList, (String)"','"));
        List hasIdList = this.jdbcTemplate.queryForList(idsql);
        for (int i = 0; i < hasIdList.size(); ++i) {
            idSet.add(((Map)hasIdList.get(i)).get(myPrimary).toString());
        }
        String gzlySql = "select gzly from paraminfo";
        ResultSetInfo gzlyResult = connTool.doQuery(gzlySql);
        ResultSet gzlyRs = gzlyResult.getResultSet();
        gzlyRs.next();
        String gzly = gzlyRs.getString("gzly");
        String shapeSql = "select shape from dkinfo";
        ResultSetInfo shapeResult = connTool.doQuery(shapeSql);
        ResultSet shapeRs = shapeResult.getResultSet();
        shapeRs.next();
        String shape = shapeRs.getString("shape");
        Long date = System.currentTimeMillis();
        String updateSql = String.format("UPDATE %s SET  f_status = 1 ,f_xzqdmcity = left(f_xzqdmcity,4)||'00',f_xzqdmsys = f_xzqdm||'000000', f_createtime = %s ,f_userid = 101 , f_gzly = '%s',f_shape = st_geomfromtext('%s')  WHERE %s in ('%s')", toTbale, date, gzly, shape, myPrimary, String.join((CharSequence)"','", idSet));
        this.jdbcTemplate.update(updateSql);
    }
}

