/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.AbstractWpzfDbResolver;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueImportRecord;
import com.geoway.landteam.patrolclue.servface.cluelibrary.JcClueImportRecordService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component(value="dbresolver_ba001")
public class WpzfClueDbResolver
extends AbstractWpzfDbResolver {
    private GiLoger logger = GwLoger.getLoger(WpzfClueDbResolver.class);
    private static final String SOURCE_IMPORT = "-import-record";

    protected String getConfigPrefix() {
        return "ba001.";
    }

    protected String getConfigPrimary() {
        return "wpzftb";
    }

    protected String getConfigChief() {
        return "wpzftb_thpwinfo";
    }

    public void resolve(SqlliteConnTool connTool) throws Exception {
        this.insertTable(connTool, this.getConfigPrimary(), "tbbsm", this.getConfigPrefix() + this.getConfigPrimary(), 1);
        try {
            this.insertTable(connTool, this.getConfigChief(), "tbbsm", this.getConfigPrefix() + this.getConfigChief(), 1);
        }
        catch (RuntimeException e) {
            this.logger.warn("SKIP INVALID TABLE", new Object[0]);
        }
        AbstractWpzfDbResolver.ExchangeParam param = new AbstractWpzfDbResolver.ExchangeParam(this.jdbcTemplate, this.exchangeFieldRelDao, this.objectTableNameService);
        param.init(this.getConfigPrimary(), "tbbsm", this.getConfigPrefix() + this.getConfigPrimary(), 1);
        this.updateSystemInfo(connTool, param, false);
    }

    @Override
    public void updateSystemInfo(SqlliteConnTool connTool, AbstractWpzfDbResolver.ExchangeParam param, boolean isChild) throws SQLException {
        String fromTable = param.getFromTable();
        String primary = param.getPrimary();
        String myPrimary = param.getPgPrimary();
        String toTbale = param.getToTable();
        String objectid = param.getObjectid();
        String sql = String.format("select %s from %s", primary, fromTable);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        ArrayList<String> idList = new ArrayList<String>();
        while (rs.next()) {
            String idvalue = rs.getString(primary);
            idList.add(idvalue);
        }
        if (idList.isEmpty()) {
            return;
        }
        HashMap<String, String> metaMap = new HashMap<String, String>();
        String idsql = String.format("select f_xfsj,%s from %s where %s in ('%s')", myPrimary, toTbale, myPrimary, StringUtils.join(idList, (String)"','"));
        List exitedIdList = this.jdbcTemplate.queryForList(idsql);
        for (int i = 0; i < exitedIdList.size(); ++i) {
            Map xs = (Map)exitedIdList.get(i);
            metaMap.put(xs.get(myPrimary).toString(), (String)xs.get("f_xfsj"));
        }
        Long date = System.currentTimeMillis();
        String updateSql = String.format("UPDATE %s SET  f_status = 0 , f_createtime = %s ,f_userid = 101 , f_sourceid = '%s' WHERE %s in ('%s')", toTbale, date, objectid, myPrimary, String.join((CharSequence)"','", metaMap.keySet()));
        this.jdbcTemplate.update(updateSql);
        Map<String, String> recordIdMap = metaMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.parseRecordId((String)e.getValue(), objectid)));
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : recordIdMap.entrySet()) {
            sb.append(String.format("UPDATE %s SET f_import_recordid = '%s'  WHERE f_id = '%s';", toTbale, entry.getValue(), entry.getKey()));
        }
        if (sb.length() > 0) {
            this.jdbcTemplate.update(sb.toString());
        }
        recordIdMap.entrySet().stream().map(Map.Entry::getValue).forEach(arg_0 -> ((JcClueImportRecordService)this.jcClueImportRecordService).updateImportRecordStatistics(arg_0));
    }

    private String parseRecordId(String xfsj, String sourceid) {
        String result = "";
        try {
            if (this.redisTemplate.opsForHash().hasKey((Object)(sourceid + SOURCE_IMPORT), (Object)xfsj).booleanValue()) {
                result = (String)this.redisTemplate.opsForHash().get((Object)(sourceid + SOURCE_IMPORT), (Object)xfsj);
            } else {
                String name = this.transferDatePartern(xfsj, "wpzfClueFrom", "wpzfClueTo");
                JcClueImportRecord record = this.jcClueImportRecordMapper.selectBySourceNameAndSourceId(name, sourceid);
                if (record == null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
                    Date date = new Date();
                    record = new JcClueImportRecord();
                    record.setfId(UUID.randomUUID().toString());
                    record.setfName(name);
                    record.setfSourceid(sourceid);
                    record.setfCreatetime(date);
                    record.setfJcsj(sdf.format(date));
                    this.jcClueImportRecordMapper.insert((Object)record);
                }
                result = record.getfId();
                this.redisTemplate.opsForHash().put((Object)(sourceid + SOURCE_IMPORT), (Object)xfsj, (Object)result);
                this.redisTemplate.expire((Object)(sourceid + SOURCE_IMPORT), 10L, TimeUnit.MINUTES);
            }
        }
        catch (Exception e) {
            this.logger.warn((Throwable)e);
        }
        return result;
    }

    private String transferDatePartern(String sj, String from, String to) throws ParseException {
        JSONObject parten = Optional.of("TimePartern").map(arg_0 -> ((SysConfigService)this.sysConfigService).findToJson(arg_0)).orElseGet(JSONObject::new);
        String xfsjParten = parten.getString(from);
        String importParten = parten.getString(to);
        SimpleDateFormat sdfFrom = new SimpleDateFormat(xfsjParten);
        SimpleDateFormat sdfTo = new SimpleDateFormat(importParten);
        Date date = sdfFrom.parse(sj);
        return sdfTo.format(date);
    }
}

