/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.AbstractWpzfDbResolver;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="dbresolver_ba004")
public class WpzfRevokeDbResolver
extends AbstractWpzfDbResolver {
    public void resolve(SqlliteConnTool connTool) throws Exception {
        this.insertApproveRecord(connTool, "dkinfo", "ba004.audit");
    }

    protected void insertApproveRecord(SqlliteConnTool connTool, String tablename, String config) throws Exception {
        String sql = "select * from " + tablename;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<Object> aduitList = new ArrayList();
        String tbbsm = "";
        while (rs.next()) {
            String bsm = rs.getString("tbbsm");
            tbbsm = rs.getString("tbbsm");
            String shr = rs.getString("shr");
            String shlx = rs.getString("shlx");
            String shsj = rs.getString("shsj");
            String shyj = rs.getString("shyj");
            JSONObject aduitRecord = new JSONObject();
            aduitRecord.put("tbbsm", (Object)bsm);
            aduitRecord.put("shr", (Object)shr);
            aduitRecord.put("shlx", (Object)shlx);
            aduitRecord.put("shyj", (Object)shyj);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(shsj);
            aduitRecord.put("shsj", (Object)date);
            aduitList.add(aduitRecord);
        }
        if (aduitList.isEmpty()) {
            return;
        }
        aduitList = aduitList.stream().sorted(Comparator.comparingDouble(e -> ((Date)e.getOrDefault((Object)"shsj", (Object)new Date(0L))).getTime())).collect(Collectors.toList());
        TbExchangeFieldRel rel = this.tbExchangeFieldRelDao.getConfig(config);
        String taskid = rel.getObjectid();
        String toTable = this.objectTableNameService.getTablename(taskid, Integer.valueOf(2));
        String uniqueKey = "f_tbbsm";
        String wpzfid = Optional.ofNullable("wpzf").map(arg_0 -> ((SysConfigService)this.sysConfigService).findOne(arg_0)).map(SysConfig::getValue).orElse("");
        if (wpzfid.equals(taskid)) {
            uniqueKey = "f_dkbsm";
        }
        String tbidSql = String.format("select f_id from %s where %s = '%s'", toTable, uniqueKey, tbbsm);
        String tbid = Optional.ofNullable(tbidSql).map(arg_0 -> ((JdbcTemplate)this.jdbcTemplate).queryForList(arg_0)).filter(e -> !e.isEmpty()).map(e -> (Map)e.get(0)).map(e -> (String)e.get("f_id")).orElseThrow(RuntimeException::new);
        for (JSONObject jSONObject : aduitList) {
            String shlx = jSONObject.getString("shlx");
            String shyj = jSONObject.getString("shyj");
            String username = jSONObject.getString("shr");
            Date shsj = jSONObject.getDate("shsj");
            this.tbtskFlowService.reject(taskid, tbid, null, null, shyj, shlx, username, "\u5e02\u7ea7\u5ba1\u6838", "\u53bf\u7ea7\u5ba1\u6838", shsj, null);
        }
    }
}

