/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.geoway.landteam.customtask.pub.enm.ByteOperator;
import com.geoway.landteam.customtask.pub.entity.ImageCaptureDef;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.repository.pub.ImageCaptureDefRepository;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.service.util.stepper.IStepParam;
import com.geoway.landteam.customtask.service.util.stepper.Stepper;
import com.geoway.landteam.customtask.service.util.stepper.StepperBuilder;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskImageCaptureService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbSyncStatusService;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.AbstractWpzfDbResolver;
import com.geoway.landteam.landcloud.service.thirddata.utils.JinAoGeoJsonUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Geometry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dbresolver_ba002")
public class WpzfSplitDbResolver
extends AbstractWpzfDbResolver {
    GiLoger logger = GwLoger.getLoger(WpzfSplitDbResolver.class);
    protected TbtskFieldsRepository fieldsDao;
    protected MTbSyncStatusService mTbSyncStatusService;
    protected MTaskImageCaptureService mTaskImageCaptureService;
    protected ImageCaptureDefRepository imageCaptureDefRepository;
    private Set<String> customedFields = new HashSet<String>(){
        {
            this.add("f_id");
            this.add("f_shape");
            this.add("f_splitedid");
            this.add("f_issplitted");
            this.add("f_mergeid");
            this.add("f_ismultipart");
            this.add("f_pid");
        }
    };

    @Autowired
    public void setFieldsDao(TbtskFieldsRepository fieldsDao) {
        this.fieldsDao = fieldsDao;
    }

    @Autowired
    public void setmTbSyncStatusService(MTbSyncStatusService mTbSyncStatusService) {
        this.mTbSyncStatusService = mTbSyncStatusService;
    }

    @Autowired
    public void setmTaskImageCaptureService(MTaskImageCaptureService mTaskImageCaptureService) {
        this.mTaskImageCaptureService = mTaskImageCaptureService;
    }

    @Autowired
    public void setImageCaptureDefRepository(ImageCaptureDefRepository imageCaptureDefRepository) {
        this.imageCaptureDefRepository = imageCaptureDefRepository;
    }

    public void resolve(SqlliteConnTool connTool) throws Exception {
        List<SplitParam> params = SplitParam.create(connTool);
        Map<String, List<SplitParam>> data = params.stream().collect(Collectors.groupingBy(SplitParam::getJcbh));
        for (Map.Entry<String, List<SplitParam>> entry : data.entrySet()) {
            String jctbbh = entry.getKey();
            List<SplitParam> splitData = entry.getValue();
            this.insertSplitedSpotToChild(splitData, jctbbh);
        }
    }

    protected void insertSplitedSpotToChild(List<SplitParam> dataList, String jctbbh) throws Exception {
        TbExchangeFieldRel rel = this.tbExchangeFieldRelDao.getConfig("ba002.dkinfo");
        String objectid = rel.getObjectid();
        String primary = rel.getInFieldName();
        String oriTable = this.objectTableNameService.getTablename(objectid, Integer.valueOf(2));
        String childTable = this.objectTableNameService.getChildTablename(objectid, Integer.valueOf(2));
        List fields = this.fieldsDao.getTbtskFieldsByTableName(oriTable);
        List fieldList = fields.stream().sorted(Comparator.comparing(TbtskFields::getfId)).filter(e -> !this.customedFields.contains(e.getfFieldname())).map(TbtskFields::getfFieldname).collect(Collectors.toList());
        String fieldtable = String.join((CharSequence)",", fieldList);
        ArrayList<String> idList = new ArrayList<String>();
        String tbbsm = "";
        boolean sfcf = false;
        for (SplitParam data : dataList) {
            sfcf = data.isSfcf();
            if (!sfcf) continue;
            Geometry shape = null;
            try {
                shape = JinAoGeoJsonUtil.rings2Geometry(data.getShape());
            }
            catch (Exception e2) {
                this.logger.error("\u65e0\u6548\u7684\u5206\u5272\u56fe\u5f62", new Object[]{e2});
            }
            if (shape == null) continue;
            tbbsm = data.getTbbsm();
            String regx = "-\\d+$";
            boolean isChild = Pattern.compile(regx).matcher(tbbsm).find();
            String sourceTable = isChild ? childTable : oriTable;
            String uuid = UUID.randomUUID().toString();
            String sql = String.format("insert into %s( %s ,f_id,f_splitedid) select %s,'%s',f_id from %s where %s = '%s';", childTable, fieldtable, fieldtable, uuid, oriTable, primary, jctbbh);
            this.jdbcTemplate.update(sql);
            idList.add(uuid);
            String tbbh = data.getTbbh();
            String updateSql = String.format("update %s set f_tbbh = '%s' ,f_shape = st_geomfromtext('%s'),f_dkbsm = '%s' where f_id = '%s';", childTable, tbbh, shape, tbbsm, uuid);
            this.jdbcTemplate.update(updateSql);
        }
        String updateMainTable = String.format("update %s set f_issplitted = 1,f_dkbsm = '%s' where %s = '%s'", oriTable, tbbsm, primary, jctbbh);
        this.jdbcTemplate.update(updateMainTable);
        ImageCaptureDef captureDef = (ImageCaptureDef)this.imageCaptureDefRepository.findById((Object)"3").orElseThrow(() -> new RuntimeException("\u65e0\u6548\u7684\u622a\u56fe\u4efb\u52a1\u7c7b\u578b"));
        CaptureParam param = new CaptureParam();
        param.setCaptureDef(captureDef);
        param.setTableName(childTable);
        param.setTaskId(objectid);
        param.setMask(MTbSyncStatusService.SYNC_CAPTURE_JA);
        StepperBuilder builder = StepperBuilder.create(this::capture).step(captureDef.getPackgeSize()).param((Object)param).continueWhenException(true);
        Stepper.run(idList, (StepperBuilder)builder);
    }

    private void startAtlasComputing(List<String> batchList, IStepParam param) {
    }

    private void capture(List<String> batchList, CaptureParam param) {
        String taskId = param.getTaskId();
        String tableName = param.getTableName();
        ImageCaptureDef captureDef = param.getCaptureDef();
        Integer mask = param.getMask();
        this.mTaskImageCaptureService.startImageCapture(tableName, String.join((CharSequence)",", batchList), captureDef);
        this.mTbSyncStatusService.changeStatus(Integer.valueOf(2), taskId, batchList, mask, ByteOperator.ADD);
    }

    private static class ComputingParam
    implements IStepParam {
        private ComputingParam() {
        }
    }

    private static class CaptureParam
    implements IStepParam {
        String taskId;
        String tableName;
        ImageCaptureDef captureDef;
        Integer mask;

        private CaptureParam() {
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public ImageCaptureDef getCaptureDef() {
            return this.captureDef;
        }

        public void setCaptureDef(ImageCaptureDef captureDef) {
            this.captureDef = captureDef;
        }

        public Integer getMask() {
            return this.mask;
        }

        public void setMask(Integer mask) {
            this.mask = mask;
        }
    }

    private static class SplitParam {
        private String xzqdm;
        private String jcbh;
        private String tbbsm;
        private boolean sfcf;
        private String shape;
        private String tbbh;
        private double lat;
        private double lon;

        private SplitParam() {
        }

        public static List<SplitParam> create(SqlliteConnTool connTool) throws Exception {
            ArrayList<SplitParam> paramList = new ArrayList<SplitParam>();
            String sql = "SELECT a.tbbsm,xzqdm,sfcf,jcbh,tbbh,shape,longitude,latitude FROM paraminfo a LEFT JOIN dkinfo b on a.tbbsm = b.tbbsm;";
            ResultSetInfo result = connTool.doQuery(sql);
            ResultSet rs = result.getResultSet();
            while (rs.next()) {
                SplitParam param = new SplitParam();
                param.tbbsm = rs.getString("tbbsm");
                param.sfcf = "Y".equals(rs.getString("sfcf"));
                param.xzqdm = rs.getString("xzqdm");
                param.jcbh = rs.getString("jcbh");
                param.tbbh = rs.getString("tbbh");
                param.shape = rs.getString("shape");
                param.lon = rs.getDouble("longitude");
                param.lat = rs.getDouble("latitude");
                paramList.add(param);
            }
            return paramList;
        }

        public String getXzqdm() {
            return this.xzqdm;
        }

        public String getJcbh() {
            return this.jcbh;
        }

        public String getTbbsm() {
            return this.tbbsm;
        }

        public boolean isSfcf() {
            return this.sfcf;
        }

        public String getShape() {
            return this.shape;
        }

        public String getTbbh() {
            return this.tbbh;
        }

        public double getLat() {
            return this.lat;
        }

        public double getLon() {
            return this.lon;
        }
    }
}

