/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.task.entity.TbtskApproveRecord;
import com.geoway.landteam.customtask.task.entity.TbtskRejectRecord;
import com.geoway.landteam.landcloud.common.util.ResultSetInfo;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.service.datatransfer.service.impl.AbstractWpzfDbResolver;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="dbresolver_ba006")
public class WpzfWtzgDbResolver
extends AbstractWpzfDbResolver {
    GiLoger logger = GwLoger.getLoger(WpzfWtzgDbResolver.class);

    protected String getConfigPrefix() {
        return "ba006.";
    }

    protected String getConfigPrimary() {
        return "wtcz_hccg";
    }

    public void resolve(SqlliteConnTool connTool) throws Exception {
        this.insertTable(connTool, this.getConfigPrimary(), "tbbsm", this.getConfigPrefix() + this.getConfigPrimary(), 2);
        try {
            this.insertTable(connTool, "wtcz_dkinfo", "tbbsm", this.getConfigPrefix() + "wtcz_dkinfo", 2);
        }
        catch (Exception e) {
            this.logger.warn("SKIP INVALID TABLE", new Object[0]);
        }
        AbstractWpzfDbResolver.ExchangeParam param = new AbstractWpzfDbResolver.ExchangeParam(this.jdbcTemplate, this.exchangeFieldRelDao, this.objectTableNameService);
        param.init("wtcz_hccg", "tbbsm", this.getConfigPrefix() + "wtcz_hccg", 2);
        this.updateSystemInfo(connTool, param, false);
        try {
            this.insertApproveRecord(connTool, "wtcz_audit", this.getConfigPrefix() + "audit");
        }
        catch (Exception e) {
            this.logger.warn("\u5ba1\u6838\u4fe1\u606f\u63d2\u5165\u5931\u8d25", new Object[0]);
        }
        try {
            this.insertPwinfo(connTool, "wtcz_pwinfo");
        }
        catch (Exception e) {
            this.logger.warn("\u6279\u6587\u63d2\u5165\u5931\u8d25", new Object[0]);
        }
    }

    protected void insertApproveRecord(SqlliteConnTool connTool, String tablename, String config) throws Exception {
        String sql = "select * from " + tablename;
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        List<Object> aduitList = new ArrayList();
        String tbbsm = "";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        while (rs.next()) {
            String bsm = rs.getString("tbbsm");
            tbbsm = rs.getString("tbbsm");
            String shr = rs.getString("shr");
            String shlx = rs.getString("shlx");
            String shsj = rs.getString("shsj");
            String shyj = rs.getString("shyj");
            JSONObject aduitRecord = new JSONObject();
            aduitRecord.put("tbbsm", (Object)bsm);
            aduitRecord.put("shr", (Object)shr);
            aduitRecord.put("shlx", (Object)shlx);
            aduitRecord.put("shyj", (Object)shyj);
            Date date = sdf.parse(shsj);
            aduitRecord.put("shsj", (Object)date);
            aduitList.add(aduitRecord);
        }
        if (aduitList.isEmpty()) {
            return;
        }
        aduitList = aduitList.stream().sorted(Comparator.comparingDouble(e -> ((Date)e.getOrDefault((Object)"shsj", (Object)new Date())).getTime())).collect(Collectors.toList());
        int revokecount = 0;
        TbExchangeFieldRel rel = this.tbExchangeFieldRelDao.getConfig(config);
        String taskid = rel.getObjectid();
        String toTable = "";
        toTable = this.objectTableNameService.getTablename(taskid, Integer.valueOf(2));
        String tbidSql = String.format("select f_id from %s where f_tbbsm = '%s'", toTable, tbbsm);
        String tbid = Optional.ofNullable(tbidSql).map(arg_0 -> ((JdbcTemplate)this.jdbcTemplate).queryForList(arg_0)).filter(e -> !e.isEmpty()).map(e -> (Map)e.get(0)).map(e -> (String)e.get("f_id")).orElseThrow(RuntimeException::new);
        ArrayList approveRecords = new ArrayList();
        for (JSONObject jSONObject : aduitList) {
            TbtskApproveRecord record;
            int countApproved;
            int revokeFlag;
            Date shsj = jSONObject.getDate("shsj");
            Date toleStasrt = DateUtils.addSeconds((Date)shsj, (int)-1);
            Date toleEnd = DateUtils.addSeconds((Date)shsj, (int)1);
            String shlx = jSONObject.getString("shlx");
            int n = revokeFlag = "\u9000\u56de\u4fee\u6539".equals(shlx) ? 2 : 1;
            if (revokeFlag == 2) {
                ++revokecount;
                countApproved = this.rejectRecordRepository.countByTaskidAndTbidAndTimerange(taskid, tbid, sdf.format(toleStasrt), sdf.format(toleEnd));
                if (countApproved >= 1) continue;
                record = new TbtskRejectRecord();
                record.setId(UUID.randomUUID().toString());
                record.setTaskid(taskid);
                record.setTbid(tbid);
                record.setRejectTime(shsj);
                record.setUserName(jSONObject.getString("shr"));
                record.setSourceStage(Integer.valueOf(95));
                record.setStepName("\u5e02\u7ea7\u5ba1\u6838");
                record.setTargetStage(Integer.valueOf(93));
                record.setRemark(jSONObject.getString("shyj"));
                this.rejectRecordRepository.save((Object)record);
                continue;
            }
            countApproved = this.approveRecordRepository.countByTaskidAndTbidAndTimerange(taskid, tbid, sdf.format(toleStasrt), sdf.format(toleEnd));
            if (countApproved >= 1) continue;
            record = new TbtskApproveRecord();
            record.setId(UUID.randomUUID().toString());
            record.setTaskid(taskid);
            record.setTbid(tbid);
            record.setApproveTime(shsj);
            record.setApproveUser(jSONObject.getString("shr"));
            record.setStepindex(Integer.valueOf(0));
            record.setStepname("\u53bf\u7ea7\u5ba1\u6838");
            record.setOption(Integer.valueOf(revokeFlag));
            record.setNextstep(Integer.valueOf(1));
            record.setRemark(jSONObject.getString("shyj"));
            record.setIsRevoked(Integer.valueOf(revokecount));
            record.setRejectCount(Integer.valueOf(revokecount));
        }
        if (approveRecords.size() > 0) {
            Integer option = ((TbtskApproveRecord)approveRecords.get(approveRecords.size() - 1)).getOption();
            if (option == 1) {
                String string = String.format("UPDATE %s SET  f_review_stage = 95 ,f_status = 10 WHERE f_id ='%s'", toTable, tbid);
                this.jdbcTemplate.update(string);
            }
            this.approveRecordRepository.saveAll(approveRecords);
        }
    }

    @Override
    public void updateSystemInfo(SqlliteConnTool connTool, AbstractWpzfDbResolver.ExchangeParam param, boolean isChild) throws SQLException {
        String fromTable = param.getFromTable();
        String primary = param.getPrimary();
        String myPrimary = param.getPgPrimary();
        String toTbale = param.getToTable();
        String sql = String.format("select %s from %s", primary, fromTable);
        ResultSetInfo result = connTool.doQuery(sql);
        ResultSet rs = result.getResultSet();
        ArrayList<String> idList = new ArrayList<String>();
        while (rs.next()) {
            String idvalue = rs.getString(primary);
            idList.add(idvalue);
        }
        if (idList.isEmpty()) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        String idsql = String.format("select %s from %s where %s in ('%s')", myPrimary, toTbale, myPrimary, StringUtils.join(idList, (String)"','"));
        List hasIdList = this.jdbcTemplate.queryForList(idsql);
        for (int i = 0; i < hasIdList.size(); ++i) {
            idSet.add(((Map)hasIdList.get(i)).get(myPrimary).toString());
        }
        String gzlySql = "select gzly from paraminfo";
        ResultSetInfo gzlyResult = connTool.doQuery(gzlySql);
        ResultSet gzlyRs = gzlyResult.getResultSet();
        gzlyRs.next();
        String gzly = gzlyRs.getString("gzly");
        Long date = System.currentTimeMillis();
        String updateSql = String.format("UPDATE %s as tb SET  f_status = 1 ,f_xzqdmsys = tb.f_xzqdm||'000000', f_createtime = %s ,f_userid = 101 , f_gzly = '%s' ,f_ssxzq = r.f_xzqmc  from tb_region as r WHERE tb.f_xzqdm = r.f_xzqdm and tb.%s in ('%s')", toTbale, date, gzly, myPrimary, String.join((CharSequence)"','", idSet));
        this.jdbcTemplate.update(updateSql);
    }
}

