/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.datatransfer.support;

import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.io.ClassPathResource;

public class ExportDataUtils {
    public static String copyDataBaseFile(String destDbFileDir, String template, String name) throws IOException {
        String destFileName = "";
        String srcFileName = "";
        if (StringUtils.isEmpty((CharSequence)name)) {
            name = "meta.db";
        }
        FileUtil.creatDirectoryIfNotExist((String)destDbFileDir);
        ClassPathResource meta = new ClassPathResource("/static/" + template);
        InputStream inputStream = meta.getInputStream();
        destFileName = destDbFileDir + File.separator + name;
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)new File(destFileName));
        return destFileName;
    }

    public static void closeConn(SqlliteConnTool connPool, Connection conn, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (connPool != null) {
            try {
                connPool.Dispose();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getInsertFields(String[] fields) {
        String result = "";
        for (int i = 0; i < fields.length; ++i) {
            result = result + "'" + fields[i] + "'";
            if (i == fields.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public static String getQuestionMark(String[] fields) {
        String result = "";
        for (int i = 0; i < fields.length; ++i) {
            result = result + "?";
            if (i == fields.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public static void setStringData(PreparedStatement pre, Map<String, Object> map, String key, int index) throws SQLException {
        if (null == map.get(key)) {
            pre.setString(index, null);
        } else {
            String val = map.get(key).toString();
            if ("f_shape".equals(key)) {
                val = val.replaceAll("^SRID=\\d{1,4};", "");
            }
            pre.setString(index, val);
        }
    }

    public static void copyFileToSubmit(String filename, String fileParentPath, String toPath) throws IOException {
        String inFile = fileParentPath + File.separator + filename;
        File in = new File(inFile);
        String outFile = toPath + File.separator + filename;
        File out = new File(outFile);
        if (!out.getParentFile().exists()) {
            out.getParentFile().mkdirs();
            out.createNewFile();
        }
        ExportDataUtils.copyFileUsingFileStreams(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingFileStreams(File in, File out) throws IOException {
        InputStream input = null;
        OutputStream output = null;
        try {
            int bytesRead;
            input = new FileInputStream(in);
            output = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            while ((bytesRead = input.read(buf)) > 0) {
                output.write(buf, 0, bytesRead);
            }
        }
        finally {
            input.close();
            output.close();
        }
    }
}

