/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.filestorage;

import com.geoway.landteam.landcloud.servface.filestorage.FileStorageService;
import com.geoway.landteam.platform.filestorage.GwSdkContent;
import com.geoway.landteam.platform.filestorage.api.GiSdkMultipartFile;
import com.geoway.landteam.platform.filestorage.api.GwFileControlApi;
import com.geoway.landteam.platform.filestorage.model.GSdkFileInfoApo;
import com.geoway.landteam.platform.filestorage.spring.SpringSdkMultipartFile;
import com.gw.base.Gw;
import java.io.File;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class FileSdkConfig
implements ApplicationRunner,
FileStorageService {
    @Value(value="${gw.filestorage.server_url}")
    private String serverUrl;
    @Value(value="${gw.filestorage.app_id}")
    private String appId;
    @Value(value="${gw.filestorage.bucket_name}")
    private String bucketName;
    @Autowired
    GwFileControlApi gwFileControlApi;

    public void run(ApplicationArguments args) throws Exception {
        GwSdkContent.serverUrl = this.serverUrl;
        GwSdkContent.appid = this.appId;
        Gw.log.info("\u6587\u4ef6\u5b58\u50a8\u521d\u59cb\u5316\u4fe1\u606f\uff1aserverUrl:{}", new Object[]{this.serverUrl});
        Gw.log.info("\u6587\u4ef6\u5b58\u50a8\u521d\u59cb\u5316\u4fe1\u606f\uff1aappId:{}", new Object[]{this.appId});
        Gw.log.info("\u6587\u4ef6\u5b58\u50a8\u521d\u59cb\u5316\u4fe1\u606f\uff1abucketName:{}", new Object[]{this.bucketName});
    }

    public String saveFile(MultipartFile file, String path) {
        GSdkFileInfoApo upload = this.gwFileControlApi.upload((GiSdkMultipartFile)new SpringSdkMultipartFile(file), this.bucketName, path);
        return upload.getUrl();
    }

    public String saveFile(File file, String path) {
        GSdkFileInfoApo upload = this.gwFileControlApi.upload(file, this.bucketName, path);
        return upload.getUrl();
    }

    public String generatePresignedUrlByUrl(String url) {
        return this.gwFileControlApi.generatePresignedUrlByUrl(url, Long.valueOf(3600L), "GET");
    }
}

