/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.landteam.landcloud.service.formatConversion;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.service.formatConversion.utils.MulFileUtil;
import com.geoway.landteam.landcloud.service.formatConversion.utils.StrUtil;
import com.geoway.landteam.patrolclue.model.until.FileUtil;
import java.io.File;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.springframework.web.multipart.MultipartFile;

public class Gson2ShpService {
    private Logger log = Logger.getLogger(this.getClass().toGenericString());
    private String rootPath = null;

    public Gson2ShpService(String downloadPath) {
        this.rootPath = downloadPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public String startExchange(MultipartFile mulFile) {
        String filename = mulFile.getOriginalFilename();
        String dirPath = this.rootPath + "gson2shp\\shp\\" + filename.substring(0, filename.indexOf("."));
        String gsonPath = this.rootPath + "gson2shp\\gson";
        GeometryJSON geojson = new GeometryJSON();
        File gsonFile = MulFileUtil.getFileFromMultipartFile(mulFile, ".geojson", gsonPath);
        String shpPath = dirPath + "\\" + filename.substring(0, filename.indexOf(".")) + ".shp";
        File dir = new File(dirPath);
        try {
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String geojsonStr = MulFileUtil.readJson(gsonFile.getAbsolutePath()).replaceAll(" ", "");
            Map geojsonMap = (Map)JSONObject.parseObject((String)geojsonStr, Map.class);
            List features = (List)geojsonMap.get("features");
            Map crsMap = (Map)geojsonMap.get("crs");
            Map geojsonExemple = (Map)features.get(0);
            String geojsonType = ((Map)geojsonExemple.get("geometry")).get("type").toString();
            Map mapFields = (Map)geojsonExemple.get("properties");
            System.out.println(features.size());
            Class<Point> geoType = null;
            switch (geojsonType) {
                case "Point": {
                    geoType = Point.class;
                    break;
                }
                case "MultiPoint": {
                    geoType = MultiPoint.class;
                    break;
                }
                case "LineString": {
                    geoType = LineString.class;
                    break;
                }
                case "MultiLineString": {
                    geoType = MultiLineString.class;
                    break;
                }
                case "Polygon": {
                    geoType = Polygon.class;
                    break;
                }
                case "MultiPolygon": {
                    geoType = MultiPolygon.class;
                }
            }
            File file = new File(shpPath);
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, file.toURI().toURL());
            ShapefileDataStore ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            String EPSG = ((String)((Map)crsMap.get("properties")).get("crs")).toLowerCase();
            String crs = "EPSG:4490";
            String rex = "epsg.*([1-9]*?)";
            Pattern pattern = Pattern.compile(rex);
            Matcher matcher = pattern.matcher(EPSG);
            if (matcher.find()) {
                crs = "EPSG:" + matcher.group().replaceAll("[^0-9]", "");
            }
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            tb.setCRS(CRS.decode((String)crs));
            tb.setName("shapefile");
            tb.add("the_geom", geoType);
            tb.setDefaultGeometry("the_geom");
            Map<String, String> newField = this.fieldMapRule(mapFields);
            if (newField == null) {
                this.log.warning("\u5c5e\u6027\u4e0d\u5b58\u5728");
                ds.dispose();
                String string = null;
                return string;
            }
            for (String key : newField.keySet()) {
                tb.add(key, String.class);
            }
            ds.setCharset(Charset.forName("GBK"));
            ds.createSchema(tb.buildFeatureType());
            FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            int len = features.size();
            for (int i = 0; i < len; ++i) {
                Map oneGeojson = (Map)features.get(i);
                Map attributes = (Map)oneGeojson.get("properties");
                String strFeature = JSONObject.toJSONString((Object)oneGeojson);
                StringReader reader = new StringReader(strFeature);
                SimpleFeature feature = (SimpleFeature)writer.next();
                switch (geojsonType) {
                    case "Point": {
                        feature.setAttribute("the_geom", (Object)geojson.readPoint((Object)reader));
                        break;
                    }
                    case "MultiPoint": {
                        feature.setAttribute("the_geom", (Object)geojson.readMultiPoint((Object)reader));
                        break;
                    }
                    case "LineString": {
                        feature.setAttribute("the_geom", (Object)geojson.readLine((Object)reader));
                        break;
                    }
                    case "MultiLineString": {
                        feature.setAttribute("the_geom", (Object)geojson.readMultiLine((Object)reader));
                        break;
                    }
                    case "Polygon": {
                        feature.setAttribute("the_geom", (Object)geojson.readPolygon((Object)reader));
                        break;
                    }
                    case "MultiPolygon": {
                        feature.setAttribute("the_geom", (Object)geojson.readMultiPolygon((Object)reader));
                    }
                }
                for (Map.Entry field : this.fieldMapRule(attributes).entrySet()) {
                    feature.setAttribute((String)field.getKey(), field.getValue());
                }
                writer.write();
            }
            writer.close();
            ds.dispose();
            String string = dirPath;
            return string;
        }
        catch (Exception e) {
            this.log.warning("\u6587\u4ef6\u5199\u5165\u6709\u8bef\uff01");
            FileUtil.deleteFileAndDir((File)dir);
            e.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            FileUtil.deleteFileAndDir((File)new File(gsonPath));
        }
    }

    private Map<String, String> fieldMapRule(Map<String, String> properties) {
        HashMap<String, String> newFields = new HashMap<String, String>();
        String[] rule = new String[]{"JZDSL", "ZMJ", "DKMC", "XMMC", "LX", "SJTFH", "DLMC"};
        String rex1 = "\u754c\u5740\u70b9\u6570\u91cf,\u603b\u9762\u79ef,\u5730\u5757\u540d\u79f0,\u9879\u76ee\u540d\u79f0,\u7c7b\u578b,\u6d89\u53ca\u56fe\u5e45\u53f7,\u5730\u7c7b\u540d\u79f0";
        String rex2 = "JZDSL,ZMJ,DKMC,XMMC,LX,SJTFH,DLMC";
        int format = 0;
        if (format == 0 && StrUtil.haveAttribute(rex1, properties)) {
            format = 1;
        }
        if (format == 0 && StrUtil.haveAttribute(rex2, properties)) {
            format = 2;
        }
        switch (format) {
            case 1: {
                String[] rexArr = rex1.split(",");
                for (int i = 0; i < rexArr.length; ++i) {
                    newFields.put(rule[i], properties.get(rexArr[i]));
                }
                break;
            }
            case 2: {
                String[] rexArr = rex2.split(",");
                for (int i = 0; i < rexArr.length; ++i) {
                    newFields.put(rule[i], properties.get(rexArr[i]));
                }
                break;
            }
            default: {
                this.log.warning("\u9700\u8981\u5148\u5b9a\u4e49\u8be5\u5c5e\u6027\u7684\u5339\u914d\u89c4\u5219\uff01");
                return null;
            }
        }
        return newFields;
    }
}

